/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the processor parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessorParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<ProcessorParameter.Builder, ProcessorParameter> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterName").getter(getter(ProcessorParameter::parameterNameAsString))
            .setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterValue").getter(getter(ProcessorParameter::parameterValue))
            .setter(setter(Builder::parameterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD,
            PARAMETER_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String parameterName;

    private final String parameterValue;

    private ProcessorParameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
    }

    /**
     * <p>
     * The name of the parameter. Currently the following default values are supported: 3 for
     * <code>NumberOfRetries</code> and 60 for the <code>BufferIntervalInSeconds</code>. The
     * <code>BufferSizeInMBs</code> ranges between 0.2 MB and up to 3MB. The default buffering hint is 1MB for all
     * destinations, except Splunk. For Splunk, the default buffering hint is 256 KB.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parameterName}
     * will return {@link ProcessorParameterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #parameterNameAsString}.
     * </p>
     * 
     * @return The name of the parameter. Currently the following default values are supported: 3 for
     *         <code>NumberOfRetries</code> and 60 for the <code>BufferIntervalInSeconds</code>. The
     *         <code>BufferSizeInMBs</code> ranges between 0.2 MB and up to 3MB. The default buffering hint is 1MB for
     *         all destinations, except Splunk. For Splunk, the default buffering hint is 256 KB.
     * @see ProcessorParameterName
     */
    public final ProcessorParameterName parameterName() {
        return ProcessorParameterName.fromValue(parameterName);
    }

    /**
     * <p>
     * The name of the parameter. Currently the following default values are supported: 3 for
     * <code>NumberOfRetries</code> and 60 for the <code>BufferIntervalInSeconds</code>. The
     * <code>BufferSizeInMBs</code> ranges between 0.2 MB and up to 3MB. The default buffering hint is 1MB for all
     * destinations, except Splunk. For Splunk, the default buffering hint is 256 KB.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parameterName}
     * will return {@link ProcessorParameterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #parameterNameAsString}.
     * </p>
     * 
     * @return The name of the parameter. Currently the following default values are supported: 3 for
     *         <code>NumberOfRetries</code> and 60 for the <code>BufferIntervalInSeconds</code>. The
     *         <code>BufferSizeInMBs</code> ranges between 0.2 MB and up to 3MB. The default buffering hint is 1MB for
     *         all destinations, except Splunk. For Splunk, the default buffering hint is 256 KB.
     * @see ProcessorParameterName
     */
    public final String parameterNameAsString() {
        return parameterName;
    }

    /**
     * <p>
     * The parameter value.
     * </p>
     * 
     * @return The parameter value.
     */
    public final String parameterValue() {
        return parameterValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parameterValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessorParameter)) {
            return false;
        }
        ProcessorParameter other = (ProcessorParameter) obj;
        return Objects.equals(parameterNameAsString(), other.parameterNameAsString())
                && Objects.equals(parameterValue(), other.parameterValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProcessorParameter").add("ParameterName", parameterNameAsString())
                .add("ParameterValue", parameterValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterNameAsString()));
        case "ParameterValue":
            return Optional.ofNullable(clazz.cast(parameterValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParameterName", PARAMETER_NAME_FIELD);
        map.put("ParameterValue", PARAMETER_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProcessorParameter, T> g) {
        return obj -> g.apply((ProcessorParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessorParameter> {
        /**
         * <p>
         * The name of the parameter. Currently the following default values are supported: 3 for
         * <code>NumberOfRetries</code> and 60 for the <code>BufferIntervalInSeconds</code>. The
         * <code>BufferSizeInMBs</code> ranges between 0.2 MB and up to 3MB. The default buffering hint is 1MB for all
         * destinations, except Splunk. For Splunk, the default buffering hint is 256 KB.
         * </p>
         * 
         * @param parameterName
         *        The name of the parameter. Currently the following default values are supported: 3 for
         *        <code>NumberOfRetries</code> and 60 for the <code>BufferIntervalInSeconds</code>. The
         *        <code>BufferSizeInMBs</code> ranges between 0.2 MB and up to 3MB. The default buffering hint is 1MB
         *        for all destinations, except Splunk. For Splunk, the default buffering hint is 256 KB.
         * @see ProcessorParameterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessorParameterName
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * The name of the parameter. Currently the following default values are supported: 3 for
         * <code>NumberOfRetries</code> and 60 for the <code>BufferIntervalInSeconds</code>. The
         * <code>BufferSizeInMBs</code> ranges between 0.2 MB and up to 3MB. The default buffering hint is 1MB for all
         * destinations, except Splunk. For Splunk, the default buffering hint is 256 KB.
         * </p>
         * 
         * @param parameterName
         *        The name of the parameter. Currently the following default values are supported: 3 for
         *        <code>NumberOfRetries</code> and 60 for the <code>BufferIntervalInSeconds</code>. The
         *        <code>BufferSizeInMBs</code> ranges between 0.2 MB and up to 3MB. The default buffering hint is 1MB
         *        for all destinations, except Splunk. For Splunk, the default buffering hint is 256 KB.
         * @see ProcessorParameterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessorParameterName
         */
        Builder parameterName(ProcessorParameterName parameterName);

        /**
         * <p>
         * The parameter value.
         * </p>
         * 
         * @param parameterValue
         *        The parameter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValue(String parameterValue);
    }

    static final class BuilderImpl implements Builder {
        private String parameterName;

        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessorParameter model) {
            parameterName(model.parameterName);
            parameterValue(model.parameterValue);
        }

        public final String getParameterName() {
            return parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        @Override
        public final Builder parameterName(ProcessorParameterName parameterName) {
            this.parameterName(parameterName == null ? null : parameterName.toString());
            return this;
        }

        public final String getParameterValue() {
            return parameterValue;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        @Override
        public ProcessorParameter build() {
            return new ProcessorParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
