/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePersistentAppUiResponse extends EmrResponse implements
        ToCopyableBuilder<CreatePersistentAppUiResponse.Builder, CreatePersistentAppUiResponse> {
    private static final SdkField<String> PERSISTENT_APP_UI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PersistentAppUIId").getter(getter(CreatePersistentAppUiResponse::persistentAppUIId))
            .setter(setter(Builder::persistentAppUIId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersistentAppUIId").build()).build();

    private static final SdkField<Boolean> RUNTIME_ROLE_ENABLED_CLUSTER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("RuntimeRoleEnabledCluster")
            .getter(getter(CreatePersistentAppUiResponse::runtimeRoleEnabledCluster))
            .setter(setter(Builder::runtimeRoleEnabledCluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeRoleEnabledCluster").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERSISTENT_APP_UI_ID_FIELD,
            RUNTIME_ROLE_ENABLED_CLUSTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String persistentAppUIId;

    private final Boolean runtimeRoleEnabledCluster;

    private CreatePersistentAppUiResponse(BuilderImpl builder) {
        super(builder);
        this.persistentAppUIId = builder.persistentAppUIId;
        this.runtimeRoleEnabledCluster = builder.runtimeRoleEnabledCluster;
    }

    /**
     * <p>
     * The persistent application user interface identifier.
     * </p>
     * 
     * @return The persistent application user interface identifier.
     */
    public final String persistentAppUIId() {
        return persistentAppUIId;
    }

    /**
     * <p>
     * Represents if the EMR on EC2 cluster that the persisent application user interface is created for is a runtime
     * role enabled cluster or not.
     * </p>
     * 
     * @return Represents if the EMR on EC2 cluster that the persisent application user interface is created for is a
     *         runtime role enabled cluster or not.
     */
    public final Boolean runtimeRoleEnabledCluster() {
        return runtimeRoleEnabledCluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(persistentAppUIId());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeRoleEnabledCluster());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePersistentAppUiResponse)) {
            return false;
        }
        CreatePersistentAppUiResponse other = (CreatePersistentAppUiResponse) obj;
        return Objects.equals(persistentAppUIId(), other.persistentAppUIId())
                && Objects.equals(runtimeRoleEnabledCluster(), other.runtimeRoleEnabledCluster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePersistentAppUiResponse").add("PersistentAppUIId", persistentAppUIId())
                .add("RuntimeRoleEnabledCluster", runtimeRoleEnabledCluster()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PersistentAppUIId":
            return Optional.ofNullable(clazz.cast(persistentAppUIId()));
        case "RuntimeRoleEnabledCluster":
            return Optional.ofNullable(clazz.cast(runtimeRoleEnabledCluster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PersistentAppUIId", PERSISTENT_APP_UI_ID_FIELD);
        map.put("RuntimeRoleEnabledCluster", RUNTIME_ROLE_ENABLED_CLUSTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePersistentAppUiResponse, T> g) {
        return obj -> g.apply((CreatePersistentAppUiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePersistentAppUiResponse> {
        /**
         * <p>
         * The persistent application user interface identifier.
         * </p>
         * 
         * @param persistentAppUIId
         *        The persistent application user interface identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder persistentAppUIId(String persistentAppUIId);

        /**
         * <p>
         * Represents if the EMR on EC2 cluster that the persisent application user interface is created for is a
         * runtime role enabled cluster or not.
         * </p>
         * 
         * @param runtimeRoleEnabledCluster
         *        Represents if the EMR on EC2 cluster that the persisent application user interface is created for is a
         *        runtime role enabled cluster or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeRoleEnabledCluster(Boolean runtimeRoleEnabledCluster);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private String persistentAppUIId;

        private Boolean runtimeRoleEnabledCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePersistentAppUiResponse model) {
            super(model);
            persistentAppUIId(model.persistentAppUIId);
            runtimeRoleEnabledCluster(model.runtimeRoleEnabledCluster);
        }

        public final String getPersistentAppUIId() {
            return persistentAppUIId;
        }

        public final void setPersistentAppUIId(String persistentAppUIId) {
            this.persistentAppUIId = persistentAppUIId;
        }

        @Override
        public final Builder persistentAppUIId(String persistentAppUIId) {
            this.persistentAppUIId = persistentAppUIId;
            return this;
        }

        public final Boolean getRuntimeRoleEnabledCluster() {
            return runtimeRoleEnabledCluster;
        }

        public final void setRuntimeRoleEnabledCluster(Boolean runtimeRoleEnabledCluster) {
            this.runtimeRoleEnabledCluster = runtimeRoleEnabledCluster;
        }

        @Override
        public final Builder runtimeRoleEnabledCluster(Boolean runtimeRoleEnabledCluster) {
            this.runtimeRoleEnabledCluster = runtimeRoleEnabledCluster;
            return this;
        }

        @Override
        public CreatePersistentAppUiResponse build() {
            return new CreatePersistentAppUiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
