/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ReadPipelineResponse</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReadPipelineResponse extends ElasticTranscoderResponse implements
        ToCopyableBuilder<ReadPipelineResponse.Builder, ReadPipelineResponse> {
    private static final SdkField<Pipeline> PIPELINE_FIELD = SdkField.<Pipeline> builder(MarshallingType.SDK_POJO)
            .memberName("Pipeline").getter(getter(ReadPipelineResponse::pipeline)).setter(setter(Builder::pipeline))
            .constructor(Pipeline::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pipeline").build()).build();

    private static final SdkField<List<Warning>> WARNINGS_FIELD = SdkField
            .<List<Warning>> builder(MarshallingType.LIST)
            .memberName("Warnings")
            .getter(getter(ReadPipelineResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Warning> builder(MarshallingType.SDK_POJO)
                                            .constructor(Warning::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PIPELINE_FIELD, WARNINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Pipeline pipeline;

    private final List<Warning> warnings;

    private ReadPipelineResponse(BuilderImpl builder) {
        super(builder);
        this.pipeline = builder.pipeline;
        this.warnings = builder.warnings;
    }

    /**
     * <p>
     * A section of the response body that provides information about the pipeline.
     * </p>
     * 
     * @return A section of the response body that provides information about the pipeline.
     */
    public final Pipeline pipeline() {
        return pipeline;
    }

    /**
     * For responses, this returns true if the service returned a value for the Warnings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the
     * pipeline.
     * </p>
     * <p>
     * Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and AWS KMS
     * key, reduces processing time and prevents cross-regional charges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWarnings} method.
     * </p>
     * 
     * @return Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as
     *         the pipeline.</p>
     *         <p>
     *         Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and
     *         AWS KMS key, reduces processing time and prevents cross-regional charges.
     */
    public final List<Warning> warnings() {
        return warnings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipeline());
        hashCode = 31 * hashCode + Objects.hashCode(hasWarnings() ? warnings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadPipelineResponse)) {
            return false;
        }
        ReadPipelineResponse other = (ReadPipelineResponse) obj;
        return Objects.equals(pipeline(), other.pipeline()) && hasWarnings() == other.hasWarnings()
                && Objects.equals(warnings(), other.warnings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReadPipelineResponse").add("Pipeline", pipeline())
                .add("Warnings", hasWarnings() ? warnings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pipeline":
            return Optional.ofNullable(clazz.cast(pipeline()));
        case "Warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Pipeline", PIPELINE_FIELD);
        map.put("Warnings", WARNINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReadPipelineResponse, T> g) {
        return obj -> g.apply((ReadPipelineResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticTranscoderResponse.Builder, SdkPojo, CopyableBuilder<Builder, ReadPipelineResponse> {
        /**
         * <p>
         * A section of the response body that provides information about the pipeline.
         * </p>
         * 
         * @param pipeline
         *        A section of the response body that provides information about the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipeline(Pipeline pipeline);

        /**
         * <p>
         * A section of the response body that provides information about the pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link Pipeline.Builder} avoiding the need to
         * create one manually via {@link Pipeline#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Pipeline.Builder#build()} is called immediately and its result is
         * passed to {@link #pipeline(Pipeline)}.
         * 
         * @param pipeline
         *        a consumer that will call methods on {@link Pipeline.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipeline(Pipeline)
         */
        default Builder pipeline(Consumer<Pipeline.Builder> pipeline) {
            return pipeline(Pipeline.builder().applyMutation(pipeline).build());
        }

        /**
         * <p>
         * Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the
         * pipeline.
         * </p>
         * <p>
         * Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and AWS
         * KMS key, reduces processing time and prevents cross-regional charges.
         * </p>
         * 
         * @param warnings
         *        Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region
         *        as the pipeline.</p>
         *        <p>
         *        Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics,
         *        and AWS KMS key, reduces processing time and prevents cross-regional charges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<Warning> warnings);

        /**
         * <p>
         * Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the
         * pipeline.
         * </p>
         * <p>
         * Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and AWS
         * KMS key, reduces processing time and prevents cross-regional charges.
         * </p>
         * 
         * @param warnings
         *        Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region
         *        as the pipeline.</p>
         *        <p>
         *        Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics,
         *        and AWS KMS key, reduces processing time and prevents cross-regional charges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Warning... warnings);

        /**
         * <p>
         * Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the
         * pipeline.
         * </p>
         * <p>
         * Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and AWS
         * KMS key, reduces processing time and prevents cross-regional charges.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elastictranscoder.model.Warning.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.elastictranscoder.model.Warning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elastictranscoder.model.Warning.Builder#build()} is called immediately
         * and its result is passed to {@link #warnings(List<Warning>)}.
         * 
         * @param warnings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elastictranscoder.model.Warning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warnings(java.util.Collection<Warning>)
         */
        Builder warnings(Consumer<Warning.Builder>... warnings);
    }

    static final class BuilderImpl extends ElasticTranscoderResponse.BuilderImpl implements Builder {
        private Pipeline pipeline;

        private List<Warning> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReadPipelineResponse model) {
            super(model);
            pipeline(model.pipeline);
            warnings(model.warnings);
        }

        public final Pipeline.Builder getPipeline() {
            return pipeline != null ? pipeline.toBuilder() : null;
        }

        public final void setPipeline(Pipeline.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        @Override
        public final Builder pipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public final List<Warning.Builder> getWarnings() {
            List<Warning.Builder> result = WarningsCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<Warning.BuilderImpl> warnings) {
            this.warnings = WarningsCopier.copyFromBuilder(warnings);
        }

        @Override
        public final Builder warnings(Collection<Warning> warnings) {
            this.warnings = WarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Warning... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<Warning.Builder>... warnings) {
            warnings(Stream.of(warnings).map(c -> Warning.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ReadPipelineResponse build() {
            return new ReadPipelineResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
