/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use the .png
 * format, which supports transparency.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobWatermark implements SdkPojo, Serializable, ToCopyableBuilder<JobWatermark.Builder, JobWatermark> {
    private static final SdkField<String> PRESET_WATERMARK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PresetWatermarkId").getter(getter(JobWatermark::presetWatermarkId))
            .setter(setter(Builder::presetWatermarkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresetWatermarkId").build()).build();

    private static final SdkField<String> INPUT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputKey").getter(getter(JobWatermark::inputKey)).setter(setter(Builder::inputKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputKey").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(JobWatermark::encryption)).setter(setter(Builder::encryption))
            .constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRESET_WATERMARK_ID_FIELD,
            INPUT_KEY_FIELD, ENCRYPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String presetWatermarkId;

    private final String inputKey;

    private final Encryption encryption;

    private JobWatermark(BuilderImpl builder) {
        this.presetWatermarkId = builder.presetWatermarkId;
        this.inputKey = builder.inputKey;
        this.encryption = builder.encryption;
    }

    /**
     * <p>
     * The ID of the watermark settings that Elastic Transcoder uses to add watermarks to the video during transcoding.
     * The settings are in the preset specified by Preset for the current output. In that preset, the value of
     * Watermarks Id tells Elastic Transcoder which settings to use.
     * </p>
     * 
     * @return The ID of the watermark settings that Elastic Transcoder uses to add watermarks to the video during
     *         transcoding. The settings are in the preset specified by Preset for the current output. In that preset,
     *         the value of Watermarks Id tells Elastic Transcoder which settings to use.
     */
    public final String presetWatermarkId() {
        return presetWatermarkId;
    }

    /**
     * <p>
     * The name of the .png or .jpg file that you want to use for the watermark. To determine which Amazon S3 bucket
     * contains the specified file, Elastic Transcoder checks the pipeline specified by <code>Pipeline</code>; the
     * <code>Input Bucket</code> object in that pipeline identifies the bucket.
     * </p>
     * <p>
     * If the file name includes a prefix, for example, <b>logos/128x64.png</b>, include the prefix in the key. If the
     * file isn't in the specified bucket, Elastic Transcoder returns an error.
     * </p>
     * 
     * @return The name of the .png or .jpg file that you want to use for the watermark. To determine which Amazon S3
     *         bucket contains the specified file, Elastic Transcoder checks the pipeline specified by
     *         <code>Pipeline</code>; the <code>Input Bucket</code> object in that pipeline identifies the bucket.</p>
     *         <p>
     *         If the file name includes a prefix, for example, <b>logos/128x64.png</b>, include the prefix in the key.
     *         If the file isn't in the specified bucket, Elastic Transcoder returns an error.
     */
    public final String inputKey() {
        return inputKey;
    }

    /**
     * <p>
     * The encryption settings, if any, that you want Elastic Transcoder to apply to your watermarks.
     * </p>
     * 
     * @return The encryption settings, if any, that you want Elastic Transcoder to apply to your watermarks.
     */
    public final Encryption encryption() {
        return encryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(presetWatermarkId());
        hashCode = 31 * hashCode + Objects.hashCode(inputKey());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobWatermark)) {
            return false;
        }
        JobWatermark other = (JobWatermark) obj;
        return Objects.equals(presetWatermarkId(), other.presetWatermarkId()) && Objects.equals(inputKey(), other.inputKey())
                && Objects.equals(encryption(), other.encryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobWatermark").add("PresetWatermarkId", presetWatermarkId()).add("InputKey", inputKey())
                .add("Encryption", encryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PresetWatermarkId":
            return Optional.ofNullable(clazz.cast(presetWatermarkId()));
        case "InputKey":
            return Optional.ofNullable(clazz.cast(inputKey()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PresetWatermarkId", PRESET_WATERMARK_ID_FIELD);
        map.put("InputKey", INPUT_KEY_FIELD);
        map.put("Encryption", ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobWatermark, T> g) {
        return obj -> g.apply((JobWatermark) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobWatermark> {
        /**
         * <p>
         * The ID of the watermark settings that Elastic Transcoder uses to add watermarks to the video during
         * transcoding. The settings are in the preset specified by Preset for the current output. In that preset, the
         * value of Watermarks Id tells Elastic Transcoder which settings to use.
         * </p>
         * 
         * @param presetWatermarkId
         *        The ID of the watermark settings that Elastic Transcoder uses to add watermarks to the video during
         *        transcoding. The settings are in the preset specified by Preset for the current output. In that
         *        preset, the value of Watermarks Id tells Elastic Transcoder which settings to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presetWatermarkId(String presetWatermarkId);

        /**
         * <p>
         * The name of the .png or .jpg file that you want to use for the watermark. To determine which Amazon S3 bucket
         * contains the specified file, Elastic Transcoder checks the pipeline specified by <code>Pipeline</code>; the
         * <code>Input Bucket</code> object in that pipeline identifies the bucket.
         * </p>
         * <p>
         * If the file name includes a prefix, for example, <b>logos/128x64.png</b>, include the prefix in the key. If
         * the file isn't in the specified bucket, Elastic Transcoder returns an error.
         * </p>
         * 
         * @param inputKey
         *        The name of the .png or .jpg file that you want to use for the watermark. To determine which Amazon S3
         *        bucket contains the specified file, Elastic Transcoder checks the pipeline specified by
         *        <code>Pipeline</code>; the <code>Input Bucket</code> object in that pipeline identifies the
         *        bucket.</p>
         *        <p>
         *        If the file name includes a prefix, for example, <b>logos/128x64.png</b>, include the prefix in the
         *        key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputKey(String inputKey);

        /**
         * <p>
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your watermarks.
         * </p>
         * 
         * @param encryption
         *        The encryption settings, if any, that you want Elastic Transcoder to apply to your watermarks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * <p>
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your watermarks.
         * </p>
         * This is a convenience method that creates an instance of the {@link Encryption.Builder} avoiding the need to
         * create one manually via {@link Encryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String presetWatermarkId;

        private String inputKey;

        private Encryption encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(JobWatermark model) {
            presetWatermarkId(model.presetWatermarkId);
            inputKey(model.inputKey);
            encryption(model.encryption);
        }

        public final String getPresetWatermarkId() {
            return presetWatermarkId;
        }

        public final void setPresetWatermarkId(String presetWatermarkId) {
            this.presetWatermarkId = presetWatermarkId;
        }

        @Override
        public final Builder presetWatermarkId(String presetWatermarkId) {
            this.presetWatermarkId = presetWatermarkId;
            return this;
        }

        public final String getInputKey() {
            return inputKey;
        }

        public final void setInputKey(String inputKey) {
            this.inputKey = inputKey;
        }

        @Override
        public final Builder inputKey(String inputKey) {
            this.inputKey = inputKey;
            return this;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        @Override
        public JobWatermark build() {
            return new JobWatermark(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
