/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for response returned by <code> <a>UpgradeElasticsearchDomain</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpgradeElasticsearchDomainResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<UpgradeElasticsearchDomainResponse.Builder, UpgradeElasticsearchDomainResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(UpgradeElasticsearchDomainResponse::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetVersion").getter(getter(UpgradeElasticsearchDomainResponse::targetVersion))
            .setter(setter(Builder::targetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()).build();

    private static final SdkField<Boolean> PERFORM_CHECK_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PerformCheckOnly").getter(getter(UpgradeElasticsearchDomainResponse::performCheckOnly))
            .setter(setter(Builder::performCheckOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformCheckOnly").build()).build();

    private static final SdkField<ChangeProgressDetails> CHANGE_PROGRESS_DETAILS_FIELD = SdkField
            .<ChangeProgressDetails> builder(MarshallingType.SDK_POJO).memberName("ChangeProgressDetails")
            .getter(getter(UpgradeElasticsearchDomainResponse::changeProgressDetails))
            .setter(setter(Builder::changeProgressDetails)).constructor(ChangeProgressDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            TARGET_VERSION_FIELD, PERFORM_CHECK_ONLY_FIELD, CHANGE_PROGRESS_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String targetVersion;

    private final Boolean performCheckOnly;

    private final ChangeProgressDetails changeProgressDetails;

    private UpgradeElasticsearchDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.targetVersion = builder.targetVersion;
        this.performCheckOnly = builder.performCheckOnly;
        this.changeProgressDetails = builder.changeProgressDetails;
    }

    /**
     * Returns the value of the DomainName property for this object.
     * 
     * @return The value of the DomainName property for this object.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The version of Elasticsearch that you intend to upgrade the domain to.
     * </p>
     * 
     * @return The version of Elasticsearch that you intend to upgrade the domain to.
     */
    public final String targetVersion() {
        return targetVersion;
    }

    /**
     * <p>
     * This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not
     * actually perform the Upgrade.
     * </p>
     * 
     * @return This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will
     *         not actually perform the Upgrade.
     */
    public final Boolean performCheckOnly() {
        return performCheckOnly;
    }

    /**
     * Returns the value of the ChangeProgressDetails property for this object.
     * 
     * @return The value of the ChangeProgressDetails property for this object.
     */
    public final ChangeProgressDetails changeProgressDetails() {
        return changeProgressDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(performCheckOnly());
        hashCode = 31 * hashCode + Objects.hashCode(changeProgressDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeElasticsearchDomainResponse)) {
            return false;
        }
        UpgradeElasticsearchDomainResponse other = (UpgradeElasticsearchDomainResponse) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(targetVersion(), other.targetVersion())
                && Objects.equals(performCheckOnly(), other.performCheckOnly())
                && Objects.equals(changeProgressDetails(), other.changeProgressDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpgradeElasticsearchDomainResponse").add("DomainName", domainName())
                .add("TargetVersion", targetVersion()).add("PerformCheckOnly", performCheckOnly())
                .add("ChangeProgressDetails", changeProgressDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "TargetVersion":
            return Optional.ofNullable(clazz.cast(targetVersion()));
        case "PerformCheckOnly":
            return Optional.ofNullable(clazz.cast(performCheckOnly()));
        case "ChangeProgressDetails":
            return Optional.ofNullable(clazz.cast(changeProgressDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("TargetVersion", TARGET_VERSION_FIELD);
        map.put("PerformCheckOnly", PERFORM_CHECK_ONLY_FIELD);
        map.put("ChangeProgressDetails", CHANGE_PROGRESS_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpgradeElasticsearchDomainResponse, T> g) {
        return obj -> g.apply((UpgradeElasticsearchDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpgradeElasticsearchDomainResponse> {
        /**
         * Sets the value of the DomainName property for this object.
         *
         * @param domainName
         *        The new value for the DomainName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The version of Elasticsearch that you intend to upgrade the domain to.
         * </p>
         * 
         * @param targetVersion
         *        The version of Elasticsearch that you intend to upgrade the domain to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVersion(String targetVersion);

        /**
         * <p>
         * This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This will not
         * actually perform the Upgrade.
         * </p>
         * 
         * @param performCheckOnly
         *        This flag, when set to True, indicates that an Upgrade Eligibility Check needs to be performed. This
         *        will not actually perform the Upgrade.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performCheckOnly(Boolean performCheckOnly);

        /**
         * Sets the value of the ChangeProgressDetails property for this object.
         *
         * @param changeProgressDetails
         *        The new value for the ChangeProgressDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeProgressDetails(ChangeProgressDetails changeProgressDetails);

        /**
         * Sets the value of the ChangeProgressDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ChangeProgressDetails.Builder} avoiding
         * the need to create one manually via {@link ChangeProgressDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChangeProgressDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #changeProgressDetails(ChangeProgressDetails)}.
         * 
         * @param changeProgressDetails
         *        a consumer that will call methods on {@link ChangeProgressDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeProgressDetails(ChangeProgressDetails)
         */
        default Builder changeProgressDetails(Consumer<ChangeProgressDetails.Builder> changeProgressDetails) {
            return changeProgressDetails(ChangeProgressDetails.builder().applyMutation(changeProgressDetails).build());
        }
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private String domainName;

        private String targetVersion;

        private Boolean performCheckOnly;

        private ChangeProgressDetails changeProgressDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeElasticsearchDomainResponse model) {
            super(model);
            domainName(model.domainName);
            targetVersion(model.targetVersion);
            performCheckOnly(model.performCheckOnly);
            changeProgressDetails(model.changeProgressDetails);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getTargetVersion() {
            return targetVersion;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final Boolean getPerformCheckOnly() {
            return performCheckOnly;
        }

        public final void setPerformCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
        }

        @Override
        public final Builder performCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
            return this;
        }

        public final ChangeProgressDetails.Builder getChangeProgressDetails() {
            return changeProgressDetails != null ? changeProgressDetails.toBuilder() : null;
        }

        public final void setChangeProgressDetails(ChangeProgressDetails.BuilderImpl changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails != null ? changeProgressDetails.build() : null;
        }

        @Override
        public final Builder changeProgressDetails(ChangeProgressDetails changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails;
            return this;
        }

        @Override
        public UpgradeElasticsearchDomainResponse build() {
            return new UpgradeElasticsearchDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
