/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for request parameters to <code> <a>CreatePackage</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePackageRequest extends ElasticsearchRequest implements
        ToCopyableBuilder<CreatePackageRequest.Builder, CreatePackageRequest> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageName").getter(getter(CreatePackageRequest::packageName)).setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()).build();

    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageType").getter(getter(CreatePackageRequest::packageTypeAsString))
            .setter(setter(Builder::packageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()).build();

    private static final SdkField<String> PACKAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageDescription").getter(getter(CreatePackageRequest::packageDescription))
            .setter(setter(Builder::packageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDescription").build())
            .build();

    private static final SdkField<PackageSource> PACKAGE_SOURCE_FIELD = SdkField
            .<PackageSource> builder(MarshallingType.SDK_POJO).memberName("PackageSource")
            .getter(getter(CreatePackageRequest::packageSource)).setter(setter(Builder::packageSource))
            .constructor(PackageSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD,
            PACKAGE_TYPE_FIELD, PACKAGE_DESCRIPTION_FIELD, PACKAGE_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String packageName;

    private final String packageType;

    private final String packageDescription;

    private final PackageSource packageSource;

    private CreatePackageRequest(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.packageType = builder.packageType;
        this.packageDescription = builder.packageDescription;
        this.packageSource = builder.packageSource;
    }

    /**
     * <p>
     * Unique identifier for the package.
     * </p>
     * 
     * @return Unique identifier for the package.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * Type of package. Currently supports only TXT-DICTIONARY.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return Type of package. Currently supports only TXT-DICTIONARY.
     * @see PackageType
     */
    public final PackageType packageType() {
        return PackageType.fromValue(packageType);
    }

    /**
     * <p>
     * Type of package. Currently supports only TXT-DICTIONARY.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return Type of package. Currently supports only TXT-DICTIONARY.
     * @see PackageType
     */
    public final String packageTypeAsString() {
        return packageType;
    }

    /**
     * <p>
     * Description of the package.
     * </p>
     * 
     * @return Description of the package.
     */
    public final String packageDescription() {
        return packageDescription;
    }

    /**
     * <p>
     * The customer S3 location <code>PackageSource</code> for importing the package.
     * </p>
     * 
     * @return The customer S3 location <code>PackageSource</code> for importing the package.
     */
    public final PackageSource packageSource() {
        return packageSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(packageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(packageSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackageRequest)) {
            return false;
        }
        CreatePackageRequest other = (CreatePackageRequest) obj;
        return Objects.equals(packageName(), other.packageName())
                && Objects.equals(packageTypeAsString(), other.packageTypeAsString())
                && Objects.equals(packageDescription(), other.packageDescription())
                && Objects.equals(packageSource(), other.packageSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePackageRequest").add("PackageName", packageName())
                .add("PackageType", packageTypeAsString()).add("PackageDescription", packageDescription())
                .add("PackageSource", packageSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "PackageType":
            return Optional.ofNullable(clazz.cast(packageTypeAsString()));
        case "PackageDescription":
            return Optional.ofNullable(clazz.cast(packageDescription()));
        case "PackageSource":
            return Optional.ofNullable(clazz.cast(packageSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PackageName", PACKAGE_NAME_FIELD);
        map.put("PackageType", PACKAGE_TYPE_FIELD);
        map.put("PackageDescription", PACKAGE_DESCRIPTION_FIELD);
        map.put("PackageSource", PACKAGE_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePackageRequest, T> g) {
        return obj -> g.apply((CreatePackageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticsearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePackageRequest> {
        /**
         * <p>
         * Unique identifier for the package.
         * </p>
         * 
         * @param packageName
         *        Unique identifier for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * Type of package. Currently supports only TXT-DICTIONARY.
         * </p>
         * 
         * @param packageType
         *        Type of package. Currently supports only TXT-DICTIONARY.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(String packageType);

        /**
         * <p>
         * Type of package. Currently supports only TXT-DICTIONARY.
         * </p>
         * 
         * @param packageType
         *        Type of package. Currently supports only TXT-DICTIONARY.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(PackageType packageType);

        /**
         * <p>
         * Description of the package.
         * </p>
         * 
         * @param packageDescription
         *        Description of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageDescription(String packageDescription);

        /**
         * <p>
         * The customer S3 location <code>PackageSource</code> for importing the package.
         * </p>
         * 
         * @param packageSource
         *        The customer S3 location <code>PackageSource</code> for importing the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageSource(PackageSource packageSource);

        /**
         * <p>
         * The customer S3 location <code>PackageSource</code> for importing the package.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageSource.Builder} avoiding the need
         * to create one manually via {@link PackageSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageSource.Builder#build()} is called immediately and its
         * result is passed to {@link #packageSource(PackageSource)}.
         * 
         * @param packageSource
         *        a consumer that will call methods on {@link PackageSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageSource(PackageSource)
         */
        default Builder packageSource(Consumer<PackageSource.Builder> packageSource) {
            return packageSource(PackageSource.builder().applyMutation(packageSource).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticsearchRequest.BuilderImpl implements Builder {
        private String packageName;

        private String packageType;

        private String packageDescription;

        private PackageSource packageSource;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackageRequest model) {
            super(model);
            packageName(model.packageName);
            packageType(model.packageType);
            packageDescription(model.packageDescription);
            packageSource(model.packageSource);
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageType() {
            return packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final String getPackageDescription() {
            return packageDescription;
        }

        public final void setPackageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
        }

        @Override
        public final Builder packageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
            return this;
        }

        public final PackageSource.Builder getPackageSource() {
            return packageSource != null ? packageSource.toBuilder() : null;
        }

        public final void setPackageSource(PackageSource.BuilderImpl packageSource) {
            this.packageSource = packageSource != null ? packageSource.build() : null;
        }

        @Override
        public final Builder packageSource(PackageSource packageSource) {
            this.packageSource = packageSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePackageRequest build() {
            return new CreatePackageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
