/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the Auto-Tune options: the Auto-Tune desired state for the domain and list of maintenance schedules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoTuneOptionsOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoTuneOptionsOutput.Builder, AutoTuneOptionsOutput> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(AutoTuneOptionsOutput::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(AutoTuneOptionsOutput::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String errorMessage;

    private AutoTuneOptionsOutput(BuilderImpl builder) {
        this.state = builder.state;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AutoTuneState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.
     * @see AutoTuneState
     */
    public final AutoTuneState state() {
        return AutoTuneState.fromValue(state);
    }

    /**
     * <p>
     * Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AutoTuneState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.
     * @see AutoTuneState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Specifies the error message while enabling or disabling the Auto-Tune.
     * </p>
     * 
     * @return Specifies the error message while enabling or disabling the Auto-Tune.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoTuneOptionsOutput)) {
            return false;
        }
        AutoTuneOptionsOutput other = (AutoTuneOptionsOutput) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoTuneOptionsOutput").add("State", stateAsString()).add("ErrorMessage", errorMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoTuneOptionsOutput, T> g) {
        return obj -> g.apply((AutoTuneOptionsOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoTuneOptionsOutput> {
        /**
         * <p>
         * Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.
         * </p>
         * 
         * @param state
         *        Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.
         * @see AutoTuneState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoTuneState
         */
        Builder state(String state);

        /**
         * <p>
         * Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.
         * </p>
         * 
         * @param state
         *        Specifies the <code>AutoTuneState</code> for the Elasticsearch domain.
         * @see AutoTuneState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoTuneState
         */
        Builder state(AutoTuneState state);

        /**
         * <p>
         * Specifies the error message while enabling or disabling the Auto-Tune.
         * </p>
         * 
         * @param errorMessage
         *        Specifies the error message while enabling or disabling the Auto-Tune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoTuneOptionsOutput model) {
            state(model.state);
            errorMessage(model.errorMessage);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AutoTuneState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public AutoTuneOptionsOutput build() {
            return new AutoTuneOptionsOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
