/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PolicyDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<PolicyDescription.Builder, PolicyDescription> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(PolicyDescription::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyTypeName").getter(getter(PolicyDescription::policyTypeName))
            .setter(setter(Builder::policyTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyTypeName").build()).build();

    private static final SdkField<List<PolicyAttributeDescription>> POLICY_ATTRIBUTE_DESCRIPTIONS_FIELD = SdkField
            .<List<PolicyAttributeDescription>> builder(MarshallingType.LIST)
            .memberName("PolicyAttributeDescriptions")
            .getter(getter(PolicyDescription::policyAttributeDescriptions))
            .setter(setter(Builder::policyAttributeDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyAttributeDescriptions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyAttributeDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyAttributeDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            POLICY_TYPE_NAME_FIELD, POLICY_ATTRIBUTE_DESCRIPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyName;

    private final String policyTypeName;

    private final List<PolicyAttributeDescription> policyAttributeDescriptions;

    private PolicyDescription(BuilderImpl builder) {
        this.policyName = builder.policyName;
        this.policyTypeName = builder.policyTypeName;
        this.policyAttributeDescriptions = builder.policyAttributeDescriptions;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The name of the policy type.
     * </p>
     * 
     * @return The name of the policy type.
     */
    public final String policyTypeName() {
        return policyTypeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyAttributeDescriptions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPolicyAttributeDescriptions() {
        return policyAttributeDescriptions != null && !(policyAttributeDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The policy attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyAttributeDescriptions} method.
     * </p>
     * 
     * @return The policy attributes.
     */
    public final List<PolicyAttributeDescription> policyAttributeDescriptions() {
        return policyAttributeDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyAttributeDescriptions() ? policyAttributeDescriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyDescription)) {
            return false;
        }
        PolicyDescription other = (PolicyDescription) obj;
        return Objects.equals(policyName(), other.policyName()) && Objects.equals(policyTypeName(), other.policyTypeName())
                && hasPolicyAttributeDescriptions() == other.hasPolicyAttributeDescriptions()
                && Objects.equals(policyAttributeDescriptions(), other.policyAttributeDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PolicyDescription").add("PolicyName", policyName()).add("PolicyTypeName", policyTypeName())
                .add("PolicyAttributeDescriptions", hasPolicyAttributeDescriptions() ? policyAttributeDescriptions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyTypeName":
            return Optional.ofNullable(clazz.cast(policyTypeName()));
        case "PolicyAttributeDescriptions":
            return Optional.ofNullable(clazz.cast(policyAttributeDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyName", POLICY_NAME_FIELD);
        map.put("PolicyTypeName", POLICY_TYPE_NAME_FIELD);
        map.put("PolicyAttributeDescriptions", POLICY_ATTRIBUTE_DESCRIPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PolicyDescription, T> g) {
        return obj -> g.apply((PolicyDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PolicyDescription> {
        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param policyName
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The name of the policy type.
         * </p>
         * 
         * @param policyTypeName
         *        The name of the policy type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypeName(String policyTypeName);

        /**
         * <p>
         * The policy attributes.
         * </p>
         * 
         * @param policyAttributeDescriptions
         *        The policy attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyAttributeDescriptions(Collection<PolicyAttributeDescription> policyAttributeDescriptions);

        /**
         * <p>
         * The policy attributes.
         * </p>
         * 
         * @param policyAttributeDescriptions
         *        The policy attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyAttributeDescriptions(PolicyAttributeDescription... policyAttributeDescriptions);

        /**
         * <p>
         * The policy attributes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeDescription.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeDescription.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #policyAttributeDescriptions(List<PolicyAttributeDescription>)}.
         * 
         * @param policyAttributeDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyAttributeDescriptions(java.util.Collection<PolicyAttributeDescription>)
         */
        Builder policyAttributeDescriptions(Consumer<PolicyAttributeDescription.Builder>... policyAttributeDescriptions);
    }

    static final class BuilderImpl implements Builder {
        private String policyName;

        private String policyTypeName;

        private List<PolicyAttributeDescription> policyAttributeDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyDescription model) {
            policyName(model.policyName);
            policyTypeName(model.policyTypeName);
            policyAttributeDescriptions(model.policyAttributeDescriptions);
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyTypeName() {
            return policyTypeName;
        }

        public final void setPolicyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
        }

        @Override
        public final Builder policyTypeName(String policyTypeName) {
            this.policyTypeName = policyTypeName;
            return this;
        }

        public final List<PolicyAttributeDescription.Builder> getPolicyAttributeDescriptions() {
            List<PolicyAttributeDescription.Builder> result = PolicyAttributeDescriptionsCopier
                    .copyToBuilder(this.policyAttributeDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyAttributeDescriptions(
                Collection<PolicyAttributeDescription.BuilderImpl> policyAttributeDescriptions) {
            this.policyAttributeDescriptions = PolicyAttributeDescriptionsCopier.copyFromBuilder(policyAttributeDescriptions);
        }

        @Override
        public final Builder policyAttributeDescriptions(Collection<PolicyAttributeDescription> policyAttributeDescriptions) {
            this.policyAttributeDescriptions = PolicyAttributeDescriptionsCopier.copy(policyAttributeDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeDescriptions(PolicyAttributeDescription... policyAttributeDescriptions) {
            policyAttributeDescriptions(Arrays.asList(policyAttributeDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyAttributeDescriptions(
                Consumer<PolicyAttributeDescription.Builder>... policyAttributeDescriptions) {
            policyAttributeDescriptions(Stream.of(policyAttributeDescriptions)
                    .map(c -> PolicyAttributeDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PolicyDescription build() {
            return new PolicyDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
