/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a listener.
 * </p>
 * <p>
 * For information about the protocols and the ports supported by Elastic Load Balancing, see <a
 * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your
 * Classic Load Balancer</a> in the <i>Classic Load Balancers Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Listener implements SdkPojo, Serializable, ToCopyableBuilder<Listener.Builder, Listener> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(Listener::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<Integer> LOAD_BALANCER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LoadBalancerPort").getter(getter(Listener::loadBalancerPort)).setter(setter(Builder::loadBalancerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerPort").build()).build();

    private static final SdkField<String> INSTANCE_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceProtocol").getter(getter(Listener::instanceProtocol)).setter(setter(Builder::instanceProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProtocol").build()).build();

    private static final SdkField<Integer> INSTANCE_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstancePort").getter(getter(Listener::instancePort)).setter(setter(Builder::instancePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePort").build()).build();

    private static final SdkField<String> SSL_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SSLCertificateId").getter(getter(Listener::sslCertificateId)).setter(setter(Builder::sslCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSLCertificateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD,
            LOAD_BALANCER_PORT_FIELD, INSTANCE_PROTOCOL_FIELD, INSTANCE_PORT_FIELD, SSL_CERTIFICATE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String protocol;

    private final Integer loadBalancerPort;

    private final String instanceProtocol;

    private final Integer instancePort;

    private final String sslCertificateId;

    private Listener(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.loadBalancerPort = builder.loadBalancerPort;
        this.instanceProtocol = builder.instanceProtocol;
        this.instancePort = builder.instancePort;
        this.sslCertificateId = builder.sslCertificateId;
    }

    /**
     * <p>
     * The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP, or SSL.
     * </p>
     * 
     * @return The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP, or SSL.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The port on which the load balancer is listening. On EC2-VPC, you can specify any port from the range 1-65535. On
     * EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.
     * </p>
     * 
     * @return The port on which the load balancer is listening. On EC2-VPC, you can specify any port from the range
     *         1-65535. On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587,
     *         1024-65535.
     */
    public final Integer loadBalancerPort() {
        return loadBalancerPort;
    }

    /**
     * <p>
     * The protocol to use for routing traffic to instances: HTTP, HTTPS, TCP, or SSL.
     * </p>
     * <p>
     * If the front-end protocol is TCP or SSL, the back-end protocol must be TCP or SSL. If the front-end protocol is
     * HTTP or HTTPS, the back-end protocol must be HTTP or HTTPS.
     * </p>
     * <p>
     * If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is
     * secure, (HTTPS or SSL), the listener's <code>InstanceProtocol</code> must also be secure.
     * </p>
     * <p>
     * If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is HTTP
     * or TCP, the listener's <code>InstanceProtocol</code> must be HTTP or TCP.
     * </p>
     * 
     * @return The protocol to use for routing traffic to instances: HTTP, HTTPS, TCP, or SSL.</p>
     *         <p>
     *         If the front-end protocol is TCP or SSL, the back-end protocol must be TCP or SSL. If the front-end
     *         protocol is HTTP or HTTPS, the back-end protocol must be HTTP or HTTPS.
     *         </p>
     *         <p>
     *         If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code>
     *         is secure, (HTTPS or SSL), the listener's <code>InstanceProtocol</code> must also be secure.
     *         </p>
     *         <p>
     *         If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code>
     *         is HTTP or TCP, the listener's <code>InstanceProtocol</code> must be HTTP or TCP.
     */
    public final String instanceProtocol() {
        return instanceProtocol;
    }

    /**
     * <p>
     * The port on which the instance is listening.
     * </p>
     * 
     * @return The port on which the instance is listening.
     */
    public final Integer instancePort() {
        return instancePort;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the server certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the server certificate.
     */
    public final String sslCertificateId() {
        return sslCertificateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerPort());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(instancePort());
        hashCode = 31 * hashCode + Objects.hashCode(sslCertificateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Listener)) {
            return false;
        }
        Listener other = (Listener) obj;
        return Objects.equals(protocol(), other.protocol()) && Objects.equals(loadBalancerPort(), other.loadBalancerPort())
                && Objects.equals(instanceProtocol(), other.instanceProtocol())
                && Objects.equals(instancePort(), other.instancePort())
                && Objects.equals(sslCertificateId(), other.sslCertificateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Listener").add("Protocol", protocol()).add("LoadBalancerPort", loadBalancerPort())
                .add("InstanceProtocol", instanceProtocol()).add("InstancePort", instancePort())
                .add("SSLCertificateId", sslCertificateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "LoadBalancerPort":
            return Optional.ofNullable(clazz.cast(loadBalancerPort()));
        case "InstanceProtocol":
            return Optional.ofNullable(clazz.cast(instanceProtocol()));
        case "InstancePort":
            return Optional.ofNullable(clazz.cast(instancePort()));
        case "SSLCertificateId":
            return Optional.ofNullable(clazz.cast(sslCertificateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("LoadBalancerPort", LOAD_BALANCER_PORT_FIELD);
        map.put("InstanceProtocol", INSTANCE_PROTOCOL_FIELD);
        map.put("InstancePort", INSTANCE_PORT_FIELD);
        map.put("SSLCertificateId", SSL_CERTIFICATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Listener, T> g) {
        return obj -> g.apply((Listener) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Listener> {
        /**
         * <p>
         * The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP, or SSL.
         * </p>
         * 
         * @param protocol
         *        The load balancer transport protocol to use for routing: HTTP, HTTPS, TCP, or SSL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The port on which the load balancer is listening. On EC2-VPC, you can specify any port from the range
         * 1-65535. On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587, 1024-65535.
         * </p>
         * 
         * @param loadBalancerPort
         *        The port on which the load balancer is listening. On EC2-VPC, you can specify any port from the range
         *        1-65535. On EC2-Classic, you can specify any port from the following list: 25, 80, 443, 465, 587,
         *        1024-65535.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerPort(Integer loadBalancerPort);

        /**
         * <p>
         * The protocol to use for routing traffic to instances: HTTP, HTTPS, TCP, or SSL.
         * </p>
         * <p>
         * If the front-end protocol is TCP or SSL, the back-end protocol must be TCP or SSL. If the front-end protocol
         * is HTTP or HTTPS, the back-end protocol must be HTTP or HTTPS.
         * </p>
         * <p>
         * If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is
         * secure, (HTTPS or SSL), the listener's <code>InstanceProtocol</code> must also be secure.
         * </p>
         * <p>
         * If there is another listener with the same <code>InstancePort</code> whose <code>InstanceProtocol</code> is
         * HTTP or TCP, the listener's <code>InstanceProtocol</code> must be HTTP or TCP.
         * </p>
         * 
         * @param instanceProtocol
         *        The protocol to use for routing traffic to instances: HTTP, HTTPS, TCP, or SSL.</p>
         *        <p>
         *        If the front-end protocol is TCP or SSL, the back-end protocol must be TCP or SSL. If the front-end
         *        protocol is HTTP or HTTPS, the back-end protocol must be HTTP or HTTPS.
         *        </p>
         *        <p>
         *        If there is another listener with the same <code>InstancePort</code> whose
         *        <code>InstanceProtocol</code> is secure, (HTTPS or SSL), the listener's <code>InstanceProtocol</code>
         *        must also be secure.
         *        </p>
         *        <p>
         *        If there is another listener with the same <code>InstancePort</code> whose
         *        <code>InstanceProtocol</code> is HTTP or TCP, the listener's <code>InstanceProtocol</code> must be
         *        HTTP or TCP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProtocol(String instanceProtocol);

        /**
         * <p>
         * The port on which the instance is listening.
         * </p>
         * 
         * @param instancePort
         *        The port on which the instance is listening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePort(Integer instancePort);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the server certificate.
         * </p>
         * 
         * @param sslCertificateId
         *        The Amazon Resource Name (ARN) of the server certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslCertificateId(String sslCertificateId);
    }

    static final class BuilderImpl implements Builder {
        private String protocol;

        private Integer loadBalancerPort;

        private String instanceProtocol;

        private Integer instancePort;

        private String sslCertificateId;

        private BuilderImpl() {
        }

        private BuilderImpl(Listener model) {
            protocol(model.protocol);
            loadBalancerPort(model.loadBalancerPort);
            instanceProtocol(model.instanceProtocol);
            instancePort(model.instancePort);
            sslCertificateId(model.sslCertificateId);
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Integer getLoadBalancerPort() {
            return loadBalancerPort;
        }

        public final void setLoadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
        }

        @Override
        public final Builder loadBalancerPort(Integer loadBalancerPort) {
            this.loadBalancerPort = loadBalancerPort;
            return this;
        }

        public final String getInstanceProtocol() {
            return instanceProtocol;
        }

        public final void setInstanceProtocol(String instanceProtocol) {
            this.instanceProtocol = instanceProtocol;
        }

        @Override
        public final Builder instanceProtocol(String instanceProtocol) {
            this.instanceProtocol = instanceProtocol;
            return this;
        }

        public final Integer getInstancePort() {
            return instancePort;
        }

        public final void setInstancePort(Integer instancePort) {
            this.instancePort = instancePort;
        }

        @Override
        public final Builder instancePort(Integer instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        public final String getSslCertificateId() {
            return sslCertificateId;
        }

        public final void setSslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
        }

        @Override
        public final Builder sslCertificateId(String sslCertificateId) {
            this.sslCertificateId = sslCertificateId;
            return this;
        }

        @Override
        public Listener build() {
            return new Listener(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
