/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeLoadBalancerAttributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLoadBalancerAttributesResponse extends ElasticLoadBalancingResponse implements
        ToCopyableBuilder<DescribeLoadBalancerAttributesResponse.Builder, DescribeLoadBalancerAttributesResponse> {
    private static final SdkField<LoadBalancerAttributes> LOAD_BALANCER_ATTRIBUTES_FIELD = SdkField
            .<LoadBalancerAttributes> builder(MarshallingType.SDK_POJO).memberName("LoadBalancerAttributes")
            .getter(getter(DescribeLoadBalancerAttributesResponse::loadBalancerAttributes))
            .setter(setter(Builder::loadBalancerAttributes)).constructor(LoadBalancerAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LOAD_BALANCER_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final LoadBalancerAttributes loadBalancerAttributes;

    private DescribeLoadBalancerAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancerAttributes = builder.loadBalancerAttributes;
    }

    /**
     * <p>
     * Information about the load balancer attributes.
     * </p>
     * 
     * @return Information about the load balancer attributes.
     */
    public final LoadBalancerAttributes loadBalancerAttributes() {
        return loadBalancerAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerAttributesResponse)) {
            return false;
        }
        DescribeLoadBalancerAttributesResponse other = (DescribeLoadBalancerAttributesResponse) obj;
        return Objects.equals(loadBalancerAttributes(), other.loadBalancerAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLoadBalancerAttributesResponse").add("LoadBalancerAttributes", loadBalancerAttributes())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerAttributes":
            return Optional.ofNullable(clazz.cast(loadBalancerAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LoadBalancerAttributes", LOAD_BALANCER_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancerAttributesResponse, T> g) {
        return obj -> g.apply((DescribeLoadBalancerAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticLoadBalancingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLoadBalancerAttributesResponse> {
        /**
         * <p>
         * Information about the load balancer attributes.
         * </p>
         * 
         * @param loadBalancerAttributes
         *        Information about the load balancer attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerAttributes(LoadBalancerAttributes loadBalancerAttributes);

        /**
         * <p>
         * Information about the load balancer attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoadBalancerAttributes.Builder} avoiding
         * the need to create one manually via {@link LoadBalancerAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoadBalancerAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #loadBalancerAttributes(LoadBalancerAttributes)}.
         * 
         * @param loadBalancerAttributes
         *        a consumer that will call methods on {@link LoadBalancerAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerAttributes(LoadBalancerAttributes)
         */
        default Builder loadBalancerAttributes(Consumer<LoadBalancerAttributes.Builder> loadBalancerAttributes) {
            return loadBalancerAttributes(LoadBalancerAttributes.builder().applyMutation(loadBalancerAttributes).build());
        }
    }

    static final class BuilderImpl extends ElasticLoadBalancingResponse.BuilderImpl implements Builder {
        private LoadBalancerAttributes loadBalancerAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerAttributesResponse model) {
            super(model);
            loadBalancerAttributes(model.loadBalancerAttributes);
        }

        public final LoadBalancerAttributes.Builder getLoadBalancerAttributes() {
            return loadBalancerAttributes != null ? loadBalancerAttributes.toBuilder() : null;
        }

        public final void setLoadBalancerAttributes(LoadBalancerAttributes.BuilderImpl loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes != null ? loadBalancerAttributes.build() : null;
        }

        @Override
        public final Builder loadBalancerAttributes(LoadBalancerAttributes loadBalancerAttributes) {
            this.loadBalancerAttributes = loadBalancerAttributes;
            return this;
        }

        @Override
        public DescribeLoadBalancerAttributesResponse build() {
            return new DescribeLoadBalancerAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
