/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for DescribeInstanceHealth.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceHealthResponse extends ElasticLoadBalancingResponse implements
        ToCopyableBuilder<DescribeInstanceHealthResponse.Builder, DescribeInstanceHealthResponse> {
    private static final SdkField<List<InstanceState>> INSTANCE_STATES_FIELD = SdkField
            .<List<InstanceState>> builder(MarshallingType.LIST)
            .memberName("InstanceStates")
            .getter(getter(DescribeInstanceHealthResponse::instanceStates))
            .setter(setter(Builder::instanceStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceState> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_STATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InstanceState> instanceStates;

    private DescribeInstanceHealthResponse(BuilderImpl builder) {
        super(builder);
        this.instanceStates = builder.instanceStates;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceStates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceStates() {
        return instanceStates != null && !(instanceStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the health of the instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceStates} method.
     * </p>
     * 
     * @return Information about the health of the instances.
     */
    public final List<InstanceState> instanceStates() {
        return instanceStates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceStates() ? instanceStates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceHealthResponse)) {
            return false;
        }
        DescribeInstanceHealthResponse other = (DescribeInstanceHealthResponse) obj;
        return hasInstanceStates() == other.hasInstanceStates() && Objects.equals(instanceStates(), other.instanceStates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstanceHealthResponse")
                .add("InstanceStates", hasInstanceStates() ? instanceStates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceStates":
            return Optional.ofNullable(clazz.cast(instanceStates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceStates", INSTANCE_STATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceHealthResponse, T> g) {
        return obj -> g.apply((DescribeInstanceHealthResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticLoadBalancingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstanceHealthResponse> {
        /**
         * <p>
         * Information about the health of the instances.
         * </p>
         * 
         * @param instanceStates
         *        Information about the health of the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStates(Collection<InstanceState> instanceStates);

        /**
         * <p>
         * Information about the health of the instances.
         * </p>
         * 
         * @param instanceStates
         *        Information about the health of the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStates(InstanceState... instanceStates);

        /**
         * <p>
         * Information about the health of the instances.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceStates(List<InstanceState>)}.
         * 
         * @param instanceStates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceStates(java.util.Collection<InstanceState>)
         */
        Builder instanceStates(Consumer<InstanceState.Builder>... instanceStates);
    }

    static final class BuilderImpl extends ElasticLoadBalancingResponse.BuilderImpl implements Builder {
        private List<InstanceState> instanceStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceHealthResponse model) {
            super(model);
            instanceStates(model.instanceStates);
        }

        public final List<InstanceState.Builder> getInstanceStates() {
            List<InstanceState.Builder> result = InstanceStatesCopier.copyToBuilder(this.instanceStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceStates(Collection<InstanceState.BuilderImpl> instanceStates) {
            this.instanceStates = InstanceStatesCopier.copyFromBuilder(instanceStates);
        }

        @Override
        public final Builder instanceStates(Collection<InstanceState> instanceStates) {
            this.instanceStates = InstanceStatesCopier.copy(instanceStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(InstanceState... instanceStates) {
            instanceStates(Arrays.asList(instanceStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(Consumer<InstanceState.Builder>... instanceStates) {
            instanceStates(Stream.of(instanceStates).map(c -> InstanceState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeInstanceHealthResponse build() {
            return new DescribeInstanceHealthResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
