/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPlatformBranchesResponse extends ElasticBeanstalkResponse implements
        ToCopyableBuilder<ListPlatformBranchesResponse.Builder, ListPlatformBranchesResponse> {
    private static final SdkField<List<PlatformBranchSummary>> PLATFORM_BRANCH_SUMMARY_LIST_FIELD = SdkField
            .<List<PlatformBranchSummary>> builder(MarshallingType.LIST)
            .memberName("PlatformBranchSummaryList")
            .getter(getter(ListPlatformBranchesResponse::platformBranchSummaryList))
            .setter(setter(Builder::platformBranchSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformBranchSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlatformBranchSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlatformBranchSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPlatformBranchesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PLATFORM_BRANCH_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PlatformBranchSummary> platformBranchSummaryList;

    private final String nextToken;

    private ListPlatformBranchesResponse(BuilderImpl builder) {
        super(builder);
        this.platformBranchSummaryList = builder.platformBranchSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlatformBranchSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPlatformBranchSummaryList() {
        return platformBranchSummaryList != null && !(platformBranchSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about the platform branches.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlatformBranchSummaryList} method.
     * </p>
     * 
     * @return Summary information about the platform branches.
     */
    public final List<PlatformBranchSummary> platformBranchSummaryList() {
        return platformBranchSummaryList;
    }

    /**
     * <p>
     * In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a subsequent
     * request to get the next response page.
     * </p>
     * 
     * @return In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a
     *         subsequent request to get the next response page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPlatformBranchSummaryList() ? platformBranchSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformBranchesResponse)) {
            return false;
        }
        ListPlatformBranchesResponse other = (ListPlatformBranchesResponse) obj;
        return hasPlatformBranchSummaryList() == other.hasPlatformBranchSummaryList()
                && Objects.equals(platformBranchSummaryList(), other.platformBranchSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPlatformBranchesResponse")
                .add("PlatformBranchSummaryList", hasPlatformBranchSummaryList() ? platformBranchSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformBranchSummaryList":
            return Optional.ofNullable(clazz.cast(platformBranchSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PlatformBranchSummaryList", PLATFORM_BRANCH_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPlatformBranchesResponse, T> g) {
        return obj -> g.apply((ListPlatformBranchesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticBeanstalkResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPlatformBranchesResponse> {
        /**
         * <p>
         * Summary information about the platform branches.
         * </p>
         * 
         * @param platformBranchSummaryList
         *        Summary information about the platform branches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformBranchSummaryList(Collection<PlatformBranchSummary> platformBranchSummaryList);

        /**
         * <p>
         * Summary information about the platform branches.
         * </p>
         * 
         * @param platformBranchSummaryList
         *        Summary information about the platform branches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformBranchSummaryList(PlatformBranchSummary... platformBranchSummaryList);

        /**
         * <p>
         * Summary information about the platform branches.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #platformBranchSummaryList(List<PlatformBranchSummary>)}.
         * 
         * @param platformBranchSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticbeanstalk.model.PlatformBranchSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #platformBranchSummaryList(java.util.Collection<PlatformBranchSummary>)
         */
        Builder platformBranchSummaryList(Consumer<PlatformBranchSummary.Builder>... platformBranchSummaryList);

        /**
         * <p>
         * In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a
         * subsequent request to get the next response page.
         * </p>
         * 
         * @param nextToken
         *        In a paginated request, if this value isn't <code>null</code>, it's the token that you can pass in a
         *        subsequent request to get the next response page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticBeanstalkResponse.BuilderImpl implements Builder {
        private List<PlatformBranchSummary> platformBranchSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformBranchesResponse model) {
            super(model);
            platformBranchSummaryList(model.platformBranchSummaryList);
            nextToken(model.nextToken);
        }

        public final List<PlatformBranchSummary.Builder> getPlatformBranchSummaryList() {
            List<PlatformBranchSummary.Builder> result = PlatformBranchSummaryListCopier
                    .copyToBuilder(this.platformBranchSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlatformBranchSummaryList(Collection<PlatformBranchSummary.BuilderImpl> platformBranchSummaryList) {
            this.platformBranchSummaryList = PlatformBranchSummaryListCopier.copyFromBuilder(platformBranchSummaryList);
        }

        @Override
        public final Builder platformBranchSummaryList(Collection<PlatformBranchSummary> platformBranchSummaryList) {
            this.platformBranchSummaryList = PlatformBranchSummaryListCopier.copy(platformBranchSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformBranchSummaryList(PlatformBranchSummary... platformBranchSummaryList) {
            platformBranchSummaryList(Arrays.asList(platformBranchSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformBranchSummaryList(Consumer<PlatformBranchSummary.Builder>... platformBranchSummaryList) {
            platformBranchSummaryList(Stream.of(platformBranchSummaryList)
                    .map(c -> PlatformBranchSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPlatformBranchesResponse build() {
            return new ListPlatformBranchesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
