/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The application version lifecycle settings for an application. Defines the rules that Elastic Beanstalk applies to an
 * application's versions in order to avoid hitting the per-region limit for application versions.
 * </p>
 * <p>
 * When Elastic Beanstalk deletes an application version from its database, you can no longer deploy that version to an
 * environment. The source bundle remains in S3 unless you configure the rule to delete it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationVersionLifecycleConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationVersionLifecycleConfig.Builder, ApplicationVersionLifecycleConfig> {
    private static final SdkField<MaxCountRule> MAX_COUNT_RULE_FIELD = SdkField.<MaxCountRule> builder(MarshallingType.SDK_POJO)
            .memberName("MaxCountRule").getter(getter(ApplicationVersionLifecycleConfig::maxCountRule))
            .setter(setter(Builder::maxCountRule)).constructor(MaxCountRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCountRule").build()).build();

    private static final SdkField<MaxAgeRule> MAX_AGE_RULE_FIELD = SdkField.<MaxAgeRule> builder(MarshallingType.SDK_POJO)
            .memberName("MaxAgeRule").getter(getter(ApplicationVersionLifecycleConfig::maxAgeRule))
            .setter(setter(Builder::maxAgeRule)).constructor(MaxAgeRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAgeRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_COUNT_RULE_FIELD,
            MAX_AGE_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MaxCountRule maxCountRule;

    private final MaxAgeRule maxAgeRule;

    private ApplicationVersionLifecycleConfig(BuilderImpl builder) {
        this.maxCountRule = builder.maxCountRule;
        this.maxAgeRule = builder.maxAgeRule;
    }

    /**
     * <p>
     * Specify a max count rule to restrict the number of application versions that are retained for an application.
     * </p>
     * 
     * @return Specify a max count rule to restrict the number of application versions that are retained for an
     *         application.
     */
    public final MaxCountRule maxCountRule() {
        return maxCountRule;
    }

    /**
     * <p>
     * Specify a max age rule to restrict the length of time that application versions are retained for an application.
     * </p>
     * 
     * @return Specify a max age rule to restrict the length of time that application versions are retained for an
     *         application.
     */
    public final MaxAgeRule maxAgeRule() {
        return maxAgeRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxCountRule());
        hashCode = 31 * hashCode + Objects.hashCode(maxAgeRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationVersionLifecycleConfig)) {
            return false;
        }
        ApplicationVersionLifecycleConfig other = (ApplicationVersionLifecycleConfig) obj;
        return Objects.equals(maxCountRule(), other.maxCountRule()) && Objects.equals(maxAgeRule(), other.maxAgeRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationVersionLifecycleConfig").add("MaxCountRule", maxCountRule())
                .add("MaxAgeRule", maxAgeRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxCountRule":
            return Optional.ofNullable(clazz.cast(maxCountRule()));
        case "MaxAgeRule":
            return Optional.ofNullable(clazz.cast(maxAgeRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MaxCountRule", MAX_COUNT_RULE_FIELD);
        map.put("MaxAgeRule", MAX_AGE_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationVersionLifecycleConfig, T> g) {
        return obj -> g.apply((ApplicationVersionLifecycleConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationVersionLifecycleConfig> {
        /**
         * <p>
         * Specify a max count rule to restrict the number of application versions that are retained for an application.
         * </p>
         * 
         * @param maxCountRule
         *        Specify a max count rule to restrict the number of application versions that are retained for an
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCountRule(MaxCountRule maxCountRule);

        /**
         * <p>
         * Specify a max count rule to restrict the number of application versions that are retained for an application.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaxCountRule.Builder} avoiding the need
         * to create one manually via {@link MaxCountRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaxCountRule.Builder#build()} is called immediately and its
         * result is passed to {@link #maxCountRule(MaxCountRule)}.
         * 
         * @param maxCountRule
         *        a consumer that will call methods on {@link MaxCountRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maxCountRule(MaxCountRule)
         */
        default Builder maxCountRule(Consumer<MaxCountRule.Builder> maxCountRule) {
            return maxCountRule(MaxCountRule.builder().applyMutation(maxCountRule).build());
        }

        /**
         * <p>
         * Specify a max age rule to restrict the length of time that application versions are retained for an
         * application.
         * </p>
         * 
         * @param maxAgeRule
         *        Specify a max age rule to restrict the length of time that application versions are retained for an
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAgeRule(MaxAgeRule maxAgeRule);

        /**
         * <p>
         * Specify a max age rule to restrict the length of time that application versions are retained for an
         * application.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaxAgeRule.Builder} avoiding the need to
         * create one manually via {@link MaxAgeRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaxAgeRule.Builder#build()} is called immediately and its result
         * is passed to {@link #maxAgeRule(MaxAgeRule)}.
         * 
         * @param maxAgeRule
         *        a consumer that will call methods on {@link MaxAgeRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maxAgeRule(MaxAgeRule)
         */
        default Builder maxAgeRule(Consumer<MaxAgeRule.Builder> maxAgeRule) {
            return maxAgeRule(MaxAgeRule.builder().applyMutation(maxAgeRule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MaxCountRule maxCountRule;

        private MaxAgeRule maxAgeRule;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationVersionLifecycleConfig model) {
            maxCountRule(model.maxCountRule);
            maxAgeRule(model.maxAgeRule);
        }

        public final MaxCountRule.Builder getMaxCountRule() {
            return maxCountRule != null ? maxCountRule.toBuilder() : null;
        }

        public final void setMaxCountRule(MaxCountRule.BuilderImpl maxCountRule) {
            this.maxCountRule = maxCountRule != null ? maxCountRule.build() : null;
        }

        @Override
        public final Builder maxCountRule(MaxCountRule maxCountRule) {
            this.maxCountRule = maxCountRule;
            return this;
        }

        public final MaxAgeRule.Builder getMaxAgeRule() {
            return maxAgeRule != null ? maxAgeRule.toBuilder() : null;
        }

        public final void setMaxAgeRule(MaxAgeRule.BuilderImpl maxAgeRule) {
            this.maxAgeRule = maxAgeRule != null ? maxAgeRule.build() : null;
        }

        @Override
        public final Builder maxAgeRule(MaxAgeRule maxAgeRule) {
            this.maxAgeRule = maxAgeRule;
            return this;
        }

        @Override
        public ApplicationVersionLifecycleConfig build() {
            return new ApplicationVersionLifecycleConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
