/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the updates being applied to the user group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserGroupPendingChanges implements SdkPojo, Serializable,
        ToCopyableBuilder<UserGroupPendingChanges.Builder, UserGroupPendingChanges> {
    private static final SdkField<List<String>> USER_IDS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserIdsToRemove")
            .getter(getter(UserGroupPendingChanges::userIdsToRemove))
            .setter(setter(Builder::userIdsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USER_IDS_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserIdsToAdd")
            .getter(getter(UserGroupPendingChanges::userIdsToAdd))
            .setter(setter(Builder::userIdsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_IDS_TO_REMOVE_FIELD,
            USER_IDS_TO_ADD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> userIdsToRemove;

    private final List<String> userIdsToAdd;

    private UserGroupPendingChanges(BuilderImpl builder) {
        this.userIdsToRemove = builder.userIdsToRemove;
        this.userIdsToAdd = builder.userIdsToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserIdsToRemove property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserIdsToRemove() {
        return userIdsToRemove != null && !(userIdsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user IDs to remove.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserIdsToRemove} method.
     * </p>
     * 
     * @return The list of user IDs to remove.
     */
    public final List<String> userIdsToRemove() {
        return userIdsToRemove;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserIdsToAdd property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserIdsToAdd() {
        return userIdsToAdd != null && !(userIdsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user IDs to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserIdsToAdd} method.
     * </p>
     * 
     * @return The list of user IDs to add.
     */
    public final List<String> userIdsToAdd() {
        return userIdsToAdd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasUserIdsToRemove() ? userIdsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserIdsToAdd() ? userIdsToAdd() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserGroupPendingChanges)) {
            return false;
        }
        UserGroupPendingChanges other = (UserGroupPendingChanges) obj;
        return hasUserIdsToRemove() == other.hasUserIdsToRemove() && Objects.equals(userIdsToRemove(), other.userIdsToRemove())
                && hasUserIdsToAdd() == other.hasUserIdsToAdd() && Objects.equals(userIdsToAdd(), other.userIdsToAdd());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserGroupPendingChanges")
                .add("UserIdsToRemove", hasUserIdsToRemove() ? userIdsToRemove() : null)
                .add("UserIdsToAdd", hasUserIdsToAdd() ? userIdsToAdd() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserIdsToRemove":
            return Optional.ofNullable(clazz.cast(userIdsToRemove()));
        case "UserIdsToAdd":
            return Optional.ofNullable(clazz.cast(userIdsToAdd()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserIdsToRemove", USER_IDS_TO_REMOVE_FIELD);
        map.put("UserIdsToAdd", USER_IDS_TO_ADD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserGroupPendingChanges, T> g) {
        return obj -> g.apply((UserGroupPendingChanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserGroupPendingChanges> {
        /**
         * <p>
         * The list of user IDs to remove.
         * </p>
         * 
         * @param userIdsToRemove
         *        The list of user IDs to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdsToRemove(Collection<String> userIdsToRemove);

        /**
         * <p>
         * The list of user IDs to remove.
         * </p>
         * 
         * @param userIdsToRemove
         *        The list of user IDs to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdsToRemove(String... userIdsToRemove);

        /**
         * <p>
         * The list of user IDs to add.
         * </p>
         * 
         * @param userIdsToAdd
         *        The list of user IDs to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdsToAdd(Collection<String> userIdsToAdd);

        /**
         * <p>
         * The list of user IDs to add.
         * </p>
         * 
         * @param userIdsToAdd
         *        The list of user IDs to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdsToAdd(String... userIdsToAdd);
    }

    static final class BuilderImpl implements Builder {
        private List<String> userIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private List<String> userIdsToAdd = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserGroupPendingChanges model) {
            userIdsToRemove(model.userIdsToRemove);
            userIdsToAdd(model.userIdsToAdd);
        }

        public final Collection<String> getUserIdsToRemove() {
            if (userIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return userIdsToRemove;
        }

        public final void setUserIdsToRemove(Collection<String> userIdsToRemove) {
            this.userIdsToRemove = UserIdListCopier.copy(userIdsToRemove);
        }

        @Override
        public final Builder userIdsToRemove(Collection<String> userIdsToRemove) {
            this.userIdsToRemove = UserIdListCopier.copy(userIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdsToRemove(String... userIdsToRemove) {
            userIdsToRemove(Arrays.asList(userIdsToRemove));
            return this;
        }

        public final Collection<String> getUserIdsToAdd() {
            if (userIdsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return userIdsToAdd;
        }

        public final void setUserIdsToAdd(Collection<String> userIdsToAdd) {
            this.userIdsToAdd = UserIdListCopier.copy(userIdsToAdd);
        }

        @Override
        public final Builder userIdsToAdd(Collection<String> userIdsToAdd) {
            this.userIdsToAdd = UserIdListCopier.copy(userIdsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdsToAdd(String... userIdsToAdd) {
            userIdsToAdd(Arrays.asList(userIdsToAdd));
            return this;
        }

        @Override
        public UserGroupPendingChanges build() {
            return new UserGroupPendingChanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
