/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource representing a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerlessCacheSnapshot implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerlessCacheSnapshot.Builder, ServerlessCacheSnapshot> {
    private static final SdkField<String> SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServerlessCacheSnapshotName")
            .getter(getter(ServerlessCacheSnapshot::serverlessCacheSnapshotName))
            .setter(setter(Builder::serverlessCacheSnapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheSnapshotName")
                    .build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(ServerlessCacheSnapshot::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(ServerlessCacheSnapshot::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotType").getter(getter(ServerlessCacheSnapshot::snapshotType))
            .setter(setter(Builder::snapshotType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ServerlessCacheSnapshot::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(ServerlessCacheSnapshot::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<Instant> EXPIRY_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiryTime").getter(getter(ServerlessCacheSnapshot::expiryTime)).setter(setter(Builder::expiryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryTime").build()).build();

    private static final SdkField<String> BYTES_USED_FOR_CACHE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BytesUsedForCache").getter(getter(ServerlessCacheSnapshot::bytesUsedForCache))
            .setter(setter(Builder::bytesUsedForCache))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesUsedForCache").build()).build();

    private static final SdkField<ServerlessCacheConfiguration> SERVERLESS_CACHE_CONFIGURATION_FIELD = SdkField
            .<ServerlessCacheConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ServerlessCacheConfiguration")
            .getter(getter(ServerlessCacheSnapshot::serverlessCacheConfiguration))
            .setter(setter(Builder::serverlessCacheConfiguration))
            .constructor(ServerlessCacheConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD, ARN_FIELD, KMS_KEY_ID_FIELD, SNAPSHOT_TYPE_FIELD, STATUS_FIELD,
            CREATE_TIME_FIELD, EXPIRY_TIME_FIELD, BYTES_USED_FOR_CACHE_FIELD, SERVERLESS_CACHE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serverlessCacheSnapshotName;

    private final String arn;

    private final String kmsKeyId;

    private final String snapshotType;

    private final String status;

    private final Instant createTime;

    private final Instant expiryTime;

    private final String bytesUsedForCache;

    private final ServerlessCacheConfiguration serverlessCacheConfiguration;

    private ServerlessCacheSnapshot(BuilderImpl builder) {
        this.serverlessCacheSnapshotName = builder.serverlessCacheSnapshotName;
        this.arn = builder.arn;
        this.kmsKeyId = builder.kmsKeyId;
        this.snapshotType = builder.snapshotType;
        this.status = builder.status;
        this.createTime = builder.createTime;
        this.expiryTime = builder.expiryTime;
        this.bytesUsedForCache = builder.bytesUsedForCache;
        this.serverlessCacheConfiguration = builder.serverlessCacheConfiguration;
    }

    /**
     * <p>
     * The identifier of a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return The identifier of a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless Memcached
     *         only.
     */
    public final String serverlessCacheSnapshotName() {
        return serverlessCacheSnapshotName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless
     * Memcached only.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a serverless cache snapshot. Available for Valkey, Redis OSS and
     *         Serverless Memcached only.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Key Management Service (KMS) key of a serverless cache snapshot. Available for
     * Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Key Management Service (KMS) key of a serverless cache snapshot.
     *         Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The type of snapshot of serverless cache. Available for Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return The type of snapshot of serverless cache. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public final String snapshotType() {
        return snapshotType;
    }

    /**
     * <p>
     * The current status of the serverless cache. Available for Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return The current status of the serverless cache. Available for Valkey, Redis OSS and Serverless Memcached
     *         only.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The date and time that the source serverless cache's metadata and cache data set was obtained for the snapshot.
     * Available for Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return The date and time that the source serverless cache's metadata and cache data set was obtained for the
     *         snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time that the serverless cache snapshot will expire. Available for Valkey, Redis OSS and Serverless Memcached
     * only.
     * </p>
     * 
     * @return The time that the serverless cache snapshot will expire. Available for Valkey, Redis OSS and Serverless
     *         Memcached only.
     */
    public final Instant expiryTime() {
        return expiryTime;
    }

    /**
     * <p>
     * The total size of a serverless cache snapshot, in bytes. Available for Valkey, Redis OSS and Serverless Memcached
     * only.
     * </p>
     * 
     * @return The total size of a serverless cache snapshot, in bytes. Available for Valkey, Redis OSS and Serverless
     *         Memcached only.
     */
    public final String bytesUsedForCache() {
        return bytesUsedForCache;
    }

    /**
     * <p>
     * The configuration of the serverless cache, at the time the snapshot was taken. Available for Valkey, Redis OSS
     * and Serverless Memcached only.
     * </p>
     * 
     * @return The configuration of the serverless cache, at the time the snapshot was taken. Available for Valkey,
     *         Redis OSS and Serverless Memcached only.
     */
    public final ServerlessCacheConfiguration serverlessCacheConfiguration() {
        return serverlessCacheConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCacheSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(expiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(bytesUsedForCache());
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCacheConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessCacheSnapshot)) {
            return false;
        }
        ServerlessCacheSnapshot other = (ServerlessCacheSnapshot) obj;
        return Objects.equals(serverlessCacheSnapshotName(), other.serverlessCacheSnapshotName())
                && Objects.equals(arn(), other.arn()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(snapshotType(), other.snapshotType()) && Objects.equals(status(), other.status())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(expiryTime(), other.expiryTime())
                && Objects.equals(bytesUsedForCache(), other.bytesUsedForCache())
                && Objects.equals(serverlessCacheConfiguration(), other.serverlessCacheConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerlessCacheSnapshot").add("ServerlessCacheSnapshotName", serverlessCacheSnapshotName())
                .add("ARN", arn()).add("KmsKeyId", kmsKeyId()).add("SnapshotType", snapshotType()).add("Status", status())
                .add("CreateTime", createTime()).add("ExpiryTime", expiryTime()).add("BytesUsedForCache", bytesUsedForCache())
                .add("ServerlessCacheConfiguration", serverlessCacheConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerlessCacheSnapshotName":
            return Optional.ofNullable(clazz.cast(serverlessCacheSnapshotName()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "SnapshotType":
            return Optional.ofNullable(clazz.cast(snapshotType()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "ExpiryTime":
            return Optional.ofNullable(clazz.cast(expiryTime()));
        case "BytesUsedForCache":
            return Optional.ofNullable(clazz.cast(bytesUsedForCache()));
        case "ServerlessCacheConfiguration":
            return Optional.ofNullable(clazz.cast(serverlessCacheConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServerlessCacheSnapshotName", SERVERLESS_CACHE_SNAPSHOT_NAME_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("SnapshotType", SNAPSHOT_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("ExpiryTime", EXPIRY_TIME_FIELD);
        map.put("BytesUsedForCache", BYTES_USED_FOR_CACHE_FIELD);
        map.put("ServerlessCacheConfiguration", SERVERLESS_CACHE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerlessCacheSnapshot, T> g) {
        return obj -> g.apply((ServerlessCacheSnapshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerlessCacheSnapshot> {
        /**
         * <p>
         * The identifier of a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param serverlessCacheSnapshotName
         *        The identifier of a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless
         *        Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCacheSnapshotName(String serverlessCacheSnapshotName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a serverless cache snapshot. Available for Valkey, Redis OSS and Serverless
         * Memcached only.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of a serverless cache snapshot. Available for Valkey, Redis OSS and
         *        Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the Amazon Web Services Key Management Service (KMS) key of a serverless cache snapshot. Available
         * for Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the Amazon Web Services Key Management Service (KMS) key of a serverless cache snapshot.
         *        Available for Valkey, Redis OSS and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The type of snapshot of serverless cache. Available for Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param snapshotType
         *        The type of snapshot of serverless cache. Available for Valkey, Redis OSS and Serverless Memcached
         *        only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotType(String snapshotType);

        /**
         * <p>
         * The current status of the serverless cache. Available for Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param status
         *        The current status of the serverless cache. Available for Valkey, Redis OSS and Serverless Memcached
         *        only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time that the source serverless cache's metadata and cache data set was obtained for the
         * snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param createTime
         *        The date and time that the source serverless cache's metadata and cache data set was obtained for the
         *        snapshot. Available for Valkey, Redis OSS and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time that the serverless cache snapshot will expire. Available for Valkey, Redis OSS and Serverless
         * Memcached only.
         * </p>
         * 
         * @param expiryTime
         *        The time that the serverless cache snapshot will expire. Available for Valkey, Redis OSS and
         *        Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryTime(Instant expiryTime);

        /**
         * <p>
         * The total size of a serverless cache snapshot, in bytes. Available for Valkey, Redis OSS and Serverless
         * Memcached only.
         * </p>
         * 
         * @param bytesUsedForCache
         *        The total size of a serverless cache snapshot, in bytes. Available for Valkey, Redis OSS and
         *        Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesUsedForCache(String bytesUsedForCache);

        /**
         * <p>
         * The configuration of the serverless cache, at the time the snapshot was taken. Available for Valkey, Redis
         * OSS and Serverless Memcached only.
         * </p>
         * 
         * @param serverlessCacheConfiguration
         *        The configuration of the serverless cache, at the time the snapshot was taken. Available for Valkey,
         *        Redis OSS and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCacheConfiguration(ServerlessCacheConfiguration serverlessCacheConfiguration);

        /**
         * <p>
         * The configuration of the serverless cache, at the time the snapshot was taken. Available for Valkey, Redis
         * OSS and Serverless Memcached only.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServerlessCacheConfiguration.Builder}
         * avoiding the need to create one manually via {@link ServerlessCacheConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerlessCacheConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #serverlessCacheConfiguration(ServerlessCacheConfiguration)}.
         * 
         * @param serverlessCacheConfiguration
         *        a consumer that will call methods on {@link ServerlessCacheConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverlessCacheConfiguration(ServerlessCacheConfiguration)
         */
        default Builder serverlessCacheConfiguration(Consumer<ServerlessCacheConfiguration.Builder> serverlessCacheConfiguration) {
            return serverlessCacheConfiguration(ServerlessCacheConfiguration.builder()
                    .applyMutation(serverlessCacheConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String serverlessCacheSnapshotName;

        private String arn;

        private String kmsKeyId;

        private String snapshotType;

        private String status;

        private Instant createTime;

        private Instant expiryTime;

        private String bytesUsedForCache;

        private ServerlessCacheConfiguration serverlessCacheConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessCacheSnapshot model) {
            serverlessCacheSnapshotName(model.serverlessCacheSnapshotName);
            arn(model.arn);
            kmsKeyId(model.kmsKeyId);
            snapshotType(model.snapshotType);
            status(model.status);
            createTime(model.createTime);
            expiryTime(model.expiryTime);
            bytesUsedForCache(model.bytesUsedForCache);
            serverlessCacheConfiguration(model.serverlessCacheConfiguration);
        }

        public final String getServerlessCacheSnapshotName() {
            return serverlessCacheSnapshotName;
        }

        public final void setServerlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
        }

        @Override
        public final Builder serverlessCacheSnapshotName(String serverlessCacheSnapshotName) {
            this.serverlessCacheSnapshotName = serverlessCacheSnapshotName;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getSnapshotType() {
            return snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getExpiryTime() {
            return expiryTime;
        }

        public final void setExpiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
        }

        @Override
        public final Builder expiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final String getBytesUsedForCache() {
            return bytesUsedForCache;
        }

        public final void setBytesUsedForCache(String bytesUsedForCache) {
            this.bytesUsedForCache = bytesUsedForCache;
        }

        @Override
        public final Builder bytesUsedForCache(String bytesUsedForCache) {
            this.bytesUsedForCache = bytesUsedForCache;
            return this;
        }

        public final ServerlessCacheConfiguration.Builder getServerlessCacheConfiguration() {
            return serverlessCacheConfiguration != null ? serverlessCacheConfiguration.toBuilder() : null;
        }

        public final void setServerlessCacheConfiguration(ServerlessCacheConfiguration.BuilderImpl serverlessCacheConfiguration) {
            this.serverlessCacheConfiguration = serverlessCacheConfiguration != null ? serverlessCacheConfiguration.build()
                    : null;
        }

        @Override
        public final Builder serverlessCacheConfiguration(ServerlessCacheConfiguration serverlessCacheConfiguration) {
            this.serverlessCacheConfiguration = serverlessCacheConfiguration;
            return this;
        }

        @Override
        public ServerlessCacheSnapshot build() {
            return new ServerlessCacheSnapshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
