/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource representing a serverless cache.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerlessCache implements SdkPojo, Serializable, ToCopyableBuilder<ServerlessCache.Builder, ServerlessCache> {
    private static final SdkField<String> SERVERLESS_CACHE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerlessCacheName").getter(getter(ServerlessCache::serverlessCacheName))
            .setter(setter(Builder::serverlessCacheName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCacheName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ServerlessCache::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(ServerlessCache::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ServerlessCache::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(ServerlessCache::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MajorEngineVersion").getter(getter(ServerlessCache::majorEngineVersion))
            .setter(setter(Builder::majorEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build())
            .build();

    private static final SdkField<String> FULL_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FullEngineVersion").getter(getter(ServerlessCache::fullEngineVersion))
            .setter(setter(Builder::fullEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullEngineVersion").build()).build();

    private static final SdkField<CacheUsageLimits> CACHE_USAGE_LIMITS_FIELD = SdkField
            .<CacheUsageLimits> builder(MarshallingType.SDK_POJO).memberName("CacheUsageLimits")
            .getter(getter(ServerlessCache::cacheUsageLimits)).setter(setter(Builder::cacheUsageLimits))
            .constructor(CacheUsageLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheUsageLimits").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(ServerlessCache::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(ServerlessCache::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SecurityGroupId").build()).build()).build()).build();

    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("Endpoint").getter(getter(ServerlessCache::endpoint)).setter(setter(Builder::endpoint))
            .constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<Endpoint> READER_ENDPOINT_FIELD = SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
            .memberName("ReaderEndpoint").getter(getter(ServerlessCache::readerEndpoint)).setter(setter(Builder::readerEndpoint))
            .constructor(Endpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReaderEndpoint").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ARN")
            .getter(getter(ServerlessCache::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()).build();

    private static final SdkField<String> USER_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserGroupId").getter(getter(ServerlessCache::userGroupId)).setter(setter(Builder::userGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(ServerlessCache::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SubnetId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SubnetId").build()).build()).build()).build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SnapshotRetentionLimit").getter(getter(ServerlessCache::snapshotRetentionLimit))
            .setter(setter(Builder::snapshotRetentionLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build())
            .build();

    private static final SdkField<String> DAILY_SNAPSHOT_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DailySnapshotTime").getter(getter(ServerlessCache::dailySnapshotTime))
            .setter(setter(Builder::dailySnapshotTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailySnapshotTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERLESS_CACHE_NAME_FIELD,
            DESCRIPTION_FIELD, CREATE_TIME_FIELD, STATUS_FIELD, ENGINE_FIELD, MAJOR_ENGINE_VERSION_FIELD,
            FULL_ENGINE_VERSION_FIELD, CACHE_USAGE_LIMITS_FIELD, KMS_KEY_ID_FIELD, SECURITY_GROUP_IDS_FIELD, ENDPOINT_FIELD,
            READER_ENDPOINT_FIELD, ARN_FIELD, USER_GROUP_ID_FIELD, SUBNET_IDS_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD,
            DAILY_SNAPSHOT_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serverlessCacheName;

    private final String description;

    private final Instant createTime;

    private final String status;

    private final String engine;

    private final String majorEngineVersion;

    private final String fullEngineVersion;

    private final CacheUsageLimits cacheUsageLimits;

    private final String kmsKeyId;

    private final List<String> securityGroupIds;

    private final Endpoint endpoint;

    private final Endpoint readerEndpoint;

    private final String arn;

    private final String userGroupId;

    private final List<String> subnetIds;

    private final Integer snapshotRetentionLimit;

    private final String dailySnapshotTime;

    private ServerlessCache(BuilderImpl builder) {
        this.serverlessCacheName = builder.serverlessCacheName;
        this.description = builder.description;
        this.createTime = builder.createTime;
        this.status = builder.status;
        this.engine = builder.engine;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.fullEngineVersion = builder.fullEngineVersion;
        this.cacheUsageLimits = builder.cacheUsageLimits;
        this.kmsKeyId = builder.kmsKeyId;
        this.securityGroupIds = builder.securityGroupIds;
        this.endpoint = builder.endpoint;
        this.readerEndpoint = builder.readerEndpoint;
        this.arn = builder.arn;
        this.userGroupId = builder.userGroupId;
        this.subnetIds = builder.subnetIds;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.dailySnapshotTime = builder.dailySnapshotTime;
    }

    /**
     * <p>
     * The unique identifier of the serverless cache.
     * </p>
     * 
     * @return The unique identifier of the serverless cache.
     */
    public final String serverlessCacheName() {
        return serverlessCacheName;
    }

    /**
     * <p>
     * A description of the serverless cache.
     * </p>
     * 
     * @return A description of the serverless cache.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * When the serverless cache was created.
     * </p>
     * 
     * @return When the serverless cache was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The current status of the serverless cache. The allowed values are CREATING, AVAILABLE, DELETING, CREATE-FAILED
     * and MODIFYING.
     * </p>
     * 
     * @return The current status of the serverless cache. The allowed values are CREATING, AVAILABLE, DELETING,
     *         CREATE-FAILED and MODIFYING.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The engine the serverless cache is compatible with.
     * </p>
     * 
     * @return The engine the serverless cache is compatible with.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the engine the serverless cache is compatible with.
     * </p>
     * 
     * @return The version number of the engine the serverless cache is compatible with.
     */
    public final String majorEngineVersion() {
        return majorEngineVersion;
    }

    /**
     * <p>
     * The name and version number of the engine the serverless cache is compatible with.
     * </p>
     * 
     * @return The name and version number of the engine the serverless cache is compatible with.
     */
    public final String fullEngineVersion() {
        return fullEngineVersion;
    }

    /**
     * <p>
     * The cache usage limit for the serverless cache.
     * </p>
     * 
     * @return The cache usage limit for the serverless cache.
     */
    public final CacheUsageLimits cacheUsageLimits() {
        return cacheUsageLimits;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt data at rest in the
     * serverless cache.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt data at rest
     *         in the serverless cache.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the EC2 security groups associated with the serverless cache.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The IDs of the EC2 security groups associated with the serverless cache.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * Returns the value of the Endpoint property for this object.
     * 
     * @return The value of the Endpoint property for this object.
     */
    public final Endpoint endpoint() {
        return endpoint;
    }

    /**
     * Returns the value of the ReaderEndpoint property for this object.
     * 
     * @return The value of the ReaderEndpoint property for this object.
     */
    public final Endpoint readerEndpoint() {
        return readerEndpoint;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the serverless cache.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the serverless cache.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The identifier of the user group associated with the serverless cache. Available for Valkey and Redis OSS only.
     * Default is NULL.
     * </p>
     * 
     * @return The identifier of the user group associated with the serverless cache. Available for Valkey and Redis OSS
     *         only. Default is NULL.
     */
    public final String userGroupId() {
        return userGroupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default subnets across
     * AZs in your VPC. For all other Regions, if no subnet IDs are given then ElastiCache will select 3 default subnets
     * across AZs in your default VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default subnets
     *         across AZs in your VPC. For all other Regions, if no subnet IDs are given then ElastiCache will select 3
     *         default subnets across AZs in your default VPC.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The current setting for the number of serverless cache snapshots the system will retain. Available for Valkey,
     * Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return The current setting for the number of serverless cache snapshots the system will retain. Available for
     *         Valkey, Redis OSS and Serverless Memcached only.
     */
    public final Integer snapshotRetentionLimit() {
        return snapshotRetentionLimit;
    }

    /**
     * <p>
     * The daily time that a cache snapshot will be created. Default is NULL, i.e. snapshots will not be created at a
     * specific time on a daily basis. Available for Valkey, Redis OSS and Serverless Memcached only.
     * </p>
     * 
     * @return The daily time that a cache snapshot will be created. Default is NULL, i.e. snapshots will not be created
     *         at a specific time on a daily basis. Available for Valkey, Redis OSS and Serverless Memcached only.
     */
    public final String dailySnapshotTime() {
        return dailySnapshotTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverlessCacheName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(fullEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(cacheUsageLimits());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(readerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(userGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(dailySnapshotTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessCache)) {
            return false;
        }
        ServerlessCache other = (ServerlessCache) obj;
        return Objects.equals(serverlessCacheName(), other.serverlessCacheName())
                && Objects.equals(description(), other.description()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(status(), other.status()) && Objects.equals(engine(), other.engine())
                && Objects.equals(majorEngineVersion(), other.majorEngineVersion())
                && Objects.equals(fullEngineVersion(), other.fullEngineVersion())
                && Objects.equals(cacheUsageLimits(), other.cacheUsageLimits()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(readerEndpoint(), other.readerEndpoint()) && Objects.equals(arn(), other.arn())
                && Objects.equals(userGroupId(), other.userGroupId()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(snapshotRetentionLimit(), other.snapshotRetentionLimit())
                && Objects.equals(dailySnapshotTime(), other.dailySnapshotTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerlessCache").add("ServerlessCacheName", serverlessCacheName())
                .add("Description", description()).add("CreateTime", createTime()).add("Status", status())
                .add("Engine", engine()).add("MajorEngineVersion", majorEngineVersion())
                .add("FullEngineVersion", fullEngineVersion()).add("CacheUsageLimits", cacheUsageLimits())
                .add("KmsKeyId", kmsKeyId()).add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("Endpoint", endpoint()).add("ReaderEndpoint", readerEndpoint()).add("ARN", arn())
                .add("UserGroupId", userGroupId()).add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("SnapshotRetentionLimit", snapshotRetentionLimit()).add("DailySnapshotTime", dailySnapshotTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerlessCacheName":
            return Optional.ofNullable(clazz.cast(serverlessCacheName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "MajorEngineVersion":
            return Optional.ofNullable(clazz.cast(majorEngineVersion()));
        case "FullEngineVersion":
            return Optional.ofNullable(clazz.cast(fullEngineVersion()));
        case "CacheUsageLimits":
            return Optional.ofNullable(clazz.cast(cacheUsageLimits()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "ReaderEndpoint":
            return Optional.ofNullable(clazz.cast(readerEndpoint()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "UserGroupId":
            return Optional.ofNullable(clazz.cast(userGroupId()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "SnapshotRetentionLimit":
            return Optional.ofNullable(clazz.cast(snapshotRetentionLimit()));
        case "DailySnapshotTime":
            return Optional.ofNullable(clazz.cast(dailySnapshotTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServerlessCacheName", SERVERLESS_CACHE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("MajorEngineVersion", MAJOR_ENGINE_VERSION_FIELD);
        map.put("FullEngineVersion", FULL_ENGINE_VERSION_FIELD);
        map.put("CacheUsageLimits", CACHE_USAGE_LIMITS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("Endpoint", ENDPOINT_FIELD);
        map.put("ReaderEndpoint", READER_ENDPOINT_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("UserGroupId", USER_GROUP_ID_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("SnapshotRetentionLimit", SNAPSHOT_RETENTION_LIMIT_FIELD);
        map.put("DailySnapshotTime", DAILY_SNAPSHOT_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerlessCache, T> g) {
        return obj -> g.apply((ServerlessCache) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerlessCache> {
        /**
         * <p>
         * The unique identifier of the serverless cache.
         * </p>
         * 
         * @param serverlessCacheName
         *        The unique identifier of the serverless cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCacheName(String serverlessCacheName);

        /**
         * <p>
         * A description of the serverless cache.
         * </p>
         * 
         * @param description
         *        A description of the serverless cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * When the serverless cache was created.
         * </p>
         * 
         * @param createTime
         *        When the serverless cache was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The current status of the serverless cache. The allowed values are CREATING, AVAILABLE, DELETING,
         * CREATE-FAILED and MODIFYING.
         * </p>
         * 
         * @param status
         *        The current status of the serverless cache. The allowed values are CREATING, AVAILABLE, DELETING,
         *        CREATE-FAILED and MODIFYING.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The engine the serverless cache is compatible with.
         * </p>
         * 
         * @param engine
         *        The engine the serverless cache is compatible with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the engine the serverless cache is compatible with.
         * </p>
         * 
         * @param majorEngineVersion
         *        The version number of the engine the serverless cache is compatible with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorEngineVersion(String majorEngineVersion);

        /**
         * <p>
         * The name and version number of the engine the serverless cache is compatible with.
         * </p>
         * 
         * @param fullEngineVersion
         *        The name and version number of the engine the serverless cache is compatible with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullEngineVersion(String fullEngineVersion);

        /**
         * <p>
         * The cache usage limit for the serverless cache.
         * </p>
         * 
         * @param cacheUsageLimits
         *        The cache usage limit for the serverless cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheUsageLimits(CacheUsageLimits cacheUsageLimits);

        /**
         * <p>
         * The cache usage limit for the serverless cache.
         * </p>
         * This is a convenience method that creates an instance of the {@link CacheUsageLimits.Builder} avoiding the
         * need to create one manually via {@link CacheUsageLimits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CacheUsageLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheUsageLimits(CacheUsageLimits)}.
         * 
         * @param cacheUsageLimits
         *        a consumer that will call methods on {@link CacheUsageLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheUsageLimits(CacheUsageLimits)
         */
        default Builder cacheUsageLimits(Consumer<CacheUsageLimits.Builder> cacheUsageLimits) {
            return cacheUsageLimits(CacheUsageLimits.builder().applyMutation(cacheUsageLimits).build());
        }

        /**
         * <p>
         * The ID of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt data at rest in
         * the serverless cache.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt data at
         *        rest in the serverless cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The IDs of the EC2 security groups associated with the serverless cache.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the EC2 security groups associated with the serverless cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The IDs of the EC2 security groups associated with the serverless cache.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the EC2 security groups associated with the serverless cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * Sets the value of the Endpoint property for this object.
         *
         * @param endpoint
         *        The new value for the Endpoint property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(Endpoint endpoint);

        /**
         * Sets the value of the Endpoint property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Endpoint.Builder} avoiding the need to
         * create one manually via {@link Endpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #endpoint(Endpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(Endpoint)
         */
        default Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return endpoint(Endpoint.builder().applyMutation(endpoint).build());
        }

        /**
         * Sets the value of the ReaderEndpoint property for this object.
         *
         * @param readerEndpoint
         *        The new value for the ReaderEndpoint property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readerEndpoint(Endpoint readerEndpoint);

        /**
         * Sets the value of the ReaderEndpoint property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Endpoint.Builder} avoiding the need to
         * create one manually via {@link Endpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Endpoint.Builder#build()} is called immediately and its result is
         * passed to {@link #readerEndpoint(Endpoint)}.
         * 
         * @param readerEndpoint
         *        a consumer that will call methods on {@link Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readerEndpoint(Endpoint)
         */
        default Builder readerEndpoint(Consumer<Endpoint.Builder> readerEndpoint) {
            return readerEndpoint(Endpoint.builder().applyMutation(readerEndpoint).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the serverless cache.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the serverless cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The identifier of the user group associated with the serverless cache. Available for Valkey and Redis OSS
         * only. Default is NULL.
         * </p>
         * 
         * @param userGroupId
         *        The identifier of the user group associated with the serverless cache. Available for Valkey and Redis
         *        OSS only. Default is NULL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userGroupId(String userGroupId);

        /**
         * <p>
         * If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default subnets
         * across AZs in your VPC. For all other Regions, if no subnet IDs are given then ElastiCache will select 3
         * default subnets across AZs in your default VPC.
         * </p>
         * 
         * @param subnetIds
         *        If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default
         *        subnets across AZs in your VPC. For all other Regions, if no subnet IDs are given then ElastiCache
         *        will select 3 default subnets across AZs in your default VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default subnets
         * across AZs in your VPC. For all other Regions, if no subnet IDs are given then ElastiCache will select 3
         * default subnets across AZs in your default VPC.
         * </p>
         * 
         * @param subnetIds
         *        If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default
         *        subnets across AZs in your VPC. For all other Regions, if no subnet IDs are given then ElastiCache
         *        will select 3 default subnets across AZs in your default VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The current setting for the number of serverless cache snapshots the system will retain. Available for
         * Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param snapshotRetentionLimit
         *        The current setting for the number of serverless cache snapshots the system will retain. Available for
         *        Valkey, Redis OSS and Serverless Memcached only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionLimit(Integer snapshotRetentionLimit);

        /**
         * <p>
         * The daily time that a cache snapshot will be created. Default is NULL, i.e. snapshots will not be created at
         * a specific time on a daily basis. Available for Valkey, Redis OSS and Serverless Memcached only.
         * </p>
         * 
         * @param dailySnapshotTime
         *        The daily time that a cache snapshot will be created. Default is NULL, i.e. snapshots will not be
         *        created at a specific time on a daily basis. Available for Valkey, Redis OSS and Serverless Memcached
         *        only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailySnapshotTime(String dailySnapshotTime);
    }

    static final class BuilderImpl implements Builder {
        private String serverlessCacheName;

        private String description;

        private Instant createTime;

        private String status;

        private String engine;

        private String majorEngineVersion;

        private String fullEngineVersion;

        private CacheUsageLimits cacheUsageLimits;

        private String kmsKeyId;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private Endpoint endpoint;

        private Endpoint readerEndpoint;

        private String arn;

        private String userGroupId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private Integer snapshotRetentionLimit;

        private String dailySnapshotTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessCache model) {
            serverlessCacheName(model.serverlessCacheName);
            description(model.description);
            createTime(model.createTime);
            status(model.status);
            engine(model.engine);
            majorEngineVersion(model.majorEngineVersion);
            fullEngineVersion(model.fullEngineVersion);
            cacheUsageLimits(model.cacheUsageLimits);
            kmsKeyId(model.kmsKeyId);
            securityGroupIds(model.securityGroupIds);
            endpoint(model.endpoint);
            readerEndpoint(model.readerEndpoint);
            arn(model.arn);
            userGroupId(model.userGroupId);
            subnetIds(model.subnetIds);
            snapshotRetentionLimit(model.snapshotRetentionLimit);
            dailySnapshotTime(model.dailySnapshotTime);
        }

        public final String getServerlessCacheName() {
            return serverlessCacheName;
        }

        public final void setServerlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
        }

        @Override
        public final Builder serverlessCacheName(String serverlessCacheName) {
            this.serverlessCacheName = serverlessCacheName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMajorEngineVersion() {
            return majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final String getFullEngineVersion() {
            return fullEngineVersion;
        }

        public final void setFullEngineVersion(String fullEngineVersion) {
            this.fullEngineVersion = fullEngineVersion;
        }

        @Override
        public final Builder fullEngineVersion(String fullEngineVersion) {
            this.fullEngineVersion = fullEngineVersion;
            return this;
        }

        public final CacheUsageLimits.Builder getCacheUsageLimits() {
            return cacheUsageLimits != null ? cacheUsageLimits.toBuilder() : null;
        }

        public final void setCacheUsageLimits(CacheUsageLimits.BuilderImpl cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits != null ? cacheUsageLimits.build() : null;
        }

        @Override
        public final Builder cacheUsageLimits(CacheUsageLimits cacheUsageLimits) {
            this.cacheUsageLimits = cacheUsageLimits;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Endpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Endpoint.Builder getReaderEndpoint() {
            return readerEndpoint != null ? readerEndpoint.toBuilder() : null;
        }

        public final void setReaderEndpoint(Endpoint.BuilderImpl readerEndpoint) {
            this.readerEndpoint = readerEndpoint != null ? readerEndpoint.build() : null;
        }

        @Override
        public final Builder readerEndpoint(Endpoint readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getUserGroupId() {
            return userGroupId;
        }

        public final void setUserGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
        }

        @Override
        public final Builder userGroupId(String userGroupId) {
            this.userGroupId = userGroupId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getDailySnapshotTime() {
            return dailySnapshotTime;
        }

        public final void setDailySnapshotTime(String dailySnapshotTime) {
            this.dailySnapshotTime = dailySnapshotTime;
        }

        @Override
        public final Builder dailySnapshotTime(String dailySnapshotTime) {
            this.dailySnapshotTime = dailySnapshotTime;
            return this;
        }

        @Override
        public ServerlessCache build() {
            return new ServerlessCache(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
