/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUpdateActionsRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<DescribeUpdateActionsRequest.Builder, DescribeUpdateActionsRequest> {
    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceUpdateName").getter(getter(DescribeUpdateActionsRequest::serviceUpdateName))
            .setter(setter(Builder::serviceUpdateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()).build();

    private static final SdkField<List<String>> REPLICATION_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReplicationGroupIds")
            .getter(getter(DescribeUpdateActionsRequest::replicationGroupIds))
            .setter(setter(Builder::replicationGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CACHE_CLUSTER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CacheClusterIds")
            .getter(getter(DescribeUpdateActionsRequest::cacheClusterIds))
            .setter(setter(Builder::cacheClusterIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DescribeUpdateActionsRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<List<String>> SERVICE_UPDATE_STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ServiceUpdateStatus")
            .getter(getter(DescribeUpdateActionsRequest::serviceUpdateStatusAsStrings))
            .setter(setter(Builder::serviceUpdateStatusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimeRangeFilter> SERVICE_UPDATE_TIME_RANGE_FIELD = SdkField
            .<TimeRangeFilter> builder(MarshallingType.SDK_POJO).memberName("ServiceUpdateTimeRange")
            .getter(getter(DescribeUpdateActionsRequest::serviceUpdateTimeRange)).setter(setter(Builder::serviceUpdateTimeRange))
            .constructor(TimeRangeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateTimeRange").build())
            .build();

    private static final SdkField<List<String>> UPDATE_ACTION_STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UpdateActionStatus")
            .getter(getter(DescribeUpdateActionsRequest::updateActionStatusAsStrings))
            .setter(setter(Builder::updateActionStatusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateActionStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> SHOW_NODE_LEVEL_UPDATE_STATUS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ShowNodeLevelUpdateStatus")
            .getter(getter(DescribeUpdateActionsRequest::showNodeLevelUpdateStatus))
            .setter(setter(Builder::showNodeLevelUpdateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShowNodeLevelUpdateStatus").build())
            .build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeUpdateActionsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeUpdateActionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_UPDATE_NAME_FIELD,
            REPLICATION_GROUP_IDS_FIELD, CACHE_CLUSTER_IDS_FIELD, ENGINE_FIELD, SERVICE_UPDATE_STATUS_FIELD,
            SERVICE_UPDATE_TIME_RANGE_FIELD, UPDATE_ACTION_STATUS_FIELD, SHOW_NODE_LEVEL_UPDATE_STATUS_FIELD, MAX_RECORDS_FIELD,
            MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceUpdateName;

    private final List<String> replicationGroupIds;

    private final List<String> cacheClusterIds;

    private final String engine;

    private final List<String> serviceUpdateStatus;

    private final TimeRangeFilter serviceUpdateTimeRange;

    private final List<String> updateActionStatus;

    private final Boolean showNodeLevelUpdateStatus;

    private final Integer maxRecords;

    private final String marker;

    private DescribeUpdateActionsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceUpdateName = builder.serviceUpdateName;
        this.replicationGroupIds = builder.replicationGroupIds;
        this.cacheClusterIds = builder.cacheClusterIds;
        this.engine = builder.engine;
        this.serviceUpdateStatus = builder.serviceUpdateStatus;
        this.serviceUpdateTimeRange = builder.serviceUpdateTimeRange;
        this.updateActionStatus = builder.updateActionStatus;
        this.showNodeLevelUpdateStatus = builder.showNodeLevelUpdateStatus;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The unique ID of the service update
     * </p>
     * 
     * @return The unique ID of the service update
     */
    public final String serviceUpdateName() {
        return serviceUpdateName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicationGroupIds() {
        return replicationGroupIds != null && !(replicationGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The replication group IDs
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationGroupIds} method.
     * </p>
     * 
     * @return The replication group IDs
     */
    public final List<String> replicationGroupIds() {
        return replicationGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheClusterIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCacheClusterIds() {
        return cacheClusterIds != null && !(cacheClusterIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cache cluster IDs
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheClusterIds} method.
     * </p>
     * 
     * @return The cache cluster IDs
     */
    public final List<String> cacheClusterIds() {
        return cacheClusterIds;
    }

    /**
     * <p>
     * The Elasticache engine to which the update applies. Either Valkey, Redis OSS or Memcached.
     * </p>
     * 
     * @return The Elasticache engine to which the update applies. Either Valkey, Redis OSS or Memcached.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The status of the service update
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceUpdateStatus} method.
     * </p>
     * 
     * @return The status of the service update
     */
    public final List<ServiceUpdateStatus> serviceUpdateStatus() {
        return ServiceUpdateStatusListCopier.copyStringToEnum(serviceUpdateStatus);
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceUpdateStatus property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceUpdateStatus() {
        return serviceUpdateStatus != null && !(serviceUpdateStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the service update
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceUpdateStatus} method.
     * </p>
     * 
     * @return The status of the service update
     */
    public final List<String> serviceUpdateStatusAsStrings() {
        return serviceUpdateStatus;
    }

    /**
     * <p>
     * The range of time specified to search for service updates that are in available status
     * </p>
     * 
     * @return The range of time specified to search for service updates that are in available status
     */
    public final TimeRangeFilter serviceUpdateTimeRange() {
        return serviceUpdateTimeRange;
    }

    /**
     * <p>
     * The status of the update action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdateActionStatus} method.
     * </p>
     * 
     * @return The status of the update action.
     */
    public final List<UpdateActionStatus> updateActionStatus() {
        return UpdateActionStatusListCopier.copyStringToEnum(updateActionStatus);
    }

    /**
     * For responses, this returns true if the service returned a value for the UpdateActionStatus property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUpdateActionStatus() {
        return updateActionStatus != null && !(updateActionStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the update action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdateActionStatus} method.
     * </p>
     * 
     * @return The status of the update action.
     */
    public final List<String> updateActionStatusAsStrings() {
        return updateActionStatus;
    }

    /**
     * <p>
     * Dictates whether to include node level update status in the response
     * </p>
     * 
     * @return Dictates whether to include node level update status in the response
     */
    public final Boolean showNodeLevelUpdateStatus() {
        return showNodeLevelUpdateStatus;
    }

    /**
     * <p>
     * The maximum number of records to include in the response
     * </p>
     * 
     * @return The maximum number of records to include in the response
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker, up to the value specified
     * by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional marker returned from a prior request. Use this marker for pagination of results from this
     *         operation. If this parameter is specified, the response includes only records beyond the marker, up to
     *         the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicationGroupIds() ? replicationGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheClusterIds() ? cacheClusterIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceUpdateStatus() ? serviceUpdateStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdateActionStatus() ? updateActionStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(showNodeLevelUpdateStatus());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUpdateActionsRequest)) {
            return false;
        }
        DescribeUpdateActionsRequest other = (DescribeUpdateActionsRequest) obj;
        return Objects.equals(serviceUpdateName(), other.serviceUpdateName())
                && hasReplicationGroupIds() == other.hasReplicationGroupIds()
                && Objects.equals(replicationGroupIds(), other.replicationGroupIds())
                && hasCacheClusterIds() == other.hasCacheClusterIds()
                && Objects.equals(cacheClusterIds(), other.cacheClusterIds()) && Objects.equals(engine(), other.engine())
                && hasServiceUpdateStatus() == other.hasServiceUpdateStatus()
                && Objects.equals(serviceUpdateStatusAsStrings(), other.serviceUpdateStatusAsStrings())
                && Objects.equals(serviceUpdateTimeRange(), other.serviceUpdateTimeRange())
                && hasUpdateActionStatus() == other.hasUpdateActionStatus()
                && Objects.equals(updateActionStatusAsStrings(), other.updateActionStatusAsStrings())
                && Objects.equals(showNodeLevelUpdateStatus(), other.showNodeLevelUpdateStatus())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUpdateActionsRequest").add("ServiceUpdateName", serviceUpdateName())
                .add("ReplicationGroupIds", hasReplicationGroupIds() ? replicationGroupIds() : null)
                .add("CacheClusterIds", hasCacheClusterIds() ? cacheClusterIds() : null).add("Engine", engine())
                .add("ServiceUpdateStatus", hasServiceUpdateStatus() ? serviceUpdateStatusAsStrings() : null)
                .add("ServiceUpdateTimeRange", serviceUpdateTimeRange())
                .add("UpdateActionStatus", hasUpdateActionStatus() ? updateActionStatusAsStrings() : null)
                .add("ShowNodeLevelUpdateStatus", showNodeLevelUpdateStatus()).add("MaxRecords", maxRecords())
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceUpdateName":
            return Optional.ofNullable(clazz.cast(serviceUpdateName()));
        case "ReplicationGroupIds":
            return Optional.ofNullable(clazz.cast(replicationGroupIds()));
        case "CacheClusterIds":
            return Optional.ofNullable(clazz.cast(cacheClusterIds()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "ServiceUpdateStatus":
            return Optional.ofNullable(clazz.cast(serviceUpdateStatusAsStrings()));
        case "ServiceUpdateTimeRange":
            return Optional.ofNullable(clazz.cast(serviceUpdateTimeRange()));
        case "UpdateActionStatus":
            return Optional.ofNullable(clazz.cast(updateActionStatusAsStrings()));
        case "ShowNodeLevelUpdateStatus":
            return Optional.ofNullable(clazz.cast(showNodeLevelUpdateStatus()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceUpdateName", SERVICE_UPDATE_NAME_FIELD);
        map.put("ReplicationGroupIds", REPLICATION_GROUP_IDS_FIELD);
        map.put("CacheClusterIds", CACHE_CLUSTER_IDS_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("ServiceUpdateStatus", SERVICE_UPDATE_STATUS_FIELD);
        map.put("ServiceUpdateTimeRange", SERVICE_UPDATE_TIME_RANGE_FIELD);
        map.put("UpdateActionStatus", UPDATE_ACTION_STATUS_FIELD);
        map.put("ShowNodeLevelUpdateStatus", SHOW_NODE_LEVEL_UPDATE_STATUS_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeUpdateActionsRequest, T> g) {
        return obj -> g.apply((DescribeUpdateActionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUpdateActionsRequest> {
        /**
         * <p>
         * The unique ID of the service update
         * </p>
         * 
         * @param serviceUpdateName
         *        The unique ID of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateName(String serviceUpdateName);

        /**
         * <p>
         * The replication group IDs
         * </p>
         * 
         * @param replicationGroupIds
         *        The replication group IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupIds(Collection<String> replicationGroupIds);

        /**
         * <p>
         * The replication group IDs
         * </p>
         * 
         * @param replicationGroupIds
         *        The replication group IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupIds(String... replicationGroupIds);

        /**
         * <p>
         * The cache cluster IDs
         * </p>
         * 
         * @param cacheClusterIds
         *        The cache cluster IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterIds(Collection<String> cacheClusterIds);

        /**
         * <p>
         * The cache cluster IDs
         * </p>
         * 
         * @param cacheClusterIds
         *        The cache cluster IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterIds(String... cacheClusterIds);

        /**
         * <p>
         * The Elasticache engine to which the update applies. Either Valkey, Redis OSS or Memcached.
         * </p>
         * 
         * @param engine
         *        The Elasticache engine to which the update applies. Either Valkey, Redis OSS or Memcached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param serviceUpdateStatus
         *        The status of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateStatusWithStrings(Collection<String> serviceUpdateStatus);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param serviceUpdateStatus
         *        The status of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateStatusWithStrings(String... serviceUpdateStatus);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param serviceUpdateStatus
         *        The status of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateStatus(Collection<ServiceUpdateStatus> serviceUpdateStatus);

        /**
         * <p>
         * The status of the service update
         * </p>
         * 
         * @param serviceUpdateStatus
         *        The status of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateStatus(ServiceUpdateStatus... serviceUpdateStatus);

        /**
         * <p>
         * The range of time specified to search for service updates that are in available status
         * </p>
         * 
         * @param serviceUpdateTimeRange
         *        The range of time specified to search for service updates that are in available status
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateTimeRange(TimeRangeFilter serviceUpdateTimeRange);

        /**
         * <p>
         * The range of time specified to search for service updates that are in available status
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeRangeFilter.Builder} avoiding the
         * need to create one manually via {@link TimeRangeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeRangeFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceUpdateTimeRange(TimeRangeFilter)}.
         * 
         * @param serviceUpdateTimeRange
         *        a consumer that will call methods on {@link TimeRangeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceUpdateTimeRange(TimeRangeFilter)
         */
        default Builder serviceUpdateTimeRange(Consumer<TimeRangeFilter.Builder> serviceUpdateTimeRange) {
            return serviceUpdateTimeRange(TimeRangeFilter.builder().applyMutation(serviceUpdateTimeRange).build());
        }

        /**
         * <p>
         * The status of the update action.
         * </p>
         * 
         * @param updateActionStatus
         *        The status of the update action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateActionStatusWithStrings(Collection<String> updateActionStatus);

        /**
         * <p>
         * The status of the update action.
         * </p>
         * 
         * @param updateActionStatus
         *        The status of the update action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateActionStatusWithStrings(String... updateActionStatus);

        /**
         * <p>
         * The status of the update action.
         * </p>
         * 
         * @param updateActionStatus
         *        The status of the update action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateActionStatus(Collection<UpdateActionStatus> updateActionStatus);

        /**
         * <p>
         * The status of the update action.
         * </p>
         * 
         * @param updateActionStatus
         *        The status of the update action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateActionStatus(UpdateActionStatus... updateActionStatus);

        /**
         * <p>
         * Dictates whether to include node level update status in the response
         * </p>
         * 
         * @param showNodeLevelUpdateStatus
         *        Dictates whether to include node level update status in the response
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder showNodeLevelUpdateStatus(Boolean showNodeLevelUpdateStatus);

        /**
         * <p>
         * The maximum number of records to include in the response
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional marker returned from a prior request. Use this marker for pagination of results from this
         * operation. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional marker returned from a prior request. Use this marker for pagination of results from this
         *        operation. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String serviceUpdateName;

        private List<String> replicationGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> cacheClusterIds = DefaultSdkAutoConstructList.getInstance();

        private String engine;

        private List<String> serviceUpdateStatus = DefaultSdkAutoConstructList.getInstance();

        private TimeRangeFilter serviceUpdateTimeRange;

        private List<String> updateActionStatus = DefaultSdkAutoConstructList.getInstance();

        private Boolean showNodeLevelUpdateStatus;

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUpdateActionsRequest model) {
            super(model);
            serviceUpdateName(model.serviceUpdateName);
            replicationGroupIds(model.replicationGroupIds);
            cacheClusterIds(model.cacheClusterIds);
            engine(model.engine);
            serviceUpdateStatusWithStrings(model.serviceUpdateStatus);
            serviceUpdateTimeRange(model.serviceUpdateTimeRange);
            updateActionStatusWithStrings(model.updateActionStatus);
            showNodeLevelUpdateStatus(model.showNodeLevelUpdateStatus);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getServiceUpdateName() {
            return serviceUpdateName;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final Collection<String> getReplicationGroupIds() {
            if (replicationGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationGroupIds;
        }

        public final void setReplicationGroupIds(Collection<String> replicationGroupIds) {
            this.replicationGroupIds = ReplicationGroupIdListCopier.copy(replicationGroupIds);
        }

        @Override
        public final Builder replicationGroupIds(Collection<String> replicationGroupIds) {
            this.replicationGroupIds = ReplicationGroupIdListCopier.copy(replicationGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroupIds(String... replicationGroupIds) {
            replicationGroupIds(Arrays.asList(replicationGroupIds));
            return this;
        }

        public final Collection<String> getCacheClusterIds() {
            if (cacheClusterIds instanceof SdkAutoConstructList) {
                return null;
            }
            return cacheClusterIds;
        }

        public final void setCacheClusterIds(Collection<String> cacheClusterIds) {
            this.cacheClusterIds = CacheClusterIdListCopier.copy(cacheClusterIds);
        }

        @Override
        public final Builder cacheClusterIds(Collection<String> cacheClusterIds) {
            this.cacheClusterIds = CacheClusterIdListCopier.copy(cacheClusterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheClusterIds(String... cacheClusterIds) {
            cacheClusterIds(Arrays.asList(cacheClusterIds));
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final Collection<String> getServiceUpdateStatus() {
            if (serviceUpdateStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return serviceUpdateStatus;
        }

        public final void setServiceUpdateStatus(Collection<String> serviceUpdateStatus) {
            this.serviceUpdateStatus = ServiceUpdateStatusListCopier.copy(serviceUpdateStatus);
        }

        @Override
        public final Builder serviceUpdateStatusWithStrings(Collection<String> serviceUpdateStatus) {
            this.serviceUpdateStatus = ServiceUpdateStatusListCopier.copy(serviceUpdateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdateStatusWithStrings(String... serviceUpdateStatus) {
            serviceUpdateStatusWithStrings(Arrays.asList(serviceUpdateStatus));
            return this;
        }

        @Override
        public final Builder serviceUpdateStatus(Collection<ServiceUpdateStatus> serviceUpdateStatus) {
            this.serviceUpdateStatus = ServiceUpdateStatusListCopier.copyEnumToString(serviceUpdateStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceUpdateStatus(ServiceUpdateStatus... serviceUpdateStatus) {
            serviceUpdateStatus(Arrays.asList(serviceUpdateStatus));
            return this;
        }

        public final TimeRangeFilter.Builder getServiceUpdateTimeRange() {
            return serviceUpdateTimeRange != null ? serviceUpdateTimeRange.toBuilder() : null;
        }

        public final void setServiceUpdateTimeRange(TimeRangeFilter.BuilderImpl serviceUpdateTimeRange) {
            this.serviceUpdateTimeRange = serviceUpdateTimeRange != null ? serviceUpdateTimeRange.build() : null;
        }

        @Override
        public final Builder serviceUpdateTimeRange(TimeRangeFilter serviceUpdateTimeRange) {
            this.serviceUpdateTimeRange = serviceUpdateTimeRange;
            return this;
        }

        public final Collection<String> getUpdateActionStatus() {
            if (updateActionStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return updateActionStatus;
        }

        public final void setUpdateActionStatus(Collection<String> updateActionStatus) {
            this.updateActionStatus = UpdateActionStatusListCopier.copy(updateActionStatus);
        }

        @Override
        public final Builder updateActionStatusWithStrings(Collection<String> updateActionStatus) {
            this.updateActionStatus = UpdateActionStatusListCopier.copy(updateActionStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateActionStatusWithStrings(String... updateActionStatus) {
            updateActionStatusWithStrings(Arrays.asList(updateActionStatus));
            return this;
        }

        @Override
        public final Builder updateActionStatus(Collection<UpdateActionStatus> updateActionStatus) {
            this.updateActionStatus = UpdateActionStatusListCopier.copyEnumToString(updateActionStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateActionStatus(UpdateActionStatus... updateActionStatus) {
            updateActionStatus(Arrays.asList(updateActionStatus));
            return this;
        }

        public final Boolean getShowNodeLevelUpdateStatus() {
            return showNodeLevelUpdateStatus;
        }

        public final void setShowNodeLevelUpdateStatus(Boolean showNodeLevelUpdateStatus) {
            this.showNodeLevelUpdateStatus = showNodeLevelUpdateStatus;
        }

        @Override
        public final Builder showNodeLevelUpdateStatus(Boolean showNodeLevelUpdateStatus) {
            this.showNodeLevelUpdateStatus = showNodeLevelUpdateStatus;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeUpdateActionsRequest build() {
            return new DescribeUpdateActionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
