/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeServerlessCachesResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeServerlessCachesResponse.Builder, DescribeServerlessCachesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeServerlessCachesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ServerlessCache>> SERVERLESS_CACHES_FIELD = SdkField
            .<List<ServerlessCache>> builder(MarshallingType.LIST)
            .memberName("ServerlessCaches")
            .getter(getter(DescribeServerlessCachesResponse::serverlessCaches))
            .setter(setter(Builder::serverlessCaches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessCaches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerlessCache> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerlessCache::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SERVERLESS_CACHES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ServerlessCache> serverlessCaches;

    private DescribeServerlessCachesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serverlessCaches = builder.serverlessCaches;
    }

    /**
     * <p>
     * An optional marker returned from a prior request to support pagination of results from this operation. If this
     * parameter is specified, the response includes only records beyond the marker, up to the value specified by
     * MaxResults.
     * </p>
     * 
     * @return An optional marker returned from a prior request to support pagination of results from this operation. If
     *         this parameter is specified, the response includes only records beyond the marker, up to the value
     *         specified by MaxResults.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerlessCaches property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServerlessCaches() {
        return serverlessCaches != null && !(serverlessCaches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The serverless caches associated with a given description request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerlessCaches} method.
     * </p>
     * 
     * @return The serverless caches associated with a given description request.
     */
    public final List<ServerlessCache> serverlessCaches() {
        return serverlessCaches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasServerlessCaches() ? serverlessCaches() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServerlessCachesResponse)) {
            return false;
        }
        DescribeServerlessCachesResponse other = (DescribeServerlessCachesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasServerlessCaches() == other.hasServerlessCaches()
                && Objects.equals(serverlessCaches(), other.serverlessCaches());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeServerlessCachesResponse").add("NextToken", nextToken())
                .add("ServerlessCaches", hasServerlessCaches() ? serverlessCaches() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ServerlessCaches":
            return Optional.ofNullable(clazz.cast(serverlessCaches()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ServerlessCaches", SERVERLESS_CACHES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServerlessCachesResponse, T> g) {
        return obj -> g.apply((DescribeServerlessCachesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeServerlessCachesResponse> {
        /**
         * <p>
         * An optional marker returned from a prior request to support pagination of results from this operation. If
         * this parameter is specified, the response includes only records beyond the marker, up to the value specified
         * by MaxResults.
         * </p>
         * 
         * @param nextToken
         *        An optional marker returned from a prior request to support pagination of results from this operation.
         *        If this parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by MaxResults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The serverless caches associated with a given description request.
         * </p>
         * 
         * @param serverlessCaches
         *        The serverless caches associated with a given description request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCaches(Collection<ServerlessCache> serverlessCaches);

        /**
         * <p>
         * The serverless caches associated with a given description request.
         * </p>
         * 
         * @param serverlessCaches
         *        The serverless caches associated with a given description request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessCaches(ServerlessCache... serverlessCaches);

        /**
         * <p>
         * The serverless caches associated with a given description request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.ServerlessCache.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.elasticache.model.ServerlessCache#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.ServerlessCache.Builder#build()} is called
         * immediately and its result is passed to {@link #serverlessCaches(List<ServerlessCache>)}.
         * 
         * @param serverlessCaches
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.ServerlessCache.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverlessCaches(java.util.Collection<ServerlessCache>)
         */
        Builder serverlessCaches(Consumer<ServerlessCache.Builder>... serverlessCaches);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ServerlessCache> serverlessCaches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServerlessCachesResponse model) {
            super(model);
            nextToken(model.nextToken);
            serverlessCaches(model.serverlessCaches);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ServerlessCache.Builder> getServerlessCaches() {
            List<ServerlessCache.Builder> result = ServerlessCacheListCopier.copyToBuilder(this.serverlessCaches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerlessCaches(Collection<ServerlessCache.BuilderImpl> serverlessCaches) {
            this.serverlessCaches = ServerlessCacheListCopier.copyFromBuilder(serverlessCaches);
        }

        @Override
        public final Builder serverlessCaches(Collection<ServerlessCache> serverlessCaches) {
            this.serverlessCaches = ServerlessCacheListCopier.copy(serverlessCaches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverlessCaches(ServerlessCache... serverlessCaches) {
            serverlessCaches(Arrays.asList(serverlessCaches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverlessCaches(Consumer<ServerlessCache.Builder>... serverlessCaches) {
            serverlessCaches(Stream.of(serverlessCaches).map(c -> ServerlessCache.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeServerlessCachesResponse build() {
            return new DescribeServerlessCachesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
