/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGlobalReplicationGroupsResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeGlobalReplicationGroupsResponse.Builder, DescribeGlobalReplicationGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeGlobalReplicationGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<GlobalReplicationGroup>> GLOBAL_REPLICATION_GROUPS_FIELD = SdkField
            .<List<GlobalReplicationGroup>> builder(MarshallingType.LIST)
            .memberName("GlobalReplicationGroups")
            .getter(getter(DescribeGlobalReplicationGroupsResponse::globalReplicationGroups))
            .setter(setter(Builder::globalReplicationGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalReplicationGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("GlobalReplicationGroup")
                            .memberFieldInfo(
                                    SdkField.<GlobalReplicationGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalReplicationGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("GlobalReplicationGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            GLOBAL_REPLICATION_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<GlobalReplicationGroup> globalReplicationGroups;

    private DescribeGlobalReplicationGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.globalReplicationGroups = builder.globalReplicationGroups;
    }

    /**
     * <p>
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation.
     * If this parameter is specified, the response includes only records beyond the marker, up to the value specified
     * by MaxRecords. &gt;
     * </p>
     * 
     * @return An optional marker returned from a prior request. Use this marker for pagination of results from this
     *         operation. If this parameter is specified, the response includes only records beyond the marker, up to
     *         the value specified by MaxRecords. &gt;
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalReplicationGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGlobalReplicationGroups() {
        return globalReplicationGroups != null && !(globalReplicationGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the slot configuration and global identifier for each slice group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalReplicationGroups} method.
     * </p>
     * 
     * @return Indicates the slot configuration and global identifier for each slice group.
     */
    public final List<GlobalReplicationGroup> globalReplicationGroups() {
        return globalReplicationGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalReplicationGroups() ? globalReplicationGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGlobalReplicationGroupsResponse)) {
            return false;
        }
        DescribeGlobalReplicationGroupsResponse other = (DescribeGlobalReplicationGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasGlobalReplicationGroups() == other.hasGlobalReplicationGroups()
                && Objects.equals(globalReplicationGroups(), other.globalReplicationGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGlobalReplicationGroupsResponse").add("Marker", marker())
                .add("GlobalReplicationGroups", hasGlobalReplicationGroups() ? globalReplicationGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "GlobalReplicationGroups":
            return Optional.ofNullable(clazz.cast(globalReplicationGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("GlobalReplicationGroups", GLOBAL_REPLICATION_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGlobalReplicationGroupsResponse, T> g) {
        return obj -> g.apply((DescribeGlobalReplicationGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeGlobalReplicationGroupsResponse> {
        /**
         * <p>
         * An optional marker returned from a prior request. Use this marker for pagination of results from this
         * operation. If this parameter is specified, the response includes only records beyond the marker, up to the
         * value specified by MaxRecords. &gt;
         * </p>
         * 
         * @param marker
         *        An optional marker returned from a prior request. Use this marker for pagination of results from this
         *        operation. If this parameter is specified, the response includes only records beyond the marker, up to
         *        the value specified by MaxRecords. &gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Indicates the slot configuration and global identifier for each slice group.
         * </p>
         * 
         * @param globalReplicationGroups
         *        Indicates the slot configuration and global identifier for each slice group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroups(Collection<GlobalReplicationGroup> globalReplicationGroups);

        /**
         * <p>
         * Indicates the slot configuration and global identifier for each slice group.
         * </p>
         * 
         * @param globalReplicationGroups
         *        Indicates the slot configuration and global identifier for each slice group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalReplicationGroups(GlobalReplicationGroup... globalReplicationGroups);

        /**
         * <p>
         * Indicates the slot configuration and global identifier for each slice group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #globalReplicationGroups(List<GlobalReplicationGroup>)}.
         * 
         * @param globalReplicationGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticache.model.GlobalReplicationGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalReplicationGroups(java.util.Collection<GlobalReplicationGroup>)
         */
        Builder globalReplicationGroups(Consumer<GlobalReplicationGroup.Builder>... globalReplicationGroups);
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private String marker;

        private List<GlobalReplicationGroup> globalReplicationGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGlobalReplicationGroupsResponse model) {
            super(model);
            marker(model.marker);
            globalReplicationGroups(model.globalReplicationGroups);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<GlobalReplicationGroup.Builder> getGlobalReplicationGroups() {
            List<GlobalReplicationGroup.Builder> result = GlobalReplicationGroupListCopier
                    .copyToBuilder(this.globalReplicationGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalReplicationGroups(Collection<GlobalReplicationGroup.BuilderImpl> globalReplicationGroups) {
            this.globalReplicationGroups = GlobalReplicationGroupListCopier.copyFromBuilder(globalReplicationGroups);
        }

        @Override
        public final Builder globalReplicationGroups(Collection<GlobalReplicationGroup> globalReplicationGroups) {
            this.globalReplicationGroups = GlobalReplicationGroupListCopier.copy(globalReplicationGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalReplicationGroups(GlobalReplicationGroup... globalReplicationGroups) {
            globalReplicationGroups(Arrays.asList(globalReplicationGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalReplicationGroups(Consumer<GlobalReplicationGroup.Builder>... globalReplicationGroups) {
            globalReplicationGroups(Stream.of(globalReplicationGroups)
                    .map(c -> GlobalReplicationGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeGlobalReplicationGroupsResponse build() {
            return new DescribeGlobalReplicationGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
