/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEngineDefaultParametersResponse extends ElastiCacheResponse implements
        ToCopyableBuilder<DescribeEngineDefaultParametersResponse.Builder, DescribeEngineDefaultParametersResponse> {
    private static final SdkField<EngineDefaults> ENGINE_DEFAULTS_FIELD = SdkField
            .<EngineDefaults> builder(MarshallingType.SDK_POJO).memberName("EngineDefaults")
            .getter(getter(DescribeEngineDefaultParametersResponse::engineDefaults)).setter(setter(Builder::engineDefaults))
            .constructor(EngineDefaults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineDefaults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_DEFAULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final EngineDefaults engineDefaults;

    private DescribeEngineDefaultParametersResponse(BuilderImpl builder) {
        super(builder);
        this.engineDefaults = builder.engineDefaults;
    }

    /**
     * Returns the value of the EngineDefaults property for this object.
     * 
     * @return The value of the EngineDefaults property for this object.
     */
    public final EngineDefaults engineDefaults() {
        return engineDefaults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engineDefaults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEngineDefaultParametersResponse)) {
            return false;
        }
        DescribeEngineDefaultParametersResponse other = (DescribeEngineDefaultParametersResponse) obj;
        return Objects.equals(engineDefaults(), other.engineDefaults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEngineDefaultParametersResponse").add("EngineDefaults", engineDefaults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngineDefaults":
            return Optional.ofNullable(clazz.cast(engineDefaults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EngineDefaults", ENGINE_DEFAULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEngineDefaultParametersResponse, T> g) {
        return obj -> g.apply((DescribeEngineDefaultParametersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElastiCacheResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEngineDefaultParametersResponse> {
        /**
         * Sets the value of the EngineDefaults property for this object.
         *
         * @param engineDefaults
         *        The new value for the EngineDefaults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineDefaults(EngineDefaults engineDefaults);

        /**
         * Sets the value of the EngineDefaults property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EngineDefaults.Builder} avoiding the need
         * to create one manually via {@link EngineDefaults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EngineDefaults.Builder#build()} is called immediately and its
         * result is passed to {@link #engineDefaults(EngineDefaults)}.
         * 
         * @param engineDefaults
         *        a consumer that will call methods on {@link EngineDefaults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engineDefaults(EngineDefaults)
         */
        default Builder engineDefaults(Consumer<EngineDefaults.Builder> engineDefaults) {
            return engineDefaults(EngineDefaults.builder().applyMutation(engineDefaults).build());
        }
    }

    static final class BuilderImpl extends ElastiCacheResponse.BuilderImpl implements Builder {
        private EngineDefaults engineDefaults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEngineDefaultParametersResponse model) {
            super(model);
            engineDefaults(model.engineDefaults);
        }

        public final EngineDefaults.Builder getEngineDefaults() {
            return engineDefaults != null ? engineDefaults.toBuilder() : null;
        }

        public final void setEngineDefaults(EngineDefaults.BuilderImpl engineDefaults) {
            this.engineDefaults = engineDefaults != null ? engineDefaults.build() : null;
        }

        @Override
        public final Builder engineDefaults(EngineDefaults engineDefaults) {
            this.engineDefaults = engineDefaults;
            return this;
        }

        @Override
        public DescribeEngineDefaultParametersResponse build() {
            return new DescribeEngineDefaultParametersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
