/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data storage limit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataStorage implements SdkPojo, Serializable, ToCopyableBuilder<DataStorage.Builder, DataStorage> {
    private static final SdkField<Integer> MAXIMUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Maximum").getter(getter(DataStorage::maximum)).setter(setter(Builder::maximum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Maximum").build()).build();

    private static final SdkField<Integer> MINIMUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Minimum").getter(getter(DataStorage::minimum)).setter(setter(Builder::minimum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Minimum").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(DataStorage::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_FIELD, MINIMUM_FIELD,
            UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maximum;

    private final Integer minimum;

    private final String unit;

    private DataStorage(BuilderImpl builder) {
        this.maximum = builder.maximum;
        this.minimum = builder.minimum;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The upper limit for data storage the cache is set to use.
     * </p>
     * 
     * @return The upper limit for data storage the cache is set to use.
     */
    public final Integer maximum() {
        return maximum;
    }

    /**
     * <p>
     * The lower limit for data storage the cache is set to use.
     * </p>
     * 
     * @return The lower limit for data storage the cache is set to use.
     */
    public final Integer minimum() {
        return minimum;
    }

    /**
     * <p>
     * The unit that the storage is measured in, in GB.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link DataStorageUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit that the storage is measured in, in GB.
     * @see DataStorageUnit
     */
    public final DataStorageUnit unit() {
        return DataStorageUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit that the storage is measured in, in GB.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link DataStorageUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit that the storage is measured in, in GB.
     * @see DataStorageUnit
     */
    public final String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maximum());
        hashCode = 31 * hashCode + Objects.hashCode(minimum());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataStorage)) {
            return false;
        }
        DataStorage other = (DataStorage) obj;
        return Objects.equals(maximum(), other.maximum()) && Objects.equals(minimum(), other.minimum())
                && Objects.equals(unitAsString(), other.unitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataStorage").add("Maximum", maximum()).add("Minimum", minimum()).add("Unit", unitAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Maximum":
            return Optional.ofNullable(clazz.cast(maximum()));
        case "Minimum":
            return Optional.ofNullable(clazz.cast(minimum()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Maximum", MAXIMUM_FIELD);
        map.put("Minimum", MINIMUM_FIELD);
        map.put("Unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataStorage, T> g) {
        return obj -> g.apply((DataStorage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataStorage> {
        /**
         * <p>
         * The upper limit for data storage the cache is set to use.
         * </p>
         * 
         * @param maximum
         *        The upper limit for data storage the cache is set to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximum(Integer maximum);

        /**
         * <p>
         * The lower limit for data storage the cache is set to use.
         * </p>
         * 
         * @param minimum
         *        The lower limit for data storage the cache is set to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimum(Integer minimum);

        /**
         * <p>
         * The unit that the storage is measured in, in GB.
         * </p>
         * 
         * @param unit
         *        The unit that the storage is measured in, in GB.
         * @see DataStorageUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataStorageUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit that the storage is measured in, in GB.
         * </p>
         * 
         * @param unit
         *        The unit that the storage is measured in, in GB.
         * @see DataStorageUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataStorageUnit
         */
        Builder unit(DataStorageUnit unit);
    }

    static final class BuilderImpl implements Builder {
        private Integer maximum;

        private Integer minimum;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(DataStorage model) {
            maximum(model.maximum);
            minimum(model.minimum);
            unit(model.unit);
        }

        public final Integer getMaximum() {
            return maximum;
        }

        public final void setMaximum(Integer maximum) {
            this.maximum = maximum;
        }

        @Override
        public final Builder maximum(Integer maximum) {
            this.maximum = maximum;
            return this;
        }

        public final Integer getMinimum() {
            return minimum;
        }

        public final void setMinimum(Integer minimum) {
            this.minimum = minimum;
        }

        @Override
        public final Builder minimum(Integer minimum) {
            this.minimum = minimum;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(DataStorageUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        @Override
        public DataStorage build() {
            return new DataStorage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
