/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the authentication mode to use.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationMode implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationMode.Builder, AuthenticationMode> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AuthenticationMode::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<String>> PASSWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Passwords")
            .getter(getter(AuthenticationMode::passwords))
            .setter(setter(Builder::passwords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Passwords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PASSWORDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final List<String> passwords;

    private AuthenticationMode(BuilderImpl builder) {
        this.type = builder.type;
        this.passwords = builder.passwords;
    }

    /**
     * <p>
     * Specifies the authentication type. Possible options are IAM authentication, password and no password.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InputAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the authentication type. Possible options are IAM authentication, password and no password.
     * @see InputAuthenticationType
     */
    public final InputAuthenticationType type() {
        return InputAuthenticationType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the authentication type. Possible options are IAM authentication, password and no password.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InputAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the authentication type. Possible options are IAM authentication, password and no password.
     * @see InputAuthenticationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Passwords property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPasswords() {
        return passwords != null && !(passwords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the passwords to use for authentication if <code>Type</code> is set to <code>password</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPasswords} method.
     * </p>
     * 
     * @return Specifies the passwords to use for authentication if <code>Type</code> is set to <code>password</code>.
     */
    public final List<String> passwords() {
        return passwords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPasswords() ? passwords() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationMode)) {
            return false;
        }
        AuthenticationMode other = (AuthenticationMode) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && hasPasswords() == other.hasPasswords()
                && Objects.equals(passwords(), other.passwords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationMode").add("Type", typeAsString())
                .add("Passwords", hasPasswords() ? passwords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Passwords":
            return Optional.ofNullable(clazz.cast(passwords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Passwords", PASSWORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationMode, T> g) {
        return obj -> g.apply((AuthenticationMode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationMode> {
        /**
         * <p>
         * Specifies the authentication type. Possible options are IAM authentication, password and no password.
         * </p>
         * 
         * @param type
         *        Specifies the authentication type. Possible options are IAM authentication, password and no password.
         * @see InputAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputAuthenticationType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the authentication type. Possible options are IAM authentication, password and no password.
         * </p>
         * 
         * @param type
         *        Specifies the authentication type. Possible options are IAM authentication, password and no password.
         * @see InputAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputAuthenticationType
         */
        Builder type(InputAuthenticationType type);

        /**
         * <p>
         * Specifies the passwords to use for authentication if <code>Type</code> is set to <code>password</code>.
         * </p>
         * 
         * @param passwords
         *        Specifies the passwords to use for authentication if <code>Type</code> is set to <code>password</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwords(Collection<String> passwords);

        /**
         * <p>
         * Specifies the passwords to use for authentication if <code>Type</code> is set to <code>password</code>.
         * </p>
         * 
         * @param passwords
         *        Specifies the passwords to use for authentication if <code>Type</code> is set to <code>password</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwords(String... passwords);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private List<String> passwords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationMode model) {
            type(model.type);
            passwords(model.passwords);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputAuthenticationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getPasswords() {
            if (passwords instanceof SdkAutoConstructList) {
                return null;
            }
            return passwords;
        }

        public final void setPasswords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
        }

        @Override
        public final Builder passwords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passwords(String... passwords) {
            passwords(Arrays.asList(passwords));
            return this;
        }

        @Override
        public AuthenticationMode build() {
            return new AuthenticationMode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
