/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopServiceDeploymentResponse extends EcsResponse implements
        ToCopyableBuilder<StopServiceDeploymentResponse.Builder, StopServiceDeploymentResponse> {
    private static final SdkField<String> SERVICE_DEPLOYMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceDeploymentArn").getter(getter(StopServiceDeploymentResponse::serviceDeploymentArn))
            .setter(setter(Builder::serviceDeploymentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDeploymentArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_DEPLOYMENT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceDeploymentArn;

    private StopServiceDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.serviceDeploymentArn = builder.serviceDeploymentArn;
    }

    /**
     * <p>
     * The ARN of the stopped service deployment.
     * </p>
     * 
     * @return The ARN of the stopped service deployment.
     */
    public final String serviceDeploymentArn() {
        return serviceDeploymentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceDeploymentArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopServiceDeploymentResponse)) {
            return false;
        }
        StopServiceDeploymentResponse other = (StopServiceDeploymentResponse) obj;
        return Objects.equals(serviceDeploymentArn(), other.serviceDeploymentArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopServiceDeploymentResponse").add("ServiceDeploymentArn", serviceDeploymentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceDeploymentArn":
            return Optional.ofNullable(clazz.cast(serviceDeploymentArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceDeploymentArn", SERVICE_DEPLOYMENT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopServiceDeploymentResponse, T> g) {
        return obj -> g.apply((StopServiceDeploymentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopServiceDeploymentResponse> {
        /**
         * <p>
         * The ARN of the stopped service deployment.
         * </p>
         * 
         * @param serviceDeploymentArn
         *        The ARN of the stopped service deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceDeploymentArn(String serviceDeploymentArn);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private String serviceDeploymentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StopServiceDeploymentResponse model) {
            super(model);
            serviceDeploymentArn(model.serviceDeploymentArn);
        }

        public final String getServiceDeploymentArn() {
            return serviceDeploymentArn;
        }

        public final void setServiceDeploymentArn(String serviceDeploymentArn) {
            this.serviceDeploymentArn = serviceDeploymentArn;
        }

        @Override
        public final Builder serviceDeploymentArn(String serviceDeploymentArn) {
            this.serviceDeploymentArn = serviceDeploymentArn;
            return this;
        }

        @Override
        public StopServiceDeploymentResponse build() {
            return new StopServiceDeploymentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
