/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidatePullThroughCacheRuleResponse extends EcrResponse implements
        ToCopyableBuilder<ValidatePullThroughCacheRuleResponse.Builder, ValidatePullThroughCacheRuleResponse> {
    private static final SdkField<String> ECR_REPOSITORY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ecrRepositoryPrefix").getter(getter(ValidatePullThroughCacheRuleResponse::ecrRepositoryPrefix))
            .setter(setter(Builder::ecrRepositoryPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefix").build())
            .build();

    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(ValidatePullThroughCacheRuleResponse::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> UPSTREAM_REGISTRY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstreamRegistryUrl").getter(getter(ValidatePullThroughCacheRuleResponse::upstreamRegistryUrl))
            .setter(setter(Builder::upstreamRegistryUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRegistryUrl").build())
            .build();

    private static final SdkField<String> CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialArn").getter(getter(ValidatePullThroughCacheRuleResponse::credentialArn))
            .setter(setter(Builder::credentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialArn").build()).build();

    private static final SdkField<String> CUSTOM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customRoleArn").getter(getter(ValidatePullThroughCacheRuleResponse::customRoleArn))
            .setter(setter(Builder::customRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRoleArn").build()).build();

    private static final SdkField<String> UPSTREAM_REPOSITORY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstreamRepositoryPrefix")
            .getter(getter(ValidatePullThroughCacheRuleResponse::upstreamRepositoryPrefix))
            .setter(setter(Builder::upstreamRepositoryPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRepositoryPrefix").build())
            .build();

    private static final SdkField<Boolean> IS_VALID_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isValid").getter(getter(ValidatePullThroughCacheRuleResponse::isValid)).setter(setter(Builder::isValid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isValid").build()).build();

    private static final SdkField<String> FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("failure")
            .getter(getter(ValidatePullThroughCacheRuleResponse::failure)).setter(setter(Builder::failure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failure").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECR_REPOSITORY_PREFIX_FIELD,
            REGISTRY_ID_FIELD, UPSTREAM_REGISTRY_URL_FIELD, CREDENTIAL_ARN_FIELD, CUSTOM_ROLE_ARN_FIELD,
            UPSTREAM_REPOSITORY_PREFIX_FIELD, IS_VALID_FIELD, FAILURE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ecrRepositoryPrefix;

    private final String registryId;

    private final String upstreamRegistryUrl;

    private final String credentialArn;

    private final String customRoleArn;

    private final String upstreamRepositoryPrefix;

    private final Boolean isValid;

    private final String failure;

    private ValidatePullThroughCacheRuleResponse(BuilderImpl builder) {
        super(builder);
        this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
        this.registryId = builder.registryId;
        this.upstreamRegistryUrl = builder.upstreamRegistryUrl;
        this.credentialArn = builder.credentialArn;
        this.customRoleArn = builder.customRoleArn;
        this.upstreamRepositoryPrefix = builder.upstreamRepositoryPrefix;
        this.isValid = builder.isValid;
        this.failure = builder.failure;
    }

    /**
     * <p>
     * The Amazon ECR repository prefix associated with the pull through cache rule.
     * </p>
     * 
     * @return The Amazon ECR repository prefix associated with the pull through cache rule.
     */
    public final String ecrRepositoryPrefix() {
        return ecrRepositoryPrefix;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @return The registry ID associated with the request.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The upstream registry URL associated with the pull through cache rule.
     * </p>
     * 
     * @return The upstream registry URL associated with the pull through cache rule.
     */
    public final String upstreamRegistryUrl() {
        return upstreamRegistryUrl;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the pull through
     * cache rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the pull
     *         through cache rule.
     */
    public final String credentialArn() {
        return credentialArn;
    }

    /**
     * <p>
     * The ARN of the IAM role associated with the pull through cache rule.
     * </p>
     * 
     * @return The ARN of the IAM role associated with the pull through cache rule.
     */
    public final String customRoleArn() {
        return customRoleArn;
    }

    /**
     * <p>
     * The upstream repository prefix associated with the pull through cache rule.
     * </p>
     * 
     * @return The upstream repository prefix associated with the pull through cache rule.
     */
    public final String upstreamRepositoryPrefix() {
        return upstreamRepositoryPrefix;
    }

    /**
     * <p>
     * Whether or not the pull through cache rule was validated. If <code>true</code>, Amazon ECR was able to reach the
     * upstream registry and authentication was successful. If <code>false</code>, there was an issue and validation
     * failed. The <code>failure</code> reason indicates the cause.
     * </p>
     * 
     * @return Whether or not the pull through cache rule was validated. If <code>true</code>, Amazon ECR was able to
     *         reach the upstream registry and authentication was successful. If <code>false</code>, there was an issue
     *         and validation failed. The <code>failure</code> reason indicates the cause.
     */
    public final Boolean isValid() {
        return isValid;
    }

    /**
     * <p>
     * The reason the validation failed. For more details about possible causes and how to address them, see <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html">Using pull through cache
     * rules</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     * </p>
     * 
     * @return The reason the validation failed. For more details about possible causes and how to address them, see <a
     *         href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html">Using pull through
     *         cache rules</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
     */
    public final String failure() {
        return failure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ecrRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(upstreamRegistryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(credentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(customRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(upstreamRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(isValid());
        hashCode = 31 * hashCode + Objects.hashCode(failure());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePullThroughCacheRuleResponse)) {
            return false;
        }
        ValidatePullThroughCacheRuleResponse other = (ValidatePullThroughCacheRuleResponse) obj;
        return Objects.equals(ecrRepositoryPrefix(), other.ecrRepositoryPrefix())
                && Objects.equals(registryId(), other.registryId())
                && Objects.equals(upstreamRegistryUrl(), other.upstreamRegistryUrl())
                && Objects.equals(credentialArn(), other.credentialArn())
                && Objects.equals(customRoleArn(), other.customRoleArn())
                && Objects.equals(upstreamRepositoryPrefix(), other.upstreamRepositoryPrefix())
                && Objects.equals(isValid(), other.isValid()) && Objects.equals(failure(), other.failure());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidatePullThroughCacheRuleResponse").add("EcrRepositoryPrefix", ecrRepositoryPrefix())
                .add("RegistryId", registryId()).add("UpstreamRegistryUrl", upstreamRegistryUrl())
                .add("CredentialArn", credentialArn()).add("CustomRoleArn", customRoleArn())
                .add("UpstreamRepositoryPrefix", upstreamRepositoryPrefix()).add("IsValid", isValid()).add("Failure", failure())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ecrRepositoryPrefix":
            return Optional.ofNullable(clazz.cast(ecrRepositoryPrefix()));
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "upstreamRegistryUrl":
            return Optional.ofNullable(clazz.cast(upstreamRegistryUrl()));
        case "credentialArn":
            return Optional.ofNullable(clazz.cast(credentialArn()));
        case "customRoleArn":
            return Optional.ofNullable(clazz.cast(customRoleArn()));
        case "upstreamRepositoryPrefix":
            return Optional.ofNullable(clazz.cast(upstreamRepositoryPrefix()));
        case "isValid":
            return Optional.ofNullable(clazz.cast(isValid()));
        case "failure":
            return Optional.ofNullable(clazz.cast(failure()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ecrRepositoryPrefix", ECR_REPOSITORY_PREFIX_FIELD);
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("upstreamRegistryUrl", UPSTREAM_REGISTRY_URL_FIELD);
        map.put("credentialArn", CREDENTIAL_ARN_FIELD);
        map.put("customRoleArn", CUSTOM_ROLE_ARN_FIELD);
        map.put("upstreamRepositoryPrefix", UPSTREAM_REPOSITORY_PREFIX_FIELD);
        map.put("isValid", IS_VALID_FIELD);
        map.put("failure", FAILURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidatePullThroughCacheRuleResponse, T> g) {
        return obj -> g.apply((ValidatePullThroughCacheRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, ValidatePullThroughCacheRuleResponse> {
        /**
         * <p>
         * The Amazon ECR repository prefix associated with the pull through cache rule.
         * </p>
         * 
         * @param ecrRepositoryPrefix
         *        The Amazon ECR repository prefix associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepositoryPrefix(String ecrRepositoryPrefix);

        /**
         * <p>
         * The registry ID associated with the request.
         * </p>
         * 
         * @param registryId
         *        The registry ID associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The upstream registry URL associated with the pull through cache rule.
         * </p>
         * 
         * @param upstreamRegistryUrl
         *        The upstream registry URL associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreamRegistryUrl(String upstreamRegistryUrl);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the pull
         * through cache rule.
         * </p>
         * 
         * @param credentialArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret associated with the
         *        pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialArn(String credentialArn);

        /**
         * <p>
         * The ARN of the IAM role associated with the pull through cache rule.
         * </p>
         * 
         * @param customRoleArn
         *        The ARN of the IAM role associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRoleArn(String customRoleArn);

        /**
         * <p>
         * The upstream repository prefix associated with the pull through cache rule.
         * </p>
         * 
         * @param upstreamRepositoryPrefix
         *        The upstream repository prefix associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreamRepositoryPrefix(String upstreamRepositoryPrefix);

        /**
         * <p>
         * Whether or not the pull through cache rule was validated. If <code>true</code>, Amazon ECR was able to reach
         * the upstream registry and authentication was successful. If <code>false</code>, there was an issue and
         * validation failed. The <code>failure</code> reason indicates the cause.
         * </p>
         * 
         * @param isValid
         *        Whether or not the pull through cache rule was validated. If <code>true</code>, Amazon ECR was able to
         *        reach the upstream registry and authentication was successful. If <code>false</code>, there was an
         *        issue and validation failed. The <code>failure</code> reason indicates the cause.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isValid(Boolean isValid);

        /**
         * <p>
         * The reason the validation failed. For more details about possible causes and how to address them, see <a
         * href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html">Using pull through
         * cache rules</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
         * </p>
         * 
         * @param failure
         *        The reason the validation failed. For more details about possible causes and how to address them, see
         *        <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/pull-through-cache.html">Using pull
         *        through cache rules</a> in the <i>Amazon Elastic Container Registry User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failure(String failure);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String ecrRepositoryPrefix;

        private String registryId;

        private String upstreamRegistryUrl;

        private String credentialArn;

        private String customRoleArn;

        private String upstreamRepositoryPrefix;

        private Boolean isValid;

        private String failure;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidatePullThroughCacheRuleResponse model) {
            super(model);
            ecrRepositoryPrefix(model.ecrRepositoryPrefix);
            registryId(model.registryId);
            upstreamRegistryUrl(model.upstreamRegistryUrl);
            credentialArn(model.credentialArn);
            customRoleArn(model.customRoleArn);
            upstreamRepositoryPrefix(model.upstreamRepositoryPrefix);
            isValid(model.isValid);
            failure(model.failure);
        }

        public final String getEcrRepositoryPrefix() {
            return ecrRepositoryPrefix;
        }

        public final void setEcrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
        }

        @Override
        public final Builder ecrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getUpstreamRegistryUrl() {
            return upstreamRegistryUrl;
        }

        public final void setUpstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
        }

        @Override
        public final Builder upstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
            return this;
        }

        public final String getCredentialArn() {
            return credentialArn;
        }

        public final void setCredentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
        }

        @Override
        public final Builder credentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
            return this;
        }

        public final String getCustomRoleArn() {
            return customRoleArn;
        }

        public final void setCustomRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
        }

        @Override
        public final Builder customRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        public final String getUpstreamRepositoryPrefix() {
            return upstreamRepositoryPrefix;
        }

        public final void setUpstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
        }

        @Override
        public final Builder upstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
            return this;
        }

        public final Boolean getIsValid() {
            return isValid;
        }

        public final void setIsValid(Boolean isValid) {
            this.isValid = isValid;
        }

        @Override
        public final Builder isValid(Boolean isValid) {
            this.isValid = isValid;
            return this;
        }

        public final String getFailure() {
            return failure;
        }

        public final void setFailure(String failure) {
            this.failure = failure;
        }

        @Override
        public final Builder failure(String failure) {
            this.failure = failure;
            return this;
        }

        @Override
        public ValidatePullThroughCacheRuleResponse build() {
            return new ValidatePullThroughCacheRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
