/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Traffic Mirror filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficMirrorFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficMirrorFilter.Builder, TrafficMirrorFilter> {
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficMirrorFilterId")
            .getter(getter(TrafficMirrorFilter::trafficMirrorFilterId))
            .setter(setter(Builder::trafficMirrorFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId")
                    .unmarshallLocationName("trafficMirrorFilterId").build()).build();

    private static final SdkField<List<TrafficMirrorFilterRule>> INGRESS_FILTER_RULES_FIELD = SdkField
            .<List<TrafficMirrorFilterRule>> builder(MarshallingType.LIST)
            .memberName("IngressFilterRules")
            .getter(getter(TrafficMirrorFilter::ingressFilterRules))
            .setter(setter(Builder::ingressFilterRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressFilterRuleSet")
                    .unmarshallLocationName("ingressFilterRuleSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TrafficMirrorFilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrafficMirrorFilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<TrafficMirrorFilterRule>> EGRESS_FILTER_RULES_FIELD = SdkField
            .<List<TrafficMirrorFilterRule>> builder(MarshallingType.LIST)
            .memberName("EgressFilterRules")
            .getter(getter(TrafficMirrorFilter::egressFilterRules))
            .setter(setter(Builder::egressFilterRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressFilterRuleSet")
                    .unmarshallLocationName("egressFilterRuleSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TrafficMirrorFilterRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrafficMirrorFilterRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> NETWORK_SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NetworkServices")
            .getter(getter(TrafficMirrorFilter::networkServicesAsStrings))
            .setter(setter(Builder::networkServicesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkServiceSet")
                    .unmarshallLocationName("networkServiceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(TrafficMirrorFilter::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TrafficMirrorFilter::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_MIRROR_FILTER_ID_FIELD, INGRESS_FILTER_RULES_FIELD, EGRESS_FILTER_RULES_FIELD, NETWORK_SERVICES_FIELD,
            DESCRIPTION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String trafficMirrorFilterId;

    private final List<TrafficMirrorFilterRule> ingressFilterRules;

    private final List<TrafficMirrorFilterRule> egressFilterRules;

    private final List<String> networkServices;

    private final String description;

    private final List<Tag> tags;

    private TrafficMirrorFilter(BuilderImpl builder) {
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.ingressFilterRules = builder.ingressFilterRules;
        this.egressFilterRules = builder.egressFilterRules;
        this.networkServices = builder.networkServices;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror filter.
     * </p>
     * 
     * @return The ID of the Traffic Mirror filter.
     */
    public final String trafficMirrorFilterId() {
        return trafficMirrorFilterId;
    }

    /**
     * For responses, this returns true if the service returned a value for the IngressFilterRules property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIngressFilterRules() {
        return ingressFilterRules != null && !(ingressFilterRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the ingress rules that are associated with the Traffic Mirror filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIngressFilterRules} method.
     * </p>
     * 
     * @return Information about the ingress rules that are associated with the Traffic Mirror filter.
     */
    public final List<TrafficMirrorFilterRule> ingressFilterRules() {
        return ingressFilterRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the EgressFilterRules property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEgressFilterRules() {
        return egressFilterRules != null && !(egressFilterRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the egress rules that are associated with the Traffic Mirror filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEgressFilterRules} method.
     * </p>
     * 
     * @return Information about the egress rules that are associated with the Traffic Mirror filter.
     */
    public final List<TrafficMirrorFilterRule> egressFilterRules() {
        return egressFilterRules;
    }

    /**
     * <p>
     * The network service traffic that is associated with the Traffic Mirror filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkServices} method.
     * </p>
     * 
     * @return The network service traffic that is associated with the Traffic Mirror filter.
     */
    public final List<TrafficMirrorNetworkService> networkServices() {
        return TrafficMirrorNetworkServiceListCopier.copyStringToEnum(networkServices);
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkServices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkServices() {
        return networkServices != null && !(networkServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network service traffic that is associated with the Traffic Mirror filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkServices} method.
     * </p>
     * 
     * @return The network service traffic that is associated with the Traffic Mirror filter.
     */
    public final List<String> networkServicesAsStrings() {
        return networkServices;
    }

    /**
     * <p>
     * The description of the Traffic Mirror filter.
     * </p>
     * 
     * @return The description of the Traffic Mirror filter.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags assigned to the Traffic Mirror filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the Traffic Mirror filter.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(hasIngressFilterRules() ? ingressFilterRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEgressFilterRules() ? egressFilterRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkServices() ? networkServicesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficMirrorFilter)) {
            return false;
        }
        TrafficMirrorFilter other = (TrafficMirrorFilter) obj;
        return Objects.equals(trafficMirrorFilterId(), other.trafficMirrorFilterId())
                && hasIngressFilterRules() == other.hasIngressFilterRules()
                && Objects.equals(ingressFilterRules(), other.ingressFilterRules())
                && hasEgressFilterRules() == other.hasEgressFilterRules()
                && Objects.equals(egressFilterRules(), other.egressFilterRules())
                && hasNetworkServices() == other.hasNetworkServices()
                && Objects.equals(networkServicesAsStrings(), other.networkServicesAsStrings())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrafficMirrorFilter").add("TrafficMirrorFilterId", trafficMirrorFilterId())
                .add("IngressFilterRules", hasIngressFilterRules() ? ingressFilterRules() : null)
                .add("EgressFilterRules", hasEgressFilterRules() ? egressFilterRules() : null)
                .add("NetworkServices", hasNetworkServices() ? networkServicesAsStrings() : null)
                .add("Description", description()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorFilterId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterId()));
        case "IngressFilterRules":
            return Optional.ofNullable(clazz.cast(ingressFilterRules()));
        case "EgressFilterRules":
            return Optional.ofNullable(clazz.cast(egressFilterRules()));
        case "NetworkServices":
            return Optional.ofNullable(clazz.cast(networkServicesAsStrings()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrafficMirrorFilterId", TRAFFIC_MIRROR_FILTER_ID_FIELD);
        map.put("IngressFilterRuleSet", INGRESS_FILTER_RULES_FIELD);
        map.put("EgressFilterRuleSet", EGRESS_FILTER_RULES_FIELD);
        map.put("NetworkServiceSet", NETWORK_SERVICES_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrafficMirrorFilter, T> g) {
        return obj -> g.apply((TrafficMirrorFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficMirrorFilter> {
        /**
         * <p>
         * The ID of the Traffic Mirror filter.
         * </p>
         * 
         * @param trafficMirrorFilterId
         *        The ID of the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterId(String trafficMirrorFilterId);

        /**
         * <p>
         * Information about the ingress rules that are associated with the Traffic Mirror filter.
         * </p>
         * 
         * @param ingressFilterRules
         *        Information about the ingress rules that are associated with the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressFilterRules(Collection<TrafficMirrorFilterRule> ingressFilterRules);

        /**
         * <p>
         * Information about the ingress rules that are associated with the Traffic Mirror filter.
         * </p>
         * 
         * @param ingressFilterRules
         *        Information about the ingress rules that are associated with the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressFilterRules(TrafficMirrorFilterRule... ingressFilterRules);

        /**
         * <p>
         * Information about the ingress rules that are associated with the Traffic Mirror filter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule.Builder#build()} is called
         * immediately and its result is passed to {@link #ingressFilterRules(List<TrafficMirrorFilterRule>)}.
         * 
         * @param ingressFilterRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressFilterRules(java.util.Collection<TrafficMirrorFilterRule>)
         */
        Builder ingressFilterRules(Consumer<TrafficMirrorFilterRule.Builder>... ingressFilterRules);

        /**
         * <p>
         * Information about the egress rules that are associated with the Traffic Mirror filter.
         * </p>
         * 
         * @param egressFilterRules
         *        Information about the egress rules that are associated with the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressFilterRules(Collection<TrafficMirrorFilterRule> egressFilterRules);

        /**
         * <p>
         * Information about the egress rules that are associated with the Traffic Mirror filter.
         * </p>
         * 
         * @param egressFilterRules
         *        Information about the egress rules that are associated with the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressFilterRules(TrafficMirrorFilterRule... egressFilterRules);

        /**
         * <p>
         * Information about the egress rules that are associated with the Traffic Mirror filter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule.Builder#build()} is called
         * immediately and its result is passed to {@link #egressFilterRules(List<TrafficMirrorFilterRule>)}.
         * 
         * @param egressFilterRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressFilterRules(java.util.Collection<TrafficMirrorFilterRule>)
         */
        Builder egressFilterRules(Consumer<TrafficMirrorFilterRule.Builder>... egressFilterRules);

        /**
         * <p>
         * The network service traffic that is associated with the Traffic Mirror filter.
         * </p>
         * 
         * @param networkServices
         *        The network service traffic that is associated with the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkServicesWithStrings(Collection<String> networkServices);

        /**
         * <p>
         * The network service traffic that is associated with the Traffic Mirror filter.
         * </p>
         * 
         * @param networkServices
         *        The network service traffic that is associated with the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkServicesWithStrings(String... networkServices);

        /**
         * <p>
         * The network service traffic that is associated with the Traffic Mirror filter.
         * </p>
         * 
         * @param networkServices
         *        The network service traffic that is associated with the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkServices(Collection<TrafficMirrorNetworkService> networkServices);

        /**
         * <p>
         * The network service traffic that is associated with the Traffic Mirror filter.
         * </p>
         * 
         * @param networkServices
         *        The network service traffic that is associated with the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkServices(TrafficMirrorNetworkService... networkServices);

        /**
         * <p>
         * The description of the Traffic Mirror filter.
         * </p>
         * 
         * @param description
         *        The description of the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The tags assigned to the Traffic Mirror filter.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags assigned to the Traffic Mirror filter.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags assigned to the Traffic Mirror filter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String trafficMirrorFilterId;

        private List<TrafficMirrorFilterRule> ingressFilterRules = DefaultSdkAutoConstructList.getInstance();

        private List<TrafficMirrorFilterRule> egressFilterRules = DefaultSdkAutoConstructList.getInstance();

        private List<String> networkServices = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficMirrorFilter model) {
            trafficMirrorFilterId(model.trafficMirrorFilterId);
            ingressFilterRules(model.ingressFilterRules);
            egressFilterRules(model.egressFilterRules);
            networkServicesWithStrings(model.networkServices);
            description(model.description);
            tags(model.tags);
        }

        public final String getTrafficMirrorFilterId() {
            return trafficMirrorFilterId;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final List<TrafficMirrorFilterRule.Builder> getIngressFilterRules() {
            List<TrafficMirrorFilterRule.Builder> result = TrafficMirrorFilterRuleListCopier
                    .copyToBuilder(this.ingressFilterRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIngressFilterRules(Collection<TrafficMirrorFilterRule.BuilderImpl> ingressFilterRules) {
            this.ingressFilterRules = TrafficMirrorFilterRuleListCopier.copyFromBuilder(ingressFilterRules);
        }

        @Override
        public final Builder ingressFilterRules(Collection<TrafficMirrorFilterRule> ingressFilterRules) {
            this.ingressFilterRules = TrafficMirrorFilterRuleListCopier.copy(ingressFilterRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressFilterRules(TrafficMirrorFilterRule... ingressFilterRules) {
            ingressFilterRules(Arrays.asList(ingressFilterRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressFilterRules(Consumer<TrafficMirrorFilterRule.Builder>... ingressFilterRules) {
            ingressFilterRules(Stream.of(ingressFilterRules).map(c -> TrafficMirrorFilterRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TrafficMirrorFilterRule.Builder> getEgressFilterRules() {
            List<TrafficMirrorFilterRule.Builder> result = TrafficMirrorFilterRuleListCopier
                    .copyToBuilder(this.egressFilterRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEgressFilterRules(Collection<TrafficMirrorFilterRule.BuilderImpl> egressFilterRules) {
            this.egressFilterRules = TrafficMirrorFilterRuleListCopier.copyFromBuilder(egressFilterRules);
        }

        @Override
        public final Builder egressFilterRules(Collection<TrafficMirrorFilterRule> egressFilterRules) {
            this.egressFilterRules = TrafficMirrorFilterRuleListCopier.copy(egressFilterRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressFilterRules(TrafficMirrorFilterRule... egressFilterRules) {
            egressFilterRules(Arrays.asList(egressFilterRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressFilterRules(Consumer<TrafficMirrorFilterRule.Builder>... egressFilterRules) {
            egressFilterRules(Stream.of(egressFilterRules).map(c -> TrafficMirrorFilterRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNetworkServices() {
            if (networkServices instanceof SdkAutoConstructList) {
                return null;
            }
            return networkServices;
        }

        public final void setNetworkServices(Collection<String> networkServices) {
            this.networkServices = TrafficMirrorNetworkServiceListCopier.copy(networkServices);
        }

        @Override
        public final Builder networkServicesWithStrings(Collection<String> networkServices) {
            this.networkServices = TrafficMirrorNetworkServiceListCopier.copy(networkServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkServicesWithStrings(String... networkServices) {
            networkServicesWithStrings(Arrays.asList(networkServices));
            return this;
        }

        @Override
        public final Builder networkServices(Collection<TrafficMirrorNetworkService> networkServices) {
            this.networkServices = TrafficMirrorNetworkServiceListCopier.copyEnumToString(networkServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkServices(TrafficMirrorNetworkService... networkServices) {
            networkServices(Arrays.asList(networkServices));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TrafficMirrorFilter build() {
            return new TrafficMirrorFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
