/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the service link virtual interfaces that establish connectivity between Amazon Web Services Outpost and
 * on-premises networks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceLinkVirtualInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceLinkVirtualInterface.Builder, ServiceLinkVirtualInterface> {
    private static final SdkField<String> SERVICE_LINK_VIRTUAL_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceLinkVirtualInterfaceId")
            .getter(getter(ServiceLinkVirtualInterface::serviceLinkVirtualInterfaceId))
            .setter(setter(Builder::serviceLinkVirtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkVirtualInterfaceId")
                    .unmarshallLocationName("serviceLinkVirtualInterfaceId").build()).build();

    private static final SdkField<String> SERVICE_LINK_VIRTUAL_INTERFACE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceLinkVirtualInterfaceArn")
            .getter(getter(ServiceLinkVirtualInterface::serviceLinkVirtualInterfaceArn))
            .setter(setter(Builder::serviceLinkVirtualInterfaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkVirtualInterfaceArn")
                    .unmarshallLocationName("serviceLinkVirtualInterfaceArn").build()).build();

    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostId")
            .getter(getter(ServiceLinkVirtualInterface::outpostId))
            .setter(setter(Builder::outpostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostId")
                    .unmarshallLocationName("outpostId").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(ServiceLinkVirtualInterface::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("outpostArn").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(ServiceLinkVirtualInterface::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<String> LOCAL_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalAddress")
            .getter(getter(ServiceLinkVirtualInterface::localAddress))
            .setter(setter(Builder::localAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalAddress")
                    .unmarshallLocationName("localAddress").build()).build();

    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerAddress")
            .getter(getter(ServiceLinkVirtualInterface::peerAddress))
            .setter(setter(Builder::peerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress")
                    .unmarshallLocationName("peerAddress").build()).build();

    private static final SdkField<Long> PEER_BGP_ASN_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("PeerBgpAsn")
            .getter(getter(ServiceLinkVirtualInterface::peerBgpAsn))
            .setter(setter(Builder::peerBgpAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerBgpAsn")
                    .unmarshallLocationName("peerBgpAsn").build()).build();

    private static final SdkField<Integer> VLAN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Vlan")
            .getter(getter(ServiceLinkVirtualInterface::vlan))
            .setter(setter(Builder::vlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vlan")
                    .unmarshallLocationName("vlan").build()).build();

    private static final SdkField<String> OUTPOST_LAG_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostLagId")
            .getter(getter(ServiceLinkVirtualInterface::outpostLagId))
            .setter(setter(Builder::outpostLagId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostLagId")
                    .unmarshallLocationName("outpostLagId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ServiceLinkVirtualInterface::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> CONFIGURATION_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationState")
            .getter(getter(ServiceLinkVirtualInterface::configurationStateAsString))
            .setter(setter(Builder::configurationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationState")
                    .unmarshallLocationName("configurationState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SERVICE_LINK_VIRTUAL_INTERFACE_ID_FIELD, SERVICE_LINK_VIRTUAL_INTERFACE_ARN_FIELD, OUTPOST_ID_FIELD,
            OUTPOST_ARN_FIELD, OWNER_ID_FIELD, LOCAL_ADDRESS_FIELD, PEER_ADDRESS_FIELD, PEER_BGP_ASN_FIELD, VLAN_FIELD,
            OUTPOST_LAG_ID_FIELD, TAGS_FIELD, CONFIGURATION_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceLinkVirtualInterfaceId;

    private final String serviceLinkVirtualInterfaceArn;

    private final String outpostId;

    private final String outpostArn;

    private final String ownerId;

    private final String localAddress;

    private final String peerAddress;

    private final Long peerBgpAsn;

    private final Integer vlan;

    private final String outpostLagId;

    private final List<Tag> tags;

    private final String configurationState;

    private ServiceLinkVirtualInterface(BuilderImpl builder) {
        this.serviceLinkVirtualInterfaceId = builder.serviceLinkVirtualInterfaceId;
        this.serviceLinkVirtualInterfaceArn = builder.serviceLinkVirtualInterfaceArn;
        this.outpostId = builder.outpostId;
        this.outpostArn = builder.outpostArn;
        this.ownerId = builder.ownerId;
        this.localAddress = builder.localAddress;
        this.peerAddress = builder.peerAddress;
        this.peerBgpAsn = builder.peerBgpAsn;
        this.vlan = builder.vlan;
        this.outpostLagId = builder.outpostLagId;
        this.tags = builder.tags;
        this.configurationState = builder.configurationState;
    }

    /**
     * <p>
     * The ID of the service link virtual interface.
     * </p>
     * 
     * @return The ID of the service link virtual interface.
     */
    public final String serviceLinkVirtualInterfaceId() {
        return serviceLinkVirtualInterfaceId;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) for the service link virtual interface.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) for the service link virtual interface.
     */
    public final String serviceLinkVirtualInterfaceArn() {
        return serviceLinkVirtualInterfaceArn;
    }

    /**
     * <p>
     * The Outpost ID for the service link virtual interface.
     * </p>
     * 
     * @return The Outpost ID for the service link virtual interface.
     */
    public final String outpostId() {
        return outpostId;
    }

    /**
     * <p>
     * The Outpost Amazon Resource Number (ARN) for the service link virtual interface.
     * </p>
     * 
     * @return The Outpost Amazon Resource Number (ARN) for the service link virtual interface.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the service link virtual interface..
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the service link virtual interface..
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The IPv4 address assigned to the local gateway virtual interface on the Outpost side.
     * </p>
     * 
     * @return The IPv4 address assigned to the local gateway virtual interface on the Outpost side.
     */
    public final String localAddress() {
        return localAddress;
    }

    /**
     * <p>
     * The IPv4 peer address for the service link virtual interface.
     * </p>
     * 
     * @return The IPv4 peer address for the service link virtual interface.
     */
    public final String peerAddress() {
        return peerAddress;
    }

    /**
     * <p>
     * The ASN for the Border Gateway Protocol (BGP) associated with the service link virtual interface.
     * </p>
     * 
     * @return The ASN for the Border Gateway Protocol (BGP) associated with the service link virtual interface.
     */
    public final Long peerBgpAsn() {
        return peerBgpAsn;
    }

    /**
     * <p>
     * The virtual local area network for the service link virtual interface.
     * </p>
     * 
     * @return The virtual local area network for the service link virtual interface.
     */
    public final Integer vlan() {
        return vlan;
    }

    /**
     * <p>
     * The link aggregation group (LAG) ID for the service link virtual interface.
     * </p>
     * 
     * @return The link aggregation group (LAG) ID for the service link virtual interface.
     */
    public final String outpostLagId() {
        return outpostLagId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the service link virtual interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the service link virtual interface.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The current state of the service link virtual interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationState} will return
     * {@link ServiceLinkVirtualInterfaceConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #configurationStateAsString}.
     * </p>
     * 
     * @return The current state of the service link virtual interface.
     * @see ServiceLinkVirtualInterfaceConfigurationState
     */
    public final ServiceLinkVirtualInterfaceConfigurationState configurationState() {
        return ServiceLinkVirtualInterfaceConfigurationState.fromValue(configurationState);
    }

    /**
     * <p>
     * The current state of the service link virtual interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationState} will return
     * {@link ServiceLinkVirtualInterfaceConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #configurationStateAsString}.
     * </p>
     * 
     * @return The current state of the service link virtual interface.
     * @see ServiceLinkVirtualInterfaceConfigurationState
     */
    public final String configurationStateAsString() {
        return configurationState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceLinkVirtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceLinkVirtualInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(localAddress());
        hashCode = 31 * hashCode + Objects.hashCode(peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(peerBgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(vlan());
        hashCode = 31 * hashCode + Objects.hashCode(outpostLagId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configurationStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLinkVirtualInterface)) {
            return false;
        }
        ServiceLinkVirtualInterface other = (ServiceLinkVirtualInterface) obj;
        return Objects.equals(serviceLinkVirtualInterfaceId(), other.serviceLinkVirtualInterfaceId())
                && Objects.equals(serviceLinkVirtualInterfaceArn(), other.serviceLinkVirtualInterfaceArn())
                && Objects.equals(outpostId(), other.outpostId()) && Objects.equals(outpostArn(), other.outpostArn())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(localAddress(), other.localAddress())
                && Objects.equals(peerAddress(), other.peerAddress()) && Objects.equals(peerBgpAsn(), other.peerBgpAsn())
                && Objects.equals(vlan(), other.vlan()) && Objects.equals(outpostLagId(), other.outpostLagId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(configurationStateAsString(), other.configurationStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceLinkVirtualInterface")
                .add("ServiceLinkVirtualInterfaceId", serviceLinkVirtualInterfaceId())
                .add("ServiceLinkVirtualInterfaceArn", serviceLinkVirtualInterfaceArn()).add("OutpostId", outpostId())
                .add("OutpostArn", outpostArn()).add("OwnerId", ownerId()).add("LocalAddress", localAddress())
                .add("PeerAddress", peerAddress()).add("PeerBgpAsn", peerBgpAsn()).add("Vlan", vlan())
                .add("OutpostLagId", outpostLagId()).add("Tags", hasTags() ? tags() : null)
                .add("ConfigurationState", configurationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceLinkVirtualInterfaceId":
            return Optional.ofNullable(clazz.cast(serviceLinkVirtualInterfaceId()));
        case "ServiceLinkVirtualInterfaceArn":
            return Optional.ofNullable(clazz.cast(serviceLinkVirtualInterfaceArn()));
        case "OutpostId":
            return Optional.ofNullable(clazz.cast(outpostId()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "LocalAddress":
            return Optional.ofNullable(clazz.cast(localAddress()));
        case "PeerAddress":
            return Optional.ofNullable(clazz.cast(peerAddress()));
        case "PeerBgpAsn":
            return Optional.ofNullable(clazz.cast(peerBgpAsn()));
        case "Vlan":
            return Optional.ofNullable(clazz.cast(vlan()));
        case "OutpostLagId":
            return Optional.ofNullable(clazz.cast(outpostLagId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ConfigurationState":
            return Optional.ofNullable(clazz.cast(configurationStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServiceLinkVirtualInterfaceId", SERVICE_LINK_VIRTUAL_INTERFACE_ID_FIELD);
        map.put("ServiceLinkVirtualInterfaceArn", SERVICE_LINK_VIRTUAL_INTERFACE_ARN_FIELD);
        map.put("OutpostId", OUTPOST_ID_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("LocalAddress", LOCAL_ADDRESS_FIELD);
        map.put("PeerAddress", PEER_ADDRESS_FIELD);
        map.put("PeerBgpAsn", PEER_BGP_ASN_FIELD);
        map.put("Vlan", VLAN_FIELD);
        map.put("OutpostLagId", OUTPOST_LAG_ID_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("ConfigurationState", CONFIGURATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceLinkVirtualInterface, T> g) {
        return obj -> g.apply((ServiceLinkVirtualInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceLinkVirtualInterface> {
        /**
         * <p>
         * The ID of the service link virtual interface.
         * </p>
         * 
         * @param serviceLinkVirtualInterfaceId
         *        The ID of the service link virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceLinkVirtualInterfaceId(String serviceLinkVirtualInterfaceId);

        /**
         * <p>
         * The Amazon Resource Number (ARN) for the service link virtual interface.
         * </p>
         * 
         * @param serviceLinkVirtualInterfaceArn
         *        The Amazon Resource Number (ARN) for the service link virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceLinkVirtualInterfaceArn(String serviceLinkVirtualInterfaceArn);

        /**
         * <p>
         * The Outpost ID for the service link virtual interface.
         * </p>
         * 
         * @param outpostId
         *        The Outpost ID for the service link virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostId(String outpostId);

        /**
         * <p>
         * The Outpost Amazon Resource Number (ARN) for the service link virtual interface.
         * </p>
         * 
         * @param outpostArn
         *        The Outpost Amazon Resource Number (ARN) for the service link virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the service link virtual interface..
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the service link virtual interface..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The IPv4 address assigned to the local gateway virtual interface on the Outpost side.
         * </p>
         * 
         * @param localAddress
         *        The IPv4 address assigned to the local gateway virtual interface on the Outpost side.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localAddress(String localAddress);

        /**
         * <p>
         * The IPv4 peer address for the service link virtual interface.
         * </p>
         * 
         * @param peerAddress
         *        The IPv4 peer address for the service link virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAddress(String peerAddress);

        /**
         * <p>
         * The ASN for the Border Gateway Protocol (BGP) associated with the service link virtual interface.
         * </p>
         * 
         * @param peerBgpAsn
         *        The ASN for the Border Gateway Protocol (BGP) associated with the service link virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerBgpAsn(Long peerBgpAsn);

        /**
         * <p>
         * The virtual local area network for the service link virtual interface.
         * </p>
         * 
         * @param vlan
         *        The virtual local area network for the service link virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vlan(Integer vlan);

        /**
         * <p>
         * The link aggregation group (LAG) ID for the service link virtual interface.
         * </p>
         * 
         * @param outpostLagId
         *        The link aggregation group (LAG) ID for the service link virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostLagId(String outpostLagId);

        /**
         * <p>
         * The tags associated with the service link virtual interface.
         * </p>
         * 
         * @param tags
         *        The tags associated with the service link virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the service link virtual interface.
         * </p>
         * 
         * @param tags
         *        The tags associated with the service link virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the service link virtual interface.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The current state of the service link virtual interface.
         * </p>
         * 
         * @param configurationState
         *        The current state of the service link virtual interface.
         * @see ServiceLinkVirtualInterfaceConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLinkVirtualInterfaceConfigurationState
         */
        Builder configurationState(String configurationState);

        /**
         * <p>
         * The current state of the service link virtual interface.
         * </p>
         * 
         * @param configurationState
         *        The current state of the service link virtual interface.
         * @see ServiceLinkVirtualInterfaceConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLinkVirtualInterfaceConfigurationState
         */
        Builder configurationState(ServiceLinkVirtualInterfaceConfigurationState configurationState);
    }

    static final class BuilderImpl implements Builder {
        private String serviceLinkVirtualInterfaceId;

        private String serviceLinkVirtualInterfaceArn;

        private String outpostId;

        private String outpostArn;

        private String ownerId;

        private String localAddress;

        private String peerAddress;

        private Long peerBgpAsn;

        private Integer vlan;

        private String outpostLagId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String configurationState;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLinkVirtualInterface model) {
            serviceLinkVirtualInterfaceId(model.serviceLinkVirtualInterfaceId);
            serviceLinkVirtualInterfaceArn(model.serviceLinkVirtualInterfaceArn);
            outpostId(model.outpostId);
            outpostArn(model.outpostArn);
            ownerId(model.ownerId);
            localAddress(model.localAddress);
            peerAddress(model.peerAddress);
            peerBgpAsn(model.peerBgpAsn);
            vlan(model.vlan);
            outpostLagId(model.outpostLagId);
            tags(model.tags);
            configurationState(model.configurationState);
        }

        public final String getServiceLinkVirtualInterfaceId() {
            return serviceLinkVirtualInterfaceId;
        }

        public final void setServiceLinkVirtualInterfaceId(String serviceLinkVirtualInterfaceId) {
            this.serviceLinkVirtualInterfaceId = serviceLinkVirtualInterfaceId;
        }

        @Override
        public final Builder serviceLinkVirtualInterfaceId(String serviceLinkVirtualInterfaceId) {
            this.serviceLinkVirtualInterfaceId = serviceLinkVirtualInterfaceId;
            return this;
        }

        public final String getServiceLinkVirtualInterfaceArn() {
            return serviceLinkVirtualInterfaceArn;
        }

        public final void setServiceLinkVirtualInterfaceArn(String serviceLinkVirtualInterfaceArn) {
            this.serviceLinkVirtualInterfaceArn = serviceLinkVirtualInterfaceArn;
        }

        @Override
        public final Builder serviceLinkVirtualInterfaceArn(String serviceLinkVirtualInterfaceArn) {
            this.serviceLinkVirtualInterfaceArn = serviceLinkVirtualInterfaceArn;
            return this;
        }

        public final String getOutpostId() {
            return outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getLocalAddress() {
            return localAddress;
        }

        public final void setLocalAddress(String localAddress) {
            this.localAddress = localAddress;
        }

        @Override
        public final Builder localAddress(String localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public final String getPeerAddress() {
            return peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final Long getPeerBgpAsn() {
            return peerBgpAsn;
        }

        public final void setPeerBgpAsn(Long peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
        }

        @Override
        public final Builder peerBgpAsn(Long peerBgpAsn) {
            this.peerBgpAsn = peerBgpAsn;
            return this;
        }

        public final Integer getVlan() {
            return vlan;
        }

        public final void setVlan(Integer vlan) {
            this.vlan = vlan;
        }

        @Override
        public final Builder vlan(Integer vlan) {
            this.vlan = vlan;
            return this;
        }

        public final String getOutpostLagId() {
            return outpostLagId;
        }

        public final void setOutpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
        }

        @Override
        public final Builder outpostLagId(String outpostLagId) {
            this.outpostLagId = outpostLagId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConfigurationState() {
            return configurationState;
        }

        public final void setConfigurationState(String configurationState) {
            this.configurationState = configurationState;
        }

        @Override
        public final Builder configurationState(String configurationState) {
            this.configurationState = configurationState;
            return this;
        }

        @Override
        public final Builder configurationState(ServiceLinkVirtualInterfaceConfigurationState configurationState) {
            this.configurationState(configurationState == null ? null : configurationState.toString());
            return this;
        }

        @Override
        public ServiceLinkVirtualInterface build() {
            return new ServiceLinkVirtualInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
