/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyTrafficMirrorSessionRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyTrafficMirrorSessionRequest.Builder, ModifyTrafficMirrorSessionRequest> {
    private static final SdkField<String> TRAFFIC_MIRROR_SESSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficMirrorSessionId")
            .getter(getter(ModifyTrafficMirrorSessionRequest::trafficMirrorSessionId))
            .setter(setter(Builder::trafficMirrorSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorSessionId")
                    .unmarshallLocationName("TrafficMirrorSessionId").build()).build();

    private static final SdkField<String> TRAFFIC_MIRROR_TARGET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficMirrorTargetId")
            .getter(getter(ModifyTrafficMirrorSessionRequest::trafficMirrorTargetId))
            .setter(setter(Builder::trafficMirrorTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorTargetId")
                    .unmarshallLocationName("TrafficMirrorTargetId").build()).build();

    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficMirrorFilterId")
            .getter(getter(ModifyTrafficMirrorSessionRequest::trafficMirrorFilterId))
            .setter(setter(Builder::trafficMirrorFilterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId")
                    .unmarshallLocationName("TrafficMirrorFilterId").build()).build();

    private static final SdkField<Integer> PACKET_LENGTH_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PacketLength")
            .getter(getter(ModifyTrafficMirrorSessionRequest::packetLength))
            .setter(setter(Builder::packetLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketLength")
                    .unmarshallLocationName("PacketLength").build()).build();

    private static final SdkField<Integer> SESSION_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionNumber")
            .getter(getter(ModifyTrafficMirrorSessionRequest::sessionNumber))
            .setter(setter(Builder::sessionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionNumber")
                    .unmarshallLocationName("SessionNumber").build()).build();

    private static final SdkField<Integer> VIRTUAL_NETWORK_ID_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("VirtualNetworkId")
            .getter(getter(ModifyTrafficMirrorSessionRequest::virtualNetworkId))
            .setter(setter(Builder::virtualNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualNetworkId")
                    .unmarshallLocationName("VirtualNetworkId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ModifyTrafficMirrorSessionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<List<String>> REMOVE_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveFields")
            .getter(getter(ModifyTrafficMirrorSessionRequest::removeFieldsAsStrings))
            .setter(setter(Builder::removeFieldsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveField")
                    .unmarshallLocationName("RemoveField").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyTrafficMirrorSessionRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_MIRROR_SESSION_ID_FIELD, TRAFFIC_MIRROR_TARGET_ID_FIELD, TRAFFIC_MIRROR_FILTER_ID_FIELD, PACKET_LENGTH_FIELD,
            SESSION_NUMBER_FIELD, VIRTUAL_NETWORK_ID_FIELD, DESCRIPTION_FIELD, REMOVE_FIELDS_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trafficMirrorSessionId;

    private final String trafficMirrorTargetId;

    private final String trafficMirrorFilterId;

    private final Integer packetLength;

    private final Integer sessionNumber;

    private final Integer virtualNetworkId;

    private final String description;

    private final List<String> removeFields;

    private final Boolean dryRun;

    private ModifyTrafficMirrorSessionRequest(BuilderImpl builder) {
        super(builder);
        this.trafficMirrorSessionId = builder.trafficMirrorSessionId;
        this.trafficMirrorTargetId = builder.trafficMirrorTargetId;
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.packetLength = builder.packetLength;
        this.sessionNumber = builder.sessionNumber;
        this.virtualNetworkId = builder.virtualNetworkId;
        this.description = builder.description;
        this.removeFields = builder.removeFields;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror session.
     * </p>
     * 
     * @return The ID of the Traffic Mirror session.
     */
    public final String trafficMirrorSessionId() {
        return trafficMirrorSessionId;
    }

    /**
     * <p>
     * The Traffic Mirror target. The target must be in the same VPC as the source, or have a VPC peering connection
     * with the source.
     * </p>
     * 
     * @return The Traffic Mirror target. The target must be in the same VPC as the source, or have a VPC peering
     *         connection with the source.
     */
    public final String trafficMirrorTargetId() {
        return trafficMirrorTargetId;
    }

    /**
     * <p>
     * The ID of the Traffic Mirror filter.
     * </p>
     * 
     * @return The ID of the Traffic Mirror filter.
     */
    public final String trafficMirrorFilterId() {
        return trafficMirrorFilterId;
    }

    /**
     * <p>
     * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a subset, set
     * this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes that
     * meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror the
     * entire packet.
     * </p>
     * <p>
     * For sessions with Network Load Balancer (NLB) traffic mirror targets, the default <code>PacketLength</code> will
     * be set to 8500. Valid values are 1-8500. Setting a <code>PacketLength</code> greater than 8500 will result in an
     * error response.
     * </p>
     * 
     * @return The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a subset,
     *         set this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first
     *         100 bytes that meet the filter criteria are copied to the target. Do not specify this parameter when you
     *         want to mirror the entire packet.</p>
     *         <p>
     *         For sessions with Network Load Balancer (NLB) traffic mirror targets, the default
     *         <code>PacketLength</code> will be set to 8500. Valid values are 1-8500. Setting a
     *         <code>PacketLength</code> greater than 8500 will result in an error response.
     */
    public final Integer packetLength() {
        return packetLength;
    }

    /**
     * <p>
     * The session number determines the order in which sessions are evaluated when an interface is used by multiple
     * sessions. The first session with a matching filter is the one that mirrors the packets.
     * </p>
     * <p>
     * Valid values are 1-32766.
     * </p>
     * 
     * @return The session number determines the order in which sessions are evaluated when an interface is used by
     *         multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p>
     *         <p>
     *         Valid values are 1-32766.
     */
    public final Integer sessionNumber() {
        return sessionNumber;
    }

    /**
     * <p>
     * The virtual network ID of the Traffic Mirror session.
     * </p>
     * 
     * @return The virtual network ID of the Traffic Mirror session.
     */
    public final Integer virtualNetworkId() {
        return virtualNetworkId;
    }

    /**
     * <p>
     * The description to assign to the Traffic Mirror session.
     * </p>
     * 
     * @return The description to assign to the Traffic Mirror session.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The properties that you want to remove from the Traffic Mirror session.
     * </p>
     * <p>
     * When you remove a property from a Traffic Mirror session, the property is set to the default.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveFields} method.
     * </p>
     * 
     * @return The properties that you want to remove from the Traffic Mirror session.</p>
     *         <p>
     *         When you remove a property from a Traffic Mirror session, the property is set to the default.
     */
    public final List<TrafficMirrorSessionField> removeFields() {
        return TrafficMirrorSessionFieldListCopier.copyStringToEnum(removeFields);
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveFields() {
        return removeFields != null && !(removeFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties that you want to remove from the Traffic Mirror session.
     * </p>
     * <p>
     * When you remove a property from a Traffic Mirror session, the property is set to the default.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveFields} method.
     * </p>
     * 
     * @return The properties that you want to remove from the Traffic Mirror session.</p>
     *         <p>
     *         When you remove a property from a Traffic Mirror session, the property is set to the default.
     */
    public final List<String> removeFieldsAsStrings() {
        return removeFields;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(packetLength());
        hashCode = 31 * hashCode + Objects.hashCode(sessionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(virtualNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveFields() ? removeFieldsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTrafficMirrorSessionRequest)) {
            return false;
        }
        ModifyTrafficMirrorSessionRequest other = (ModifyTrafficMirrorSessionRequest) obj;
        return Objects.equals(trafficMirrorSessionId(), other.trafficMirrorSessionId())
                && Objects.equals(trafficMirrorTargetId(), other.trafficMirrorTargetId())
                && Objects.equals(trafficMirrorFilterId(), other.trafficMirrorFilterId())
                && Objects.equals(packetLength(), other.packetLength()) && Objects.equals(sessionNumber(), other.sessionNumber())
                && Objects.equals(virtualNetworkId(), other.virtualNetworkId())
                && Objects.equals(description(), other.description()) && hasRemoveFields() == other.hasRemoveFields()
                && Objects.equals(removeFieldsAsStrings(), other.removeFieldsAsStrings())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyTrafficMirrorSessionRequest").add("TrafficMirrorSessionId", trafficMirrorSessionId())
                .add("TrafficMirrorTargetId", trafficMirrorTargetId()).add("TrafficMirrorFilterId", trafficMirrorFilterId())
                .add("PacketLength", packetLength()).add("SessionNumber", sessionNumber())
                .add("VirtualNetworkId", virtualNetworkId()).add("Description", description())
                .add("RemoveFields", hasRemoveFields() ? removeFieldsAsStrings() : null).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficMirrorSessionId":
            return Optional.ofNullable(clazz.cast(trafficMirrorSessionId()));
        case "TrafficMirrorTargetId":
            return Optional.ofNullable(clazz.cast(trafficMirrorTargetId()));
        case "TrafficMirrorFilterId":
            return Optional.ofNullable(clazz.cast(trafficMirrorFilterId()));
        case "PacketLength":
            return Optional.ofNullable(clazz.cast(packetLength()));
        case "SessionNumber":
            return Optional.ofNullable(clazz.cast(sessionNumber()));
        case "VirtualNetworkId":
            return Optional.ofNullable(clazz.cast(virtualNetworkId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RemoveFields":
            return Optional.ofNullable(clazz.cast(removeFieldsAsStrings()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrafficMirrorSessionId", TRAFFIC_MIRROR_SESSION_ID_FIELD);
        map.put("TrafficMirrorTargetId", TRAFFIC_MIRROR_TARGET_ID_FIELD);
        map.put("TrafficMirrorFilterId", TRAFFIC_MIRROR_FILTER_ID_FIELD);
        map.put("PacketLength", PACKET_LENGTH_FIELD);
        map.put("SessionNumber", SESSION_NUMBER_FIELD);
        map.put("VirtualNetworkId", VIRTUAL_NETWORK_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("RemoveField", REMOVE_FIELDS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyTrafficMirrorSessionRequest, T> g) {
        return obj -> g.apply((ModifyTrafficMirrorSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyTrafficMirrorSessionRequest> {
        /**
         * <p>
         * The ID of the Traffic Mirror session.
         * </p>
         * 
         * @param trafficMirrorSessionId
         *        The ID of the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorSessionId(String trafficMirrorSessionId);

        /**
         * <p>
         * The Traffic Mirror target. The target must be in the same VPC as the source, or have a VPC peering connection
         * with the source.
         * </p>
         * 
         * @param trafficMirrorTargetId
         *        The Traffic Mirror target. The target must be in the same VPC as the source, or have a VPC peering
         *        connection with the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorTargetId(String trafficMirrorTargetId);

        /**
         * <p>
         * The ID of the Traffic Mirror filter.
         * </p>
         * 
         * @param trafficMirrorFilterId
         *        The ID of the Traffic Mirror filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficMirrorFilterId(String trafficMirrorFilterId);

        /**
         * <p>
         * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a subset, set
         * this to the length (in bytes) to mirror. For example, if you set this value to 100, then the first 100 bytes
         * that meet the filter criteria are copied to the target. Do not specify this parameter when you want to mirror
         * the entire packet.
         * </p>
         * <p>
         * For sessions with Network Load Balancer (NLB) traffic mirror targets, the default <code>PacketLength</code>
         * will be set to 8500. Valid values are 1-8500. Setting a <code>PacketLength</code> greater than 8500 will
         * result in an error response.
         * </p>
         * 
         * @param packetLength
         *        The number of bytes in each packet to mirror. These are bytes after the VXLAN header. To mirror a
         *        subset, set this to the length (in bytes) to mirror. For example, if you set this value to 100, then
         *        the first 100 bytes that meet the filter criteria are copied to the target. Do not specify this
         *        parameter when you want to mirror the entire packet.</p>
         *        <p>
         *        For sessions with Network Load Balancer (NLB) traffic mirror targets, the default
         *        <code>PacketLength</code> will be set to 8500. Valid values are 1-8500. Setting a
         *        <code>PacketLength</code> greater than 8500 will result in an error response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packetLength(Integer packetLength);

        /**
         * <p>
         * The session number determines the order in which sessions are evaluated when an interface is used by multiple
         * sessions. The first session with a matching filter is the one that mirrors the packets.
         * </p>
         * <p>
         * Valid values are 1-32766.
         * </p>
         * 
         * @param sessionNumber
         *        The session number determines the order in which sessions are evaluated when an interface is used by
         *        multiple sessions. The first session with a matching filter is the one that mirrors the packets.</p>
         *        <p>
         *        Valid values are 1-32766.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionNumber(Integer sessionNumber);

        /**
         * <p>
         * The virtual network ID of the Traffic Mirror session.
         * </p>
         * 
         * @param virtualNetworkId
         *        The virtual network ID of the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNetworkId(Integer virtualNetworkId);

        /**
         * <p>
         * The description to assign to the Traffic Mirror session.
         * </p>
         * 
         * @param description
         *        The description to assign to the Traffic Mirror session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The properties that you want to remove from the Traffic Mirror session.
         * </p>
         * <p>
         * When you remove a property from a Traffic Mirror session, the property is set to the default.
         * </p>
         * 
         * @param removeFields
         *        The properties that you want to remove from the Traffic Mirror session.</p>
         *        <p>
         *        When you remove a property from a Traffic Mirror session, the property is set to the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFieldsWithStrings(Collection<String> removeFields);

        /**
         * <p>
         * The properties that you want to remove from the Traffic Mirror session.
         * </p>
         * <p>
         * When you remove a property from a Traffic Mirror session, the property is set to the default.
         * </p>
         * 
         * @param removeFields
         *        The properties that you want to remove from the Traffic Mirror session.</p>
         *        <p>
         *        When you remove a property from a Traffic Mirror session, the property is set to the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFieldsWithStrings(String... removeFields);

        /**
         * <p>
         * The properties that you want to remove from the Traffic Mirror session.
         * </p>
         * <p>
         * When you remove a property from a Traffic Mirror session, the property is set to the default.
         * </p>
         * 
         * @param removeFields
         *        The properties that you want to remove from the Traffic Mirror session.</p>
         *        <p>
         *        When you remove a property from a Traffic Mirror session, the property is set to the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFields(Collection<TrafficMirrorSessionField> removeFields);

        /**
         * <p>
         * The properties that you want to remove from the Traffic Mirror session.
         * </p>
         * <p>
         * When you remove a property from a Traffic Mirror session, the property is set to the default.
         * </p>
         * 
         * @param removeFields
         *        The properties that you want to remove from the Traffic Mirror session.</p>
         *        <p>
         *        When you remove a property from a Traffic Mirror session, the property is set to the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeFields(TrafficMirrorSessionField... removeFields);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String trafficMirrorSessionId;

        private String trafficMirrorTargetId;

        private String trafficMirrorFilterId;

        private Integer packetLength;

        private Integer sessionNumber;

        private Integer virtualNetworkId;

        private String description;

        private List<String> removeFields = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTrafficMirrorSessionRequest model) {
            super(model);
            trafficMirrorSessionId(model.trafficMirrorSessionId);
            trafficMirrorTargetId(model.trafficMirrorTargetId);
            trafficMirrorFilterId(model.trafficMirrorFilterId);
            packetLength(model.packetLength);
            sessionNumber(model.sessionNumber);
            virtualNetworkId(model.virtualNetworkId);
            description(model.description);
            removeFieldsWithStrings(model.removeFields);
            dryRun(model.dryRun);
        }

        public final String getTrafficMirrorSessionId() {
            return trafficMirrorSessionId;
        }

        public final void setTrafficMirrorSessionId(String trafficMirrorSessionId) {
            this.trafficMirrorSessionId = trafficMirrorSessionId;
        }

        @Override
        public final Builder trafficMirrorSessionId(String trafficMirrorSessionId) {
            this.trafficMirrorSessionId = trafficMirrorSessionId;
            return this;
        }

        public final String getTrafficMirrorTargetId() {
            return trafficMirrorTargetId;
        }

        public final void setTrafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
        }

        @Override
        public final Builder trafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
            return this;
        }

        public final String getTrafficMirrorFilterId() {
            return trafficMirrorFilterId;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final Integer getPacketLength() {
            return packetLength;
        }

        public final void setPacketLength(Integer packetLength) {
            this.packetLength = packetLength;
        }

        @Override
        public final Builder packetLength(Integer packetLength) {
            this.packetLength = packetLength;
            return this;
        }

        public final Integer getSessionNumber() {
            return sessionNumber;
        }

        public final void setSessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
        }

        @Override
        public final Builder sessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
            return this;
        }

        public final Integer getVirtualNetworkId() {
            return virtualNetworkId;
        }

        public final void setVirtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
        }

        @Override
        public final Builder virtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getRemoveFields() {
            if (removeFields instanceof SdkAutoConstructList) {
                return null;
            }
            return removeFields;
        }

        public final void setRemoveFields(Collection<String> removeFields) {
            this.removeFields = TrafficMirrorSessionFieldListCopier.copy(removeFields);
        }

        @Override
        public final Builder removeFieldsWithStrings(Collection<String> removeFields) {
            this.removeFields = TrafficMirrorSessionFieldListCopier.copy(removeFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeFieldsWithStrings(String... removeFields) {
            removeFieldsWithStrings(Arrays.asList(removeFields));
            return this;
        }

        @Override
        public final Builder removeFields(Collection<TrafficMirrorSessionField> removeFields) {
            this.removeFields = TrafficMirrorSessionFieldListCopier.copyEnumToString(removeFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeFields(TrafficMirrorSessionField... removeFields) {
            removeFields(Arrays.asList(removeFields));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTrafficMirrorSessionRequest build() {
            return new ModifyTrafficMirrorSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
