/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyInstanceCapacityReservationAttributesRequest extends Ec2Request
        implements
        ToCopyableBuilder<ModifyInstanceCapacityReservationAttributesRequest.Builder, ModifyInstanceCapacityReservationAttributesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(ModifyInstanceCapacityReservationAttributesRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build()).build();

    private static final SdkField<CapacityReservationSpecification> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField
            .<CapacityReservationSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityReservationSpecification")
            .getter(getter(ModifyInstanceCapacityReservationAttributesRequest::capacityReservationSpecification))
            .setter(setter(Builder::capacityReservationSpecification))
            .constructor(CapacityReservationSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification")
                    .unmarshallLocationName("CapacityReservationSpecification").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyInstanceCapacityReservationAttributesRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CAPACITY_RESERVATION_SPECIFICATION_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final CapacityReservationSpecification capacityReservationSpecification;

    private final Boolean dryRun;

    private ModifyInstanceCapacityReservationAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The ID of the instance to be modified.
     * </p>
     * 
     * @return The ID of the instance to be modified.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Information about the Capacity Reservation targeting option.
     * </p>
     * 
     * @return Information about the Capacity Reservation targeting option.
     */
    public final CapacityReservationSpecification capacityReservationSpecification() {
        return capacityReservationSpecification;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceCapacityReservationAttributesRequest)) {
            return false;
        }
        ModifyInstanceCapacityReservationAttributesRequest other = (ModifyInstanceCapacityReservationAttributesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(capacityReservationSpecification(), other.capacityReservationSpecification())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyInstanceCapacityReservationAttributesRequest").add("InstanceId", instanceId())
                .add("CapacityReservationSpecification", capacityReservationSpecification()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "CapacityReservationSpecification":
            return Optional.ofNullable(clazz.cast(capacityReservationSpecification()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("CapacityReservationSpecification", CAPACITY_RESERVATION_SPECIFICATION_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceCapacityReservationAttributesRequest, T> g) {
        return obj -> g.apply((ModifyInstanceCapacityReservationAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyInstanceCapacityReservationAttributesRequest> {
        /**
         * <p>
         * The ID of the instance to be modified.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance to be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Information about the Capacity Reservation targeting option.
         * </p>
         * 
         * @param capacityReservationSpecification
         *        Information about the Capacity Reservation targeting option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationSpecification(CapacityReservationSpecification capacityReservationSpecification);

        /**
         * <p>
         * Information about the Capacity Reservation targeting option.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityReservationSpecification.Builder}
         * avoiding the need to create one manually via {@link CapacityReservationSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservationSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #capacityReservationSpecification(CapacityReservationSpecification)}.
         * 
         * @param capacityReservationSpecification
         *        a consumer that will call methods on {@link CapacityReservationSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationSpecification(CapacityReservationSpecification)
         */
        default Builder capacityReservationSpecification(
                Consumer<CapacityReservationSpecification.Builder> capacityReservationSpecification) {
            return capacityReservationSpecification(CapacityReservationSpecification.builder()
                    .applyMutation(capacityReservationSpecification).build());
        }

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String instanceId;

        private CapacityReservationSpecification capacityReservationSpecification;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceCapacityReservationAttributesRequest model) {
            super(model);
            instanceId(model.instanceId);
            capacityReservationSpecification(model.capacityReservationSpecification);
            dryRun(model.dryRun);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final CapacityReservationSpecification.Builder getCapacityReservationSpecification() {
            return capacityReservationSpecification != null ? capacityReservationSpecification.toBuilder() : null;
        }

        public final void setCapacityReservationSpecification(
                CapacityReservationSpecification.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification
                    .build() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(CapacityReservationSpecification capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceCapacityReservationAttributesRequest build() {
            return new ModifyInstanceCapacityReservationAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
