/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a new global secondary index to be added to an existing table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGlobalSecondaryIndexAction implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateGlobalSecondaryIndexAction.Builder, CreateGlobalSecondaryIndexAction> {
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndexName").getter(getter(CreateGlobalSecondaryIndexAction::indexName))
            .setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<List<KeySchemaElement>> KEY_SCHEMA_FIELD = SdkField
            .<List<KeySchemaElement>> builder(MarshallingType.LIST)
            .memberName("KeySchema")
            .getter(getter(CreateGlobalSecondaryIndexAction::keySchema))
            .setter(setter(Builder::keySchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeySchemaElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeySchemaElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Projection> PROJECTION_FIELD = SdkField.<Projection> builder(MarshallingType.SDK_POJO)
            .memberName("Projection").getter(getter(CreateGlobalSecondaryIndexAction::projection))
            .setter(setter(Builder::projection)).constructor(Projection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Projection").build()).build();

    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField
            .<ProvisionedThroughput> builder(MarshallingType.SDK_POJO).memberName("ProvisionedThroughput")
            .getter(getter(CreateGlobalSecondaryIndexAction::provisionedThroughput))
            .setter(setter(Builder::provisionedThroughput)).constructor(ProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build())
            .build();

    private static final SdkField<OnDemandThroughput> ON_DEMAND_THROUGHPUT_FIELD = SdkField
            .<OnDemandThroughput> builder(MarshallingType.SDK_POJO).memberName("OnDemandThroughput")
            .getter(getter(CreateGlobalSecondaryIndexAction::onDemandThroughput)).setter(setter(Builder::onDemandThroughput))
            .constructor(OnDemandThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandThroughput").build())
            .build();

    private static final SdkField<WarmThroughput> WARM_THROUGHPUT_FIELD = SdkField
            .<WarmThroughput> builder(MarshallingType.SDK_POJO).memberName("WarmThroughput")
            .getter(getter(CreateGlobalSecondaryIndexAction::warmThroughput)).setter(setter(Builder::warmThroughput))
            .constructor(WarmThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmThroughput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAME_FIELD,
            KEY_SCHEMA_FIELD, PROJECTION_FIELD, PROVISIONED_THROUGHPUT_FIELD, ON_DEMAND_THROUGHPUT_FIELD, WARM_THROUGHPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String indexName;

    private final List<KeySchemaElement> keySchema;

    private final Projection projection;

    private final ProvisionedThroughput provisionedThroughput;

    private final OnDemandThroughput onDemandThroughput;

    private final WarmThroughput warmThroughput;

    private CreateGlobalSecondaryIndexAction(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.keySchema = builder.keySchema;
        this.projection = builder.projection;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.onDemandThroughput = builder.onDemandThroughput;
        this.warmThroughput = builder.warmThroughput;
    }

    /**
     * <p>
     * The name of the global secondary index to be created.
     * </p>
     * 
     * @return The name of the global secondary index to be created.
     */
    public final String indexName() {
        return indexName;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeySchema property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeySchema() {
        return keySchema != null && !(keySchema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key schema for the global secondary index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeySchema} method.
     * </p>
     * 
     * @return The key schema for the global secondary index.
     */
    public final List<KeySchemaElement> keySchema() {
        return keySchema;
    }

    /**
     * <p>
     * Represents attributes that are copied (projected) from the table into an index. These are in addition to the
     * primary key attributes and index key attributes, which are automatically projected.
     * </p>
     * 
     * @return Represents attributes that are copied (projected) from the table into an index. These are in addition to
     *         the primary key attributes and index key attributes, which are automatically projected.
     */
    public final Projection projection() {
        return projection;
    }

    /**
     * <p>
     * Represents the provisioned throughput settings for the specified global secondary index.
     * </p>
     * <p>
     * For current minimum and maximum provisioned throughput values, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table
     * Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return Represents the provisioned throughput settings for the specified global secondary index.</p>
     *         <p>
     *         For current minimum and maximum provisioned throughput values, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and
     *         Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final ProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     * <p>
     * The maximum number of read and write units for the global secondary index being created. If you use this
     * parameter, you must specify <code>MaxReadRequestUnits</code>, <code>MaxWriteRequestUnits</code>, or both. You
     * must use either <code>OnDemand Throughput</code> or <code>ProvisionedThroughput</code> based on your table's
     * capacity mode.
     * </p>
     * 
     * @return The maximum number of read and write units for the global secondary index being created. If you use this
     *         parameter, you must specify <code>MaxReadRequestUnits</code>, <code>MaxWriteRequestUnits</code>, or both.
     *         You must use either <code>OnDemand Throughput</code> or <code>ProvisionedThroughput</code> based on your
     *         table's capacity mode.
     */
    public final OnDemandThroughput onDemandThroughput() {
        return onDemandThroughput;
    }

    /**
     * <p>
     * Represents the warm throughput value (in read units per second and write units per second) when creating a
     * secondary index.
     * </p>
     * 
     * @return Represents the warm throughput value (in read units per second and write units per second) when creating
     *         a secondary index.
     */
    public final WarmThroughput warmThroughput() {
        return warmThroughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeySchema() ? keySchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(projection());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(warmThroughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlobalSecondaryIndexAction)) {
            return false;
        }
        CreateGlobalSecondaryIndexAction other = (CreateGlobalSecondaryIndexAction) obj;
        return Objects.equals(indexName(), other.indexName()) && hasKeySchema() == other.hasKeySchema()
                && Objects.equals(keySchema(), other.keySchema()) && Objects.equals(projection(), other.projection())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput())
                && Objects.equals(onDemandThroughput(), other.onDemandThroughput())
                && Objects.equals(warmThroughput(), other.warmThroughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGlobalSecondaryIndexAction").add("IndexName", indexName())
                .add("KeySchema", hasKeySchema() ? keySchema() : null).add("Projection", projection())
                .add("ProvisionedThroughput", provisionedThroughput()).add("OnDemandThroughput", onDemandThroughput())
                .add("WarmThroughput", warmThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "KeySchema":
            return Optional.ofNullable(clazz.cast(keySchema()));
        case "Projection":
            return Optional.ofNullable(clazz.cast(projection()));
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        case "OnDemandThroughput":
            return Optional.ofNullable(clazz.cast(onDemandThroughput()));
        case "WarmThroughput":
            return Optional.ofNullable(clazz.cast(warmThroughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IndexName", INDEX_NAME_FIELD);
        map.put("KeySchema", KEY_SCHEMA_FIELD);
        map.put("Projection", PROJECTION_FIELD);
        map.put("ProvisionedThroughput", PROVISIONED_THROUGHPUT_FIELD);
        map.put("OnDemandThroughput", ON_DEMAND_THROUGHPUT_FIELD);
        map.put("WarmThroughput", WARM_THROUGHPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGlobalSecondaryIndexAction, T> g) {
        return obj -> g.apply((CreateGlobalSecondaryIndexAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateGlobalSecondaryIndexAction> {
        /**
         * <p>
         * The name of the global secondary index to be created.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The key schema for the global secondary index.
         * </p>
         * 
         * @param keySchema
         *        The key schema for the global secondary index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(Collection<KeySchemaElement> keySchema);

        /**
         * <p>
         * The key schema for the global secondary index.
         * </p>
         * 
         * @param keySchema
         *        The key schema for the global secondary index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(KeySchemaElement... keySchema);

        /**
         * <p>
         * The key schema for the global secondary index.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.KeySchemaElement.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.dynamodb.model.KeySchemaElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.KeySchemaElement.Builder#build()} is called immediately
         * and its result is passed to {@link #keySchema(List<KeySchemaElement>)}.
         * 
         * @param keySchema
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.KeySchemaElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keySchema(java.util.Collection<KeySchemaElement>)
         */
        Builder keySchema(Consumer<KeySchemaElement.Builder>... keySchema);

        /**
         * <p>
         * Represents attributes that are copied (projected) from the table into an index. These are in addition to the
         * primary key attributes and index key attributes, which are automatically projected.
         * </p>
         * 
         * @param projection
         *        Represents attributes that are copied (projected) from the table into an index. These are in addition
         *        to the primary key attributes and index key attributes, which are automatically projected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projection(Projection projection);

        /**
         * <p>
         * Represents attributes that are copied (projected) from the table into an index. These are in addition to the
         * primary key attributes and index key attributes, which are automatically projected.
         * </p>
         * This is a convenience method that creates an instance of the {@link Projection.Builder} avoiding the need to
         * create one manually via {@link Projection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Projection.Builder#build()} is called immediately and its result
         * is passed to {@link #projection(Projection)}.
         * 
         * @param projection
         *        a consumer that will call methods on {@link Projection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projection(Projection)
         */
        default Builder projection(Consumer<Projection.Builder> projection) {
            return projection(Projection.builder().applyMutation(projection).build());
        }

        /**
         * <p>
         * Represents the provisioned throughput settings for the specified global secondary index.
         * </p>
         * <p>
         * For current minimum and maximum provisioned throughput values, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and
         * Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param provisionedThroughput
         *        Represents the provisioned throughput settings for the specified global secondary index.</p>
         *        <p>
         *        For current minimum and maximum provisioned throughput values, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account,
         *        and Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput);

        /**
         * <p>
         * Represents the provisioned throughput settings for the specified global secondary index.
         * </p>
         * <p>
         * For current minimum and maximum provisioned throughput values, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and
         * Table Quotas</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisionedThroughput.Builder} avoiding
         * the need to create one manually via {@link ProvisionedThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionedThroughput.Builder#build()} is called immediately and
         * its result is passed to {@link #provisionedThroughput(ProvisionedThroughput)}.
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link ProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(ProvisionedThroughput)
         */
        default Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return provisionedThroughput(ProvisionedThroughput.builder().applyMutation(provisionedThroughput).build());
        }

        /**
         * <p>
         * The maximum number of read and write units for the global secondary index being created. If you use this
         * parameter, you must specify <code>MaxReadRequestUnits</code>, <code>MaxWriteRequestUnits</code>, or both. You
         * must use either <code>OnDemand Throughput</code> or <code>ProvisionedThroughput</code> based on your table's
         * capacity mode.
         * </p>
         * 
         * @param onDemandThroughput
         *        The maximum number of read and write units for the global secondary index being created. If you use
         *        this parameter, you must specify <code>MaxReadRequestUnits</code>, <code>MaxWriteRequestUnits</code>,
         *        or both. You must use either <code>OnDemand Throughput</code> or <code>ProvisionedThroughput</code>
         *        based on your table's capacity mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandThroughput(OnDemandThroughput onDemandThroughput);

        /**
         * <p>
         * The maximum number of read and write units for the global secondary index being created. If you use this
         * parameter, you must specify <code>MaxReadRequestUnits</code>, <code>MaxWriteRequestUnits</code>, or both. You
         * must use either <code>OnDemand Throughput</code> or <code>ProvisionedThroughput</code> based on your table's
         * capacity mode.
         * </p>
         * This is a convenience method that creates an instance of the {@link OnDemandThroughput.Builder} avoiding the
         * need to create one manually via {@link OnDemandThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnDemandThroughput.Builder#build()} is called immediately and its
         * result is passed to {@link #onDemandThroughput(OnDemandThroughput)}.
         * 
         * @param onDemandThroughput
         *        a consumer that will call methods on {@link OnDemandThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onDemandThroughput(OnDemandThroughput)
         */
        default Builder onDemandThroughput(Consumer<OnDemandThroughput.Builder> onDemandThroughput) {
            return onDemandThroughput(OnDemandThroughput.builder().applyMutation(onDemandThroughput).build());
        }

        /**
         * <p>
         * Represents the warm throughput value (in read units per second and write units per second) when creating a
         * secondary index.
         * </p>
         * 
         * @param warmThroughput
         *        Represents the warm throughput value (in read units per second and write units per second) when
         *        creating a secondary index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmThroughput(WarmThroughput warmThroughput);

        /**
         * <p>
         * Represents the warm throughput value (in read units per second and write units per second) when creating a
         * secondary index.
         * </p>
         * This is a convenience method that creates an instance of the {@link WarmThroughput.Builder} avoiding the need
         * to create one manually via {@link WarmThroughput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WarmThroughput.Builder#build()} is called immediately and its
         * result is passed to {@link #warmThroughput(WarmThroughput)}.
         * 
         * @param warmThroughput
         *        a consumer that will call methods on {@link WarmThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warmThroughput(WarmThroughput)
         */
        default Builder warmThroughput(Consumer<WarmThroughput.Builder> warmThroughput) {
            return warmThroughput(WarmThroughput.builder().applyMutation(warmThroughput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String indexName;

        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();

        private Projection projection;

        private ProvisionedThroughput provisionedThroughput;

        private OnDemandThroughput onDemandThroughput;

        private WarmThroughput warmThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlobalSecondaryIndexAction model) {
            indexName(model.indexName);
            keySchema(model.keySchema);
            projection(model.projection);
            provisionedThroughput(model.provisionedThroughput);
            onDemandThroughput(model.onDemandThroughput);
            warmThroughput(model.warmThroughput);
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final List<KeySchemaElement.Builder> getKeySchema() {
            List<KeySchemaElement.Builder> result = KeySchemaCopier.copyToBuilder(this.keySchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement... keySchema) {
            keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder>... keySchema) {
            keySchema(Stream.of(keySchema).map(c -> KeySchemaElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Projection.Builder getProjection() {
            return projection != null ? projection.toBuilder() : null;
        }

        public final void setProjection(Projection.BuilderImpl projection) {
            this.projection = projection != null ? projection.build() : null;
        }

        @Override
        public final Builder projection(Projection projection) {
            this.projection = projection;
            return this;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final OnDemandThroughput.Builder getOnDemandThroughput() {
            return onDemandThroughput != null ? onDemandThroughput.toBuilder() : null;
        }

        public final void setOnDemandThroughput(OnDemandThroughput.BuilderImpl onDemandThroughput) {
            this.onDemandThroughput = onDemandThroughput != null ? onDemandThroughput.build() : null;
        }

        @Override
        public final Builder onDemandThroughput(OnDemandThroughput onDemandThroughput) {
            this.onDemandThroughput = onDemandThroughput;
            return this;
        }

        public final WarmThroughput.Builder getWarmThroughput() {
            return warmThroughput != null ? warmThroughput.toBuilder() : null;
        }

        public final void setWarmThroughput(WarmThroughput.BuilderImpl warmThroughput) {
            this.warmThroughput = warmThroughput != null ? warmThroughput.build() : null;
        }

        @Override
        public final Builder warmThroughput(WarmThroughput warmThroughput) {
            this.warmThroughput = warmThroughput;
            return this;
        }

        @Override
        public CreateGlobalSecondaryIndexAction build() {
            return new CreateGlobalSecondaryIndexAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
