/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input to <a>RestoreDBClusterFromSnapshot</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreDbClusterFromSnapshotRequest extends DocDbRequest implements
        ToCopyableBuilder<RestoreDbClusterFromSnapshotRequest.Builder, RestoreDbClusterFromSnapshotRequest> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AvailabilityZone")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AvailabilityZone").build()).build()).build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(RestoreDbClusterFromSnapshotRequest::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotIdentifier").getter(getter(RestoreDbClusterFromSnapshotRequest::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(RestoreDbClusterFromSnapshotRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSubnetGroupName").getter(getter(RestoreDbClusterFromSnapshotRequest::dbSubnetGroupName))
            .setter(setter(Builder::dbSubnetGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()).build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroupIds")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("VpcSecurityGroupId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("VpcSecurityGroupId").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(RestoreDbClusterFromSnapshotRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnableCloudwatchLogsExports")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::enableCloudwatchLogsExports))
            .setter(setter(Builder::enableCloudwatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(RestoreDbClusterFromSnapshotRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterParameterGroupName")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::dbClusterParameterGroupName))
            .setter(setter(Builder::dbClusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName")
                    .build()).build();

    private static final SdkField<ServerlessV2ScalingConfiguration> SERVERLESS_V2_SCALING_CONFIGURATION_FIELD = SdkField
            .<ServerlessV2ScalingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ServerlessV2ScalingConfiguration")
            .getter(getter(RestoreDbClusterFromSnapshotRequest::serverlessV2ScalingConfiguration))
            .setter(setter(Builder::serverlessV2ScalingConfiguration))
            .constructor(ServerlessV2ScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessV2ScalingConfiguration")
                    .build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(RestoreDbClusterFromSnapshotRequest::storageType))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD,
            DB_CLUSTER_IDENTIFIER_FIELD, SNAPSHOT_IDENTIFIER_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, PORT_FIELD,
            DB_SUBNET_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD,
            ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, DELETION_PROTECTION_FIELD, DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD,
            SERVERLESS_V2_SCALING_CONFIGURATION_FIELD, STORAGE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> availabilityZones;

    private final String dbClusterIdentifier;

    private final String snapshotIdentifier;

    private final String engine;

    private final String engineVersion;

    private final Integer port;

    private final String dbSubnetGroupName;

    private final List<String> vpcSecurityGroupIds;

    private final List<Tag> tags;

    private final String kmsKeyId;

    private final List<String> enableCloudwatchLogsExports;

    private final Boolean deletionProtection;

    private final String dbClusterParameterGroupName;

    private final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;

    private final String storageType;

    private RestoreDbClusterFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.deletionProtection = builder.deletionProtection;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.serverlessV2ScalingConfiguration = builder.serverlessV2ScalingConfiguration;
        this.storageType = builder.storageType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the list of Amazon EC2 Availability Zones that instances in the restored DB cluster can be created in.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return Provides the list of Amazon EC2 Availability Zones that instances in the restored DB cluster can be
     *         created in.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The name of the cluster to create from the snapshot or cluster snapshot. This parameter isn't case sensitive.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * The first character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-snapshot-id</code>
     * </p>
     * 
     * @return The name of the cluster to create from the snapshot or cluster snapshot. This parameter isn't case
     *         sensitive.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain from 1 to 63 letters, numbers, or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The first character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-snapshot-id</code>
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * The identifier for the snapshot or cluster snapshot to restore from.
     * </p>
     * <p>
     * You can use either the name or the Amazon Resource Name (ARN) to specify a cluster snapshot. However, you can use
     * only the ARN to specify a snapshot.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing snapshot.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier for the snapshot or cluster snapshot to restore from.</p>
     *         <p>
     *         You can use either the name or the Amazon Resource Name (ARN) to specify a cluster snapshot. However, you
     *         can use only the ARN to specify a snapshot.
     *         </p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing snapshot.
     *         </p>
     *         </li>
     */
    public final String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The database engine to use for the new cluster.
     * </p>
     * <p>
     * Default: The same as source.
     * </p>
     * <p>
     * Constraint: Must be compatible with the engine of the source.
     * </p>
     * 
     * @return The database engine to use for the new cluster.</p>
     *         <p>
     *         Default: The same as source.
     *         </p>
     *         <p>
     *         Constraint: Must be compatible with the engine of the source.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The version of the database engine to use for the new cluster.
     * </p>
     * 
     * @return The version of the database engine to use for the new cluster.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The port number on which the new cluster accepts connections.
     * </p>
     * <p>
     * Constraints: Must be a value from <code>1150</code> to <code>65535</code>.
     * </p>
     * <p>
     * Default: The same port as the original cluster.
     * </p>
     * 
     * @return The port number on which the new cluster accepts connections.</p>
     *         <p>
     *         Constraints: Must be a value from <code>1150</code> to <code>65535</code>.
     *         </p>
     *         <p>
     *         Default: The same port as the original cluster.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The name of the subnet group to use for the new cluster.
     * </p>
     * <p>
     * Constraints: If provided, must match the name of an existing <code>DBSubnetGroup</code>.
     * </p>
     * <p>
     * Example: <code>mySubnetgroup</code>
     * </p>
     * 
     * @return The name of the subnet group to use for the new cluster.</p>
     *         <p>
     *         Constraints: If provided, must match the name of an existing <code>DBSubnetGroup</code>.
     *         </p>
     *         <p>
     *         Example: <code>mySubnetgroup</code>
     */
    public final String dbSubnetGroupName() {
        return dbSubnetGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of virtual private cloud (VPC) security groups that the new cluster will belong to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of virtual private cloud (VPC) security groups that the new cluster will belong to.
     */
    public final List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be assigned to the restored cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be assigned to the restored cluster.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster snapshot.
     * </p>
     * <p>
     * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a
     * cluster with the same Amazon Web Services account that owns the KMS encryption key used to encrypt the new
     * cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
     * </p>
     * <p>
     * If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the snapshot or cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored cluster is
     * encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the snapshot or the cluster snapshot in <code>SnapshotIdentifier</code> is not encrypted, then the restored DB
     * cluster is not encrypted.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster
     *         snapshot.</p>
     *         <p>
     *         The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring
     *         a cluster with the same Amazon Web Services account that owns the KMS encryption key used to encrypt the
     *         new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
     *         </p>
     *         <p>
     *         If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the snapshot or cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored
     *         cluster is encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the snapshot or the cluster snapshot in <code>SnapshotIdentifier</code> is not encrypted, then the
     *         restored DB cluster is not encrypted.
     *         </p>
     *         </li>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnableCloudwatchLogsExports property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports != null && !(enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnableCloudwatchLogsExports} method.
     * </p>
     * 
     * @return A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
     */
    public final List<String> enableCloudwatchLogsExports() {
        return enableCloudwatchLogsExports;
    }

    /**
     * <p>
     * Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster cannot
     * be deleted unless it is modified and <code>DeletionProtection</code> is disabled. <code>DeletionProtection</code>
     * protects clusters from being accidentally deleted.
     * </p>
     * 
     * @return Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster
     *         cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
     *         <code>DeletionProtection</code> protects clusters from being accidentally deleted.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The name of the DB cluster parameter group to associate with this DB cluster.
     * </p>
     * <p>
     * <i>Type:</i> String.       <i>Required:</i> No.
     * </p>
     * <p>
     * If this argument is omitted, the default DB cluster parameter group is used. If supplied, must match the name of
     * an existing default DB cluster parameter group. The string must consist of from 1 to 255 letters, numbers or
     * hyphens. Its first character must be a letter, and it cannot end with a hyphen or contain two consecutive
     * hyphens.
     * </p>
     * 
     * @return The name of the DB cluster parameter group to associate with this DB cluster.</p>
     *         <p>
     *         <i>Type:</i> String.       <i>Required:</i> No.
     *         </p>
     *         <p>
     *         If this argument is omitted, the default DB cluster parameter group is used. If supplied, must match the
     *         name of an existing default DB cluster parameter group. The string must consist of from 1 to 255 letters,
     *         numbers or hyphens. Its first character must be a letter, and it cannot end with a hyphen or contain two
     *         consecutive hyphens.
     */
    public final String dbClusterParameterGroupName() {
        return dbClusterParameterGroupName;
    }

    /**
     * <p>
     * Contains the scaling configuration of an Amazon DocumentDB Serverless cluster.
     * </p>
     * 
     * @return Contains the scaling configuration of an Amazon DocumentDB Serverless cluster.
     */
    public final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration() {
        return serverlessV2ScalingConfiguration;
    }

    /**
     * <p>
     * The storage type to associate with the DB cluster.
     * </p>
     * <p>
     * For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in the
     * <i>Amazon DocumentDB Developer Guide</i>.
     * </p>
     * <p>
     * Valid values for storage type - <code>standard | iopt1</code>
     * </p>
     * <p>
     * Default value is <code>standard </code>
     * </p>
     * 
     * @return The storage type to associate with the DB cluster.</p>
     *         <p>
     *         For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in
     *         the <i>Amazon DocumentDB Developer Guide</i>.
     *         </p>
     *         <p>
     *         Valid values for storage type - <code>standard | iopt1</code>
     *         </p>
     *         <p>
     *         Default value is <code>standard </code>
     */
    public final String storageType() {
        return storageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(serverlessV2ScalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbClusterFromSnapshotRequest)) {
            return false;
        }
        RestoreDbClusterFromSnapshotRequest other = (RestoreDbClusterFromSnapshotRequest) obj;
        return hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(port(), other.port())
                && Objects.equals(dbSubnetGroupName(), other.dbSubnetGroupName())
                && hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds()
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports()
                && Objects.equals(enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(dbClusterParameterGroupName(), other.dbClusterParameterGroupName())
                && Objects.equals(serverlessV2ScalingConfiguration(), other.serverlessV2ScalingConfiguration())
                && Objects.equals(storageType(), other.storageType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreDbClusterFromSnapshotRequest")
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("DBClusterIdentifier", dbClusterIdentifier()).add("SnapshotIdentifier", snapshotIdentifier())
                .add("Engine", engine()).add("EngineVersion", engineVersion()).add("Port", port())
                .add("DBSubnetGroupName", dbSubnetGroupName())
                .add("VpcSecurityGroupIds", hasVpcSecurityGroupIds() ? vpcSecurityGroupIds() : null)
                .add("Tags", hasTags() ? tags() : null).add("KmsKeyId", kmsKeyId())
                .add("EnableCloudwatchLogsExports", hasEnableCloudwatchLogsExports() ? enableCloudwatchLogsExports() : null)
                .add("DeletionProtection", deletionProtection())
                .add("DBClusterParameterGroupName", dbClusterParameterGroupName())
                .add("ServerlessV2ScalingConfiguration", serverlessV2ScalingConfiguration()).add("StorageType", storageType())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "DBSubnetGroupName":
            return Optional.ofNullable(clazz.cast(dbSubnetGroupName()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "EnableCloudwatchLogsExports":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogsExports()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "DBClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(dbClusterParameterGroupName()));
        case "ServerlessV2ScalingConfiguration":
            return Optional.ofNullable(clazz.cast(serverlessV2ScalingConfiguration()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("DBClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("SnapshotIdentifier", SNAPSHOT_IDENTIFIER_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("DBSubnetGroupName", DB_SUBNET_GROUP_NAME_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("EnableCloudwatchLogsExports", ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("DBClusterParameterGroupName", DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD);
        map.put("ServerlessV2ScalingConfiguration", SERVERLESS_V2_SCALING_CONFIGURATION_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreDbClusterFromSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreDbClusterFromSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DocDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, RestoreDbClusterFromSnapshotRequest> {
        /**
         * <p>
         * Provides the list of Amazon EC2 Availability Zones that instances in the restored DB cluster can be created
         * in.
         * </p>
         * 
         * @param availabilityZones
         *        Provides the list of Amazon EC2 Availability Zones that instances in the restored DB cluster can be
         *        created in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * Provides the list of Amazon EC2 Availability Zones that instances in the restored DB cluster can be created
         * in.
         * </p>
         * 
         * @param availabilityZones
         *        Provides the list of Amazon EC2 Availability Zones that instances in the restored DB cluster can be
         *        created in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The name of the cluster to create from the snapshot or cluster snapshot. This parameter isn't case sensitive.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * The first character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-snapshot-id</code>
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The name of the cluster to create from the snapshot or cluster snapshot. This parameter isn't case
         *        sensitive.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain from 1 to 63 letters, numbers, or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The first character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-snapshot-id</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * The identifier for the snapshot or cluster snapshot to restore from.
         * </p>
         * <p>
         * You can use either the name or the Amazon Resource Name (ARN) to specify a cluster snapshot. However, you can
         * use only the ARN to specify a snapshot.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing snapshot.
         * </p>
         * </li>
         * </ul>
         * 
         * @param snapshotIdentifier
         *        The identifier for the snapshot or cluster snapshot to restore from.</p>
         *        <p>
         *        You can use either the name or the Amazon Resource Name (ARN) to specify a cluster snapshot. However,
         *        you can use only the ARN to specify a snapshot.
         *        </p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing snapshot.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The database engine to use for the new cluster.
         * </p>
         * <p>
         * Default: The same as source.
         * </p>
         * <p>
         * Constraint: Must be compatible with the engine of the source.
         * </p>
         * 
         * @param engine
         *        The database engine to use for the new cluster.</p>
         *        <p>
         *        Default: The same as source.
         *        </p>
         *        <p>
         *        Constraint: Must be compatible with the engine of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version of the database engine to use for the new cluster.
         * </p>
         * 
         * @param engineVersion
         *        The version of the database engine to use for the new cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The port number on which the new cluster accepts connections.
         * </p>
         * <p>
         * Constraints: Must be a value from <code>1150</code> to <code>65535</code>.
         * </p>
         * <p>
         * Default: The same port as the original cluster.
         * </p>
         * 
         * @param port
         *        The port number on which the new cluster accepts connections.</p>
         *        <p>
         *        Constraints: Must be a value from <code>1150</code> to <code>65535</code>.
         *        </p>
         *        <p>
         *        Default: The same port as the original cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The name of the subnet group to use for the new cluster.
         * </p>
         * <p>
         * Constraints: If provided, must match the name of an existing <code>DBSubnetGroup</code>.
         * </p>
         * <p>
         * Example: <code>mySubnetgroup</code>
         * </p>
         * 
         * @param dbSubnetGroupName
         *        The name of the subnet group to use for the new cluster.</p>
         *        <p>
         *        Constraints: If provided, must match the name of an existing <code>DBSubnetGroup</code>.
         *        </p>
         *        <p>
         *        Example: <code>mySubnetgroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroupName(String dbSubnetGroupName);

        /**
         * <p>
         * A list of virtual private cloud (VPC) security groups that the new cluster will belong to.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of virtual private cloud (VPC) security groups that the new cluster will belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * A list of virtual private cloud (VPC) security groups that the new cluster will belong to.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        A list of virtual private cloud (VPC) security groups that the new cluster will belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The tags to be assigned to the restored cluster.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the restored cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be assigned to the restored cluster.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the restored cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be assigned to the restored cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.docdb.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.docdb.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.docdb.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.docdb.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster snapshot.
         * </p>
         * <p>
         * The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are restoring a
         * cluster with the same Amazon Web Services account that owns the KMS encryption key used to encrypt the new
         * cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption key.
         * </p>
         * <p>
         * If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the snapshot or cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored
         * cluster is encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the snapshot or the cluster snapshot in <code>SnapshotIdentifier</code> is not encrypted, then the
         * restored DB cluster is not encrypted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kmsKeyId
         *        The KMS key identifier to use when restoring an encrypted cluster from a DB snapshot or cluster
         *        snapshot.</p>
         *        <p>
         *        The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption key. If you are
         *        restoring a cluster with the same Amazon Web Services account that owns the KMS encryption key used to
         *        encrypt the new cluster, then you can use the KMS key alias instead of the ARN for the KMS encryption
         *        key.
         *        </p>
         *        <p>
         *        If you do not specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the snapshot or cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored
         *        cluster is encrypted using the KMS key that was used to encrypt the snapshot or the cluster snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the snapshot or the cluster snapshot in <code>SnapshotIdentifier</code> is not encrypted, then the
         *        restored DB cluster is not encrypted.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports);

        /**
         * <p>
         * A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param enableCloudwatchLogsExports
         *        A list of log types that must be enabled for exporting to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports);

        /**
         * <p>
         * Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the cluster
         * cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
         * <code>DeletionProtection</code> protects clusters from being accidentally deleted.
         * </p>
         * 
         * @param deletionProtection
         *        Specifies whether this cluster can be deleted. If <code>DeletionProtection</code> is enabled, the
         *        cluster cannot be deleted unless it is modified and <code>DeletionProtection</code> is disabled.
         *        <code>DeletionProtection</code> protects clusters from being accidentally deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The name of the DB cluster parameter group to associate with this DB cluster.
         * </p>
         * <p>
         * <i>Type:</i> String.       <i>Required:</i> No.
         * </p>
         * <p>
         * If this argument is omitted, the default DB cluster parameter group is used. If supplied, must match the name
         * of an existing default DB cluster parameter group. The string must consist of from 1 to 255 letters, numbers
         * or hyphens. Its first character must be a letter, and it cannot end with a hyphen or contain two consecutive
         * hyphens.
         * </p>
         * 
         * @param dbClusterParameterGroupName
         *        The name of the DB cluster parameter group to associate with this DB cluster.</p>
         *        <p>
         *        <i>Type:</i> String.       <i>Required:</i> No.
         *        </p>
         *        <p>
         *        If this argument is omitted, the default DB cluster parameter group is used. If supplied, must match
         *        the name of an existing default DB cluster parameter group. The string must consist of from 1 to 255
         *        letters, numbers or hyphens. Its first character must be a letter, and it cannot end with a hyphen or
         *        contain two consecutive hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterParameterGroupName(String dbClusterParameterGroupName);

        /**
         * <p>
         * Contains the scaling configuration of an Amazon DocumentDB Serverless cluster.
         * </p>
         * 
         * @param serverlessV2ScalingConfiguration
         *        Contains the scaling configuration of an Amazon DocumentDB Serverless cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration);

        /**
         * <p>
         * Contains the scaling configuration of an Amazon DocumentDB Serverless cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServerlessV2ScalingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ServerlessV2ScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerlessV2ScalingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration)}.
         * 
         * @param serverlessV2ScalingConfiguration
         *        a consumer that will call methods on {@link ServerlessV2ScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration)
         */
        default Builder serverlessV2ScalingConfiguration(
                Consumer<ServerlessV2ScalingConfiguration.Builder> serverlessV2ScalingConfiguration) {
            return serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration.builder()
                    .applyMutation(serverlessV2ScalingConfiguration).build());
        }

        /**
         * <p>
         * The storage type to associate with the DB cluster.
         * </p>
         * <p>
         * For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in the
         * <i>Amazon DocumentDB Developer Guide</i>.
         * </p>
         * <p>
         * Valid values for storage type - <code>standard | iopt1</code>
         * </p>
         * <p>
         * Default value is <code>standard </code>
         * </p>
         * 
         * @param storageType
         *        The storage type to associate with the DB cluster.</p>
         *        <p>
         *        For information on storage types for Amazon DocumentDB clusters, see Cluster storage configurations in
         *        the <i>Amazon DocumentDB Developer Guide</i>.
         *        </p>
         *        <p>
         *        Valid values for storage type - <code>standard | iopt1</code>
         *        </p>
         *        <p>
         *        Default value is <code>standard </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DocDbRequest.BuilderImpl implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private String dbClusterIdentifier;

        private String snapshotIdentifier;

        private String engine;

        private String engineVersion;

        private Integer port;

        private String dbSubnetGroupName;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private Boolean deletionProtection;

        private String dbClusterParameterGroupName;

        private ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;

        private String storageType;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbClusterFromSnapshotRequest model) {
            super(model);
            availabilityZones(model.availabilityZones);
            dbClusterIdentifier(model.dbClusterIdentifier);
            snapshotIdentifier(model.snapshotIdentifier);
            engine(model.engine);
            engineVersion(model.engineVersion);
            port(model.port);
            dbSubnetGroupName(model.dbSubnetGroupName);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            tags(model.tags);
            kmsKeyId(model.kmsKeyId);
            enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            deletionProtection(model.deletionProtection);
            dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            serverlessV2ScalingConfiguration(model.serverlessV2ScalingConfiguration);
            storageType(model.storageType);
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDbSubnetGroupName() {
            return dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enableCloudwatchLogsExports;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String... enableCloudwatchLogsExports) {
            enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final String getDbClusterParameterGroupName() {
            return dbClusterParameterGroupName;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final ServerlessV2ScalingConfiguration.Builder getServerlessV2ScalingConfiguration() {
            return serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration.toBuilder() : null;
        }

        public final void setServerlessV2ScalingConfiguration(
                ServerlessV2ScalingConfiguration.BuilderImpl serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbClusterFromSnapshotRequest build() {
            return new RestoreDbClusterFromSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
