/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>[Default policies only]</b> Specifies a destination Region for cross-Region copy actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrossRegionCopyTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<CrossRegionCopyTarget.Builder, CrossRegionCopyTarget> {
    private static final SdkField<String> TARGET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetRegion").getter(getter(CrossRegionCopyTarget::targetRegion)).setter(setter(Builder::targetRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetRegion;

    private CrossRegionCopyTarget(BuilderImpl builder) {
        this.targetRegion = builder.targetRegion;
    }

    /**
     * <p>
     * The target Region, for example <code>us-east-1</code>.
     * </p>
     * 
     * @return The target Region, for example <code>us-east-1</code>.
     */
    public final String targetRegion() {
        return targetRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossRegionCopyTarget)) {
            return false;
        }
        CrossRegionCopyTarget other = (CrossRegionCopyTarget) obj;
        return Objects.equals(targetRegion(), other.targetRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrossRegionCopyTarget").add("TargetRegion", targetRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetRegion":
            return Optional.ofNullable(clazz.cast(targetRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetRegion", TARGET_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CrossRegionCopyTarget, T> g) {
        return obj -> g.apply((CrossRegionCopyTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrossRegionCopyTarget> {
        /**
         * <p>
         * The target Region, for example <code>us-east-1</code>.
         * </p>
         * 
         * @param targetRegion
         *        The target Region, for example <code>us-east-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRegion(String targetRegion);
    }

    static final class BuilderImpl implements Builder {
        private String targetRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CrossRegionCopyTarget model) {
            targetRegion(model.targetRegion);
        }

        public final String getTargetRegion() {
            return targetRegion;
        }

        public final void setTargetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
        }

        @Override
        public final Builder targetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
            return this;
        }

        @Override
        public CrossRegionCopyTarget build() {
            return new CrossRegionCopyTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
