/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShareDirectoryRequest extends DirectoryRequest implements
        ToCopyableBuilder<ShareDirectoryRequest.Builder, ShareDirectoryRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(ShareDirectoryRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> SHARE_NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareNotes").getter(getter(ShareDirectoryRequest::shareNotes)).setter(setter(Builder::shareNotes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareNotes").build()).build();

    private static final SdkField<ShareTarget> SHARE_TARGET_FIELD = SdkField.<ShareTarget> builder(MarshallingType.SDK_POJO)
            .memberName("ShareTarget").getter(getter(ShareDirectoryRequest::shareTarget)).setter(setter(Builder::shareTarget))
            .constructor(ShareTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareTarget").build()).build();

    private static final SdkField<String> SHARE_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareMethod").getter(getter(ShareDirectoryRequest::shareMethodAsString))
            .setter(setter(Builder::shareMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            SHARE_NOTES_FIELD, SHARE_TARGET_FIELD, SHARE_METHOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final String shareNotes;

    private final ShareTarget shareTarget;

    private final String shareMethod;

    private ShareDirectoryRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.shareNotes = builder.shareNotes;
        this.shareTarget = builder.shareTarget;
        this.shareMethod = builder.shareMethod;
    }

    /**
     * <p>
     * Identifier of the Managed Microsoft AD directory that you want to share with other Amazon Web Services accounts.
     * </p>
     * 
     * @return Identifier of the Managed Microsoft AD directory that you want to share with other Amazon Web Services
     *         accounts.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * A directory share request that is sent by the directory owner to the directory consumer. The request includes a
     * typed message to help the directory consumer administrator determine whether to approve or reject the share
     * invitation.
     * </p>
     * 
     * @return A directory share request that is sent by the directory owner to the directory consumer. The request
     *         includes a typed message to help the directory consumer administrator determine whether to approve or
     *         reject the share invitation.
     */
    public final String shareNotes() {
        return shareNotes;
    }

    /**
     * <p>
     * Identifier for the directory consumer account with whom the directory is to be shared.
     * </p>
     * 
     * @return Identifier for the directory consumer account with whom the directory is to be shared.
     */
    public final ShareTarget shareTarget() {
        return shareTarget;
    }

    /**
     * <p>
     * The method used when sharing a directory to determine whether the directory should be shared within your Amazon
     * Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by sending a
     * directory sharing request (<code>HANDSHAKE</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareMethod} will
     * return {@link ShareMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareMethodAsString}.
     * </p>
     * 
     * @return The method used when sharing a directory to determine whether the directory should be shared within your
     *         Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
     *         sending a directory sharing request (<code>HANDSHAKE</code>).
     * @see ShareMethod
     */
    public final ShareMethod shareMethod() {
        return ShareMethod.fromValue(shareMethod);
    }

    /**
     * <p>
     * The method used when sharing a directory to determine whether the directory should be shared within your Amazon
     * Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by sending a
     * directory sharing request (<code>HANDSHAKE</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareMethod} will
     * return {@link ShareMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareMethodAsString}.
     * </p>
     * 
     * @return The method used when sharing a directory to determine whether the directory should be shared within your
     *         Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
     *         sending a directory sharing request (<code>HANDSHAKE</code>).
     * @see ShareMethod
     */
    public final String shareMethodAsString() {
        return shareMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(shareNotes());
        hashCode = 31 * hashCode + Objects.hashCode(shareTarget());
        hashCode = 31 * hashCode + Objects.hashCode(shareMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareDirectoryRequest)) {
            return false;
        }
        ShareDirectoryRequest other = (ShareDirectoryRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(shareNotes(), other.shareNotes())
                && Objects.equals(shareTarget(), other.shareTarget())
                && Objects.equals(shareMethodAsString(), other.shareMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShareDirectoryRequest").add("DirectoryId", directoryId())
                .add("ShareNotes", shareNotes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShareTarget", shareTarget()).add("ShareMethod", shareMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "ShareNotes":
            return Optional.ofNullable(clazz.cast(shareNotes()));
        case "ShareTarget":
            return Optional.ofNullable(clazz.cast(shareTarget()));
        case "ShareMethod":
            return Optional.ofNullable(clazz.cast(shareMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("ShareNotes", SHARE_NOTES_FIELD);
        map.put("ShareTarget", SHARE_TARGET_FIELD);
        map.put("ShareMethod", SHARE_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShareDirectoryRequest, T> g) {
        return obj -> g.apply((ShareDirectoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, ShareDirectoryRequest> {
        /**
         * <p>
         * Identifier of the Managed Microsoft AD directory that you want to share with other Amazon Web Services
         * accounts.
         * </p>
         * 
         * @param directoryId
         *        Identifier of the Managed Microsoft AD directory that you want to share with other Amazon Web Services
         *        accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * A directory share request that is sent by the directory owner to the directory consumer. The request includes
         * a typed message to help the directory consumer administrator determine whether to approve or reject the share
         * invitation.
         * </p>
         * 
         * @param shareNotes
         *        A directory share request that is sent by the directory owner to the directory consumer. The request
         *        includes a typed message to help the directory consumer administrator determine whether to approve or
         *        reject the share invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareNotes(String shareNotes);

        /**
         * <p>
         * Identifier for the directory consumer account with whom the directory is to be shared.
         * </p>
         * 
         * @param shareTarget
         *        Identifier for the directory consumer account with whom the directory is to be shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareTarget(ShareTarget shareTarget);

        /**
         * <p>
         * Identifier for the directory consumer account with whom the directory is to be shared.
         * </p>
         * This is a convenience method that creates an instance of the {@link ShareTarget.Builder} avoiding the need to
         * create one manually via {@link ShareTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ShareTarget.Builder#build()} is called immediately and its result
         * is passed to {@link #shareTarget(ShareTarget)}.
         * 
         * @param shareTarget
         *        a consumer that will call methods on {@link ShareTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shareTarget(ShareTarget)
         */
        default Builder shareTarget(Consumer<ShareTarget.Builder> shareTarget) {
            return shareTarget(ShareTarget.builder().applyMutation(shareTarget).build());
        }

        /**
         * <p>
         * The method used when sharing a directory to determine whether the directory should be shared within your
         * Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
         * sending a directory sharing request (<code>HANDSHAKE</code>).
         * </p>
         * 
         * @param shareMethod
         *        The method used when sharing a directory to determine whether the directory should be shared within
         *        your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services
         *        account by sending a directory sharing request (<code>HANDSHAKE</code>).
         * @see ShareMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareMethod
         */
        Builder shareMethod(String shareMethod);

        /**
         * <p>
         * The method used when sharing a directory to determine whether the directory should be shared within your
         * Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
         * sending a directory sharing request (<code>HANDSHAKE</code>).
         * </p>
         * 
         * @param shareMethod
         *        The method used when sharing a directory to determine whether the directory should be shared within
         *        your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services
         *        account by sending a directory sharing request (<code>HANDSHAKE</code>).
         * @see ShareMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareMethod
         */
        Builder shareMethod(ShareMethod shareMethod);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private String shareNotes;

        private ShareTarget shareTarget;

        private String shareMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareDirectoryRequest model) {
            super(model);
            directoryId(model.directoryId);
            shareNotes(model.shareNotes);
            shareTarget(model.shareTarget);
            shareMethod(model.shareMethod);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getShareNotes() {
            return shareNotes;
        }

        public final void setShareNotes(String shareNotes) {
            this.shareNotes = shareNotes;
        }

        @Override
        public final Builder shareNotes(String shareNotes) {
            this.shareNotes = shareNotes;
            return this;
        }

        public final ShareTarget.Builder getShareTarget() {
            return shareTarget != null ? shareTarget.toBuilder() : null;
        }

        public final void setShareTarget(ShareTarget.BuilderImpl shareTarget) {
            this.shareTarget = shareTarget != null ? shareTarget.build() : null;
        }

        @Override
        public final Builder shareTarget(ShareTarget shareTarget) {
            this.shareTarget = shareTarget;
            return this;
        }

        public final String getShareMethod() {
            return shareMethod;
        }

        public final void setShareMethod(String shareMethod) {
            this.shareMethod = shareMethod;
        }

        @Override
        public final Builder shareMethod(String shareMethod) {
            this.shareMethod = shareMethod;
            return this;
        }

        @Override
        public final Builder shareMethod(ShareMethod shareMethod) {
            this.shareMethod(shareMethod == null ? null : shareMethod.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ShareDirectoryRequest build() {
            return new ShareDirectoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
