/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration values for a hybrid directory update, including Amazon Web Services System Manager managed
 * node and DNS information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HybridUpdateValue implements SdkPojo, Serializable,
        ToCopyableBuilder<HybridUpdateValue.Builder, HybridUpdateValue> {
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceIds")
            .getter(getter(HybridUpdateValue::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DNS_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DnsIps")
            .getter(getter(HybridUpdateValue::dnsIps))
            .setter(setter(Builder::dnsIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_IDS_FIELD,
            DNS_IPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> instanceIds;

    private final List<String> dnsIps;

    private HybridUpdateValue(BuilderImpl builder) {
        this.instanceIds = builder.instanceIds;
        this.dnsIps = builder.dnsIps;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceIds() {
        return instanceIds != null && !(instanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the self-managed instances with SSM in the hybrid directory configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceIds} method.
     * </p>
     * 
     * @return The identifiers of the self-managed instances with SSM in the hybrid directory configuration.
     */
    public final List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the DnsIps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDnsIps() {
        return dnsIps != null && !(dnsIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP addresses of the DNS servers or domain controllers in the hybrid directory configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDnsIps} method.
     * </p>
     * 
     * @return The IP addresses of the DNS servers or domain controllers in the hybrid directory configuration.
     */
    public final List<String> dnsIps() {
        return dnsIps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceIds() ? instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDnsIps() ? dnsIps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HybridUpdateValue)) {
            return false;
        }
        HybridUpdateValue other = (HybridUpdateValue) obj;
        return hasInstanceIds() == other.hasInstanceIds() && Objects.equals(instanceIds(), other.instanceIds())
                && hasDnsIps() == other.hasDnsIps() && Objects.equals(dnsIps(), other.dnsIps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HybridUpdateValue").add("InstanceIds", hasInstanceIds() ? instanceIds() : null)
                .add("DnsIps", hasDnsIps() ? dnsIps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "DnsIps":
            return Optional.ofNullable(clazz.cast(dnsIps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceIds", INSTANCE_IDS_FIELD);
        map.put("DnsIps", DNS_IPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HybridUpdateValue, T> g) {
        return obj -> g.apply((HybridUpdateValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HybridUpdateValue> {
        /**
         * <p>
         * The identifiers of the self-managed instances with SSM in the hybrid directory configuration.
         * </p>
         * 
         * @param instanceIds
         *        The identifiers of the self-managed instances with SSM in the hybrid directory configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The identifiers of the self-managed instances with SSM in the hybrid directory configuration.
         * </p>
         * 
         * @param instanceIds
         *        The identifiers of the self-managed instances with SSM in the hybrid directory configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The IP addresses of the DNS servers or domain controllers in the hybrid directory configuration.
         * </p>
         * 
         * @param dnsIps
         *        The IP addresses of the DNS servers or domain controllers in the hybrid directory configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsIps(Collection<String> dnsIps);

        /**
         * <p>
         * The IP addresses of the DNS servers or domain controllers in the hybrid directory configuration.
         * </p>
         * 
         * @param dnsIps
         *        The IP addresses of the DNS servers or domain controllers in the hybrid directory configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsIps(String... dnsIps);
    }

    static final class BuilderImpl implements Builder {
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> dnsIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HybridUpdateValue model) {
            instanceIds(model.instanceIds);
            dnsIps(model.dnsIps);
        }

        public final Collection<String> getInstanceIds() {
            if (instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = AssessmentInstanceIdsCopier.copy(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = AssessmentInstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final Collection<String> getDnsIps() {
            if (dnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return dnsIps;
        }

        public final void setDnsIps(Collection<String> dnsIps) {
            this.dnsIps = CustomerDnsIpsCopier.copy(dnsIps);
        }

        @Override
        public final Builder dnsIps(Collection<String> dnsIps) {
            this.dnsIps = CustomerDnsIpsCopier.copy(dnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIps(String... dnsIps) {
            dnsIps(Arrays.asList(dnsIps));
            return this;
        }

        @Override
        public HybridUpdateValue build() {
            return new HybridUpdateValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
