/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the inputs for the <a>EnableCAEnrollmentPolicy</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableCaEnrollmentPolicyRequest extends DirectoryRequest implements
        ToCopyableBuilder<EnableCaEnrollmentPolicyRequest.Builder, EnableCaEnrollmentPolicyRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(EnableCaEnrollmentPolicyRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> PCA_CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PcaConnectorArn").getter(getter(EnableCaEnrollmentPolicyRequest::pcaConnectorArn))
            .setter(setter(Builder::pcaConnectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PcaConnectorArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            PCA_CONNECTOR_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final String pcaConnectorArn;

    private EnableCaEnrollmentPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.pcaConnectorArn = builder.pcaConnectorArn;
    }

    /**
     * <p>
     * The identifier of the directory for which to enable the CA enrollment policy.
     * </p>
     * 
     * @return The identifier of the directory for which to enable the CA enrollment policy.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Private Certificate Authority (PCA) connector to use for automatic
     * certificate enrollment. This connector must be properly configured and accessible from the directory.
     * </p>
     * <p>
     * The ARN format is:
     * <code>arn:aws:pca-connector-ad:<i>region</i>:<i>account-id</i>:connector/<i>connector-id</i> </code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Private Certificate Authority (PCA) connector to use for automatic
     *         certificate enrollment. This connector must be properly configured and accessible from the directory.</p>
     *         <p>
     *         The ARN format is:
     *         <code>arn:aws:pca-connector-ad:<i>region</i>:<i>account-id</i>:connector/<i>connector-id</i> </code>
     */
    public final String pcaConnectorArn() {
        return pcaConnectorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(pcaConnectorArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableCaEnrollmentPolicyRequest)) {
            return false;
        }
        EnableCaEnrollmentPolicyRequest other = (EnableCaEnrollmentPolicyRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(pcaConnectorArn(), other.pcaConnectorArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableCaEnrollmentPolicyRequest").add("DirectoryId", directoryId())
                .add("PcaConnectorArn", pcaConnectorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "PcaConnectorArn":
            return Optional.ofNullable(clazz.cast(pcaConnectorArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("PcaConnectorArn", PCA_CONNECTOR_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableCaEnrollmentPolicyRequest, T> g) {
        return obj -> g.apply((EnableCaEnrollmentPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, EnableCaEnrollmentPolicyRequest> {
        /**
         * <p>
         * The identifier of the directory for which to enable the CA enrollment policy.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory for which to enable the CA enrollment policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Private Certificate Authority (PCA) connector to use for automatic
         * certificate enrollment. This connector must be properly configured and accessible from the directory.
         * </p>
         * <p>
         * The ARN format is:
         * <code>arn:aws:pca-connector-ad:<i>region</i>:<i>account-id</i>:connector/<i>connector-id</i> </code>
         * </p>
         * 
         * @param pcaConnectorArn
         *        The Amazon Resource Name (ARN) of the Private Certificate Authority (PCA) connector to use for
         *        automatic certificate enrollment. This connector must be properly configured and accessible from the
         *        directory.</p>
         *        <p>
         *        The ARN format is:
         *        <code>arn:aws:pca-connector-ad:<i>region</i>:<i>account-id</i>:connector/<i>connector-id</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pcaConnectorArn(String pcaConnectorArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private String pcaConnectorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableCaEnrollmentPolicyRequest model) {
            super(model);
            directoryId(model.directoryId);
            pcaConnectorArn(model.pcaConnectorArn);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getPcaConnectorArn() {
            return pcaConnectorArn;
        }

        public final void setPcaConnectorArn(String pcaConnectorArn) {
            this.pcaConnectorArn = pcaConnectorArn;
        }

        @Override
        public final Builder pcaConnectorArn(String pcaConnectorArn) {
            this.pcaConnectorArn = pcaConnectorArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableCaEnrollmentPolicyRequest build() {
            return new EnableCaEnrollmentPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
