/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAdAssessmentResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeAdAssessmentResponse.Builder, DescribeAdAssessmentResponse> {
    private static final SdkField<Assessment> ASSESSMENT_FIELD = SdkField.<Assessment> builder(MarshallingType.SDK_POJO)
            .memberName("Assessment").getter(getter(DescribeAdAssessmentResponse::assessment))
            .setter(setter(Builder::assessment)).constructor(Assessment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assessment").build()).build();

    private static final SdkField<List<AssessmentReport>> ASSESSMENT_REPORTS_FIELD = SdkField
            .<List<AssessmentReport>> builder(MarshallingType.LIST)
            .memberName("AssessmentReports")
            .getter(getter(DescribeAdAssessmentResponse::assessmentReports))
            .setter(setter(Builder::assessmentReports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentReports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssessmentReport> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssessmentReport::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_FIELD,
            ASSESSMENT_REPORTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Assessment assessment;

    private final List<AssessmentReport> assessmentReports;

    private DescribeAdAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.assessment = builder.assessment;
        this.assessmentReports = builder.assessmentReports;
    }

    /**
     * <p>
     * Detailed information about the self-managed instance settings (IDs and DNS IPs).
     * </p>
     * 
     * @return Detailed information about the self-managed instance settings (IDs and DNS IPs).
     */
    public final Assessment assessment() {
        return assessment;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssessmentReports property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssessmentReports() {
        return assessmentReports != null && !(assessmentReports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of assessment reports containing validation results for each domain controller and test category. Each
     * report includes specific validation details and outcomes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssessmentReports} method.
     * </p>
     * 
     * @return A list of assessment reports containing validation results for each domain controller and test category.
     *         Each report includes specific validation details and outcomes.
     */
    public final List<AssessmentReport> assessmentReports() {
        return assessmentReports;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessment());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssessmentReports() ? assessmentReports() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAdAssessmentResponse)) {
            return false;
        }
        DescribeAdAssessmentResponse other = (DescribeAdAssessmentResponse) obj;
        return Objects.equals(assessment(), other.assessment()) && hasAssessmentReports() == other.hasAssessmentReports()
                && Objects.equals(assessmentReports(), other.assessmentReports());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAdAssessmentResponse").add("Assessment", assessment())
                .add("AssessmentReports", hasAssessmentReports() ? assessmentReports() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Assessment":
            return Optional.ofNullable(clazz.cast(assessment()));
        case "AssessmentReports":
            return Optional.ofNullable(clazz.cast(assessmentReports()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Assessment", ASSESSMENT_FIELD);
        map.put("AssessmentReports", ASSESSMENT_REPORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAdAssessmentResponse, T> g) {
        return obj -> g.apply((DescribeAdAssessmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAdAssessmentResponse> {
        /**
         * <p>
         * Detailed information about the self-managed instance settings (IDs and DNS IPs).
         * </p>
         * 
         * @param assessment
         *        Detailed information about the self-managed instance settings (IDs and DNS IPs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessment(Assessment assessment);

        /**
         * <p>
         * Detailed information about the self-managed instance settings (IDs and DNS IPs).
         * </p>
         * This is a convenience method that creates an instance of the {@link Assessment.Builder} avoiding the need to
         * create one manually via {@link Assessment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Assessment.Builder#build()} is called immediately and its result
         * is passed to {@link #assessment(Assessment)}.
         * 
         * @param assessment
         *        a consumer that will call methods on {@link Assessment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessment(Assessment)
         */
        default Builder assessment(Consumer<Assessment.Builder> assessment) {
            return assessment(Assessment.builder().applyMutation(assessment).build());
        }

        /**
         * <p>
         * A list of assessment reports containing validation results for each domain controller and test category. Each
         * report includes specific validation details and outcomes.
         * </p>
         * 
         * @param assessmentReports
         *        A list of assessment reports containing validation results for each domain controller and test
         *        category. Each report includes specific validation details and outcomes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReports(Collection<AssessmentReport> assessmentReports);

        /**
         * <p>
         * A list of assessment reports containing validation results for each domain controller and test category. Each
         * report includes specific validation details and outcomes.
         * </p>
         * 
         * @param assessmentReports
         *        A list of assessment reports containing validation results for each domain controller and test
         *        category. Each report includes specific validation details and outcomes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReports(AssessmentReport... assessmentReports);

        /**
         * <p>
         * A list of assessment reports containing validation results for each domain controller and test category. Each
         * report includes specific validation details and outcomes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directory.model.AssessmentReport.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.directory.model.AssessmentReport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directory.model.AssessmentReport.Builder#build()} is called
         * immediately and its result is passed to {@link #assessmentReports(List<AssessmentReport>)}.
         * 
         * @param assessmentReports
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directory.model.AssessmentReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentReports(java.util.Collection<AssessmentReport>)
         */
        Builder assessmentReports(Consumer<AssessmentReport.Builder>... assessmentReports);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private Assessment assessment;

        private List<AssessmentReport> assessmentReports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAdAssessmentResponse model) {
            super(model);
            assessment(model.assessment);
            assessmentReports(model.assessmentReports);
        }

        public final Assessment.Builder getAssessment() {
            return assessment != null ? assessment.toBuilder() : null;
        }

        public final void setAssessment(Assessment.BuilderImpl assessment) {
            this.assessment = assessment != null ? assessment.build() : null;
        }

        @Override
        public final Builder assessment(Assessment assessment) {
            this.assessment = assessment;
            return this;
        }

        public final List<AssessmentReport.Builder> getAssessmentReports() {
            List<AssessmentReport.Builder> result = AssessmentReportsCopier.copyToBuilder(this.assessmentReports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessmentReports(Collection<AssessmentReport.BuilderImpl> assessmentReports) {
            this.assessmentReports = AssessmentReportsCopier.copyFromBuilder(assessmentReports);
        }

        @Override
        public final Builder assessmentReports(Collection<AssessmentReport> assessmentReports) {
            this.assessmentReports = AssessmentReportsCopier.copy(assessmentReports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentReports(AssessmentReport... assessmentReports) {
            assessmentReports(Arrays.asList(assessmentReports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentReports(Consumer<AssessmentReport.Builder>... assessmentReports) {
            assessmentReports(Stream.of(assessmentReports).map(c -> AssessmentReport.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAdAssessmentResponse build() {
            return new DescribeAdAssessmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
