/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Deletes the local side of an existing trust relationship between the Managed Microsoft AD directory and the external
 * domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTrustRequest extends DirectoryRequest implements
        ToCopyableBuilder<DeleteTrustRequest.Builder, DeleteTrustRequest> {
    private static final SdkField<String> TRUST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrustId").getter(getter(DeleteTrustRequest::trustId)).setter(setter(Builder::trustId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustId").build()).build();

    private static final SdkField<Boolean> DELETE_ASSOCIATED_CONDITIONAL_FORWARDER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteAssociatedConditionalForwarder")
            .getter(getter(DeleteTrustRequest::deleteAssociatedConditionalForwarder))
            .setter(setter(Builder::deleteAssociatedConditionalForwarder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DeleteAssociatedConditionalForwarder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_ID_FIELD,
            DELETE_ASSOCIATED_CONDITIONAL_FORWARDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trustId;

    private final Boolean deleteAssociatedConditionalForwarder;

    private DeleteTrustRequest(BuilderImpl builder) {
        super(builder);
        this.trustId = builder.trustId;
        this.deleteAssociatedConditionalForwarder = builder.deleteAssociatedConditionalForwarder;
    }

    /**
     * <p>
     * The Trust ID of the trust relationship to be deleted.
     * </p>
     * 
     * @return The Trust ID of the trust relationship to be deleted.
     */
    public final String trustId() {
        return trustId;
    }

    /**
     * <p>
     * Delete a conditional forwarder as part of a DeleteTrustRequest.
     * </p>
     * 
     * @return Delete a conditional forwarder as part of a DeleteTrustRequest.
     */
    public final Boolean deleteAssociatedConditionalForwarder() {
        return deleteAssociatedConditionalForwarder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trustId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAssociatedConditionalForwarder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTrustRequest)) {
            return false;
        }
        DeleteTrustRequest other = (DeleteTrustRequest) obj;
        return Objects.equals(trustId(), other.trustId())
                && Objects.equals(deleteAssociatedConditionalForwarder(), other.deleteAssociatedConditionalForwarder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteTrustRequest").add("TrustId", trustId())
                .add("DeleteAssociatedConditionalForwarder", deleteAssociatedConditionalForwarder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustId":
            return Optional.ofNullable(clazz.cast(trustId()));
        case "DeleteAssociatedConditionalForwarder":
            return Optional.ofNullable(clazz.cast(deleteAssociatedConditionalForwarder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrustId", TRUST_ID_FIELD);
        map.put("DeleteAssociatedConditionalForwarder", DELETE_ASSOCIATED_CONDITIONAL_FORWARDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteTrustRequest, T> g) {
        return obj -> g.apply((DeleteTrustRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteTrustRequest> {
        /**
         * <p>
         * The Trust ID of the trust relationship to be deleted.
         * </p>
         * 
         * @param trustId
         *        The Trust ID of the trust relationship to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustId(String trustId);

        /**
         * <p>
         * Delete a conditional forwarder as part of a DeleteTrustRequest.
         * </p>
         * 
         * @param deleteAssociatedConditionalForwarder
         *        Delete a conditional forwarder as part of a DeleteTrustRequest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAssociatedConditionalForwarder(Boolean deleteAssociatedConditionalForwarder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String trustId;

        private Boolean deleteAssociatedConditionalForwarder;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTrustRequest model) {
            super(model);
            trustId(model.trustId);
            deleteAssociatedConditionalForwarder(model.deleteAssociatedConditionalForwarder);
        }

        public final String getTrustId() {
            return trustId;
        }

        public final void setTrustId(String trustId) {
            this.trustId = trustId;
        }

        @Override
        public final Builder trustId(String trustId) {
            this.trustId = trustId;
            return this;
        }

        public final Boolean getDeleteAssociatedConditionalForwarder() {
            return deleteAssociatedConditionalForwarder;
        }

        public final void setDeleteAssociatedConditionalForwarder(Boolean deleteAssociatedConditionalForwarder) {
            this.deleteAssociatedConditionalForwarder = deleteAssociatedConditionalForwarder;
        }

        @Override
        public final Builder deleteAssociatedConditionalForwarder(Boolean deleteAssociatedConditionalForwarder) {
            this.deleteAssociatedConditionalForwarder = deleteAssociatedConditionalForwarder;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTrustRequest build() {
            return new DeleteTrustRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
