/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a specific validation test performed during a directory assessment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentValidation implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentValidation.Builder, AssessmentValidation> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(AssessmentValidation::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AssessmentValidation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AssessmentValidation::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCode").getter(getter(AssessmentValidation::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(AssessmentValidation::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(AssessmentValidation::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateDateTime").getter(getter(AssessmentValidation::lastUpdateDateTime))
            .setter(setter(Builder::lastUpdateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, NAME_FIELD,
            STATUS_FIELD, STATUS_CODE_FIELD, STATUS_REASON_FIELD, START_TIME_FIELD, LAST_UPDATE_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String category;

    private final String name;

    private final String status;

    private final String statusCode;

    private final String statusReason;

    private final Instant startTime;

    private final Instant lastUpdateDateTime;

    private AssessmentValidation(BuilderImpl builder) {
        this.category = builder.category;
        this.name = builder.name;
        this.status = builder.status;
        this.statusCode = builder.statusCode;
        this.statusReason = builder.statusReason;
        this.startTime = builder.startTime;
        this.lastUpdateDateTime = builder.lastUpdateDateTime;
    }

    /**
     * <p>
     * The category of the validation test.
     * </p>
     * 
     * @return The category of the validation test.
     */
    public final String category() {
        return category;
    }

    /**
     * <p>
     * The name of the specific validation test performed within the category.
     * </p>
     * 
     * @return The name of the specific validation test performed within the category.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The result status of the validation test. Valid values include <code>SUCCESS</code>, <code>FAILED</code>,
     * <code>PENDING</code>, and <code>IN_PROGRESS</code>.
     * </p>
     * 
     * @return The result status of the validation test. Valid values include <code>SUCCESS</code>, <code>FAILED</code>,
     *         <code>PENDING</code>, and <code>IN_PROGRESS</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * A detailed status code providing additional information about the validation result.
     * </p>
     * 
     * @return A detailed status code providing additional information about the validation result.
     */
    public final String statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * A human-readable description of the validation result, including any error details or recommendations.
     * </p>
     * 
     * @return A human-readable description of the validation result, including any error details or recommendations.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The date and time when the validation test was started.
     * </p>
     * 
     * @return The date and time when the validation test was started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time when the validation test was completed or last updated.
     * </p>
     * 
     * @return The date and time when the validation test was completed or last updated.
     */
    public final Instant lastUpdateDateTime() {
        return lastUpdateDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentValidation)) {
            return false;
        }
        AssessmentValidation other = (AssessmentValidation) obj;
        return Objects.equals(category(), other.category()) && Objects.equals(name(), other.name())
                && Objects.equals(status(), other.status()) && Objects.equals(statusCode(), other.statusCode())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(lastUpdateDateTime(), other.lastUpdateDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssessmentValidation").add("Category", category()).add("Name", name()).add("Status", status())
                .add("StatusCode", statusCode()).add("StatusReason", statusReason()).add("StartTime", startTime())
                .add("LastUpdateDateTime", lastUpdateDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "LastUpdateDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Category", CATEGORY_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("LastUpdateDateTime", LAST_UPDATE_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssessmentValidation, T> g) {
        return obj -> g.apply((AssessmentValidation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentValidation> {
        /**
         * <p>
         * The category of the validation test.
         * </p>
         * 
         * @param category
         *        The category of the validation test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * <p>
         * The name of the specific validation test performed within the category.
         * </p>
         * 
         * @param name
         *        The name of the specific validation test performed within the category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The result status of the validation test. Valid values include <code>SUCCESS</code>, <code>FAILED</code>,
         * <code>PENDING</code>, and <code>IN_PROGRESS</code>.
         * </p>
         * 
         * @param status
         *        The result status of the validation test. Valid values include <code>SUCCESS</code>,
         *        <code>FAILED</code>, <code>PENDING</code>, and <code>IN_PROGRESS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A detailed status code providing additional information about the validation result.
         * </p>
         * 
         * @param statusCode
         *        A detailed status code providing additional information about the validation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * A human-readable description of the validation result, including any error details or recommendations.
         * </p>
         * 
         * @param statusReason
         *        A human-readable description of the validation result, including any error details or recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The date and time when the validation test was started.
         * </p>
         * 
         * @param startTime
         *        The date and time when the validation test was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time when the validation test was completed or last updated.
         * </p>
         * 
         * @param lastUpdateDateTime
         *        The date and time when the validation test was completed or last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDateTime(Instant lastUpdateDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String category;

        private String name;

        private String status;

        private String statusCode;

        private String statusReason;

        private Instant startTime;

        private Instant lastUpdateDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentValidation model) {
            category(model.category);
            name(model.name);
            status(model.status);
            statusCode(model.statusCode);
            statusReason(model.statusReason);
            startTime(model.startTime);
            lastUpdateDateTime(model.lastUpdateDateTime);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLastUpdateDateTime() {
            return lastUpdateDateTime;
        }

        public final void setLastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
        }

        @Override
        public final Builder lastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            return this;
        }

        @Override
        public AssessmentValidation build() {
            return new AssessmentValidation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
