/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration parameters required to perform a directory assessment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentConfiguration.Builder, AssessmentConfiguration> {
    private static final SdkField<List<String>> CUSTOMER_DNS_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CustomerDnsIps")
            .getter(getter(AssessmentConfiguration::customerDnsIps))
            .setter(setter(Builder::customerDnsIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerDnsIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DnsName").getter(getter(AssessmentConfiguration::dnsName)).setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()).build();

    private static final SdkField<DirectoryVpcSettings> VPC_SETTINGS_FIELD = SdkField
            .<DirectoryVpcSettings> builder(MarshallingType.SDK_POJO).memberName("VpcSettings")
            .getter(getter(AssessmentConfiguration::vpcSettings)).setter(setter(Builder::vpcSettings))
            .constructor(DirectoryVpcSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSettings").build()).build();

    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceIds")
            .getter(getter(AssessmentConfiguration::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(AssessmentConfiguration::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_DNS_IPS_FIELD,
            DNS_NAME_FIELD, VPC_SETTINGS_FIELD, INSTANCE_IDS_FIELD, SECURITY_GROUP_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> customerDnsIps;

    private final String dnsName;

    private final DirectoryVpcSettings vpcSettings;

    private final List<String> instanceIds;

    private final List<String> securityGroupIds;

    private AssessmentConfiguration(BuilderImpl builder) {
        this.customerDnsIps = builder.customerDnsIps;
        this.dnsName = builder.dnsName;
        this.vpcSettings = builder.vpcSettings;
        this.instanceIds = builder.instanceIds;
        this.securityGroupIds = builder.securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomerDnsIps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomerDnsIps() {
        return customerDnsIps != null && !(customerDnsIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IP addresses for the DNS servers or domain controllers in your self-managed AD that are tested during
     * the assessment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomerDnsIps} method.
     * </p>
     * 
     * @return A list of IP addresses for the DNS servers or domain controllers in your self-managed AD that are tested
     *         during the assessment.
     */
    public final List<String> customerDnsIps() {
        return customerDnsIps;
    }

    /**
     * <p>
     * The fully qualified domain name (FQDN) of the self-managed AD domain to assess.
     * </p>
     * 
     * @return The fully qualified domain name (FQDN) of the self-managed AD domain to assess.
     */
    public final String dnsName() {
        return dnsName;
    }

    /**
     * Returns the value of the VpcSettings property for this object.
     * 
     * @return The value of the VpcSettings property for this object.
     */
    public final DirectoryVpcSettings vpcSettings() {
        return vpcSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceIds() {
        return instanceIds != null && !(instanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the self-managed instances with SSM that are used to perform connectivity and validation
     * tests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceIds} method.
     * </p>
     * 
     * @return The identifiers of the self-managed instances with SSM that are used to perform connectivity and
     *         validation tests.
     */
    public final List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * By default, the service attaches a security group to allow network access to the self-managed nodes in your
     * Amazon VPC. You can optionally supply your own security group that allows network traffic to and from your
     * self-managed domain controllers outside of your Amazon VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return By default, the service attaches a security group to allow network access to the self-managed nodes in
     *         your Amazon VPC. You can optionally supply your own security group that allows network traffic to and
     *         from your self-managed domain controllers outside of your Amazon VPC.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomerDnsIps() ? customerDnsIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceIds() ? instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentConfiguration)) {
            return false;
        }
        AssessmentConfiguration other = (AssessmentConfiguration) obj;
        return hasCustomerDnsIps() == other.hasCustomerDnsIps() && Objects.equals(customerDnsIps(), other.customerDnsIps())
                && Objects.equals(dnsName(), other.dnsName()) && Objects.equals(vpcSettings(), other.vpcSettings())
                && hasInstanceIds() == other.hasInstanceIds() && Objects.equals(instanceIds(), other.instanceIds())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssessmentConfiguration").add("CustomerDnsIps", hasCustomerDnsIps() ? customerDnsIps() : null)
                .add("DnsName", dnsName()).add("VpcSettings", vpcSettings())
                .add("InstanceIds", hasInstanceIds() ? instanceIds() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerDnsIps":
            return Optional.ofNullable(clazz.cast(customerDnsIps()));
        case "DnsName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "VpcSettings":
            return Optional.ofNullable(clazz.cast(vpcSettings()));
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomerDnsIps", CUSTOMER_DNS_IPS_FIELD);
        map.put("DnsName", DNS_NAME_FIELD);
        map.put("VpcSettings", VPC_SETTINGS_FIELD);
        map.put("InstanceIds", INSTANCE_IDS_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssessmentConfiguration, T> g) {
        return obj -> g.apply((AssessmentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentConfiguration> {
        /**
         * <p>
         * A list of IP addresses for the DNS servers or domain controllers in your self-managed AD that are tested
         * during the assessment.
         * </p>
         * 
         * @param customerDnsIps
         *        A list of IP addresses for the DNS servers or domain controllers in your self-managed AD that are
         *        tested during the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerDnsIps(Collection<String> customerDnsIps);

        /**
         * <p>
         * A list of IP addresses for the DNS servers or domain controllers in your self-managed AD that are tested
         * during the assessment.
         * </p>
         * 
         * @param customerDnsIps
         *        A list of IP addresses for the DNS servers or domain controllers in your self-managed AD that are
         *        tested during the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerDnsIps(String... customerDnsIps);

        /**
         * <p>
         * The fully qualified domain name (FQDN) of the self-managed AD domain to assess.
         * </p>
         * 
         * @param dnsName
         *        The fully qualified domain name (FQDN) of the self-managed AD domain to assess.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * Sets the value of the VpcSettings property for this object.
         *
         * @param vpcSettings
         *        The new value for the VpcSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSettings(DirectoryVpcSettings vpcSettings);

        /**
         * Sets the value of the VpcSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DirectoryVpcSettings.Builder} avoiding
         * the need to create one manually via {@link DirectoryVpcSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectoryVpcSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcSettings(DirectoryVpcSettings)}.
         * 
         * @param vpcSettings
         *        a consumer that will call methods on {@link DirectoryVpcSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSettings(DirectoryVpcSettings)
         */
        default Builder vpcSettings(Consumer<DirectoryVpcSettings.Builder> vpcSettings) {
            return vpcSettings(DirectoryVpcSettings.builder().applyMutation(vpcSettings).build());
        }

        /**
         * <p>
         * The identifiers of the self-managed instances with SSM that are used to perform connectivity and validation
         * tests.
         * </p>
         * 
         * @param instanceIds
         *        The identifiers of the self-managed instances with SSM that are used to perform connectivity and
         *        validation tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The identifiers of the self-managed instances with SSM that are used to perform connectivity and validation
         * tests.
         * </p>
         * 
         * @param instanceIds
         *        The identifiers of the self-managed instances with SSM that are used to perform connectivity and
         *        validation tests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * By default, the service attaches a security group to allow network access to the self-managed nodes in your
         * Amazon VPC. You can optionally supply your own security group that allows network traffic to and from your
         * self-managed domain controllers outside of your Amazon VPC.
         * </p>
         * 
         * @param securityGroupIds
         *        By default, the service attaches a security group to allow network access to the self-managed nodes in
         *        your Amazon VPC. You can optionally supply your own security group that allows network traffic to and
         *        from your self-managed domain controllers outside of your Amazon VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * By default, the service attaches a security group to allow network access to the self-managed nodes in your
         * Amazon VPC. You can optionally supply your own security group that allows network traffic to and from your
         * self-managed domain controllers outside of your Amazon VPC.
         * </p>
         * 
         * @param securityGroupIds
         *        By default, the service attaches a security group to allow network access to the self-managed nodes in
         *        your Amazon VPC. You can optionally supply your own security group that allows network traffic to and
         *        from your self-managed domain controllers outside of your Amazon VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> customerDnsIps = DefaultSdkAutoConstructList.getInstance();

        private String dnsName;

        private DirectoryVpcSettings vpcSettings;

        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentConfiguration model) {
            customerDnsIps(model.customerDnsIps);
            dnsName(model.dnsName);
            vpcSettings(model.vpcSettings);
            instanceIds(model.instanceIds);
            securityGroupIds(model.securityGroupIds);
        }

        public final Collection<String> getCustomerDnsIps() {
            if (customerDnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return customerDnsIps;
        }

        public final void setCustomerDnsIps(Collection<String> customerDnsIps) {
            this.customerDnsIps = CustomerDnsIpsCopier.copy(customerDnsIps);
        }

        @Override
        public final Builder customerDnsIps(Collection<String> customerDnsIps) {
            this.customerDnsIps = CustomerDnsIpsCopier.copy(customerDnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerDnsIps(String... customerDnsIps) {
            customerDnsIps(Arrays.asList(customerDnsIps));
            return this;
        }

        public final String getDnsName() {
            return dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final DirectoryVpcSettings.Builder getVpcSettings() {
            return vpcSettings != null ? vpcSettings.toBuilder() : null;
        }

        public final void setVpcSettings(DirectoryVpcSettings.BuilderImpl vpcSettings) {
            this.vpcSettings = vpcSettings != null ? vpcSettings.build() : null;
        }

        @Override
        public final Builder vpcSettings(DirectoryVpcSettings vpcSettings) {
            this.vpcSettings = vpcSettings;
            return this;
        }

        public final Collection<String> getInstanceIds() {
            if (instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = AssessmentInstanceIdsCopier.copy(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = AssessmentInstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        @Override
        public AssessmentConfiguration build() {
            return new AssessmentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
