/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddRegionRequest extends DirectoryRequest implements
        ToCopyableBuilder<AddRegionRequest.Builder, AddRegionRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(AddRegionRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(AddRegionRequest::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<DirectoryVpcSettings> VPC_SETTINGS_FIELD = SdkField
            .<DirectoryVpcSettings> builder(MarshallingType.SDK_POJO).memberName("VPCSettings")
            .getter(getter(AddRegionRequest::vpcSettings)).setter(setter(Builder::vpcSettings))
            .constructor(DirectoryVpcSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            REGION_NAME_FIELD, VPC_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final String regionName;

    private final DirectoryVpcSettings vpcSettings;

    private AddRegionRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.regionName = builder.regionName;
        this.vpcSettings = builder.vpcSettings;
    }

    /**
     * <p>
     * The identifier of the directory to which you want to add Region replication.
     * </p>
     * 
     * @return The identifier of the directory to which you want to add Region replication.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The name of the Region where you want to add domain controllers for replication. For example,
     * <code>us-east-1</code>.
     * </p>
     * 
     * @return The name of the Region where you want to add domain controllers for replication. For example,
     *         <code>us-east-1</code>.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * Returns the value of the VPCSettings property for this object.
     * 
     * @return The value of the VPCSettings property for this object.
     */
    public final DirectoryVpcSettings vpcSettings() {
        return vpcSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddRegionRequest)) {
            return false;
        }
        AddRegionRequest other = (AddRegionRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(regionName(), other.regionName())
                && Objects.equals(vpcSettings(), other.vpcSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddRegionRequest").add("DirectoryId", directoryId()).add("RegionName", regionName())
                .add("VPCSettings", vpcSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "VPCSettings":
            return Optional.ofNullable(clazz.cast(vpcSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("RegionName", REGION_NAME_FIELD);
        map.put("VPCSettings", VPC_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddRegionRequest, T> g) {
        return obj -> g.apply((AddRegionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddRegionRequest> {
        /**
         * <p>
         * The identifier of the directory to which you want to add Region replication.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory to which you want to add Region replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The name of the Region where you want to add domain controllers for replication. For example,
         * <code>us-east-1</code>.
         * </p>
         * 
         * @param regionName
         *        The name of the Region where you want to add domain controllers for replication. For example,
         *        <code>us-east-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * Sets the value of the VPCSettings property for this object.
         *
         * @param vpcSettings
         *        The new value for the VPCSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSettings(DirectoryVpcSettings vpcSettings);

        /**
         * Sets the value of the VPCSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DirectoryVpcSettings.Builder} avoiding
         * the need to create one manually via {@link DirectoryVpcSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectoryVpcSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcSettings(DirectoryVpcSettings)}.
         * 
         * @param vpcSettings
         *        a consumer that will call methods on {@link DirectoryVpcSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSettings(DirectoryVpcSettings)
         */
        default Builder vpcSettings(Consumer<DirectoryVpcSettings.Builder> vpcSettings) {
            return vpcSettings(DirectoryVpcSettings.builder().applyMutation(vpcSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private String regionName;

        private DirectoryVpcSettings vpcSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AddRegionRequest model) {
            super(model);
            directoryId(model.directoryId);
            regionName(model.regionName);
            vpcSettings(model.vpcSettings);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final DirectoryVpcSettings.Builder getVpcSettings() {
            return vpcSettings != null ? vpcSettings.toBuilder() : null;
        }

        public final void setVpcSettings(DirectoryVpcSettings.BuilderImpl vpcSettings) {
            this.vpcSettings = vpcSettings != null ? vpcSettings.build() : null;
        }

        @Override
        public final Builder vpcSettings(DirectoryVpcSettings vpcSettings) {
            this.vpcSettings = vpcSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddRegionRequest build() {
            return new AddRegionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
