/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.directory.internal.DirectoryServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.directory.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.AccessDeniedException;
import software.amazon.awssdk.services.directory.model.AdAssessmentLimitExceededException;
import software.amazon.awssdk.services.directory.model.AddIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.AddIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.AddRegionRequest;
import software.amazon.awssdk.services.directory.model.AddRegionResponse;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.directory.model.AuthenticationFailedException;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.CertificateAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.CertificateDoesNotExistException;
import software.amazon.awssdk.services.directory.model.CertificateInUseException;
import software.amazon.awssdk.services.directory.model.CertificateLimitExceededException;
import software.amazon.awssdk.services.directory.model.ClientException;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateAliasRequest;
import software.amazon.awssdk.services.directory.model.CreateAliasResponse;
import software.amazon.awssdk.services.directory.model.CreateComputerRequest;
import software.amazon.awssdk.services.directory.model.CreateComputerResponse;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.CreateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.CreateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateHybridAdRequest;
import software.amazon.awssdk.services.directory.model.CreateHybridAdResponse;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdRequest;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdResponse;
import software.amazon.awssdk.services.directory.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.directory.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.directory.model.CreateTrustRequest;
import software.amazon.awssdk.services.directory.model.CreateTrustResponse;
import software.amazon.awssdk.services.directory.model.DeleteAdAssessmentRequest;
import software.amazon.awssdk.services.directory.model.DeleteAdAssessmentResponse;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.directory.model.DeleteTrustRequest;
import software.amazon.awssdk.services.directory.model.DeleteTrustResponse;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.DescribeAdAssessmentRequest;
import software.amazon.awssdk.services.directory.model.DescribeAdAssessmentResponse;
import software.amazon.awssdk.services.directory.model.DescribeCaEnrollmentPolicyRequest;
import software.amazon.awssdk.services.directory.model.DescribeCaEnrollmentPolicyResponse;
import software.amazon.awssdk.services.directory.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.directory.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersRequest;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersResponse;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeDirectoryDataAccessRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoryDataAccessResponse;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsRequest;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsResponse;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateRequest;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateResponse;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.directory.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.directory.model.DescribeTrustsRequest;
import software.amazon.awssdk.services.directory.model.DescribeTrustsResponse;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DirectoryAlreadyInRegionException;
import software.amazon.awssdk.services.directory.model.DirectoryAlreadySharedException;
import software.amazon.awssdk.services.directory.model.DirectoryDoesNotExistException;
import software.amazon.awssdk.services.directory.model.DirectoryException;
import software.amazon.awssdk.services.directory.model.DirectoryInDesiredStateException;
import software.amazon.awssdk.services.directory.model.DirectoryLimitExceededException;
import software.amazon.awssdk.services.directory.model.DirectoryNotSharedException;
import software.amazon.awssdk.services.directory.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.directory.model.DisableAlreadyInProgressException;
import software.amazon.awssdk.services.directory.model.DisableCaEnrollmentPolicyRequest;
import software.amazon.awssdk.services.directory.model.DisableCaEnrollmentPolicyResponse;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.DisableDirectoryDataAccessRequest;
import software.amazon.awssdk.services.directory.model.DisableDirectoryDataAccessResponse;
import software.amazon.awssdk.services.directory.model.DisableLdapsRequest;
import software.amazon.awssdk.services.directory.model.DisableLdapsResponse;
import software.amazon.awssdk.services.directory.model.DisableRadiusRequest;
import software.amazon.awssdk.services.directory.model.DisableRadiusResponse;
import software.amazon.awssdk.services.directory.model.DisableSsoRequest;
import software.amazon.awssdk.services.directory.model.DisableSsoResponse;
import software.amazon.awssdk.services.directory.model.DomainControllerLimitExceededException;
import software.amazon.awssdk.services.directory.model.EnableAlreadyInProgressException;
import software.amazon.awssdk.services.directory.model.EnableCaEnrollmentPolicyRequest;
import software.amazon.awssdk.services.directory.model.EnableCaEnrollmentPolicyResponse;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.EnableDirectoryDataAccessRequest;
import software.amazon.awssdk.services.directory.model.EnableDirectoryDataAccessResponse;
import software.amazon.awssdk.services.directory.model.EnableLdapsRequest;
import software.amazon.awssdk.services.directory.model.EnableLdapsResponse;
import software.amazon.awssdk.services.directory.model.EnableRadiusRequest;
import software.amazon.awssdk.services.directory.model.EnableRadiusResponse;
import software.amazon.awssdk.services.directory.model.EnableSsoRequest;
import software.amazon.awssdk.services.directory.model.EnableSsoResponse;
import software.amazon.awssdk.services.directory.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.EntityDoesNotExistException;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsResponse;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsResponse;
import software.amazon.awssdk.services.directory.model.IncompatibleSettingsException;
import software.amazon.awssdk.services.directory.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.directory.model.InvalidCertificateException;
import software.amazon.awssdk.services.directory.model.InvalidClientAuthStatusException;
import software.amazon.awssdk.services.directory.model.InvalidLdapsStatusException;
import software.amazon.awssdk.services.directory.model.InvalidNextTokenException;
import software.amazon.awssdk.services.directory.model.InvalidParameterException;
import software.amazon.awssdk.services.directory.model.InvalidPasswordException;
import software.amazon.awssdk.services.directory.model.InvalidTargetException;
import software.amazon.awssdk.services.directory.model.IpRouteLimitExceededException;
import software.amazon.awssdk.services.directory.model.ListAdAssessmentsRequest;
import software.amazon.awssdk.services.directory.model.ListAdAssessmentsResponse;
import software.amazon.awssdk.services.directory.model.ListCertificatesRequest;
import software.amazon.awssdk.services.directory.model.ListCertificatesResponse;
import software.amazon.awssdk.services.directory.model.ListIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.ListIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.directory.model.NoAvailableCertificateException;
import software.amazon.awssdk.services.directory.model.OrganizationsException;
import software.amazon.awssdk.services.directory.model.RegionLimitExceededException;
import software.amazon.awssdk.services.directory.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.RemoveRegionRequest;
import software.amazon.awssdk.services.directory.model.RemoveRegionResponse;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordRequest;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordResponse;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.directory.model.ServiceException;
import software.amazon.awssdk.services.directory.model.ShareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ShareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.ShareLimitExceededException;
import software.amazon.awssdk.services.directory.model.SnapshotLimitExceededException;
import software.amazon.awssdk.services.directory.model.StartAdAssessmentRequest;
import software.amazon.awssdk.services.directory.model.StartAdAssessmentResponse;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.TagLimitExceededException;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.UnsupportedOperationException;
import software.amazon.awssdk.services.directory.model.UnsupportedSettingsException;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.UpdateDirectorySetupRequest;
import software.amazon.awssdk.services.directory.model.UpdateDirectorySetupResponse;
import software.amazon.awssdk.services.directory.model.UpdateHybridAdRequest;
import software.amazon.awssdk.services.directory.model.UpdateHybridAdResponse;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.UpdateRadiusRequest;
import software.amazon.awssdk.services.directory.model.UpdateRadiusResponse;
import software.amazon.awssdk.services.directory.model.UpdateSettingsRequest;
import software.amazon.awssdk.services.directory.model.UpdateSettingsResponse;
import software.amazon.awssdk.services.directory.model.UpdateTrustRequest;
import software.amazon.awssdk.services.directory.model.UpdateTrustResponse;
import software.amazon.awssdk.services.directory.model.UserDoesNotExistException;
import software.amazon.awssdk.services.directory.model.VerifyTrustRequest;
import software.amazon.awssdk.services.directory.model.VerifyTrustResponse;
import software.amazon.awssdk.services.directory.transform.AcceptSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddRegionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CancelSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ConnectDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateComputerRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateHybridAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateMicrosoftAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteAdAssessmentRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeAdAssessmentRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeCaEnrollmentPolicyRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeClientAuthenticationSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeConditionalForwardersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDirectoryDataAccessRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeEventTopicsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeHybridAdUpdateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeLdapsSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeRegionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSharedDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeTrustsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeUpdateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableCaEnrollmentPolicyRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableClientAuthenticationRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableDirectoryDataAccessRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableCaEnrollmentPolicyRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableClientAuthenticationRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableDirectoryDataAccessRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetDirectoryLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetSnapshotLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListAdAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListCertificatesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListLogSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListSchemaExtensionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RejectSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveRegionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ResetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RestoreFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ShareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.StartAdAssessmentRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.StartSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UnshareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateDirectorySetupRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateHybridAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateNumberOfDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.VerifyTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.waiters.DirectoryAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link DirectoryAsyncClient}.
 *
 * @see DirectoryAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultDirectoryAsyncClient implements DirectoryAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDirectoryAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultDirectoryAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Directory_Service" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Accepts a directory sharing request that was sent from the directory owner account.
     * </p>
     *
     * @param acceptSharedDirectoryRequest
     * @return A Java Future containing the result of the AcceptSharedDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryAlreadySharedException The specified directory has already been shared with this Amazon Web
     *         Services account.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AcceptSharedDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AcceptSharedDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptSharedDirectoryResponse> acceptSharedDirectory(
            AcceptSharedDirectoryRequest acceptSharedDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptSharedDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptSharedDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptSharedDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptSharedDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AcceptSharedDirectoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AcceptSharedDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptSharedDirectoryRequest, AcceptSharedDirectoryResponse>()
                            .withOperationName("AcceptSharedDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptSharedDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptSharedDirectoryRequest));
            CompletableFuture<AcceptSharedDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * If the DNS server for your self-managed domain uses a publicly addressable IP address, you must add a CIDR
     * address block to correctly route traffic to and from your Microsoft AD on Amazon Web Services. <i>AddIpRoutes</i>
     * adds this address block. You can also use <i>AddIpRoutes</i> to facilitate routing traffic that uses public IP
     * ranges from your Microsoft AD on Amazon Web Services to a peer VPC.
     * </p>
     * <p>
     * Before you call <i>AddIpRoutes</i>, ensure that all of the required permissions have been explicitly granted
     * through a policy. For details about what permissions are required to run the <i>AddIpRoutes</i> operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">
     * Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param addIpRoutesRequest
     * @return A Java Future containing the result of the AddIpRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable.</li>
     *         <li>IpRouteLimitExceededException The maximum allowed number of IP addresses was exceeded. The default
     *         limit is 100 IP address blocks.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AddIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddIpRoutesResponse> addIpRoutes(AddIpRoutesRequest addIpRoutesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addIpRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addIpRoutesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddIpRoutes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddIpRoutesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AddIpRoutesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AddIpRoutesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddIpRoutesRequest, AddIpRoutesResponse>()
                            .withOperationName("AddIpRoutes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddIpRoutesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addIpRoutesRequest));
            CompletableFuture<AddIpRoutesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds two domain controllers in the specified Region for the specified directory.
     * </p>
     *
     * @param addRegionRequest
     * @return A Java Future containing the result of the AddRegion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryAlreadyInRegionException The Region you specified is the same Region where the Managed
     *         Microsoft AD directory was created. Specify a different Region and try again.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>RegionLimitExceededException You have reached the limit for maximum number of simultaneous Region
     *         replications per directory.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AddRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddRegion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddRegionResponse> addRegion(AddRegionRequest addRegionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addRegionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addRegionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddRegion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddRegionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AddRegionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AddRegionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddRegionRequest, AddRegionResponse>().withOperationName("AddRegion")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddRegionRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(addRegionRequest));
            CompletableFuture<AddRegionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified directory. Each directory can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique to each resource.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>TagLimitExceededException The maximum allowed number of tags was exceeded.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsToResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AddTagsToResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AddTagsToResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                            .withOperationName("AddTagsToResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(addTagsToResourceRequest));
            CompletableFuture<AddTagsToResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an in-progress schema extension to a Microsoft AD directory. Once a schema extension has started
     * replicating to all domain controllers, the task can no longer be canceled. A schema extension can be canceled
     * during any of the following states; <code>Initializing</code>, <code>CreatingSnapshot</code>, and
     * <code>UpdatingSchema</code>.
     * </p>
     *
     * @param cancelSchemaExtensionRequest
     * @return A Java Future containing the result of the CancelSchemaExtension operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CancelSchemaExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CancelSchemaExtension" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelSchemaExtensionResponse> cancelSchemaExtension(
            CancelSchemaExtensionRequest cancelSchemaExtensionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelSchemaExtensionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelSchemaExtensionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelSchemaExtension");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelSchemaExtensionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelSchemaExtensionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CancelSchemaExtensionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelSchemaExtensionRequest, CancelSchemaExtensionResponse>()
                            .withOperationName("CancelSchemaExtension").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelSchemaExtensionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelSchemaExtensionRequest));
            CompletableFuture<CancelSchemaExtensionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an AD Connector to connect to a self-managed directory.
     * </p>
     * <p>
     * Before you call <code>ConnectDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the
     * <code>ConnectDirectory</code> operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param connectDirectoryRequest
     *        Contains the inputs for the <a>ConnectDirectory</a> operation.
     * @return A Java Future containing the result of the ConnectDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryLimitExceededException The maximum number of directories in the region has been reached. You
     *         can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ConnectDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ConnectDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ConnectDirectoryResponse> connectDirectory(ConnectDirectoryRequest connectDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(connectDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, connectDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConnectDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ConnectDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ConnectDirectoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ConnectDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ConnectDirectoryRequest, ConnectDirectoryResponse>()
                            .withOperationName("ConnectDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ConnectDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(connectDirectoryRequest));
            CompletableFuture<ConnectDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an alias for a directory and assigns the alias to the directory. The alias is used to construct the
     * access URL for the directory, such as <code>http://&lt;alias&gt;.awsapps.com</code>.
     * </p>
     * <important>
     * <p>
     * After an alias has been created, it cannot be deleted or reused, so this operation should only be used when
     * absolutely necessary.
     * </p>
     * </important>
     *
     * @param createAliasRequest
     *        Contains the inputs for the <a>CreateAlias</a> operation.
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAliasRequest, CreateAliasResponse>()
                            .withOperationName("CreateAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAliasRequest));
            CompletableFuture<CreateAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Active Directory computer object in the specified directory.
     * </p>
     *
     * @param createComputerRequest
     *        Contains the inputs for the <a>CreateComputer</a> operation.
     * @return A Java Future containing the result of the CreateComputer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthenticationFailedException An authentication error occurred.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable.</li>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateComputer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateComputer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateComputerResponse> createComputer(CreateComputerRequest createComputerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createComputerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createComputerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateComputer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateComputerResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateComputerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateComputerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateComputerRequest, CreateComputerResponse>()
                            .withOperationName("CreateComputer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateComputerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createComputerRequest));
            CompletableFuture<CreateComputerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a conditional forwarder associated with your Amazon Web Services directory. Conditional forwarders are
     * required in order to set up a trust relationship with another domain. The conditional forwarder points to the
     * trusted domain.
     * </p>
     *
     * @param createConditionalForwarderRequest
     *        Initiates the creation of a conditional forwarder for your Directory Service for Microsoft Active
     *        Directory. Conditional forwarders are required in order to set up a trust relationship with another
     *        domain.
     * @return A Java Future containing the result of the CreateConditionalForwarder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateConditionalForwarder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateConditionalForwarder" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConditionalForwarderResponse> createConditionalForwarder(
            CreateConditionalForwarderRequest createConditionalForwarderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConditionalForwarderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConditionalForwarderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConditionalForwarder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConditionalForwarderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateConditionalForwarderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateConditionalForwarderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConditionalForwarderRequest, CreateConditionalForwarderResponse>()
                            .withOperationName("CreateConditionalForwarder").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateConditionalForwarderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createConditionalForwarderRequest));
            CompletableFuture<CreateConditionalForwarderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Simple AD directory. For more information, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_simple_ad.html">Simple Active
     * Directory</a> in the <i>Directory Service Admin Guide</i>.
     * </p>
     * <p>
     * Before you call <code>CreateDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <code>CreateDirectory</code>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param createDirectoryRequest
     *        Contains the inputs for the <a>CreateDirectory</a> operation.
     * @return A Java Future containing the result of the CreateDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryLimitExceededException The maximum number of directories in the region has been reached. You
     *         can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDirectoryResponse> createDirectory(CreateDirectoryRequest createDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDirectoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDirectoryRequest, CreateDirectoryResponse>()
                            .withOperationName("CreateDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDirectoryRequest));
            CompletableFuture<CreateDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a hybrid directory that connects your self-managed Active Directory (AD) infrastructure and Amazon Web
     * Services.
     * </p>
     * <p>
     * You must have a successful directory assessment using <a>StartADAssessment</a> to validate your environment
     * compatibility before you use this operation.
     * </p>
     * <p>
     * Updates are applied asynchronously. Use <a>DescribeDirectories</a> to monitor the progress of directory creation.
     * </p>
     *
     * @param createHybridAdRequest
     * @return A Java Future containing the result of the CreateHybridAD operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryLimitExceededException The maximum number of directories in the region has been reached. You
     *         can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</li>
     *         <li>AdAssessmentLimitExceededException A directory assessment is automatically created when you create a
     *         hybrid directory. There are two types of assessments: <code>CUSTOMER</code> and <code>SYSTEM</code>. Your
     *         Amazon Web Services account has a limit of 100 <code>CUSTOMER</code> directory assessments.</p>
     *         <p>
     *         If you attempt to create a hybrid directory; and you already have 100 <code>CUSTOMER</code> directory
     *         assessments;, you will encounter an error. Delete assessments to free up capacity before trying again.
     *         </p>
     *         <p>
     *         You can request an increase to your <code>CUSTOMER</code> directory assessment quota by contacting
     *         customer support or delete existing CUSTOMER directory assessments; to free up capacity.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateHybridAD
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateHybridAD" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateHybridAdResponse> createHybridAD(CreateHybridAdRequest createHybridAdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createHybridAdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createHybridAdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHybridAD");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateHybridAdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateHybridAdResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateHybridAdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateHybridAdRequest, CreateHybridAdResponse>()
                            .withOperationName("CreateHybridAD").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateHybridAdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createHybridAdRequest));
            CompletableFuture<CreateHybridAdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a subscription to forward real-time Directory Service domain controller security logs to the specified
     * Amazon CloudWatch log group in your Amazon Web Services account.
     * </p>
     *
     * @param createLogSubscriptionRequest
     * @return A Java Future containing the result of the CreateLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InsufficientPermissionsException The account does not have sufficient permission to perform the
     *         operation.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateLogSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLogSubscriptionResponse> createLogSubscription(
            CreateLogSubscriptionRequest createLogSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLogSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLogSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLogSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLogSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLogSubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateLogSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLogSubscriptionRequest, CreateLogSubscriptionResponse>()
                            .withOperationName("CreateLogSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateLogSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createLogSubscriptionRequest));
            CompletableFuture<CreateLogSubscriptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a Microsoft AD directory in the Amazon Web Services Cloud. For more information, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">Managed
     * Microsoft AD</a> in the <i>Directory Service Admin Guide</i>.
     * </p>
     * <p>
     * Before you call <i>CreateMicrosoftAD</i>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <i>CreateMicrosoftAD</i>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param createMicrosoftAdRequest
     *        Creates an Managed Microsoft AD directory.
     * @return A Java Future containing the result of the CreateMicrosoftAD operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryLimitExceededException The maximum number of directories in the region has been reached. You
     *         can use the <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateMicrosoftAD
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateMicrosoftAD" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMicrosoftAdResponse> createMicrosoftAD(CreateMicrosoftAdRequest createMicrosoftAdRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMicrosoftAdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMicrosoftAdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMicrosoftAD");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMicrosoftAdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMicrosoftAdResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateMicrosoftAdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMicrosoftAdRequest, CreateMicrosoftAdResponse>()
                            .withOperationName("CreateMicrosoftAD").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMicrosoftAdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMicrosoftAdRequest));
            CompletableFuture<CreateMicrosoftAdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a snapshot of a Simple AD or Microsoft AD directory in the Amazon Web Services cloud.
     * </p>
     * <note>
     * <p>
     * You cannot take snapshots of AD Connector directories.
     * </p>
     * </note>
     *
     * @param createSnapshotRequest
     *        Contains the inputs for the <a>CreateSnapshot</a> operation.
     * @return A Java Future containing the result of the CreateSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>SnapshotLimitExceededException The maximum number of manual snapshots for the directory has been
     *         reached. You can use the <a>GetSnapshotLimits</a> operation to determine the snapshot limits for a
     *         directory.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSnapshotResponse> createSnapshot(CreateSnapshotRequest createSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSnapshotRequest, CreateSnapshotResponse>()
                            .withOperationName("CreateSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createSnapshotRequest));
            CompletableFuture<CreateSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example, you
     * can establish a trust between your Managed Microsoft AD directory, and your existing self-managed Microsoft
     * Active Directory. This would allow you to provide users and groups access to resources in either domain, with a
     * single set of credentials.
     * </p>
     * <p>
     * This action initiates the creation of the Amazon Web Services side of a trust relationship between an Managed
     * Microsoft AD directory and an external domain. You can create either a forest trust or an external trust.
     * </p>
     *
     * @param createTrustRequest
     *        Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example,
     *        you can establish a trust between your Managed Microsoft AD directory, and your existing self-managed
     *        Microsoft Active Directory. This would allow you to provide users and groups access to resources in either
     *        domain, with a single set of credentials.</p>
     *        <p>
     *        This action initiates the creation of the Amazon Web Services side of a trust relationship between an
     *        Managed Microsoft AD directory and an external domain.
     * @return A Java Future containing the result of the CreateTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li> <li>
     *         EntityDoesNotExistException The specified entity could not be found.</li> <li>InvalidParameterException
     *         One or more parameters are not valid.</li> <li>ClientException A client exception has occurred.</li> <li>
     *         ServiceException An exception has occurred in Directory Service.</li> <li>UnsupportedOperationException
     *         The operation is not supported.</li> <li>SdkException Base class for all exceptions that can be thrown by
     *         the SDK (both service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If
     *         any client side error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>
     *         DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.CreateTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateTrust" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrustResponse> createTrust(CreateTrustRequest createTrustRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrustRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrustRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrust");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTrustResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateTrustResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateTrustResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrustRequest, CreateTrustResponse>()
                            .withOperationName("CreateTrust").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateTrustRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createTrustRequest));
            CompletableFuture<CreateTrustResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a directory assessment and all associated data. This operation permanently removes the assessment
     * results, validation reports, and configuration information.
     * </p>
     * <p>
     * You cannot delete system-initiated assessments. You can delete customer-created assessments even if they are in
     * progress.
     * </p>
     *
     * @param deleteAdAssessmentRequest
     * @return A Java Future containing the result of the DeleteADAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteADAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteADAssessment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAdAssessmentResponse> deleteADAssessment(DeleteAdAssessmentRequest deleteAdAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAdAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAdAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteADAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAdAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAdAssessmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteAdAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAdAssessmentRequest, DeleteAdAssessmentResponse>()
                            .withOperationName("DeleteADAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAdAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAdAssessmentRequest));
            CompletableFuture<DeleteAdAssessmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a conditional forwarder that has been set up for your Amazon Web Services directory.
     * </p>
     *
     * @param deleteConditionalForwarderRequest
     *        Deletes a conditional forwarder.
     * @return A Java Future containing the result of the DeleteConditionalForwarder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteConditionalForwarder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteConditionalForwarder" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConditionalForwarderResponse> deleteConditionalForwarder(
            DeleteConditionalForwarderRequest deleteConditionalForwarderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConditionalForwarderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConditionalForwarderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConditionalForwarder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConditionalForwarderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConditionalForwarderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteConditionalForwarderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConditionalForwarderRequest, DeleteConditionalForwarderResponse>()
                            .withOperationName("DeleteConditionalForwarder").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConditionalForwarderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConditionalForwarderRequest));
            CompletableFuture<DeleteConditionalForwarderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Directory Service directory.
     * </p>
     * <p>
     * Before you call <code>DeleteDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <code>DeleteDirectory</code>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param deleteDirectoryRequest
     *        Contains the inputs for the <a>DeleteDirectory</a> operation.
     * @return A Java Future containing the result of the DeleteDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDirectoryResponse> deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDirectoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDirectoryRequest, DeleteDirectoryResponse>()
                            .withOperationName("DeleteDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDirectoryRequest));
            CompletableFuture<DeleteDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified log subscription.
     * </p>
     *
     * @param deleteLogSubscriptionRequest
     * @return A Java Future containing the result of the DeleteLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteLogSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLogSubscriptionResponse> deleteLogSubscription(
            DeleteLogSubscriptionRequest deleteLogSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLogSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLogSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLogSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLogSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteLogSubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteLogSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLogSubscriptionRequest, DeleteLogSubscriptionResponse>()
                            .withOperationName("DeleteLogSubscription").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteLogSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteLogSubscriptionRequest));
            CompletableFuture<DeleteLogSubscriptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a directory snapshot.
     * </p>
     *
     * @param deleteSnapshotRequest
     *        Contains the inputs for the <a>DeleteSnapshot</a> operation.
     * @return A Java Future containing the result of the DeleteSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSnapshotResponse> deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSnapshotRequest, DeleteSnapshotResponse>()
                            .withOperationName("DeleteSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteSnapshotRequest));
            CompletableFuture<DeleteSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing trust relationship between your Managed Microsoft AD directory and an external domain.
     * </p>
     *
     * @param deleteTrustRequest
     *        Deletes the local side of an existing trust relationship between the Managed Microsoft AD directory and
     *        the external domain.
     * @return A Java Future containing the result of the DeleteTrust operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeleteTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteTrust" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrustResponse> deleteTrust(DeleteTrustRequest deleteTrustRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrustRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrustRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrust");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTrustResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteTrustResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteTrustResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrustRequest, DeleteTrustResponse>()
                            .withOperationName("DeleteTrust").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteTrustRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteTrustRequest));
            CompletableFuture<DeleteTrustResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes from the system the certificate that was registered for secure LDAP or client certificate authentication.
     * </p>
     *
     * @param deregisterCertificateRequest
     * @return A Java Future containing the result of the DeregisterCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>CertificateDoesNotExistException The certificate is not present in the system for describe or
     *         deregister activities.</li>
     *         <li>CertificateInUseException The certificate is being used for the LDAP security connection and cannot
     *         be removed without disabling LDAP security.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeregisterCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterCertificateResponse> deregisterCertificate(
            DeregisterCertificateRequest deregisterCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeregisterCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterCertificateRequest, DeregisterCertificateResponse>()
                            .withOperationName("DeregisterCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterCertificateRequest));
            CompletableFuture<DeregisterCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified directory as a publisher to the specified Amazon SNS topic.
     * </p>
     *
     * @param deregisterEventTopicRequest
     *        Removes the specified directory as a publisher to the specified Amazon SNS topic.
     * @return A Java Future containing the result of the DeregisterEventTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DeregisterEventTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterEventTopic" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterEventTopicResponse> deregisterEventTopic(
            DeregisterEventTopicRequest deregisterEventTopicRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterEventTopicRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterEventTopicRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterEventTopic");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterEventTopicResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterEventTopicResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeregisterEventTopicResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterEventTopicRequest, DeregisterEventTopicResponse>()
                            .withOperationName("DeregisterEventTopic").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterEventTopicRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterEventTopicRequest));
            CompletableFuture<DeregisterEventTopicResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves detailed information about a directory assessment, including its current status, validation results,
     * and configuration details. Use this operation to monitor assessment progress and review results.
     * </p>
     *
     * @param describeAdAssessmentRequest
     * @return A Java Future containing the result of the DescribeADAssessment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeADAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeADAssessment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAdAssessmentResponse> describeADAssessment(
            DescribeAdAssessmentRequest describeAdAssessmentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAdAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAdAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeADAssessment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAdAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAdAssessmentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAdAssessmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAdAssessmentRequest, DescribeAdAssessmentResponse>()
                            .withOperationName("DescribeADAssessment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAdAssessmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAdAssessmentRequest));
            CompletableFuture<DescribeAdAssessmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves detailed information about the certificate authority (CA) enrollment policy for the specified
     * directory. This policy determines how client certificates are automatically enrolled and managed through Amazon
     * Web Services Private Certificate Authority.
     * </p>
     *
     * @param describeCaEnrollmentPolicyRequest
     *        Contains the inputs for the <a>DescribeCAEnrollmentPolicy</a> operation.
     * @return A Java Future containing the result of the DescribeCAEnrollmentPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeCAEnrollmentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeCAEnrollmentPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCaEnrollmentPolicyResponse> describeCAEnrollmentPolicy(
            DescribeCaEnrollmentPolicyRequest describeCaEnrollmentPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCaEnrollmentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCaEnrollmentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCAEnrollmentPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCaEnrollmentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCaEnrollmentPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeCaEnrollmentPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCaEnrollmentPolicyRequest, DescribeCaEnrollmentPolicyResponse>()
                            .withOperationName("DescribeCAEnrollmentPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCaEnrollmentPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCaEnrollmentPolicyRequest));
            CompletableFuture<DescribeCaEnrollmentPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Displays information about the certificate registered for secure LDAP or client certificate authentication.
     * </p>
     *
     * @param describeCertificateRequest
     * @return A Java Future containing the result of the DescribeCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>CertificateDoesNotExistException The certificate is not present in the system for describe or
     *         deregister activities.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeCertificateResponse> describeCertificate(
            DescribeCertificateRequest describeCertificateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeCertificateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeCertificateRequest, DescribeCertificateResponse>()
                            .withOperationName("DescribeCertificate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeCertificateRequest));
            CompletableFuture<DescribeCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the type of client authentication for the specified directory, if the type is
     * specified. If no type is specified, information about all client authentication types that are supported for the
     * specified directory is retrieved. Currently, only <code>SmartCard</code> is supported.
     * </p>
     *
     * @param describeClientAuthenticationSettingsRequest
     * @return A Java Future containing the result of the DescribeClientAuthenticationSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeClientAuthenticationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeClientAuthenticationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeClientAuthenticationSettingsResponse> describeClientAuthenticationSettings(
            DescribeClientAuthenticationSettingsRequest describeClientAuthenticationSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClientAuthenticationSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeClientAuthenticationSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClientAuthenticationSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeClientAuthenticationSettingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeClientAuthenticationSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeClientAuthenticationSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeClientAuthenticationSettingsRequest, DescribeClientAuthenticationSettingsResponse>()
                            .withOperationName("DescribeClientAuthenticationSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeClientAuthenticationSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeClientAuthenticationSettingsRequest));
            CompletableFuture<DescribeClientAuthenticationSettingsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains information about the conditional forwarders for this account.
     * </p>
     * <p>
     * If no input parameters are provided for RemoteDomainNames, this request describes all conditional forwarders for
     * the specified directory ID.
     * </p>
     *
     * @param describeConditionalForwardersRequest
     *        Describes a conditional forwarder.
     * @return A Java Future containing the result of the DescribeConditionalForwarders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeConditionalForwarders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeConditionalForwarders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConditionalForwardersResponse> describeConditionalForwarders(
            DescribeConditionalForwardersRequest describeConditionalForwardersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConditionalForwardersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConditionalForwardersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConditionalForwarders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConditionalForwardersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConditionalForwardersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeConditionalForwardersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConditionalForwardersRequest, DescribeConditionalForwardersResponse>()
                            .withOperationName("DescribeConditionalForwarders").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConditionalForwardersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConditionalForwardersRequest));
            CompletableFuture<DescribeConditionalForwardersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains information about the directories that belong to this account.
     * </p>
     * <p>
     * You can retrieve information about specific directories by passing the directory identifiers in the
     * <code>DirectoryIds</code> parameter. Otherwise, all directories that belong to the current account are returned.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>DescribeDirectoriesResult.NextToken</code> member contains a token that you
     * pass in the next call to <a>DescribeDirectories</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>Limit</code> parameter.
     * </p>
     *
     * @param describeDirectoriesRequest
     *        Contains the inputs for the <a>DescribeDirectories</a> operation.
     * @return A Java Future containing the result of the DescribeDirectories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectories" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDirectoriesResponse> describeDirectories(
            DescribeDirectoriesRequest describeDirectoriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDirectoriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDirectoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDirectoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDirectoriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDirectoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDirectoriesRequest, DescribeDirectoriesResponse>()
                            .withOperationName("DescribeDirectories").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDirectoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDirectoriesRequest));
            CompletableFuture<DescribeDirectoriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains status of directory data access enablement through the Directory Service Data API for the specified
     * directory.
     * </p>
     *
     * @param describeDirectoryDataAccessRequest
     * @return A Java Future containing the result of the DescribeDirectoryDataAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDirectoryDataAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectoryDataAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDirectoryDataAccessResponse> describeDirectoryDataAccess(
            DescribeDirectoryDataAccessRequest describeDirectoryDataAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDirectoryDataAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDirectoryDataAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectoryDataAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDirectoryDataAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDirectoryDataAccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDirectoryDataAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDirectoryDataAccessRequest, DescribeDirectoryDataAccessResponse>()
                            .withOperationName("DescribeDirectoryDataAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDirectoryDataAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDirectoryDataAccessRequest));
            CompletableFuture<DescribeDirectoryDataAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information about any domain controllers in your directory.
     * </p>
     *
     * @param describeDomainControllersRequest
     * @return A Java Future containing the result of the DescribeDomainControllers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeDomainControllers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDomainControllers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDomainControllersResponse> describeDomainControllers(
            DescribeDomainControllersRequest describeDomainControllersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainControllersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainControllersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomainControllers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDomainControllersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDomainControllersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDomainControllersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDomainControllersRequest, DescribeDomainControllersResponse>()
                            .withOperationName("DescribeDomainControllers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDomainControllersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDomainControllersRequest));
            CompletableFuture<DescribeDomainControllersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains information about which Amazon SNS topics receive status messages from the specified directory.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TopicName, this request describes all of the
     * associations in the account.
     * </p>
     *
     * @param describeEventTopicsRequest
     *        Describes event topics.
     * @return A Java Future containing the result of the DescribeEventTopics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeEventTopics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeEventTopics" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEventTopicsResponse> describeEventTopics(
            DescribeEventTopicsRequest describeEventTopicsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventTopicsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventTopicsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventTopics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEventTopicsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEventTopicsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEventTopicsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEventTopicsRequest, DescribeEventTopicsResponse>()
                            .withOperationName("DescribeEventTopics").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEventTopicsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEventTopicsRequest));
            CompletableFuture<DescribeEventTopicsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about update activities for a hybrid directory. This operation provides details about
     * configuration changes, administrator account updates, and self-managed instance settings (IDs and DNS IPs).
     * </p>
     *
     * @param describeHybridAdUpdateRequest
     * @return A Java Future containing the result of the DescribeHybridADUpdate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeHybridADUpdate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeHybridADUpdate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeHybridAdUpdateResponse> describeHybridADUpdate(
            DescribeHybridAdUpdateRequest describeHybridAdUpdateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeHybridAdUpdateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeHybridAdUpdateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHybridADUpdate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeHybridAdUpdateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeHybridAdUpdateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeHybridAdUpdateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeHybridAdUpdateRequest, DescribeHybridAdUpdateResponse>()
                            .withOperationName("DescribeHybridADUpdate").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeHybridAdUpdateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeHybridAdUpdateRequest));
            CompletableFuture<DescribeHybridAdUpdateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the status of LDAP security for the specified directory.
     * </p>
     *
     * @param describeLdapsSettingsRequest
     * @return A Java Future containing the result of the DescribeLDAPSSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeLDAPSSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeLDAPSSettings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeLdapsSettingsResponse> describeLDAPSSettings(
            DescribeLdapsSettingsRequest describeLdapsSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLdapsSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLdapsSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLDAPSSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeLdapsSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeLdapsSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeLdapsSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeLdapsSettingsRequest, DescribeLdapsSettingsResponse>()
                            .withOperationName("DescribeLDAPSSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeLdapsSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeLdapsSettingsRequest));
            CompletableFuture<DescribeLdapsSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information about the Regions that are configured for multi-Region replication.
     * </p>
     *
     * @param describeRegionsRequest
     * @return A Java Future containing the result of the DescribeRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeRegions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeRegionsResponse> describeRegions(DescribeRegionsRequest describeRegionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRegionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRegionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRegions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeRegionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeRegionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeRegionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeRegionsRequest, DescribeRegionsResponse>()
                            .withOperationName("DescribeRegions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeRegionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeRegionsRequest));
            CompletableFuture<DescribeRegionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about the configurable settings for the specified directory.
     * </p>
     *
     * @param describeSettingsRequest
     * @return A Java Future containing the result of the DescribeSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSettings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSettingsResponse> describeSettings(DescribeSettingsRequest describeSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSettingsRequest, DescribeSettingsResponse>()
                            .withOperationName("DescribeSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSettingsRequest));
            CompletableFuture<DescribeSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the shared directories in your account.
     * </p>
     *
     * @param describeSharedDirectoriesRequest
     * @return A Java Future containing the result of the DescribeSharedDirectories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSharedDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSharedDirectories" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSharedDirectoriesResponse> describeSharedDirectories(
            DescribeSharedDirectoriesRequest describeSharedDirectoriesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSharedDirectoriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSharedDirectoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSharedDirectories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSharedDirectoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSharedDirectoriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeSharedDirectoriesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSharedDirectoriesRequest, DescribeSharedDirectoriesResponse>()
                            .withOperationName("DescribeSharedDirectories").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSharedDirectoriesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSharedDirectoriesRequest));
            CompletableFuture<DescribeSharedDirectoriesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains information about the directory snapshots that belong to this account.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <i>NextToken</i> request and response parameters. If more
     * results are available, the <i>DescribeSnapshots.NextToken</i> member contains a token that you pass in the next
     * call to <a>DescribeSnapshots</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <i>Limit</i> parameter.
     * </p>
     *
     * @param describeSnapshotsRequest
     *        Contains the inputs for the <a>DescribeSnapshots</a> operation.
     * @return A Java Future containing the result of the DescribeSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeSnapshotsResponse> describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSnapshots");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeSnapshotsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeSnapshotsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeSnapshotsRequest, DescribeSnapshotsResponse>()
                            .withOperationName("DescribeSnapshots").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeSnapshotsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeSnapshotsRequest));
            CompletableFuture<DescribeSnapshotsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains information about the trust relationships for this account.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TrustIds, this request describes all the trust
     * relationships belonging to the account.
     * </p>
     *
     * @param describeTrustsRequest
     *        Describes the trust relationships for a particular Managed Microsoft AD directory. If no input parameters
     *        are provided, such as directory ID or trust ID, this request describes all the trust relationships.
     * @return A Java Future containing the result of the DescribeTrusts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeTrusts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrusts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTrustsResponse> describeTrusts(DescribeTrustsRequest describeTrustsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrustsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrustsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrusts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTrustsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTrustsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeTrustsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTrustsRequest, DescribeTrustsResponse>()
                            .withOperationName("DescribeTrusts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeTrustsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeTrustsRequest));
            CompletableFuture<DescribeTrustsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the updates of a directory for a particular update type.
     * </p>
     *
     * @param describeUpdateDirectoryRequest
     * @return A Java Future containing the result of the DescribeUpdateDirectory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DescribeUpdateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeUpdateDirectory" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUpdateDirectoryResponse> describeUpdateDirectory(
            DescribeUpdateDirectoryRequest describeUpdateDirectoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUpdateDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUpdateDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUpdateDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUpdateDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeUpdateDirectoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeUpdateDirectoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUpdateDirectoryRequest, DescribeUpdateDirectoryResponse>()
                            .withOperationName("DescribeUpdateDirectory").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeUpdateDirectoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeUpdateDirectoryRequest));
            CompletableFuture<DescribeUpdateDirectoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the certificate authority (CA) enrollment policy for the specified directory. This stops automatic
     * certificate enrollment and management for domain-joined clients, but does not affect existing certificates.
     * </p>
     * <important>
     * <p>
     * Disabling the CA enrollment policy prevents new certificates from being automatically enrolled, but existing
     * certificates remain valid and functional until they expire.
     * </p>
     * </important>
     *
     * @param disableCaEnrollmentPolicyRequest
     *        Contains the inputs for the <a>DisableCAEnrollmentPolicy</a> operation.
     * @return A Java Future containing the result of the DisableCAEnrollmentPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>DisableAlreadyInProgressException A disable operation for CA enrollment policy is already in progress
     *         for this directory.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableCAEnrollmentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableCAEnrollmentPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableCaEnrollmentPolicyResponse> disableCAEnrollmentPolicy(
            DisableCaEnrollmentPolicyRequest disableCaEnrollmentPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableCaEnrollmentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableCaEnrollmentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableCAEnrollmentPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableCaEnrollmentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisableCaEnrollmentPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisableCaEnrollmentPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableCaEnrollmentPolicyRequest, DisableCaEnrollmentPolicyResponse>()
                            .withOperationName("DisableCAEnrollmentPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableCaEnrollmentPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableCaEnrollmentPolicyRequest));
            CompletableFuture<DisableCaEnrollmentPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables alternative client authentication methods for the specified directory.
     * </p>
     *
     * @param disableClientAuthenticationRequest
     * @return A Java Future containing the result of the DisableClientAuthentication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidClientAuthStatusException Client authentication is already enabled.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableClientAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableClientAuthentication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableClientAuthenticationResponse> disableClientAuthentication(
            DisableClientAuthenticationRequest disableClientAuthenticationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableClientAuthenticationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableClientAuthenticationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableClientAuthentication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableClientAuthenticationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisableClientAuthenticationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisableClientAuthenticationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableClientAuthenticationRequest, DisableClientAuthenticationResponse>()
                            .withOperationName("DisableClientAuthentication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableClientAuthenticationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableClientAuthenticationRequest));
            CompletableFuture<DisableClientAuthenticationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deactivates access to directory data via the Directory Service Data API for the specified directory. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/Welcome.html"
     * >Directory Service Data API Reference</a>.
     * </p>
     *
     * @param disableDirectoryDataAccessRequest
     * @return A Java Future containing the result of the DisableDirectoryDataAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryInDesiredStateException The directory is already updated to desired update type settings.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableDirectoryDataAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableDirectoryDataAccess" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DisableDirectoryDataAccessResponse> disableDirectoryDataAccess(
            DisableDirectoryDataAccessRequest disableDirectoryDataAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableDirectoryDataAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableDirectoryDataAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableDirectoryDataAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableDirectoryDataAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisableDirectoryDataAccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisableDirectoryDataAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableDirectoryDataAccessRequest, DisableDirectoryDataAccessResponse>()
                            .withOperationName("DisableDirectoryDataAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableDirectoryDataAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableDirectoryDataAccessRequest));
            CompletableFuture<DisableDirectoryDataAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deactivates LDAP secure calls for the specified directory.
     * </p>
     *
     * @param disableLdapsRequest
     * @return A Java Future containing the result of the DisableLDAPS operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>InvalidLdapsStatusException The LDAP activities could not be performed because they are limited by
     *         the LDAPS status.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableLDAPS
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableLDAPS" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisableLdapsResponse> disableLDAPS(DisableLdapsRequest disableLdapsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableLdapsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableLdapsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableLDAPS");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableLdapsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DisableLdapsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisableLdapsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableLdapsRequest, DisableLdapsResponse>()
                            .withOperationName("DisableLDAPS").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableLdapsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableLdapsRequest));
            CompletableFuture<DisableLdapsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server
     * for an AD Connector or Microsoft AD directory.
     * </p>
     *
     * @param disableRadiusRequest
     *        Contains the inputs for the <a>DisableRadius</a> operation.
     * @return A Java Future containing the result of the DisableRadius operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableRadius
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableRadius" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisableRadiusResponse> disableRadius(DisableRadiusRequest disableRadiusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableRadiusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableRadiusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableRadius");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableRadiusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DisableRadiusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisableRadiusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableRadiusRequest, DisableRadiusResponse>()
                            .withOperationName("DisableRadius").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableRadiusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableRadiusRequest));
            CompletableFuture<DisableRadiusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables single-sign on for a directory.
     * </p>
     *
     * @param disableSsoRequest
     *        Contains the inputs for the <a>DisableSso</a> operation.
     * @return A Java Future containing the result of the DisableSso operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InsufficientPermissionsException The account does not have sufficient permission to perform the
     *         operation.</li>
     *         <li>AuthenticationFailedException An authentication error occurred.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.DisableSso
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableSso" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DisableSsoResponse> disableSso(DisableSsoRequest disableSsoRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableSsoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableSsoRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableSso");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisableSsoResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DisableSsoResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisableSsoResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisableSsoRequest, DisableSsoResponse>().withOperationName("DisableSso")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisableSsoRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disableSsoRequest));
            CompletableFuture<DisableSsoResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables certificate authority (CA) enrollment policy for the specified directory. This allows domain-joined
     * clients to automatically request and receive certificates from the specified Amazon Web Services Private
     * Certificate Authority.
     * </p>
     * <note>
     * <p>
     * Before enabling CA enrollment, ensure that the PCA connector is properly configured and accessible from the
     * directory. The connector must be in an active state and have the necessary permissions.
     * </p>
     * </note>
     *
     * @param enableCaEnrollmentPolicyRequest
     *        Contains the inputs for the <a>EnableCAEnrollmentPolicy</a> operation.
     * @return A Java Future containing the result of the EnableCAEnrollmentPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>EnableAlreadyInProgressException An enable operation for CA enrollment policy is already in progress
     *         for this directory.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableCAEnrollmentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableCAEnrollmentPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableCaEnrollmentPolicyResponse> enableCAEnrollmentPolicy(
            EnableCaEnrollmentPolicyRequest enableCaEnrollmentPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableCaEnrollmentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableCaEnrollmentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableCAEnrollmentPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableCaEnrollmentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, EnableCaEnrollmentPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<EnableCaEnrollmentPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableCaEnrollmentPolicyRequest, EnableCaEnrollmentPolicyResponse>()
                            .withOperationName("EnableCAEnrollmentPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableCaEnrollmentPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableCaEnrollmentPolicyRequest));
            CompletableFuture<EnableCaEnrollmentPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables alternative client authentication methods for the specified directory.
     * </p>
     *
     * @param enableClientAuthenticationRequest
     * @return A Java Future containing the result of the EnableClientAuthentication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidClientAuthStatusException Client authentication is already enabled.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>NoAvailableCertificateException Client authentication setup could not be completed because at least
     *         one valid certificate must be registered in the system.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableClientAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableClientAuthentication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableClientAuthenticationResponse> enableClientAuthentication(
            EnableClientAuthenticationRequest enableClientAuthenticationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableClientAuthenticationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableClientAuthenticationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableClientAuthentication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableClientAuthenticationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, EnableClientAuthenticationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<EnableClientAuthenticationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableClientAuthenticationRequest, EnableClientAuthenticationResponse>()
                            .withOperationName("EnableClientAuthentication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableClientAuthenticationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableClientAuthenticationRequest));
            CompletableFuture<EnableClientAuthenticationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables access to directory data via the Directory Service Data API for the specified directory. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/Welcome.html"
     * >Directory Service Data API Reference</a>.
     * </p>
     *
     * @param enableDirectoryDataAccessRequest
     * @return A Java Future containing the result of the EnableDirectoryDataAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>DirectoryUnavailableException The specified directory is unavailable.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryInDesiredStateException The directory is already updated to desired update type settings.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableDirectoryDataAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableDirectoryDataAccess" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<EnableDirectoryDataAccessResponse> enableDirectoryDataAccess(
            EnableDirectoryDataAccessRequest enableDirectoryDataAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableDirectoryDataAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableDirectoryDataAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableDirectoryDataAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableDirectoryDataAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, EnableDirectoryDataAccessResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<EnableDirectoryDataAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableDirectoryDataAccessRequest, EnableDirectoryDataAccessResponse>()
                            .withOperationName("EnableDirectoryDataAccess").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableDirectoryDataAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableDirectoryDataAccessRequest));
            CompletableFuture<EnableDirectoryDataAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Activates the switch for the specific directory to always use LDAP secure calls.
     * </p>
     *
     * @param enableLdapsRequest
     * @return A Java Future containing the result of the EnableLDAPS operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryUnavailableException The specified directory is unavailable.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>NoAvailableCertificateException Client authentication setup could not be completed because at least
     *         one valid certificate must be registered in the system.</li>
     *         <li>InvalidLdapsStatusException The LDAP activities could not be performed because they are limited by
     *         the LDAPS status.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableLDAPS
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableLDAPS" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableLdapsResponse> enableLDAPS(EnableLdapsRequest enableLdapsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableLdapsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableLdapsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableLDAPS");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableLdapsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    EnableLdapsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<EnableLdapsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableLdapsRequest, EnableLdapsResponse>()
                            .withOperationName("EnableLDAPS").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableLdapsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableLdapsRequest));
            CompletableFuture<EnableLdapsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for
     * an AD Connector or Microsoft AD directory.
     * </p>
     *
     * @param enableRadiusRequest
     *        Contains the inputs for the <a>EnableRadius</a> operation.
     * @return A Java Future containing the result of the EnableRadius operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>EntityAlreadyExistsException The specified entity already exists.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableRadius
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableRadius" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableRadiusResponse> enableRadius(EnableRadiusRequest enableRadiusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableRadiusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableRadiusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableRadius");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableRadiusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    EnableRadiusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<EnableRadiusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableRadiusRequest, EnableRadiusResponse>()
                            .withOperationName("EnableRadius").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableRadiusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(enableRadiusRequest));
            CompletableFuture<EnableRadiusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables single sign-on for a directory. Single sign-on allows users in your directory to access certain Amazon
     * Web Services services from a computer joined to the directory without having to enter their credentials
     * separately.
     * </p>
     *
     * @param enableSsoRequest
     *        Contains the inputs for the <a>EnableSso</a> operation.
     * @return A Java Future containing the result of the EnableSso operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InsufficientPermissionsException The account does not have sufficient permission to perform the
     *         operation.</li>
     *         <li>AuthenticationFailedException An authentication error occurred.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.EnableSso
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableSso" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<EnableSsoResponse> enableSso(EnableSsoRequest enableSsoRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableSsoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableSsoRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableSso");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<EnableSsoResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    EnableSsoResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<EnableSsoResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<EnableSsoRequest, EnableSsoResponse>().withOperationName("EnableSso")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new EnableSsoRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(enableSsoRequest));
            CompletableFuture<EnableSsoResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains directory limit information for the current Region.
     * </p>
     *
     * @param getDirectoryLimitsRequest
     *        Contains the inputs for the <a>GetDirectoryLimits</a> operation.
     * @return A Java Future containing the result of the GetDirectoryLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.GetDirectoryLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetDirectoryLimits" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDirectoryLimitsResponse> getDirectoryLimits(GetDirectoryLimitsRequest getDirectoryLimitsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDirectoryLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDirectoryLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDirectoryLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDirectoryLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDirectoryLimitsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetDirectoryLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDirectoryLimitsRequest, GetDirectoryLimitsResponse>()
                            .withOperationName("GetDirectoryLimits").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDirectoryLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDirectoryLimitsRequest));
            CompletableFuture<GetDirectoryLimitsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Obtains the manual snapshot limits for a directory.
     * </p>
     *
     * @param getSnapshotLimitsRequest
     *        Contains the inputs for the <a>GetSnapshotLimits</a> operation.
     * @return A Java Future containing the result of the GetSnapshotLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.GetSnapshotLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetSnapshotLimits" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSnapshotLimitsResponse> getSnapshotLimits(GetSnapshotLimitsRequest getSnapshotLimitsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSnapshotLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSnapshotLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSnapshotLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSnapshotLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSnapshotLimitsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetSnapshotLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSnapshotLimitsRequest, GetSnapshotLimitsResponse>()
                            .withOperationName("GetSnapshotLimits").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSnapshotLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getSnapshotLimitsRequest));
            CompletableFuture<GetSnapshotLimitsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of directory assessments for the specified directory or all assessments in your account. Use
     * this operation to monitor assessment status and manage multiple assessments.
     * </p>
     *
     * @param listAdAssessmentsRequest
     * @return A Java Future containing the result of the ListADAssessments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListADAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListADAssessments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAdAssessmentsResponse> listADAssessments(ListAdAssessmentsRequest listAdAssessmentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAdAssessmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAdAssessmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListADAssessments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAdAssessmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAdAssessmentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListAdAssessmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAdAssessmentsRequest, ListAdAssessmentsResponse>()
                            .withOperationName("ListADAssessments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAdAssessmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAdAssessmentsRequest));
            CompletableFuture<ListAdAssessmentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * For the specified directory, lists all the certificates registered for a secure LDAP or client certificate
     * authentication.
     * </p>
     *
     * @param listCertificatesRequest
     * @return A Java Future containing the result of the ListCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryDoesNotExistException The specified directory does not exist in the system.</li>
     *         <li>UnsupportedOperationException The operation is not supported.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListCertificatesResponse> listCertificates(ListCertificatesRequest listCertificatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCertificatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCertificatesRequest, ListCertificatesResponse>()
                            .withOperationName("ListCertificates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCertificatesRequest));
            CompletableFuture<ListCertificatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the address blocks that you have added to a directory.
     * </p>
     *
     * @param listIpRoutesRequest
     * @return A Java Future containing the result of the ListIpRoutes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>InvalidParameterException One or more parameters are not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListIpRoutesResponse> listIpRoutes(ListIpRoutesRequest listIpRoutesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIpRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIpRoutesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIpRoutes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIpRoutesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListIpRoutesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListIpRoutesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIpRoutesRequest, ListIpRoutesResponse>()
                            .withOperationName("ListIpRoutes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListIpRoutesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listIpRoutesRequest));
            CompletableFuture<ListIpRoutesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the active log subscriptions for the Amazon Web Services account.
     * </p>
     *
     * @param listLogSubscriptionsRequest
     * @return A Java Future containing the result of the ListLogSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListLogSubscriptionsResponse> listLogSubscriptions(
            ListLogSubscriptionsRequest listLogSubscriptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLogSubscriptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLogSubscriptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLogSubscriptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLogSubscriptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLogSubscriptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
                case "UnsupportedSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "NoAvailableCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
                case "InvalidTargetException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTargetException::builder).build());
                case "IpRouteLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
                case "TagLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
                case "ShareLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
                case "CertificateInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(CertificateInUseException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListLogSubscriptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLogSubscriptionsRequest, ListLogSubscriptionsResponse>()
                            .withOperationName("ListLogSubscriptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListLogSubscriptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listLogSubscriptionsRequest));
            CompletableFuture<ListLogSubscriptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all schema extensions applied to a Microsoft AD Directory.
     * </p>
     *
     * @param listSchemaExtensionsRequest
     * @return A Java Future containing the result of the ListSchemaExtensions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value is not valid.</li>
     *         <li>EntityDoesNotExistException The specified entity could not be found.</li>
     *         <li>ClientException A client exception has occurred.</li>
     *         <li>ServiceException An exception has occurred in Directory Service.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DirectoryException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample DirectoryAsyncClient.ListSchemaExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListSchemaExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSchemaExtensionsResponse> listSchemaExtensions(
            ListSchemaExtensionsRequest listSchemaExtensionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSchemaExtensionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSchemaExtensionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSchemaExtensions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSchemaExtensionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSchemaExtensionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryAlreadySharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
                case "EnableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "InvalidCertificateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
                case "DirectoryNotSharedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
                case "RegionLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
                case "DisableAlreadyInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
                case "EntityDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
                case "DirectoryLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
                case "DirectoryDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "CertificateAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
                case "DirectoryAlreadyInRegionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
                case "DomainControllerLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder)
                            .build());
                case "UserDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "ClientException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ClientException::builder).build());
                case "IncompatibleSettingsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
                case "AuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
                case "DirectoryInDesiredStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "CertificateLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
                case "OrganizationsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationsException::builder).build());
                case "InvalidLDAPSStatusException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "CertificateDoesNotExistException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException")
                            .httpStatusCode(400).exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
                case "ServiceException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                            .exceptionBuilderSupplier(ServiceException::builder).build());
                case "SnapshotLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
                case "EntityAlreadyExistsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                case "ADAssessmentLimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
                case "InvalidClientAuthStatusException":
                    return Optional.of(ExceptionMetadata.builder().er