/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class UniqueProblemsByExecutionResultMapCopier {
    static Map<String, List<UniqueProblem>> copy(
            Map<String, ? extends Collection<? extends UniqueProblem>> uniqueProblemsByExecutionResultMapParam) {
        Map<String, List<UniqueProblem>> map;
        if (uniqueProblemsByExecutionResultMapParam == null
                || uniqueProblemsByExecutionResultMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<UniqueProblem>> modifiableMap = new LinkedHashMap<>(uniqueProblemsByExecutionResultMapParam.size());
            uniqueProblemsByExecutionResultMapParam.forEach((key, value) -> {
                List<UniqueProblem> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<UniqueProblem> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<UniqueProblem>> copyFromBuilder(
            Map<String, ? extends Collection<? extends UniqueProblem.Builder>> uniqueProblemsByExecutionResultMapParam) {
        Map<String, List<UniqueProblem>> map;
        if (uniqueProblemsByExecutionResultMapParam == null
                || uniqueProblemsByExecutionResultMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<UniqueProblem>> modifiableMap = new LinkedHashMap<>(uniqueProblemsByExecutionResultMapParam.size());
            uniqueProblemsByExecutionResultMapParam.forEach((key, value) -> {
                List<UniqueProblem> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<UniqueProblem> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        UniqueProblem member = entry == null ? null : entry.build();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<UniqueProblem.Builder>> copyToBuilder(
            Map<String, ? extends Collection<? extends UniqueProblem>> uniqueProblemsByExecutionResultMapParam) {
        Map<String, List<UniqueProblem.Builder>> map;
        if (uniqueProblemsByExecutionResultMapParam == null
                || uniqueProblemsByExecutionResultMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<UniqueProblem.Builder>> modifiableMap = new LinkedHashMap<>(
                    uniqueProblemsByExecutionResultMapParam.size());
            uniqueProblemsByExecutionResultMapParam.forEach((key, value) -> {
                List<UniqueProblem.Builder> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<UniqueProblem.Builder> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        UniqueProblem.Builder member = entry == null ? null : entry.toBuilder();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<UniqueProblem>> copyEnumToString(
            Map<ExecutionResult, ? extends Collection<? extends UniqueProblem>> uniqueProblemsByExecutionResultMapParam) {
        Map<String, List<UniqueProblem>> map;
        if (uniqueProblemsByExecutionResultMapParam == null
                || uniqueProblemsByExecutionResultMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<UniqueProblem>> modifiableMap = new LinkedHashMap<>(uniqueProblemsByExecutionResultMapParam.size());
            uniqueProblemsByExecutionResultMapParam.forEach((key, value) -> {
                String result = key == null ? null : key.toString();
                List<UniqueProblem> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<UniqueProblem> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(result, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<ExecutionResult, List<UniqueProblem>> copyStringToEnum(
            Map<String, ? extends Collection<? extends UniqueProblem>> uniqueProblemsByExecutionResultMapParam) {
        Map<ExecutionResult, List<UniqueProblem>> map;
        if (uniqueProblemsByExecutionResultMapParam == null
                || uniqueProblemsByExecutionResultMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<ExecutionResult, List<UniqueProblem>> modifiableMap = new LinkedHashMap<>(
                    uniqueProblemsByExecutionResultMapParam.size());
            uniqueProblemsByExecutionResultMapParam.forEach((key, value) -> {
                ExecutionResult result = ExecutionResult.fromValue(key);
                List<UniqueProblem> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<UniqueProblem> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                if (result != ExecutionResult.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, list);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
