/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestGridSessionArtifactsRequest extends DeviceFarmRequest implements
        ToCopyableBuilder<ListTestGridSessionArtifactsRequest.Builder, ListTestGridSessionArtifactsRequest> {
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionArn").getter(getter(ListTestGridSessionArtifactsRequest::sessionArn))
            .setter(setter(Builder::sessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ListTestGridSessionArtifactsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Integer> MAX_RESULT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResult").getter(getter(ListTestGridSessionArtifactsRequest::maxResult))
            .setter(setter(Builder::maxResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResult").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestGridSessionArtifactsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ARN_FIELD, TYPE_FIELD,
            MAX_RESULT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionArn;

    private final String type;

    private final Integer maxResult;

    private final String nextToken;

    private ListTestGridSessionArtifactsRequest(BuilderImpl builder) {
        super(builder);
        this.sessionArn = builder.sessionArn;
        this.type = builder.type;
        this.maxResult = builder.maxResult;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ARN of a <a>TestGridSession</a>.
     * </p>
     * 
     * @return The ARN of a <a>TestGridSession</a>.
     */
    public final String sessionArn() {
        return sessionArn;
    }

    /**
     * <p>
     * Limit results to a specified type of artifact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestGridSessionArtifactCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return Limit results to a specified type of artifact.
     * @see TestGridSessionArtifactCategory
     */
    public final TestGridSessionArtifactCategory type() {
        return TestGridSessionArtifactCategory.fromValue(type);
    }

    /**
     * <p>
     * Limit results to a specified type of artifact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TestGridSessionArtifactCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return Limit results to a specified type of artifact.
     * @see TestGridSessionArtifactCategory
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The maximum number of results to be returned by a request.
     * </p>
     * 
     * @return The maximum number of results to be returned by a request.
     */
    public final Integer maxResult() {
        return maxResult;
    }

    /**
     * <p>
     * Pagination token.
     * </p>
     * 
     * @return Pagination token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResult());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestGridSessionArtifactsRequest)) {
            return false;
        }
        ListTestGridSessionArtifactsRequest other = (ListTestGridSessionArtifactsRequest) obj;
        return Objects.equals(sessionArn(), other.sessionArn()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(maxResult(), other.maxResult()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestGridSessionArtifactsRequest").add("SessionArn", sessionArn())
                .add("Type", typeAsString()).add("MaxResult", maxResult()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionArn":
            return Optional.ofNullable(clazz.cast(sessionArn()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "maxResult":
            return Optional.ofNullable(clazz.cast(maxResult()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("maxResult", MAX_RESULT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTestGridSessionArtifactsRequest, T> g) {
        return obj -> g.apply((ListTestGridSessionArtifactsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeviceFarmRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTestGridSessionArtifactsRequest> {
        /**
         * <p>
         * The ARN of a <a>TestGridSession</a>.
         * </p>
         * 
         * @param sessionArn
         *        The ARN of a <a>TestGridSession</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionArn(String sessionArn);

        /**
         * <p>
         * Limit results to a specified type of artifact.
         * </p>
         * 
         * @param type
         *        Limit results to a specified type of artifact.
         * @see TestGridSessionArtifactCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestGridSessionArtifactCategory
         */
        Builder type(String type);

        /**
         * <p>
         * Limit results to a specified type of artifact.
         * </p>
         * 
         * @param type
         *        Limit results to a specified type of artifact.
         * @see TestGridSessionArtifactCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestGridSessionArtifactCategory
         */
        Builder type(TestGridSessionArtifactCategory type);

        /**
         * <p>
         * The maximum number of results to be returned by a request.
         * </p>
         * 
         * @param maxResult
         *        The maximum number of results to be returned by a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResult(Integer maxResult);

        /**
         * <p>
         * Pagination token.
         * </p>
         * 
         * @param nextToken
         *        Pagination token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeviceFarmRequest.BuilderImpl implements Builder {
        private String sessionArn;

        private String type;

        private Integer maxResult;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestGridSessionArtifactsRequest model) {
            super(model);
            sessionArn(model.sessionArn);
            type(model.type);
            maxResult(model.maxResult);
            nextToken(model.nextToken);
        }

        public final String getSessionArn() {
            return sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestGridSessionArtifactCategory type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getMaxResult() {
            return maxResult;
        }

        public final void setMaxResult(Integer maxResult) {
            this.maxResult = maxResult;
        }

        @Override
        public final Builder maxResult(Integer maxResult) {
            this.maxResult = maxResult;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTestGridSessionArtifactsRequest build() {
            return new ListTestGridSessionArtifactsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
