/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeviceInstanceResponse extends DeviceFarmResponse implements
        ToCopyableBuilder<GetDeviceInstanceResponse.Builder, GetDeviceInstanceResponse> {
    private static final SdkField<DeviceInstance> DEVICE_INSTANCE_FIELD = SdkField
            .<DeviceInstance> builder(MarshallingType.SDK_POJO).memberName("deviceInstance")
            .getter(getter(GetDeviceInstanceResponse::deviceInstance)).setter(setter(Builder::deviceInstance))
            .constructor(DeviceInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceInstance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_INSTANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DeviceInstance deviceInstance;

    private GetDeviceInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.deviceInstance = builder.deviceInstance;
    }

    /**
     * <p>
     * An object that contains information about your device instance.
     * </p>
     * 
     * @return An object that contains information about your device instance.
     */
    public final DeviceInstance deviceInstance() {
        return deviceInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceInstanceResponse)) {
            return false;
        }
        GetDeviceInstanceResponse other = (GetDeviceInstanceResponse) obj;
        return Objects.equals(deviceInstance(), other.deviceInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeviceInstanceResponse").add("DeviceInstance", deviceInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceInstance":
            return Optional.ofNullable(clazz.cast(deviceInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deviceInstance", DEVICE_INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceInstanceResponse, T> g) {
        return obj -> g.apply((GetDeviceInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeviceFarmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDeviceInstanceResponse> {
        /**
         * <p>
         * An object that contains information about your device instance.
         * </p>
         * 
         * @param deviceInstance
         *        An object that contains information about your device instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceInstance(DeviceInstance deviceInstance);

        /**
         * <p>
         * An object that contains information about your device instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceInstance.Builder} avoiding the need
         * to create one manually via {@link DeviceInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceInstance.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceInstance(DeviceInstance)}.
         * 
         * @param deviceInstance
         *        a consumer that will call methods on {@link DeviceInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceInstance(DeviceInstance)
         */
        default Builder deviceInstance(Consumer<DeviceInstance.Builder> deviceInstance) {
            return deviceInstance(DeviceInstance.builder().applyMutation(deviceInstance).build());
        }
    }

    static final class BuilderImpl extends DeviceFarmResponse.BuilderImpl implements Builder {
        private DeviceInstance deviceInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceInstanceResponse model) {
            super(model);
            deviceInstance(model.deviceInstance);
        }

        public final DeviceInstance.Builder getDeviceInstance() {
            return deviceInstance != null ? deviceInstance.toBuilder() : null;
        }

        public final void setDeviceInstance(DeviceInstance.BuilderImpl deviceInstance) {
            this.deviceInstance = deviceInstance != null ? deviceInstance.build() : null;
        }

        @Override
        public final Builder deviceInstance(DeviceInstance deviceInstance) {
            this.deviceInstance = deviceInstance;
            return this;
        }

        @Override
        public GetDeviceInstanceResponse build() {
            return new GetDeviceInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
