/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dax.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateParameterGroupRequest extends DaxRequest implements
        ToCopyableBuilder<UpdateParameterGroupRequest.Builder, UpdateParameterGroupRequest> {
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupName").getter(getter(UpdateParameterGroupRequest::parameterGroupName))
            .setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final SdkField<List<ParameterNameValue>> PARAMETER_NAME_VALUES_FIELD = SdkField
            .<List<ParameterNameValue>> builder(MarshallingType.LIST)
            .memberName("ParameterNameValues")
            .getter(getter(UpdateParameterGroupRequest::parameterNameValues))
            .setter(setter(Builder::parameterNameValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterNameValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterNameValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterNameValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_GROUP_NAME_FIELD,
            PARAMETER_NAME_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String parameterGroupName;

    private final List<ParameterNameValue> parameterNameValues;

    private UpdateParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterNameValues = builder.parameterNameValues;
    }

    /**
     * <p>
     * The name of the parameter group.
     * </p>
     * 
     * @return The name of the parameter group.
     */
    public final String parameterGroupName() {
        return parameterGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterNameValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterNameValues() {
        return parameterNameValues != null && !(parameterNameValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of name-value pairs for the parameters in the group. Each element in the array represents a single
     * parameter.
     * </p>
     * <note>
     * <p>
     * <code>record-ttl-millis</code> and <code>query-ttl-millis</code> are the only supported parameter names. For more
     * details, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.cluster-management.html#DAX.cluster-management.custom-settings.ttl"
     * >Configuring TTL Settings</a>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterNameValues} method.
     * </p>
     * 
     * @return An array of name-value pairs for the parameters in the group. Each element in the array represents a
     *         single parameter.</p> <note>
     *         <p>
     *         <code>record-ttl-millis</code> and <code>query-ttl-millis</code> are the only supported parameter names.
     *         For more details, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.cluster-management.html#DAX.cluster-management.custom-settings.ttl"
     *         >Configuring TTL Settings</a>.
     *         </p>
     */
    public final List<ParameterNameValue> parameterNameValues() {
        return parameterNameValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterNameValues() ? parameterNameValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateParameterGroupRequest)) {
            return false;
        }
        UpdateParameterGroupRequest other = (UpdateParameterGroupRequest) obj;
        return Objects.equals(parameterGroupName(), other.parameterGroupName())
                && hasParameterNameValues() == other.hasParameterNameValues()
                && Objects.equals(parameterNameValues(), other.parameterNameValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateParameterGroupRequest").add("ParameterGroupName", parameterGroupName())
                .add("ParameterNameValues", hasParameterNameValues() ? parameterNameValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        case "ParameterNameValues":
            return Optional.ofNullable(clazz.cast(parameterNameValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParameterGroupName", PARAMETER_GROUP_NAME_FIELD);
        map.put("ParameterNameValues", PARAMETER_NAME_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateParameterGroupRequest, T> g) {
        return obj -> g.apply((UpdateParameterGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DaxRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateParameterGroupRequest> {
        /**
         * <p>
         * The name of the parameter group.
         * </p>
         * 
         * @param parameterGroupName
         *        The name of the parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);

        /**
         * <p>
         * An array of name-value pairs for the parameters in the group. Each element in the array represents a single
         * parameter.
         * </p>
         * <note>
         * <p>
         * <code>record-ttl-millis</code> and <code>query-ttl-millis</code> are the only supported parameter names. For
         * more details, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.cluster-management.html#DAX.cluster-management.custom-settings.ttl"
         * >Configuring TTL Settings</a>.
         * </p>
         * </note>
         * 
         * @param parameterNameValues
         *        An array of name-value pairs for the parameters in the group. Each element in the array represents a
         *        single parameter.</p> <note>
         *        <p>
         *        <code>record-ttl-millis</code> and <code>query-ttl-millis</code> are the only supported parameter
         *        names. For more details, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.cluster-management.html#DAX.cluster-management.custom-settings.ttl"
         *        >Configuring TTL Settings</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues);

        /**
         * <p>
         * An array of name-value pairs for the parameters in the group. Each element in the array represents a single
         * parameter.
         * </p>
         * <note>
         * <p>
         * <code>record-ttl-millis</code> and <code>query-ttl-millis</code> are the only supported parameter names. For
         * more details, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.cluster-management.html#DAX.cluster-management.custom-settings.ttl"
         * >Configuring TTL Settings</a>.
         * </p>
         * </note>
         * 
         * @param parameterNameValues
         *        An array of name-value pairs for the parameters in the group. Each element in the array represents a
         *        single parameter.</p> <note>
         *        <p>
         *        <code>record-ttl-millis</code> and <code>query-ttl-millis</code> are the only supported parameter
         *        names. For more details, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.cluster-management.html#DAX.cluster-management.custom-settings.ttl"
         *        >Configuring TTL Settings</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterNameValues(ParameterNameValue... parameterNameValues);

        /**
         * <p>
         * An array of name-value pairs for the parameters in the group. Each element in the array represents a single
         * parameter.
         * </p>
         * <note>
         * <p>
         * <code>record-ttl-millis</code> and <code>query-ttl-millis</code> are the only supported parameter names. For
         * more details, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DAX.cluster-management.html#DAX.cluster-management.custom-settings.ttl"
         * >Configuring TTL Settings</a>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dax.model.ParameterNameValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.dax.model.ParameterNameValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dax.model.ParameterNameValue.Builder#build()} is called immediately
         * and its result is passed to {@link #parameterNameValues(List<ParameterNameValue>)}.
         * 
         * @param parameterNameValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dax.model.ParameterNameValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterNameValues(java.util.Collection<ParameterNameValue>)
         */
        Builder parameterNameValues(Consumer<ParameterNameValue.Builder>... parameterNameValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DaxRequest.BuilderImpl implements Builder {
        private String parameterGroupName;

        private List<ParameterNameValue> parameterNameValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateParameterGroupRequest model) {
            super(model);
            parameterGroupName(model.parameterGroupName);
            parameterNameValues(model.parameterNameValues);
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final List<ParameterNameValue.Builder> getParameterNameValues() {
            List<ParameterNameValue.Builder> result = ParameterNameValueListCopier.copyToBuilder(this.parameterNameValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterNameValues(Collection<ParameterNameValue.BuilderImpl> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copyFromBuilder(parameterNameValues);
        }

        @Override
        public final Builder parameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
            this.parameterNameValues = ParameterNameValueListCopier.copy(parameterNameValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(ParameterNameValue... parameterNameValues) {
            parameterNameValues(Arrays.asList(parameterNameValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterNameValues(Consumer<ParameterNameValue.Builder>... parameterNameValues) {
            parameterNameValues(Stream.of(parameterNameValues).map(c -> ParameterNameValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateParameterGroupRequest build() {
            return new UpdateParameterGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
