/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ListAgentsResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAgentsResponse extends DataSyncResponse implements
        ToCopyableBuilder<ListAgentsResponse.Builder, ListAgentsResponse> {
    private static final SdkField<List<AgentListEntry>> AGENTS_FIELD = SdkField
            .<List<AgentListEntry>> builder(MarshallingType.LIST)
            .memberName("Agents")
            .getter(getter(ListAgentsResponse::agents))
            .setter(setter(Builder::agents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Agents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAgentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AGENTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AgentListEntry> agents;

    private final String nextToken;

    private ListAgentsResponse(BuilderImpl builder) {
        super(builder);
        this.agents = builder.agents;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Agents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAgents() {
        return agents != null && !(agents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of DataSync agents in your Amazon Web Services account in the Amazon Web Services Region specified in the
     * request. The list is ordered by the agents' Amazon Resource Names (ARNs).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgents} method.
     * </p>
     * 
     * @return A list of DataSync agents in your Amazon Web Services account in the Amazon Web Services Region specified
     *         in the request. The list is ordered by the agents' Amazon Resource Names (ARNs).
     */
    public final List<AgentListEntry> agents() {
        return agents;
    }

    /**
     * <p>
     * The opaque string that indicates the position to begin the next list of results in the response.
     * </p>
     * 
     * @return The opaque string that indicates the position to begin the next list of results in the response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAgents() ? agents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentsResponse)) {
            return false;
        }
        ListAgentsResponse other = (ListAgentsResponse) obj;
        return hasAgents() == other.hasAgents() && Objects.equals(agents(), other.agents())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAgentsResponse").add("Agents", hasAgents() ? agents() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Agents":
            return Optional.ofNullable(clazz.cast(agents()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Agents", AGENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAgentsResponse, T> g) {
        return obj -> g.apply((ListAgentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAgentsResponse> {
        /**
         * <p>
         * A list of DataSync agents in your Amazon Web Services account in the Amazon Web Services Region specified in
         * the request. The list is ordered by the agents' Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param agents
         *        A list of DataSync agents in your Amazon Web Services account in the Amazon Web Services Region
         *        specified in the request. The list is ordered by the agents' Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agents(Collection<AgentListEntry> agents);

        /**
         * <p>
         * A list of DataSync agents in your Amazon Web Services account in the Amazon Web Services Region specified in
         * the request. The list is ordered by the agents' Amazon Resource Names (ARNs).
         * </p>
         * 
         * @param agents
         *        A list of DataSync agents in your Amazon Web Services account in the Amazon Web Services Region
         *        specified in the request. The list is ordered by the agents' Amazon Resource Names (ARNs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agents(AgentListEntry... agents);

        /**
         * <p>
         * A list of DataSync agents in your Amazon Web Services account in the Amazon Web Services Region specified in
         * the request. The list is ordered by the agents' Amazon Resource Names (ARNs).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.AgentListEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.AgentListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.AgentListEntry.Builder#build()} is called immediately
         * and its result is passed to {@link #agents(List<AgentListEntry>)}.
         * 
         * @param agents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.AgentListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agents(java.util.Collection<AgentListEntry>)
         */
        Builder agents(Consumer<AgentListEntry.Builder>... agents);

        /**
         * <p>
         * The opaque string that indicates the position to begin the next list of results in the response.
         * </p>
         * 
         * @param nextToken
         *        The opaque string that indicates the position to begin the next list of results in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private List<AgentListEntry> agents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentsResponse model) {
            super(model);
            agents(model.agents);
            nextToken(model.nextToken);
        }

        public final List<AgentListEntry.Builder> getAgents() {
            List<AgentListEntry.Builder> result = AgentListCopier.copyToBuilder(this.agents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgents(Collection<AgentListEntry.BuilderImpl> agents) {
            this.agents = AgentListCopier.copyFromBuilder(agents);
        }

        @Override
        public final Builder agents(Collection<AgentListEntry> agents) {
            this.agents = AgentListCopier.copy(agents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agents(AgentListEntry... agents) {
            agents(Arrays.asList(agents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agents(Consumer<AgentListEntry.Builder>... agents) {
            agents(Stream.of(agents).map(c -> AgentListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAgentsResponse build() {
            return new ListAgentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
