/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateAgentRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAgentRequest extends DataSyncRequest implements
        ToCopyableBuilder<CreateAgentRequest.Builder, CreateAgentRequest> {
    private static final SdkField<String> ACTIVATION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationKey").getter(getter(CreateAgentRequest::activationKey)).setter(setter(Builder::activationKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationKey").build()).build();

    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentName").getter(getter(CreateAgentRequest::agentName)).setter(setter(Builder::agentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentName").build()).build();

    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField
            .<List<TagListEntry>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAgentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcEndpointId").getter(getter(CreateAgentRequest::vpcEndpointId)).setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()).build();

    private static final SdkField<List<String>> SUBNET_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetArns")
            .getter(getter(CreateAgentRequest::subnetArns))
            .setter(setter(Builder::subnetArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupArns")
            .getter(getter(CreateAgentRequest::securityGroupArns))
            .setter(setter(Builder::securityGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_KEY_FIELD,
            AGENT_NAME_FIELD, TAGS_FIELD, VPC_ENDPOINT_ID_FIELD, SUBNET_ARNS_FIELD, SECURITY_GROUP_ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String activationKey;

    private final String agentName;

    private final List<TagListEntry> tags;

    private final String vpcEndpointId;

    private final List<String> subnetArns;

    private final List<String> securityGroupArns;

    private CreateAgentRequest(BuilderImpl builder) {
        super(builder);
        this.activationKey = builder.activationKey;
        this.agentName = builder.agentName;
        this.tags = builder.tags;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.subnetArns = builder.subnetArns;
        this.securityGroupArns = builder.securityGroupArns;
    }

    /**
     * <p>
     * Specifies your DataSync agent's activation key. If you don't have an activation key, see <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html">Activating your agent</a>.
     * </p>
     * 
     * @return Specifies your DataSync agent's activation key. If you don't have an activation key, see <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html">Activating your
     *         agent</a>.
     */
    public final String activationKey() {
        return activationKey;
    }

    /**
     * <p>
     * Specifies a name for your agent. We recommend specifying a name that you can remember.
     * </p>
     * 
     * @return Specifies a name for your agent. We recommend specifying a name that you can remember.
     */
    public final String agentName() {
        return agentName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
     * recommend creating at least one tag for your agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
     *         recommend creating at least one tag for your agent.
     */
    public final List<TagListEntry> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies the ID of the <a
     * href="https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#datasync-in-vpc">VPC
     * service endpoint</a> that you're using. For example, a VPC endpoint ID looks like
     * <code>vpce-01234d5aff67890e1</code>.
     * </p>
     * <important>
     * <p>
     * The VPC service endpoint you use must include the DataSync service name (for example,
     * <code>com.amazonaws.us-east-2.datasync</code>).
     * </p>
     * </important>
     * 
     * @return Specifies the ID of the <a
     *         href="https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#datasync-in-vpc"
     *         >VPC service endpoint</a> that you're using. For example, a VPC endpoint ID looks like
     *         <code>vpce-01234d5aff67890e1</code>.</p> <important>
     *         <p>
     *         The VPC service endpoint you use must include the DataSync service name (for example,
     *         <code>com.amazonaws.us-east-2.datasync</code>).
     *         </p>
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetArns() {
        return subnetArns != null && !(subnetArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the ARN of the subnet where your VPC service endpoint is located. You can only specify one ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetArns} method.
     * </p>
     * 
     * @return Specifies the ARN of the subnet where your VPC service endpoint is located. You can only specify one ARN.
     */
    public final List<String> subnetArns() {
        return subnetArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupArns() {
        return securityGroupArns != null && !(securityGroupArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the Amazon Resource Name (ARN) of the security group that allows traffic between your agent and VPC
     * service endpoint. You can only specify one ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupArns} method.
     * </p>
     * 
     * @return Specifies the Amazon Resource Name (ARN) of the security group that allows traffic between your agent and
     *         VPC service endpoint. You can only specify one ARN.
     */
    public final List<String> securityGroupArns() {
        return securityGroupArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(activationKey());
        hashCode = 31 * hashCode + Objects.hashCode(agentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetArns() ? subnetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupArns() ? securityGroupArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentRequest)) {
            return false;
        }
        CreateAgentRequest other = (CreateAgentRequest) obj;
        return Objects.equals(activationKey(), other.activationKey()) && Objects.equals(agentName(), other.agentName())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId()) && hasSubnetArns() == other.hasSubnetArns()
                && Objects.equals(subnetArns(), other.subnetArns()) && hasSecurityGroupArns() == other.hasSecurityGroupArns()
                && Objects.equals(securityGroupArns(), other.securityGroupArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAgentRequest").add("ActivationKey", activationKey()).add("AgentName", agentName())
                .add("Tags", hasTags() ? tags() : null).add("VpcEndpointId", vpcEndpointId())
                .add("SubnetArns", hasSubnetArns() ? subnetArns() : null)
                .add("SecurityGroupArns", hasSecurityGroupArns() ? securityGroupArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivationKey":
            return Optional.ofNullable(clazz.cast(activationKey()));
        case "AgentName":
            return Optional.ofNullable(clazz.cast(agentName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "SubnetArns":
            return Optional.ofNullable(clazz.cast(subnetArns()));
        case "SecurityGroupArns":
            return Optional.ofNullable(clazz.cast(securityGroupArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActivationKey", ACTIVATION_KEY_FIELD);
        map.put("AgentName", AGENT_NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("SubnetArns", SUBNET_ARNS_FIELD);
        map.put("SecurityGroupArns", SECURITY_GROUP_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentRequest, T> g) {
        return obj -> g.apply((CreateAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAgentRequest> {
        /**
         * <p>
         * Specifies your DataSync agent's activation key. If you don't have an activation key, see <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html">Activating your agent</a>.
         * </p>
         * 
         * @param activationKey
         *        Specifies your DataSync agent's activation key. If you don't have an activation key, see <a
         *        href="https://docs.aws.amazon.com/datasync/latest/userguide/activate-agent.html">Activating your
         *        agent</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationKey(String activationKey);

        /**
         * <p>
         * Specifies a name for your agent. We recommend specifying a name that you can remember.
         * </p>
         * 
         * @param agentName
         *        Specifies a name for your agent. We recommend specifying a name that you can remember.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentName(String agentName);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
         * recommend creating at least one tag for your agent.
         * </p>
         * 
         * @param tags
         *        Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         *        We recommend creating at least one tag for your agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagListEntry> tags);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
         * recommend creating at least one tag for your agent.
         * </p>
         * 
         * @param tags
         *        Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources.
         *        We recommend creating at least one tag for your agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagListEntry... tags);

        /**
         * <p>
         * Specifies labels that help you categorize, filter, and search for your Amazon Web Services resources. We
         * recommend creating at least one tag for your agent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datasync.model.TagListEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<TagListEntry>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datasync.model.TagListEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<TagListEntry>)
         */
        Builder tags(Consumer<TagListEntry.Builder>... tags);

        /**
         * <p>
         * Specifies the ID of the <a
         * href="https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#datasync-in-vpc">VPC
         * service endpoint</a> that you're using. For example, a VPC endpoint ID looks like
         * <code>vpce-01234d5aff67890e1</code>.
         * </p>
         * <important>
         * <p>
         * The VPC service endpoint you use must include the DataSync service name (for example,
         * <code>com.amazonaws.us-east-2.datasync</code>).
         * </p>
         * </important>
         * 
         * @param vpcEndpointId
         *        Specifies the ID of the <a href=
         *        "https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#datasync-in-vpc"
         *        >VPC service endpoint</a> that you're using. For example, a VPC endpoint ID looks like
         *        <code>vpce-01234d5aff67890e1</code>.</p> <important>
         *        <p>
         *        The VPC service endpoint you use must include the DataSync service name (for example,
         *        <code>com.amazonaws.us-east-2.datasync</code>).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * Specifies the ARN of the subnet where your VPC service endpoint is located. You can only specify one ARN.
         * </p>
         * 
         * @param subnetArns
         *        Specifies the ARN of the subnet where your VPC service endpoint is located. You can only specify one
         *        ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArns(Collection<String> subnetArns);

        /**
         * <p>
         * Specifies the ARN of the subnet where your VPC service endpoint is located. You can only specify one ARN.
         * </p>
         * 
         * @param subnetArns
         *        Specifies the ARN of the subnet where your VPC service endpoint is located. You can only specify one
         *        ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetArns(String... subnetArns);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the security group that allows traffic between your agent and VPC
         * service endpoint. You can only specify one ARN.
         * </p>
         * 
         * @param securityGroupArns
         *        Specifies the Amazon Resource Name (ARN) of the security group that allows traffic between your agent
         *        and VPC service endpoint. You can only specify one ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(Collection<String> securityGroupArns);

        /**
         * <p>
         * Specifies the Amazon Resource Name (ARN) of the security group that allows traffic between your agent and VPC
         * service endpoint. You can only specify one ARN.
         * </p>
         * 
         * @param securityGroupArns
         *        Specifies the Amazon Resource Name (ARN) of the security group that allows traffic between your agent
         *        and VPC service endpoint. You can only specify one ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(String... securityGroupArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String activationKey;

        private String agentName;

        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private String vpcEndpointId;

        private List<String> subnetArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentRequest model) {
            super(model);
            activationKey(model.activationKey);
            agentName(model.agentName);
            tags(model.tags);
            vpcEndpointId(model.vpcEndpointId);
            subnetArns(model.subnetArns);
            securityGroupArns(model.securityGroupArns);
        }

        public final String getActivationKey() {
            return activationKey;
        }

        public final void setActivationKey(String activationKey) {
            this.activationKey = activationKey;
        }

        @Override
        public final Builder activationKey(String activationKey) {
            this.activationKey = activationKey;
            return this;
        }

        public final String getAgentName() {
            return agentName;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final List<TagListEntry.Builder> getTags() {
            List<TagListEntry.Builder> result = InputTagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = InputTagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = InputTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final Collection<String> getSubnetArns() {
            if (subnetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetArns;
        }

        public final void setSubnetArns(Collection<String> subnetArns) {
            this.subnetArns = PLSubnetArnListCopier.copy(subnetArns);
        }

        @Override
        public final Builder subnetArns(Collection<String> subnetArns) {
            this.subnetArns = PLSubnetArnListCopier.copy(subnetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetArns(String... subnetArns) {
            subnetArns(Arrays.asList(subnetArns));
            return this;
        }

        public final Collection<String> getSecurityGroupArns() {
            if (securityGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupArns;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = PLSecurityGroupArnListCopier.copy(securityGroupArns);
        }

        @Override
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = PLSecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupArns(String... securityGroupArns) {
            securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAgentRequest build() {
            return new CreateAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
