/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunFleetAdvisorLsaAnalysisResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<RunFleetAdvisorLsaAnalysisResponse.Builder, RunFleetAdvisorLsaAnalysisResponse> {
    private static final SdkField<String> LSA_ANALYSIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LsaAnalysisId").getter(getter(RunFleetAdvisorLsaAnalysisResponse::lsaAnalysisId))
            .setter(setter(Builder::lsaAnalysisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LsaAnalysisId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RunFleetAdvisorLsaAnalysisResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LSA_ANALYSIS_ID_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String lsaAnalysisId;

    private final String status;

    private RunFleetAdvisorLsaAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.lsaAnalysisId = builder.lsaAnalysisId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the LSA analysis run.
     * </p>
     * 
     * @return The ID of the LSA analysis run.
     */
    public final String lsaAnalysisId() {
        return lsaAnalysisId;
    }

    /**
     * <p>
     * The status of the LSA analysis, for example <code>COMPLETED</code>.
     * </p>
     * 
     * @return The status of the LSA analysis, for example <code>COMPLETED</code>.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lsaAnalysisId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunFleetAdvisorLsaAnalysisResponse)) {
            return false;
        }
        RunFleetAdvisorLsaAnalysisResponse other = (RunFleetAdvisorLsaAnalysisResponse) obj;
        return Objects.equals(lsaAnalysisId(), other.lsaAnalysisId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunFleetAdvisorLsaAnalysisResponse").add("LsaAnalysisId", lsaAnalysisId())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LsaAnalysisId":
            return Optional.ofNullable(clazz.cast(lsaAnalysisId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LsaAnalysisId", LSA_ANALYSIS_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RunFleetAdvisorLsaAnalysisResponse, T> g) {
        return obj -> g.apply((RunFleetAdvisorLsaAnalysisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RunFleetAdvisorLsaAnalysisResponse> {
        /**
         * <p>
         * The ID of the LSA analysis run.
         * </p>
         * 
         * @param lsaAnalysisId
         *        The ID of the LSA analysis run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lsaAnalysisId(String lsaAnalysisId);

        /**
         * <p>
         * The status of the LSA analysis, for example <code>COMPLETED</code>.
         * </p>
         * 
         * @param status
         *        The status of the LSA analysis, for example <code>COMPLETED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String lsaAnalysisId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RunFleetAdvisorLsaAnalysisResponse model) {
            super(model);
            lsaAnalysisId(model.lsaAnalysisId);
            status(model.status);
        }

        public final String getLsaAnalysisId() {
            return lsaAnalysisId;
        }

        public final void setLsaAnalysisId(String lsaAnalysisId) {
            this.lsaAnalysisId = lsaAnalysisId;
        }

        @Override
        public final Builder lsaAnalysisId(String lsaAnalysisId) {
            this.lsaAnalysisId = lsaAnalysisId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public RunFleetAdvisorLsaAnalysisResponse build() {
            return new RunFleetAdvisorLsaAnalysisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
