/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object containing the result statistics for a completed assessment run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationTaskAssessmentRunResultStatistic implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationTaskAssessmentRunResultStatistic.Builder, ReplicationTaskAssessmentRunResultStatistic> {
    private static final SdkField<Integer> PASSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Passed").getter(getter(ReplicationTaskAssessmentRunResultStatistic::passed))
            .setter(setter(Builder::passed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Passed").build()).build();

    private static final SdkField<Integer> FAILED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Failed").getter(getter(ReplicationTaskAssessmentRunResultStatistic::failed))
            .setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build()).build();

    private static final SdkField<Integer> ERROR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Error")
            .getter(getter(ReplicationTaskAssessmentRunResultStatistic::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<Integer> WARNING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Warning").getter(getter(ReplicationTaskAssessmentRunResultStatistic::warning))
            .setter(setter(Builder::warning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warning").build()).build();

    private static final SdkField<Integer> CANCELLED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Cancelled").getter(getter(ReplicationTaskAssessmentRunResultStatistic::cancelled))
            .setter(setter(Builder::cancelled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cancelled").build()).build();

    private static final SdkField<Integer> SKIPPED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Skipped").getter(getter(ReplicationTaskAssessmentRunResultStatistic::skipped))
            .setter(setter(Builder::skipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Skipped").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PASSED_FIELD, FAILED_FIELD,
            ERROR_FIELD, WARNING_FIELD, CANCELLED_FIELD, SKIPPED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer passed;

    private final Integer failed;

    private final Integer error;

    private final Integer warning;

    private final Integer cancelled;

    private final Integer skipped;

    private ReplicationTaskAssessmentRunResultStatistic(BuilderImpl builder) {
        this.passed = builder.passed;
        this.failed = builder.failed;
        this.error = builder.error;
        this.warning = builder.warning;
        this.cancelled = builder.cancelled;
        this.skipped = builder.skipped;
    }

    /**
     * <p>
     * The number of individual assessments that successfully passed all checks in the assessment run.
     * </p>
     * 
     * @return The number of individual assessments that successfully passed all checks in the assessment run.
     */
    public final Integer passed() {
        return passed;
    }

    /**
     * <p>
     * The number of individual assessments that failed to meet the criteria defined in the assessment run.
     * </p>
     * 
     * @return The number of individual assessments that failed to meet the criteria defined in the assessment run.
     */
    public final Integer failed() {
        return failed;
    }

    /**
     * <p>
     * The number of individual assessments that encountered a critical error and could not complete properly.
     * </p>
     * 
     * @return The number of individual assessments that encountered a critical error and could not complete properly.
     */
    public final Integer error() {
        return error;
    }

    /**
     * <p>
     * Indicates that the recent completed AssessmentRun triggered a warning.
     * </p>
     * 
     * @return Indicates that the recent completed AssessmentRun triggered a warning.
     */
    public final Integer warning() {
        return warning;
    }

    /**
     * <p>
     * The number of individual assessments that were cancelled during the assessment run.
     * </p>
     * 
     * @return The number of individual assessments that were cancelled during the assessment run.
     */
    public final Integer cancelled() {
        return cancelled;
    }

    /**
     * <p>
     * The number of individual assessments that were skipped during the assessment run.
     * </p>
     * 
     * @return The number of individual assessments that were skipped during the assessment run.
     */
    public final Integer skipped() {
        return skipped;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(passed());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(warning());
        hashCode = 31 * hashCode + Objects.hashCode(cancelled());
        hashCode = 31 * hashCode + Objects.hashCode(skipped());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationTaskAssessmentRunResultStatistic)) {
            return false;
        }
        ReplicationTaskAssessmentRunResultStatistic other = (ReplicationTaskAssessmentRunResultStatistic) obj;
        return Objects.equals(passed(), other.passed()) && Objects.equals(failed(), other.failed())
                && Objects.equals(error(), other.error()) && Objects.equals(warning(), other.warning())
                && Objects.equals(cancelled(), other.cancelled()) && Objects.equals(skipped(), other.skipped());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationTaskAssessmentRunResultStatistic").add("Passed", passed()).add("Failed", failed())
                .add("Error", error()).add("Warning", warning()).add("Cancelled", cancelled()).add("Skipped", skipped()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Passed":
            return Optional.ofNullable(clazz.cast(passed()));
        case "Failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "Warning":
            return Optional.ofNullable(clazz.cast(warning()));
        case "Cancelled":
            return Optional.ofNullable(clazz.cast(cancelled()));
        case "Skipped":
            return Optional.ofNullable(clazz.cast(skipped()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Passed", PASSED_FIELD);
        map.put("Failed", FAILED_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("Warning", WARNING_FIELD);
        map.put("Cancelled", CANCELLED_FIELD);
        map.put("Skipped", SKIPPED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationTaskAssessmentRunResultStatistic, T> g) {
        return obj -> g.apply((ReplicationTaskAssessmentRunResultStatistic) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationTaskAssessmentRunResultStatistic> {
        /**
         * <p>
         * The number of individual assessments that successfully passed all checks in the assessment run.
         * </p>
         * 
         * @param passed
         *        The number of individual assessments that successfully passed all checks in the assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passed(Integer passed);

        /**
         * <p>
         * The number of individual assessments that failed to meet the criteria defined in the assessment run.
         * </p>
         * 
         * @param failed
         *        The number of individual assessments that failed to meet the criteria defined in the assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Integer failed);

        /**
         * <p>
         * The number of individual assessments that encountered a critical error and could not complete properly.
         * </p>
         * 
         * @param error
         *        The number of individual assessments that encountered a critical error and could not complete
         *        properly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(Integer error);

        /**
         * <p>
         * Indicates that the recent completed AssessmentRun triggered a warning.
         * </p>
         * 
         * @param warning
         *        Indicates that the recent completed AssessmentRun triggered a warning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warning(Integer warning);

        /**
         * <p>
         * The number of individual assessments that were cancelled during the assessment run.
         * </p>
         * 
         * @param cancelled
         *        The number of individual assessments that were cancelled during the assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelled(Integer cancelled);

        /**
         * <p>
         * The number of individual assessments that were skipped during the assessment run.
         * </p>
         * 
         * @param skipped
         *        The number of individual assessments that were skipped during the assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipped(Integer skipped);
    }

    static final class BuilderImpl implements Builder {
        private Integer passed;

        private Integer failed;

        private Integer error;

        private Integer warning;

        private Integer cancelled;

        private Integer skipped;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationTaskAssessmentRunResultStatistic model) {
            passed(model.passed);
            failed(model.failed);
            error(model.error);
            warning(model.warning);
            cancelled(model.cancelled);
            skipped(model.skipped);
        }

        public final Integer getPassed() {
            return passed;
        }

        public final void setPassed(Integer passed) {
            this.passed = passed;
        }

        @Override
        public final Builder passed(Integer passed) {
            this.passed = passed;
            return this;
        }

        public final Integer getFailed() {
            return failed;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        public final Integer getError() {
            return error;
        }

        public final void setError(Integer error) {
            this.error = error;
        }

        @Override
        public final Builder error(Integer error) {
            this.error = error;
            return this;
        }

        public final Integer getWarning() {
            return warning;
        }

        public final void setWarning(Integer warning) {
            this.warning = warning;
        }

        @Override
        public final Builder warning(Integer warning) {
            this.warning = warning;
            return this;
        }

        public final Integer getCancelled() {
            return cancelled;
        }

        public final void setCancelled(Integer cancelled) {
            this.cancelled = cancelled;
        }

        @Override
        public final Builder cancelled(Integer cancelled) {
            this.cancelled = cancelled;
            return this;
        }

        public final Integer getSkipped() {
            return skipped;
        }

        public final void setSkipped(Integer skipped) {
            this.skipped = skipped;
        }

        @Override
        public final Builder skipped(Integer skipped) {
            this.skipped = skipped;
            return this;
        }

        @Override
        public ReplicationTaskAssessmentRunResultStatistic build() {
            return new ReplicationTaskAssessmentRunResultStatistic(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
