/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReloadReplicationTablesRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<ReloadReplicationTablesRequest.Builder, ReloadReplicationTablesRequest> {
    private static final SdkField<String> REPLICATION_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationConfigArn").getter(getter(ReloadReplicationTablesRequest::replicationConfigArn))
            .setter(setter(Builder::replicationConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigArn").build())
            .build();

    private static final SdkField<List<TableToReload>> TABLES_TO_RELOAD_FIELD = SdkField
            .<List<TableToReload>> builder(MarshallingType.LIST)
            .memberName("TablesToReload")
            .getter(getter(ReloadReplicationTablesRequest::tablesToReload))
            .setter(setter(Builder::tablesToReload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesToReload").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableToReload> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableToReload::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RELOAD_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReloadOption").getter(getter(ReloadReplicationTablesRequest::reloadOptionAsString))
            .setter(setter(Builder::reloadOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReloadOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_CONFIG_ARN_FIELD,
            TABLES_TO_RELOAD_FIELD, RELOAD_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String replicationConfigArn;

    private final List<TableToReload> tablesToReload;

    private final String reloadOption;

    private ReloadReplicationTablesRequest(BuilderImpl builder) {
        super(builder);
        this.replicationConfigArn = builder.replicationConfigArn;
        this.tablesToReload = builder.tablesToReload;
        this.reloadOption = builder.reloadOption;
    }

    /**
     * <p>
     * The Amazon Resource Name of the replication config for which to reload tables.
     * </p>
     * 
     * @return The Amazon Resource Name of the replication config for which to reload tables.
     */
    public final String replicationConfigArn() {
        return replicationConfigArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TablesToReload property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTablesToReload() {
        return tablesToReload != null && !(tablesToReload instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tables to reload.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTablesToReload} method.
     * </p>
     * 
     * @return The list of tables to reload.
     */
    public final List<TableToReload> tablesToReload() {
        return tablesToReload;
    }

    /**
     * <p>
     * Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation is
     * enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when validation is
     * enabled for the replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reloadOption} will
     * return {@link ReloadOptionValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reloadOptionAsString}.
     * </p>
     * 
     * @return Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation
     *         is enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when
     *         validation is enabled for the replication.
     * @see ReloadOptionValue
     */
    public final ReloadOptionValue reloadOption() {
        return ReloadOptionValue.fromValue(reloadOption);
    }

    /**
     * <p>
     * Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation is
     * enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when validation is
     * enabled for the replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reloadOption} will
     * return {@link ReloadOptionValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reloadOptionAsString}.
     * </p>
     * 
     * @return Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation
     *         is enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when
     *         validation is enabled for the replication.
     * @see ReloadOptionValue
     */
    public final String reloadOptionAsString() {
        return reloadOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTablesToReload() ? tablesToReload() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reloadOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReloadReplicationTablesRequest)) {
            return false;
        }
        ReloadReplicationTablesRequest other = (ReloadReplicationTablesRequest) obj;
        return Objects.equals(replicationConfigArn(), other.replicationConfigArn())
                && hasTablesToReload() == other.hasTablesToReload() && Objects.equals(tablesToReload(), other.tablesToReload())
                && Objects.equals(reloadOptionAsString(), other.reloadOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReloadReplicationTablesRequest").add("ReplicationConfigArn", replicationConfigArn())
                .add("TablesToReload", hasTablesToReload() ? tablesToReload() : null).add("ReloadOption", reloadOptionAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationConfigArn":
            return Optional.ofNullable(clazz.cast(replicationConfigArn()));
        case "TablesToReload":
            return Optional.ofNullable(clazz.cast(tablesToReload()));
        case "ReloadOption":
            return Optional.ofNullable(clazz.cast(reloadOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplicationConfigArn", REPLICATION_CONFIG_ARN_FIELD);
        map.put("TablesToReload", TABLES_TO_RELOAD_FIELD);
        map.put("ReloadOption", RELOAD_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReloadReplicationTablesRequest, T> g) {
        return obj -> g.apply((ReloadReplicationTablesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ReloadReplicationTablesRequest> {
        /**
         * <p>
         * The Amazon Resource Name of the replication config for which to reload tables.
         * </p>
         * 
         * @param replicationConfigArn
         *        The Amazon Resource Name of the replication config for which to reload tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfigArn(String replicationConfigArn);

        /**
         * <p>
         * The list of tables to reload.
         * </p>
         * 
         * @param tablesToReload
         *        The list of tables to reload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesToReload(Collection<TableToReload> tablesToReload);

        /**
         * <p>
         * The list of tables to reload.
         * </p>
         * 
         * @param tablesToReload
         *        The list of tables to reload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesToReload(TableToReload... tablesToReload);

        /**
         * <p>
         * The list of tables to reload.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.TableToReload.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.TableToReload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.TableToReload.Builder#build()} is called
         * immediately and its result is passed to {@link #tablesToReload(List<TableToReload>)}.
         * 
         * @param tablesToReload
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.TableToReload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tablesToReload(java.util.Collection<TableToReload>)
         */
        Builder tablesToReload(Consumer<TableToReload.Builder>... tablesToReload);

        /**
         * <p>
         * Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation is
         * enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when
         * validation is enabled for the replication.
         * </p>
         * 
         * @param reloadOption
         *        Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if
         *        validation is enabled. Specify <code>validate-only</code> to re-validate the table. This option
         *        applies only when validation is enabled for the replication.
         * @see ReloadOptionValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReloadOptionValue
         */
        Builder reloadOption(String reloadOption);

        /**
         * <p>
         * Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation is
         * enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when
         * validation is enabled for the replication.
         * </p>
         * 
         * @param reloadOption
         *        Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if
         *        validation is enabled. Specify <code>validate-only</code> to re-validate the table. This option
         *        applies only when validation is enabled for the replication.
         * @see ReloadOptionValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReloadOptionValue
         */
        Builder reloadOption(ReloadOptionValue reloadOption);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationConfigArn;

        private List<TableToReload> tablesToReload = DefaultSdkAutoConstructList.getInstance();

        private String reloadOption;

        private BuilderImpl() {
        }

        private BuilderImpl(ReloadReplicationTablesRequest model) {
            super(model);
            replicationConfigArn(model.replicationConfigArn);
            tablesToReload(model.tablesToReload);
            reloadOption(model.reloadOption);
        }

        public final String getReplicationConfigArn() {
            return replicationConfigArn;
        }

        public final void setReplicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
        }

        @Override
        public final Builder replicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
            return this;
        }

        public final List<TableToReload.Builder> getTablesToReload() {
            List<TableToReload.Builder> result = TableListToReloadCopier.copyToBuilder(this.tablesToReload);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTablesToReload(Collection<TableToReload.BuilderImpl> tablesToReload) {
            this.tablesToReload = TableListToReloadCopier.copyFromBuilder(tablesToReload);
        }

        @Override
        public final Builder tablesToReload(Collection<TableToReload> tablesToReload) {
            this.tablesToReload = TableListToReloadCopier.copy(tablesToReload);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablesToReload(TableToReload... tablesToReload) {
            tablesToReload(Arrays.asList(tablesToReload));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablesToReload(Consumer<TableToReload.Builder>... tablesToReload) {
            tablesToReload(Stream.of(tablesToReload).map(c -> TableToReload.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getReloadOption() {
            return reloadOption;
        }

        public final void setReloadOption(String reloadOption) {
            this.reloadOption = reloadOption;
        }

        @Override
        public final Builder reloadOption(String reloadOption) {
            this.reloadOption = reloadOption;
            return this;
        }

        @Override
        public final Builder reloadOption(ReloadOptionValue reloadOption) {
            this.reloadOption(reloadOption == null ? null : reloadOption.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReloadReplicationTablesRequest build() {
            return new ReloadReplicationTablesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
