/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The results returned in <code>describe-replications</code> to display the results of the premigration assessment from
 * the replication configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PremigrationAssessmentStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<PremigrationAssessmentStatus.Builder, PremigrationAssessmentStatus> {
    private static final SdkField<String> PREMIGRATION_ASSESSMENT_RUN_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PremigrationAssessmentRunArn")
            .getter(getter(PremigrationAssessmentStatus::premigrationAssessmentRunArn))
            .setter(setter(Builder::premigrationAssessmentRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PremigrationAssessmentRunArn")
                    .build()).build();

    private static final SdkField<Boolean> FAIL_ON_ASSESSMENT_FAILURE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FailOnAssessmentFailure").getter(getter(PremigrationAssessmentStatus::failOnAssessmentFailure))
            .setter(setter(Builder::failOnAssessmentFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailOnAssessmentFailure").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PremigrationAssessmentStatus::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> PREMIGRATION_ASSESSMENT_RUN_CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("PremigrationAssessmentRunCreationDate")
            .getter(getter(PremigrationAssessmentStatus::premigrationAssessmentRunCreationDate))
            .setter(setter(Builder::premigrationAssessmentRunCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PremigrationAssessmentRunCreationDate").build()).build();

    private static final SdkField<ReplicationTaskAssessmentRunProgress> ASSESSMENT_PROGRESS_FIELD = SdkField
            .<ReplicationTaskAssessmentRunProgress> builder(MarshallingType.SDK_POJO).memberName("AssessmentProgress")
            .getter(getter(PremigrationAssessmentStatus::assessmentProgress)).setter(setter(Builder::assessmentProgress))
            .constructor(ReplicationTaskAssessmentRunProgress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentProgress").build())
            .build();

    private static final SdkField<String> LAST_FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastFailureMessage").getter(getter(PremigrationAssessmentStatus::lastFailureMessage))
            .setter(setter(Builder::lastFailureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureMessage").build())
            .build();

    private static final SdkField<String> RESULT_LOCATION_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultLocationBucket").getter(getter(PremigrationAssessmentStatus::resultLocationBucket))
            .setter(setter(Builder::resultLocationBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultLocationBucket").build())
            .build();

    private static final SdkField<String> RESULT_LOCATION_FOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultLocationFolder").getter(getter(PremigrationAssessmentStatus::resultLocationFolder))
            .setter(setter(Builder::resultLocationFolder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultLocationFolder").build())
            .build();

    private static final SdkField<String> RESULT_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultEncryptionMode").getter(getter(PremigrationAssessmentStatus::resultEncryptionMode))
            .setter(setter(Builder::resultEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultEncryptionMode").build())
            .build();

    private static final SdkField<String> RESULT_KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultKmsKeyArn").getter(getter(PremigrationAssessmentStatus::resultKmsKeyArn))
            .setter(setter(Builder::resultKmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultKmsKeyArn").build()).build();

    private static final SdkField<ReplicationTaskAssessmentRunResultStatistic> RESULT_STATISTIC_FIELD = SdkField
            .<ReplicationTaskAssessmentRunResultStatistic> builder(MarshallingType.SDK_POJO).memberName("ResultStatistic")
            .getter(getter(PremigrationAssessmentStatus::resultStatistic)).setter(setter(Builder::resultStatistic))
            .constructor(ReplicationTaskAssessmentRunResultStatistic::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultStatistic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PREMIGRATION_ASSESSMENT_RUN_ARN_FIELD, FAIL_ON_ASSESSMENT_FAILURE_FIELD, STATUS_FIELD,
            PREMIGRATION_ASSESSMENT_RUN_CREATION_DATE_FIELD, ASSESSMENT_PROGRESS_FIELD, LAST_FAILURE_MESSAGE_FIELD,
            RESULT_LOCATION_BUCKET_FIELD, RESULT_LOCATION_FOLDER_FIELD, RESULT_ENCRYPTION_MODE_FIELD, RESULT_KMS_KEY_ARN_FIELD,
            RESULT_STATISTIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String premigrationAssessmentRunArn;

    private final Boolean failOnAssessmentFailure;

    private final String status;

    private final Instant premigrationAssessmentRunCreationDate;

    private final ReplicationTaskAssessmentRunProgress assessmentProgress;

    private final String lastFailureMessage;

    private final String resultLocationBucket;

    private final String resultLocationFolder;

    private final String resultEncryptionMode;

    private final String resultKmsKeyArn;

    private final ReplicationTaskAssessmentRunResultStatistic resultStatistic;

    private PremigrationAssessmentStatus(BuilderImpl builder) {
        this.premigrationAssessmentRunArn = builder.premigrationAssessmentRunArn;
        this.failOnAssessmentFailure = builder.failOnAssessmentFailure;
        this.status = builder.status;
        this.premigrationAssessmentRunCreationDate = builder.premigrationAssessmentRunCreationDate;
        this.assessmentProgress = builder.assessmentProgress;
        this.lastFailureMessage = builder.lastFailureMessage;
        this.resultLocationBucket = builder.resultLocationBucket;
        this.resultLocationFolder = builder.resultLocationFolder;
        this.resultEncryptionMode = builder.resultEncryptionMode;
        this.resultKmsKeyArn = builder.resultKmsKeyArn;
        this.resultStatistic = builder.resultStatistic;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of this assessment run.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of this assessment run.
     */
    public final String premigrationAssessmentRunArn() {
        return premigrationAssessmentRunArn;
    }

    /**
     * <p>
     * A configurable setting you can set to <code>true</code> (the defualt setting) or <code>false</code>. Use this
     * setting to to stop the replication from starting automatically if the assessment fails. This can help you
     * evaluate the issue that is preventing the replication from running successfully.
     * </p>
     * 
     * @return A configurable setting you can set to <code>true</code> (the defualt setting) or <code>false</code>. Use
     *         this setting to to stop the replication from starting automatically if the assessment fails. This can
     *         help you evaluate the issue that is preventing the replication from running successfully.
     */
    public final Boolean failOnAssessmentFailure() {
        return failOnAssessmentFailure;
    }

    /**
     * <p>
     * This describes the assessment run status. The status can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>cancelling</code>: The assessment run was canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: The assessment run was deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>failed</code>: At least one individual assessment completed with a failed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>error-provisioning</code>: An internal error occurred while resources were provisioned (during the
     * <code>provisioning</code> status).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>error-executing</code> An internal error occurred while individual assessments ran (during the
     * <code>running</code> status).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>invalid state</code>: The assessment run is in an unknown state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>passed</code>: All individual assessments have completed and none have a failed status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>provisioning</code>: The resources required to run individual assessments are being provisioned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>running</code>: Individual assessments are being run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>starting</code>: The assessment run is starting, but resources are not yet being provisioned for individual
     * assessments.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>warning</code>: At least one individual assessment completed with a warning status.
     * </p>
     * </li>
     * </ul>
     * 
     * @return This describes the assessment run status. The status can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>cancelling</code>: The assessment run was canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: The assessment run was deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>failed</code>: At least one individual assessment completed with a failed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>error-provisioning</code>: An internal error occurred while resources were provisioned (during the
     *         <code>provisioning</code> status).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>error-executing</code> An internal error occurred while individual assessments ran (during the
     *         <code>running</code> status).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>invalid state</code>: The assessment run is in an unknown state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>passed</code>: All individual assessments have completed and none have a failed status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>provisioning</code>: The resources required to run individual assessments are being provisioned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>running</code>: Individual assessments are being run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>starting</code>: The assessment run is starting, but resources are not yet being provisioned for
     *         individual assessments.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>warning</code>: At least one individual assessment completed with a warning status.
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The date which the assessment run was created.
     * </p>
     * 
     * @return The date which the assessment run was created.
     */
    public final Instant premigrationAssessmentRunCreationDate() {
        return premigrationAssessmentRunCreationDate;
    }

    /**
     * Returns the value of the AssessmentProgress property for this object.
     * 
     * @return The value of the AssessmentProgress property for this object.
     */
    public final ReplicationTaskAssessmentRunProgress assessmentProgress() {
        return assessmentProgress;
    }

    /**
     * <p>
     * The last message generated by an individual assessment failure.
     * </p>
     * 
     * @return The last message generated by an individual assessment failure.
     */
    public final String lastFailureMessage() {
        return lastFailureMessage;
    }

    /**
     * <p>
     * The Amazon S3 bucket that Database Migration Service Serverless created to store the results of this assessment
     * run.
     * </p>
     * 
     * @return The Amazon S3 bucket that Database Migration Service Serverless created to store the results of this
     *         assessment run.
     */
    public final String resultLocationBucket() {
        return resultLocationBucket;
    }

    /**
     * <p>
     * The folder within an Amazon S3 bucket where you want Database Migration Service to store the results of this
     * assessment run.
     * </p>
     * 
     * @return The folder within an Amazon S3 bucket where you want Database Migration Service to store the results of
     *         this assessment run.
     */
    public final String resultLocationFolder() {
        return resultLocationFolder;
    }

    /**
     * <p>
     * The supported values are <code>SSE_KMS</code> and <code>SSE_S3</code>. If these values are not provided, then the
     * files are not encrypted at rest. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.KMSKeys">Creating
     * Amazon Web Services KMS keys to encrypt Amazon S3 target objects</a>.
     * </p>
     * 
     * @return The supported values are <code>SSE_KMS</code> and <code>SSE_S3</code>. If these values are not provided,
     *         then the files are not encrypted at rest. For more information, see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.KMSKeys"
     *         >Creating Amazon Web Services KMS keys to encrypt Amazon S3 target objects</a>.
     */
    public final String resultEncryptionMode() {
        return resultEncryptionMode;
    }

    /**
     * <p>
     * The ARN of a custom KMS encryption key that you specify when you set <code>ResultEncryptionMode</code> to
     * <code>SSE_KMS</code>.
     * </p>
     * 
     * @return The ARN of a custom KMS encryption key that you specify when you set <code>ResultEncryptionMode</code> to
     *         <code>SSE_KMS</code>.
     */
    public final String resultKmsKeyArn() {
        return resultKmsKeyArn;
    }

    /**
     * Returns the value of the ResultStatistic property for this object.
     * 
     * @return The value of the ResultStatistic property for this object.
     */
    public final ReplicationTaskAssessmentRunResultStatistic resultStatistic() {
        return resultStatistic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(premigrationAssessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(failOnAssessmentFailure());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(premigrationAssessmentRunCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(lastFailureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(resultLocationBucket());
        hashCode = 31 * hashCode + Objects.hashCode(resultLocationFolder());
        hashCode = 31 * hashCode + Objects.hashCode(resultEncryptionMode());
        hashCode = 31 * hashCode + Objects.hashCode(resultKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(resultStatistic());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PremigrationAssessmentStatus)) {
            return false;
        }
        PremigrationAssessmentStatus other = (PremigrationAssessmentStatus) obj;
        return Objects.equals(premigrationAssessmentRunArn(), other.premigrationAssessmentRunArn())
                && Objects.equals(failOnAssessmentFailure(), other.failOnAssessmentFailure())
                && Objects.equals(status(), other.status())
                && Objects.equals(premigrationAssessmentRunCreationDate(), other.premigrationAssessmentRunCreationDate())
                && Objects.equals(assessmentProgress(), other.assessmentProgress())
                && Objects.equals(lastFailureMessage(), other.lastFailureMessage())
                && Objects.equals(resultLocationBucket(), other.resultLocationBucket())
                && Objects.equals(resultLocationFolder(), other.resultLocationFolder())
                && Objects.equals(resultEncryptionMode(), other.resultEncryptionMode())
                && Objects.equals(resultKmsKeyArn(), other.resultKmsKeyArn())
                && Objects.equals(resultStatistic(), other.resultStatistic());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PremigrationAssessmentStatus")
                .add("PremigrationAssessmentRunArn", premigrationAssessmentRunArn())
                .add("FailOnAssessmentFailure", failOnAssessmentFailure()).add("Status", status())
                .add("PremigrationAssessmentRunCreationDate", premigrationAssessmentRunCreationDate())
                .add("AssessmentProgress", assessmentProgress()).add("LastFailureMessage", lastFailureMessage())
                .add("ResultLocationBucket", resultLocationBucket()).add("ResultLocationFolder", resultLocationFolder())
                .add("ResultEncryptionMode", resultEncryptionMode()).add("ResultKmsKeyArn", resultKmsKeyArn())
                .add("ResultStatistic", resultStatistic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PremigrationAssessmentRunArn":
            return Optional.ofNullable(clazz.cast(premigrationAssessmentRunArn()));
        case "FailOnAssessmentFailure":
            return Optional.ofNullable(clazz.cast(failOnAssessmentFailure()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "PremigrationAssessmentRunCreationDate":
            return Optional.ofNullable(clazz.cast(premigrationAssessmentRunCreationDate()));
        case "AssessmentProgress":
            return Optional.ofNullable(clazz.cast(assessmentProgress()));
        case "LastFailureMessage":
            return Optional.ofNullable(clazz.cast(lastFailureMessage()));
        case "ResultLocationBucket":
            return Optional.ofNullable(clazz.cast(resultLocationBucket()));
        case "ResultLocationFolder":
            return Optional.ofNullable(clazz.cast(resultLocationFolder()));
        case "ResultEncryptionMode":
            return Optional.ofNullable(clazz.cast(resultEncryptionMode()));
        case "ResultKmsKeyArn":
            return Optional.ofNullable(clazz.cast(resultKmsKeyArn()));
        case "ResultStatistic":
            return Optional.ofNullable(clazz.cast(resultStatistic()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PremigrationAssessmentRunArn", PREMIGRATION_ASSESSMENT_RUN_ARN_FIELD);
        map.put("FailOnAssessmentFailure", FAIL_ON_ASSESSMENT_FAILURE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("PremigrationAssessmentRunCreationDate", PREMIGRATION_ASSESSMENT_RUN_CREATION_DATE_FIELD);
        map.put("AssessmentProgress", ASSESSMENT_PROGRESS_FIELD);
        map.put("LastFailureMessage", LAST_FAILURE_MESSAGE_FIELD);
        map.put("ResultLocationBucket", RESULT_LOCATION_BUCKET_FIELD);
        map.put("ResultLocationFolder", RESULT_LOCATION_FOLDER_FIELD);
        map.put("ResultEncryptionMode", RESULT_ENCRYPTION_MODE_FIELD);
        map.put("ResultKmsKeyArn", RESULT_KMS_KEY_ARN_FIELD);
        map.put("ResultStatistic", RESULT_STATISTIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PremigrationAssessmentStatus, T> g) {
        return obj -> g.apply((PremigrationAssessmentStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PremigrationAssessmentStatus> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of this assessment run.
         * </p>
         * 
         * @param premigrationAssessmentRunArn
         *        The Amazon Resource Name (ARN) of this assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder premigrationAssessmentRunArn(String premigrationAssessmentRunArn);

        /**
         * <p>
         * A configurable setting you can set to <code>true</code> (the defualt setting) or <code>false</code>. Use this
         * setting to to stop the replication from starting automatically if the assessment fails. This can help you
         * evaluate the issue that is preventing the replication from running successfully.
         * </p>
         * 
         * @param failOnAssessmentFailure
         *        A configurable setting you can set to <code>true</code> (the defualt setting) or <code>false</code>.
         *        Use this setting to to stop the replication from starting automatically if the assessment fails. This
         *        can help you evaluate the issue that is preventing the replication from running successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failOnAssessmentFailure(Boolean failOnAssessmentFailure);

        /**
         * <p>
         * This describes the assessment run status. The status can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>cancelling</code>: The assessment run was canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: The assessment run was deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>failed</code>: At least one individual assessment completed with a failed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error-provisioning</code>: An internal error occurred while resources were provisioned (during the
         * <code>provisioning</code> status).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error-executing</code> An internal error occurred while individual assessments ran (during the
         * <code>running</code> status).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>invalid state</code>: The assessment run is in an unknown state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>passed</code>: All individual assessments have completed and none have a failed status.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>provisioning</code>: The resources required to run individual assessments are being provisioned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>running</code>: Individual assessments are being run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>starting</code>: The assessment run is starting, but resources are not yet being provisioned for
         * individual assessments.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>warning</code>: At least one individual assessment completed with a warning status.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        This describes the assessment run status. The status can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>cancelling</code>: The assessment run was canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: The assessment run was deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>failed</code>: At least one individual assessment completed with a failed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error-provisioning</code>: An internal error occurred while resources were provisioned (during
         *        the <code>provisioning</code> status).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error-executing</code> An internal error occurred while individual assessments ran (during the
         *        <code>running</code> status).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>invalid state</code>: The assessment run is in an unknown state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>passed</code>: All individual assessments have completed and none have a failed status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>provisioning</code>: The resources required to run individual assessments are being provisioned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>running</code>: Individual assessments are being run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>starting</code>: The assessment run is starting, but resources are not yet being provisioned for
         *        individual assessments.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>warning</code>: At least one individual assessment completed with a warning status.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date which the assessment run was created.
         * </p>
         * 
         * @param premigrationAssessmentRunCreationDate
         *        The date which the assessment run was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder premigrationAssessmentRunCreationDate(Instant premigrationAssessmentRunCreationDate);

        /**
         * Sets the value of the AssessmentProgress property for this object.
         *
         * @param assessmentProgress
         *        The new value for the AssessmentProgress property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentProgress(ReplicationTaskAssessmentRunProgress assessmentProgress);

        /**
         * Sets the value of the AssessmentProgress property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link ReplicationTaskAssessmentRunProgress.Builder} avoiding the need to create one manually via
         * {@link ReplicationTaskAssessmentRunProgress#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationTaskAssessmentRunProgress.Builder#build()} is called
         * immediately and its result is passed to {@link #assessmentProgress(ReplicationTaskAssessmentRunProgress)}.
         * 
         * @param assessmentProgress
         *        a consumer that will call methods on {@link ReplicationTaskAssessmentRunProgress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentProgress(ReplicationTaskAssessmentRunProgress)
         */
        default Builder assessmentProgress(Consumer<ReplicationTaskAssessmentRunProgress.Builder> assessmentProgress) {
            return assessmentProgress(ReplicationTaskAssessmentRunProgress.builder().applyMutation(assessmentProgress).build());
        }

        /**
         * <p>
         * The last message generated by an individual assessment failure.
         * </p>
         * 
         * @param lastFailureMessage
         *        The last message generated by an individual assessment failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastFailureMessage(String lastFailureMessage);

        /**
         * <p>
         * The Amazon S3 bucket that Database Migration Service Serverless created to store the results of this
         * assessment run.
         * </p>
         * 
         * @param resultLocationBucket
         *        The Amazon S3 bucket that Database Migration Service Serverless created to store the results of this
         *        assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultLocationBucket(String resultLocationBucket);

        /**
         * <p>
         * The folder within an Amazon S3 bucket where you want Database Migration Service to store the results of this
         * assessment run.
         * </p>
         * 
         * @param resultLocationFolder
         *        The folder within an Amazon S3 bucket where you want Database Migration Service to store the results
         *        of this assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultLocationFolder(String resultLocationFolder);

        /**
         * <p>
         * The supported values are <code>SSE_KMS</code> and <code>SSE_S3</code>. If these values are not provided, then
         * the files are not encrypted at rest. For more information, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.KMSKeys">Creating
         * Amazon Web Services KMS keys to encrypt Amazon S3 target objects</a>.
         * </p>
         * 
         * @param resultEncryptionMode
         *        The supported values are <code>SSE_KMS</code> and <code>SSE_S3</code>. If these values are not
         *        provided, then the files are not encrypted at rest. For more information, see <a
         *        href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.KMSKeys"
         *        >Creating Amazon Web Services KMS keys to encrypt Amazon S3 target objects</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultEncryptionMode(String resultEncryptionMode);

        /**
         * <p>
         * The ARN of a custom KMS encryption key that you specify when you set <code>ResultEncryptionMode</code> to
         * <code>SSE_KMS</code>.
         * </p>
         * 
         * @param resultKmsKeyArn
         *        The ARN of a custom KMS encryption key that you specify when you set <code>ResultEncryptionMode</code>
         *        to <code>SSE_KMS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultKmsKeyArn(String resultKmsKeyArn);

        /**
         * Sets the value of the ResultStatistic property for this object.
         *
         * @param resultStatistic
         *        The new value for the ResultStatistic property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultStatistic(ReplicationTaskAssessmentRunResultStatistic resultStatistic);

        /**
         * Sets the value of the ResultStatistic property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link ReplicationTaskAssessmentRunResultStatistic.Builder} avoiding the need to create one manually via
         * {@link ReplicationTaskAssessmentRunResultStatistic#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationTaskAssessmentRunResultStatistic.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #resultStatistic(ReplicationTaskAssessmentRunResultStatistic)}.
         * 
         * @param resultStatistic
         *        a consumer that will call methods on {@link ReplicationTaskAssessmentRunResultStatistic.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultStatistic(ReplicationTaskAssessmentRunResultStatistic)
         */
        default Builder resultStatistic(Consumer<ReplicationTaskAssessmentRunResultStatistic.Builder> resultStatistic) {
            return resultStatistic(ReplicationTaskAssessmentRunResultStatistic.builder().applyMutation(resultStatistic).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String premigrationAssessmentRunArn;

        private Boolean failOnAssessmentFailure;

        private String status;

        private Instant premigrationAssessmentRunCreationDate;

        private ReplicationTaskAssessmentRunProgress assessmentProgress;

        private String lastFailureMessage;

        private String resultLocationBucket;

        private String resultLocationFolder;

        private String resultEncryptionMode;

        private String resultKmsKeyArn;

        private ReplicationTaskAssessmentRunResultStatistic resultStatistic;

        private BuilderImpl() {
        }

        private BuilderImpl(PremigrationAssessmentStatus model) {
            premigrationAssessmentRunArn(model.premigrationAssessmentRunArn);
            failOnAssessmentFailure(model.failOnAssessmentFailure);
            status(model.status);
            premigrationAssessmentRunCreationDate(model.premigrationAssessmentRunCreationDate);
            assessmentProgress(model.assessmentProgress);
            lastFailureMessage(model.lastFailureMessage);
            resultLocationBucket(model.resultLocationBucket);
            resultLocationFolder(model.resultLocationFolder);
            resultEncryptionMode(model.resultEncryptionMode);
            resultKmsKeyArn(model.resultKmsKeyArn);
            resultStatistic(model.resultStatistic);
        }

        public final String getPremigrationAssessmentRunArn() {
            return premigrationAssessmentRunArn;
        }

        public final void setPremigrationAssessmentRunArn(String premigrationAssessmentRunArn) {
            this.premigrationAssessmentRunArn = premigrationAssessmentRunArn;
        }

        @Override
        public final Builder premigrationAssessmentRunArn(String premigrationAssessmentRunArn) {
            this.premigrationAssessmentRunArn = premigrationAssessmentRunArn;
            return this;
        }

        public final Boolean getFailOnAssessmentFailure() {
            return failOnAssessmentFailure;
        }

        public final void setFailOnAssessmentFailure(Boolean failOnAssessmentFailure) {
            this.failOnAssessmentFailure = failOnAssessmentFailure;
        }

        @Override
        public final Builder failOnAssessmentFailure(Boolean failOnAssessmentFailure) {
            this.failOnAssessmentFailure = failOnAssessmentFailure;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getPremigrationAssessmentRunCreationDate() {
            return premigrationAssessmentRunCreationDate;
        }

        public final void setPremigrationAssessmentRunCreationDate(Instant premigrationAssessmentRunCreationDate) {
            this.premigrationAssessmentRunCreationDate = premigrationAssessmentRunCreationDate;
        }

        @Override
        public final Builder premigrationAssessmentRunCreationDate(Instant premigrationAssessmentRunCreationDate) {
            this.premigrationAssessmentRunCreationDate = premigrationAssessmentRunCreationDate;
            return this;
        }

        public final ReplicationTaskAssessmentRunProgress.Builder getAssessmentProgress() {
            return assessmentProgress != null ? assessmentProgress.toBuilder() : null;
        }

        public final void setAssessmentProgress(ReplicationTaskAssessmentRunProgress.BuilderImpl assessmentProgress) {
            this.assessmentProgress = assessmentProgress != null ? assessmentProgress.build() : null;
        }

        @Override
        public final Builder assessmentProgress(ReplicationTaskAssessmentRunProgress assessmentProgress) {
            this.assessmentProgress = assessmentProgress;
            return this;
        }

        public final String getLastFailureMessage() {
            return lastFailureMessage;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final String getResultLocationBucket() {
            return resultLocationBucket;
        }

        public final void setResultLocationBucket(String resultLocationBucket) {
            this.resultLocationBucket = resultLocationBucket;
        }

        @Override
        public final Builder resultLocationBucket(String resultLocationBucket) {
            this.resultLocationBucket = resultLocationBucket;
            return this;
        }

        public final String getResultLocationFolder() {
            return resultLocationFolder;
        }

        public final void setResultLocationFolder(String resultLocationFolder) {
            this.resultLocationFolder = resultLocationFolder;
        }

        @Override
        public final Builder resultLocationFolder(String resultLocationFolder) {
            this.resultLocationFolder = resultLocationFolder;
            return this;
        }

        public final String getResultEncryptionMode() {
            return resultEncryptionMode;
        }

        public final void setResultEncryptionMode(String resultEncryptionMode) {
            this.resultEncryptionMode = resultEncryptionMode;
        }

        @Override
        public final Builder resultEncryptionMode(String resultEncryptionMode) {
            this.resultEncryptionMode = resultEncryptionMode;
            return this;
        }

        public final String getResultKmsKeyArn() {
            return resultKmsKeyArn;
        }

        public final void setResultKmsKeyArn(String resultKmsKeyArn) {
            this.resultKmsKeyArn = resultKmsKeyArn;
        }

        @Override
        public final Builder resultKmsKeyArn(String resultKmsKeyArn) {
            this.resultKmsKeyArn = resultKmsKeyArn;
            return this;
        }

        public final ReplicationTaskAssessmentRunResultStatistic.Builder getResultStatistic() {
            return resultStatistic != null ? resultStatistic.toBuilder() : null;
        }

        public final void setResultStatistic(ReplicationTaskAssessmentRunResultStatistic.BuilderImpl resultStatistic) {
            this.resultStatistic = resultStatistic != null ? resultStatistic.build() : null;
        }

        @Override
        public final Builder resultStatistic(ReplicationTaskAssessmentRunResultStatistic resultStatistic) {
            this.resultStatistic = resultStatistic;
            return this;
        }

        @Override
        public PremigrationAssessmentStatus build() {
            return new PremigrationAssessmentStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
